/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.Arrays;
import java.util.EventObject;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemAspectListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;

public class ItemCollectionListValueModelAdapter
extends ItemAspectListValueModelAdapter {
    protected final String[] collectionNames;
    protected CollectionChangeListener itemCollectionListener;

    public ItemCollectionListValueModelAdapter(ListValueModel listValueModel, String string) {
        this(listValueModel, new String[]{string});
    }

    public ItemCollectionListValueModelAdapter(ListValueModel listValueModel, String string, String string2) {
        this(listValueModel, new String[]{string, string2});
    }

    public ItemCollectionListValueModelAdapter(ListValueModel listValueModel, String string, String string2, String string3) {
        this(listValueModel, new String[]{string, string2, string3});
    }

    public ItemCollectionListValueModelAdapter(ListValueModel listValueModel, String[] stringArray) {
        super(listValueModel);
        this.collectionNames = stringArray;
    }

    public ItemCollectionListValueModelAdapter(CollectionValueModel collectionValueModel, String string) {
        this(collectionValueModel, new String[]{string});
    }

    public ItemCollectionListValueModelAdapter(CollectionValueModel collectionValueModel, String string, String string2) {
        this(collectionValueModel, new String[]{string, string2});
    }

    public ItemCollectionListValueModelAdapter(CollectionValueModel collectionValueModel, String string, String string2, String string3) {
        this(collectionValueModel, new String[]{string, string2, string3});
    }

    public ItemCollectionListValueModelAdapter(CollectionValueModel collectionValueModel, String[] stringArray) {
        super(collectionValueModel);
        this.collectionNames = stringArray;
    }

    protected void initialize() {
        super.initialize();
        this.itemCollectionListener = this.buildItemCollectionListener();
    }

    protected CollectionChangeListener buildItemCollectionListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent collectionChangeEvent) {
                ItemCollectionListValueModelAdapter.this.itemAspectChanged((EventObject)collectionChangeEvent);
            }

            public void itemsRemoved(CollectionChangeEvent collectionChangeEvent) {
                ItemCollectionListValueModelAdapter.this.itemAspectChanged((EventObject)collectionChangeEvent);
            }

            public void collectionChanged(CollectionChangeEvent collectionChangeEvent) {
                ItemCollectionListValueModelAdapter.this.itemAspectChanged((EventObject)collectionChangeEvent);
            }

            public String toString() {
                return "item collection listener: " + Arrays.asList(ItemCollectionListValueModelAdapter.this.collectionNames);
            }
        };
    }

    protected void startListeningToItem(Model model) {
        int n = this.collectionNames.length;
        while (n-- > 0) {
            model.addCollectionChangeListener(this.collectionNames[n], this.itemCollectionListener);
        }
    }

    protected void stopListeningToItem(Model model) {
        int n = this.collectionNames.length;
        while (n-- > 0) {
            model.removeCollectionChangeListener(this.collectionNames[n], this.itemCollectionListener);
        }
    }
}

