/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemAspectListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.utility.Model;

public class ItemPropertyListValueModelAdapter
extends ItemAspectListValueModelAdapter {
    protected final String[] propertyNames;
    protected PropertyChangeListener itemPropertyListener;

    public ItemPropertyListValueModelAdapter(ListValueModel listValueModel, String string) {
        this(listValueModel, new String[]{string});
    }

    public ItemPropertyListValueModelAdapter(ListValueModel listValueModel, String string, String string2) {
        this(listValueModel, new String[]{string, string2});
    }

    public ItemPropertyListValueModelAdapter(ListValueModel listValueModel, String string, String string2, String string3) {
        this(listValueModel, new String[]{string, string2, string3});
    }

    public ItemPropertyListValueModelAdapter(ListValueModel listValueModel, String[] stringArray) {
        super(listValueModel);
        this.propertyNames = stringArray;
    }

    public ItemPropertyListValueModelAdapter(CollectionValueModel collectionValueModel, String string) {
        this(collectionValueModel, new String[]{string});
    }

    public ItemPropertyListValueModelAdapter(CollectionValueModel collectionValueModel, String string, String string2) {
        this(collectionValueModel, new String[]{string, string2});
    }

    public ItemPropertyListValueModelAdapter(CollectionValueModel collectionValueModel, String string, String string2, String string3) {
        this(collectionValueModel, new String[]{string, string2, string3});
    }

    public ItemPropertyListValueModelAdapter(CollectionValueModel collectionValueModel, String[] stringArray) {
        super(collectionValueModel);
        this.propertyNames = stringArray;
    }

    protected void initialize() {
        super.initialize();
        this.itemPropertyListener = this.buildItemPropertyListener();
    }

    protected PropertyChangeListener buildItemPropertyListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ItemPropertyListValueModelAdapter.this.itemAspectChanged(propertyChangeEvent);
            }

            public String toString() {
                return "item property listener: " + Arrays.asList(ItemPropertyListValueModelAdapter.this.propertyNames);
            }
        };
    }

    protected void startListeningToItem(Model model) {
        int n = this.propertyNames.length;
        while (n-- > 0) {
            model.addPropertyChangeListener(this.propertyNames[n], this.itemPropertyListener);
        }
    }

    protected void stopListeningToItem(Model model) {
        int n = this.propertyNames.length;
        while (n-- > 0) {
            model.removePropertyChangeListener(this.propertyNames[n], this.itemPropertyListener);
        }
    }
}

