/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.uitools.app.AspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullListIterator;

public abstract class ListAspectAdapter
extends AspectAdapter
implements ListValueModel {
    protected String listName;
    protected ListChangeListener listChangeListener;

    protected ListAspectAdapter(String string, Model model) {
        super(model);
        this.listName = string;
    }

    protected ListAspectAdapter(ValueModel valueModel, String string) {
        super(valueModel);
        this.listName = string;
    }

    protected ListAspectAdapter(ValueModel valueModel) {
        this(valueModel, null);
    }

    protected void initialize() {
        super.initialize();
        this.listChangeListener = this.buildListChangeListener();
    }

    protected ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent listChangeEvent) {
                ListAspectAdapter.this.itemsAdded(listChangeEvent);
            }

            public void itemsRemoved(ListChangeEvent listChangeEvent) {
                ListAspectAdapter.this.itemsRemoved(listChangeEvent);
            }

            public void itemsReplaced(ListChangeEvent listChangeEvent) {
                ListAspectAdapter.this.itemsReplaced(listChangeEvent);
            }

            public void listChanged(ListChangeEvent listChangeEvent) {
                ListAspectAdapter.this.listChanged(listChangeEvent);
            }

            public String toString() {
                return "list change listener: " + ListAspectAdapter.this.listName;
            }
        };
    }

    public Object getValue() {
        if (this.subject == null) {
            return NullListIterator.instance();
        }
        return this.getValueFromSubject();
    }

    protected ListIterator getValueFromSubject() {
        throw new UnsupportedOperationException();
    }

    public void addItem(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public void addItems(int n, List list) {
        for (int i = 0; i < list.size(); ++i) {
            this.addItem(n + i, list.get(i));
        }
    }

    public Object removeItem(int n) {
        throw new UnsupportedOperationException();
    }

    public List removeItems(int n, int n2) {
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(this.removeItem(n));
        }
        return arrayList;
    }

    public Object replaceItem(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public List replaceItems(int n, List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(this.replaceItem(n + i, list.get(i)));
        }
        return arrayList;
    }

    public Object getItem(int n) {
        return CollectionTools.get((ListIterator)((ListIterator)this.getValue()), (int)n);
    }

    public int size() {
        return this.subject == null ? 0 : this.sizeFromSubject();
    }

    protected int sizeFromSubject() {
        return CollectionTools.size((Iterator)((ListIterator)this.getValue()));
    }

    protected boolean hasListeners() {
        return this.hasAnyListChangeListeners("value");
    }

    protected void fireAspectChange(Object object, Object object2) {
        this.fireListChanged("value");
    }

    protected void engageNonNullSubject() {
        if (this.listName != null) {
            ((Model)this.subject).addListChangeListener(this.listName, this.listChangeListener);
        }
    }

    protected void disengageNonNullSubject() {
        if (this.listName != null) {
            ((Model)this.subject).removeListChangeListener(this.listName, this.listChangeListener);
        }
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.listName);
    }

    protected void itemsAdded(ListChangeEvent listChangeEvent) {
        this.fireItemsAdded(listChangeEvent.cloneWithSource((Object)this, "value"));
    }

    protected void itemsRemoved(ListChangeEvent listChangeEvent) {
        this.fireItemsRemoved(listChangeEvent.cloneWithSource((Object)this, "value"));
    }

    protected void itemsReplaced(ListChangeEvent listChangeEvent) {
        this.fireItemsReplaced(listChangeEvent.cloneWithSource((Object)this, "value"));
    }

    protected void listChanged(ListChangeEvent listChangeEvent) {
        this.fireListChanged("value");
    }
}

