/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.persistence.tools.workbench.uitools.app.AspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.Model;

public abstract class PropertyAspectAdapter
extends AspectAdapter
implements PropertyValueModel {
    protected Object value;
    protected String[] propertyNames;
    protected PropertyChangeListener propertyChangeListener;

    protected PropertyAspectAdapter(String string, Model model) {
        this(new String[]{string}, model);
    }

    protected PropertyAspectAdapter(String[] stringArray, Model model) {
        super(model);
        this.propertyNames = stringArray;
    }

    protected PropertyAspectAdapter(ValueModel valueModel, String string) {
        this(valueModel, new String[]{string});
    }

    protected PropertyAspectAdapter(ValueModel valueModel, String string, String string2) {
        this(valueModel, new String[]{string, string2});
    }

    protected PropertyAspectAdapter(ValueModel valueModel, String string, String string2, String string3) {
        this(valueModel, new String[]{string, string2, string3});
    }

    protected PropertyAspectAdapter(ValueModel valueModel, String[] stringArray) {
        super(valueModel);
        this.propertyNames = stringArray;
    }

    protected PropertyAspectAdapter(ValueModel valueModel, Collection collection) {
        this(valueModel, collection.toArray(new String[collection.size()]));
    }

    protected PropertyAspectAdapter(ValueModel valueModel) {
        this(valueModel, new String[0]);
    }

    protected void initialize() {
        super.initialize();
        this.value = null;
        this.propertyChangeListener = this.buildPropertyChangeListener();
    }

    protected PropertyChangeListener buildPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PropertyAspectAdapter.this.propertyChanged();
            }

            public String toString() {
                return "property change listener: " + Arrays.asList(PropertyAspectAdapter.this.propertyNames);
            }
        };
    }

    public final Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        if (this.subject != null) {
            this.setValueOnSubject(object);
        }
    }

    protected void setValueOnSubject(Object object) {
        throw new UnsupportedOperationException();
    }

    protected boolean hasListeners() {
        return this.hasAnyPropertyChangeListeners("value");
    }

    protected void fireAspectChange(Object object, Object object2) {
        this.firePropertyChanged("value", object, object2);
    }

    protected void engageSubject() {
        super.engageSubject();
        this.value = this.buildValue();
    }

    protected void engageNonNullSubject() {
        int n = this.propertyNames.length;
        while (n-- > 0) {
            ((Model)this.subject).addPropertyChangeListener(this.propertyNames[n], this.propertyChangeListener);
        }
    }

    protected void disengageSubject() {
        super.disengageSubject();
        this.value = null;
    }

    protected void disengageNonNullSubject() {
        int n = this.propertyNames.length;
        while (n-- > 0) {
            ((Model)this.subject).removePropertyChangeListener(this.propertyNames[n], this.propertyChangeListener);
        }
    }

    public void toString(StringBuffer stringBuffer) {
        for (int i = 0; i < this.propertyNames.length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.propertyNames[i]);
        }
    }

    protected Object buildValue() {
        if (this.subject == null) {
            return null;
        }
        return this.getValueFromSubject();
    }

    protected Object getValueFromSubject() {
        throw new UnsupportedOperationException();
    }

    protected void propertyChanged() {
        Object object = this.value;
        this.value = this.buildValue();
        this.fireAspectChange(object, this.value);
    }
}

