/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.app.NullTransformer;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModelChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.Transformer;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;

public class TransformationValueModel
extends AbstractModel
implements ValueModel {
    private Transformer transformer;
    protected ValueModel valueHolder;
    protected PropertyChangeListener valueChangeListener;

    public TransformationValueModel(ValueModel valueModel) {
        this(valueModel, NullTransformer.instance());
    }

    public TransformationValueModel(ValueModel valueModel, Transformer transformer) {
        this.valueHolder = valueModel;
        this.transformer = transformer;
    }

    protected void initialize() {
        super.initialize();
        this.valueChangeListener = this.buildValueChangeListener();
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return new ValueModelChangeSupport(this);
    }

    protected PropertyChangeListener buildValueChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TransformationValueModel.this.valueChanged(propertyChangeEvent);
            }

            public String toString() {
                return "value change listener";
            }
        };
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.hasNoPropertyChangeListeners("value")) {
            this.engageValueHolder();
        }
        super.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (string == "value" && this.hasNoPropertyChangeListeners("value")) {
            this.engageValueHolder();
        }
        super.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        if (this.hasNoPropertyChangeListeners("value")) {
            this.disengageValueHolder();
        }
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(string, propertyChangeListener);
        if (string == "value" && this.hasNoPropertyChangeListeners("value")) {
            this.disengageValueHolder();
        }
    }

    protected void engageValueHolder() {
        this.valueHolder.addPropertyChangeListener("value", this.valueChangeListener);
    }

    protected void disengageValueHolder() {
        this.valueHolder.removePropertyChangeListener("value", this.valueChangeListener);
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.valueHolder);
    }

    public Object getValue() {
        return this.transform(this.valueHolder.getValue());
    }

    protected void valueChanged(PropertyChangeEvent propertyChangeEvent) {
        Object object = this.transform(propertyChangeEvent.getOldValue());
        Object object2 = this.transform(propertyChangeEvent.getNewValue());
        this.firePropertyChanged("value", object, object2);
    }

    protected Object transform(Object object) {
        return object == null ? null : this.transformNonNull(object);
    }

    protected Object transformNonNull(Object object) {
        return this.transformer.transform(object);
    }
}

