/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.Arrays;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueAspectPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;

public class ValueListPropertyValueModelAdapter
extends ValueAspectPropertyValueModelAdapter {
    protected final String[] listNames;
    protected ListChangeListener valueListListener;

    public ValueListPropertyValueModelAdapter(PropertyValueModel propertyValueModel, String string) {
        this(propertyValueModel, new String[]{string});
    }

    public ValueListPropertyValueModelAdapter(PropertyValueModel propertyValueModel, String string, String string2) {
        this(propertyValueModel, new String[]{string, string2});
    }

    public ValueListPropertyValueModelAdapter(PropertyValueModel propertyValueModel, String string, String string2, String string3) {
        this(propertyValueModel, new String[]{string, string2, string3});
    }

    public ValueListPropertyValueModelAdapter(PropertyValueModel propertyValueModel, String[] stringArray) {
        super(propertyValueModel);
        this.listNames = stringArray;
    }

    protected void initialize() {
        super.initialize();
        this.valueListListener = this.buildValueListListener();
    }

    protected ListChangeListener buildValueListListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent listChangeEvent) {
                ValueListPropertyValueModelAdapter.this.valueAspectChanged();
            }

            public void itemsRemoved(ListChangeEvent listChangeEvent) {
                ValueListPropertyValueModelAdapter.this.valueAspectChanged();
            }

            public void itemsReplaced(ListChangeEvent listChangeEvent) {
                ValueListPropertyValueModelAdapter.this.valueAspectChanged();
            }

            public void listChanged(ListChangeEvent listChangeEvent) {
                ValueListPropertyValueModelAdapter.this.valueAspectChanged();
            }

            public String toString() {
                return "value list listener: " + Arrays.asList(ValueListPropertyValueModelAdapter.this.listNames);
            }
        };
    }

    protected void startListeningToValue() {
        Model model = (Model)this.value;
        int n = this.listNames.length;
        while (n-- > 0) {
            model.addListChangeListener(this.listNames[n], this.valueListListener);
        }
    }

    protected void stopListeningToValue() {
        Model model = (Model)this.value;
        int n = this.listNames.length;
        while (n-- > 0) {
            model.removeListChangeListener(this.listNames[n], this.valueListListener);
        }
    }
}

