/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.adapters;

import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.uitools.app.AspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.string.BidiStringConverter;

public class PreferencePropertyValueModel
extends AspectAdapter
implements PropertyValueModel {
    protected String key;
    protected Object value;
    protected Object defaultValue;
    protected BidiStringConverter converter;
    protected PreferenceChangeListener preferenceChangeListener;

    public PreferencePropertyValueModel(Preferences preferences, String string) {
        this(preferences, string, null);
    }

    public PreferencePropertyValueModel(Preferences preferences, String string, Object object) {
        super(preferences);
        this.key = string;
        this.defaultValue = object;
    }

    public PreferencePropertyValueModel(Preferences preferences, String string, boolean bl) {
        this(preferences, string, (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
    }

    public PreferencePropertyValueModel(Preferences preferences, String string, int n) {
        this(preferences, string, (Object)new Integer(n));
    }

    public PreferencePropertyValueModel(ValueModel valueModel, String string) {
        this(valueModel, string, null);
    }

    public PreferencePropertyValueModel(ValueModel valueModel, String string, Object object) {
        super(valueModel);
        this.key = string;
        this.defaultValue = object;
    }

    protected void initialize() {
        super.initialize();
        this.value = null;
        this.converter = BidiStringConverter.DEFAULT_INSTANCE;
        this.preferenceChangeListener = this.buildPreferenceChangeListener();
    }

    protected PreferenceChangeListener buildPreferenceChangeListener() {
        return new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                PreferencePropertyValueModel.this.preferenceChanged(preferenceChangeEvent.getKey(), preferenceChangeEvent.getNewValue());
            }

            public String toString() {
                return "preference change listener";
            }
        };
    }

    public synchronized Object getValue() {
        return this.value;
    }

    public synchronized void setValue(Object object) {
        if (this.hasNoListeners()) {
            return;
        }
        Object object2 = this.value;
        this.value = object;
        this.fireAspectChange(object2, object);
        if (this.subject != null && this.shouldSetPreference(object2, object)) {
            this.setValueOnSubject(object);
        }
    }

    protected boolean hasListeners() {
        return this.hasAnyPropertyChangeListeners("value");
    }

    protected void fireAspectChange(Object object, Object object2) {
        this.firePropertyChanged("value", object, object2);
    }

    protected void engageNonNullSubject() {
        ((Preferences)this.subject).addPreferenceChangeListener(this.preferenceChangeListener);
        this.value = this.buildValue();
    }

    protected void disengageNonNullSubject() {
        block2: {
            try {
                ((Preferences)this.subject).removePreferenceChangeListener(this.preferenceChangeListener);
            }
            catch (IllegalStateException illegalStateException) {
                if (illegalStateException.getMessage().equals("Node has been removed.")) break block2;
                throw illegalStateException;
            }
        }
        this.value = null;
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.key);
        stringBuffer.append(" => ");
        stringBuffer.append(this.value);
    }

    public String getKey() {
        return this.key;
    }

    public synchronized BidiStringConverter getConverter() {
        return this.converter;
    }

    public synchronized void setConverter(BidiStringConverter bidiStringConverter) {
        this.converter = bidiStringConverter;
    }

    protected Object buildValue() {
        if (this.subject == null) {
            return null;
        }
        return this.getValueFromSubject();
    }

    protected Object getValueFromSubject() {
        return this.convertToObject(((Preferences)this.subject).get(this.key, this.convertToString(this.defaultValue)));
    }

    protected void setValueOnSubject(Object object) {
        ((Preferences)this.subject).put(this.key, this.convertToString(object));
    }

    protected boolean shouldSetPreference(Object object, Object object2) {
        return this.attributeValueHasChanged(object, object2);
    }

    protected String convertToString(Object object) {
        return this.converter.convertToString(object);
    }

    protected Object convertToObject(String string) {
        return this.converter.convertToObject(string);
    }

    protected void preferenceChanged(String string, String string2) {
        if (string.equals(this.key)) {
            this.preferenceChanged();
        }
    }

    protected synchronized void preferenceChanged() {
        Object object = this.value;
        this.value = this.buildValue();
        this.fireAspectChange(object, this.value);
    }
}

