/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.io.Serializable;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;

public abstract class AbstractTreeModel
implements TreeModel,
Serializable {
    protected EventListenerList listenerList;

    protected AbstractTreeModel() {
        this.initialize();
    }

    protected void initialize() {
        this.listenerList = new EventListenerList();
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    public TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
    }

    protected boolean hasNoTreeModelListeners() {
        return this.listenerList.getListenerCount(TreeModelListener.class) == 0;
    }

    protected boolean hasTreeModelListeners() {
        return !this.hasNoTreeModelListeners();
    }

    protected void fireTreeNodesChanged(Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent((Object)this, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodeChanged(Object[] objectArray, int n, Object object) {
        this.fireTreeNodesChanged(objectArray, new int[]{n}, new Object[]{object});
    }

    protected void fireTreeRootChanged(Object object) {
        this.fireTreeNodesChanged(new Object[]{object}, null, null);
    }

    protected void fireTreeNodesInserted(Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent((Object)this, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodeInserted(Object[] objectArray, int n, Object object) {
        this.fireTreeNodesInserted(objectArray, new int[]{n}, new Object[]{object});
    }

    protected void fireTreeNodesRemoved(Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent((Object)this, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeNodeRemoved(Object[] objectArray, int n, Object object) {
        this.fireTreeNodesRemoved(objectArray, new int[]{n}, new Object[]{object});
    }

    protected void fireTreeStructureChanged(Object[] objectArray) {
        Object[] objectArray2 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray2.length - 2; i >= 0; i -= 2) {
            if (objectArray2[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent((Object)this, objectArray);
            }
            ((TreeModelListener)objectArray2[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    protected void fireTreeRootReplaced(Object object) {
        this.fireTreeStructureChanged(new Object[]{object});
    }
}

