/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class DateSpinnerModelAdapter
extends SpinnerDateModel {
    private Date defaultValue;
    private PropertyValueModel dateHolder;
    private PropertyChangeListener dateChangeListener;

    public DateSpinnerModelAdapter(PropertyValueModel propertyValueModel) {
        this(propertyValueModel, new Date());
    }

    public DateSpinnerModelAdapter(PropertyValueModel propertyValueModel, Date date) {
        this(propertyValueModel, null, null, 5, date);
    }

    public DateSpinnerModelAdapter(PropertyValueModel propertyValueModel, Comparable comparable, Comparable comparable2, int n) {
        this(propertyValueModel, comparable, comparable2, n, new Date());
    }

    public DateSpinnerModelAdapter(PropertyValueModel propertyValueModel, Comparable comparable, Comparable comparable2, int n, Date date) {
        super(propertyValueModel.getValue() == null ? date : (Date)propertyValueModel.getValue(), comparable, comparable2, n);
        this.dateHolder = propertyValueModel;
        this.dateChangeListener = this.buildDateChangeListener();
        this.defaultValue = date;
    }

    private PropertyChangeListener buildDateChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DateSpinnerModelAdapter.this.synchronize(propertyChangeEvent.getNewValue());
            }

            public String toString() {
                return "date listener";
            }
        };
    }

    public Object getValue() {
        if (this.getChangeListeners().length == 0) {
            super.setValue(this.spinnerValueOf(this.dateHolder.getValue()));
        }
        return super.getValue();
    }

    public void setValue(Object object) {
        super.setValue(object);
        this.dateHolder.setValue(object);
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.getChangeListeners().length == 0) {
            this.dateHolder.addPropertyChangeListener("value", this.dateChangeListener);
            this.synchronize(this.dateHolder.getValue());
        }
        super.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        super.removeChangeListener(changeListener);
        if (this.getChangeListeners().length == 0) {
            this.dateHolder.removePropertyChangeListener("value", this.dateChangeListener);
        }
    }

    protected Date getDefaultValue() {
        return this.defaultValue;
    }

    protected Object spinnerValueOf(Object object) {
        return object == null ? this.getDefaultValue() : object;
    }

    void synchronize(Object object) {
        Object object2 = this.spinnerValueOf(object);
        if (!this.getValue().equals(object2)) {
            this.setValue(object2);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.dateHolder);
    }
}

