/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class DocumentAdapter
implements Document,
Serializable {
    protected Document delegate;
    protected CombinedListener delegateListener;
    protected PropertyValueModel stringHolder;
    protected PropertyChangeListener stringListener;
    protected EventListenerList listenerList = new EventListenerList();

    private DocumentAdapter() {
        this.initialize();
    }

    public DocumentAdapter(PropertyValueModel propertyValueModel, Document document) {
        this();
        if (propertyValueModel == null || document == null) {
            throw new NullPointerException();
        }
        this.stringHolder = propertyValueModel;
        this.delegate = document;
    }

    public DocumentAdapter(PropertyValueModel propertyValueModel) {
        this(propertyValueModel, new PlainDocument());
    }

    protected void initialize() {
        this.stringListener = this.buildStringListener();
        this.delegateListener = this.buildDelegateListener();
    }

    protected PropertyChangeListener buildStringListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DocumentAdapter.this.stringChanged(propertyChangeEvent);
            }

            public String toString() {
                return "string listener";
            }
        };
    }

    protected CombinedListener buildDelegateListener() {
        return new InternalListener();
    }

    public int getLength() {
        return this.delegate.getLength();
    }

    public void addDocumentListener(DocumentListener documentListener) {
        if (this.listenerList.getListenerCount(DocumentListener.class) == 0) {
            this.delegate.addDocumentListener(this.delegateListener);
            this.engageStringHolder();
        }
        this.listenerList.add(DocumentListener.class, documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.listenerList.remove(DocumentListener.class, documentListener);
        if (this.listenerList.getListenerCount(DocumentListener.class) == 0) {
            this.disengageStringHolder();
            this.delegate.removeDocumentListener(this.delegateListener);
        }
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        if (this.listenerList.getListenerCount(UndoableEditListener.class) == 0) {
            this.delegate.addUndoableEditListener(this.delegateListener);
        }
        this.listenerList.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listenerList.remove(UndoableEditListener.class, undoableEditListener);
        if (this.listenerList.getListenerCount(UndoableEditListener.class) == 0) {
            this.delegate.removeUndoableEditListener(this.delegateListener);
        }
    }

    public Object getProperty(Object object) {
        return this.delegate.getProperty(object);
    }

    public void putProperty(Object object, Object object2) {
        this.delegate.putProperty(object, object2);
    }

    public void remove(int n, int n2) throws BadLocationException {
        this.delegate.remove(n, n2);
        this.stringHolder.setValue(this.delegate.getText(0, this.delegate.getLength()));
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        this.delegate.insertString(n, string, attributeSet);
        this.stringHolder.setValue(this.delegate.getText(0, this.delegate.getLength()));
    }

    public String getText(int n, int n2) throws BadLocationException {
        return this.delegate.getText(n, n2);
    }

    public void getText(int n, int n2, Segment segment) throws BadLocationException {
        this.delegate.getText(n, n2, segment);
    }

    public Position getStartPosition() {
        return this.delegate.getStartPosition();
    }

    public Position getEndPosition() {
        return this.delegate.getEndPosition();
    }

    public Position createPosition(int n) throws BadLocationException {
        return this.delegate.createPosition(n);
    }

    public Element[] getRootElements() {
        return this.delegate.getRootElements();
    }

    public Element getDefaultRootElement() {
        return this.delegate.getDefaultRootElement();
    }

    public void render(Runnable runnable) {
        this.delegate.render(runnable);
    }

    public DocumentListener[] getDocumentListeners() {
        return (DocumentListener[])this.listenerList.getListeners(DocumentListener.class);
    }

    public UndoableEditListener[] getUndoableEditListeners() {
        return (UndoableEditListener[])this.listenerList.getListeners(UndoableEditListener.class);
    }

    protected void stringChanged(PropertyChangeEvent propertyChangeEvent) {
        this.synchronizeDelegate((String)propertyChangeEvent.getNewValue());
    }

    protected void synchronizeDelegate(String string) {
        try {
            int n = this.delegate.getLength();
            if (!this.delegate.getText(0, n).equals(string)) {
                this.delegate.remove(0, n);
                this.delegate.insertString(0, string, null);
            }
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalStateException(badLocationException.getMessage());
        }
    }

    protected void engageStringHolder() {
        this.stringHolder.addPropertyChangeListener("value", this.stringListener);
        this.synchronizeDelegate((String)this.stringHolder.getValue());
    }

    protected void disengageStringHolder() {
        this.stringHolder.removePropertyChangeListener("value", this.stringListener);
    }

    protected void delegateChangedUpdate(DocumentEvent documentEvent) {
        InternalDocumentEvent internalDocumentEvent = new InternalDocumentEvent(this, documentEvent);
        DocumentListener[] documentListenerArray = this.getDocumentListeners();
        int n = documentListenerArray.length;
        while (n-- > 0) {
            documentListenerArray[n].changedUpdate(internalDocumentEvent);
        }
    }

    protected void delegateInsertUpdate(DocumentEvent documentEvent) {
        InternalDocumentEvent internalDocumentEvent = new InternalDocumentEvent(this, documentEvent);
        DocumentListener[] documentListenerArray = this.getDocumentListeners();
        int n = documentListenerArray.length;
        while (n-- > 0) {
            documentListenerArray[n].insertUpdate(internalDocumentEvent);
        }
    }

    protected void delegateRemoveUpdate(DocumentEvent documentEvent) {
        InternalDocumentEvent internalDocumentEvent = new InternalDocumentEvent(this, documentEvent);
        DocumentListener[] documentListenerArray = this.getDocumentListeners();
        int n = documentListenerArray.length;
        while (n-- > 0) {
            documentListenerArray[n].removeUpdate(internalDocumentEvent);
        }
    }

    protected void delegateUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        UndoableEditEvent undoableEditEvent2 = new UndoableEditEvent(this, undoableEditEvent.getEdit());
        UndoableEditListener[] undoableEditListenerArray = this.getUndoableEditListeners();
        int n = undoableEditListenerArray.length;
        while (n-- > 0) {
            undoableEditListenerArray[n].undoableEditHappened(undoableEditEvent2);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.stringHolder);
    }

    protected static class InternalDocumentEvent
    extends EventObject
    implements DocumentEvent {
        protected DocumentEvent delegate;

        protected InternalDocumentEvent(Document document, DocumentEvent documentEvent) {
            super(document);
            this.delegate = documentEvent;
        }

        public DocumentEvent.ElementChange getChange(Element element) {
            return this.delegate.getChange(element);
        }

        public Document getDocument() {
            return (Document)this.source;
        }

        public int getLength() {
            return this.delegate.getLength();
        }

        public int getOffset() {
            return this.delegate.getOffset();
        }

        public DocumentEvent.EventType getType() {
            return this.delegate.getType();
        }
    }

    protected class InternalListener
    implements CombinedListener {
        protected InternalListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            DocumentAdapter.this.delegateChangedUpdate(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            DocumentAdapter.this.delegateInsertUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            DocumentAdapter.this.delegateRemoveUpdate(documentEvent);
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            DocumentAdapter.this.delegateUndoableEditHappened(undoableEditEvent);
        }
    }

    protected static interface CombinedListener
    extends DocumentListener,
    UndoableEditListener {
    }
}

