/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import javax.swing.AbstractListModel;
import javax.swing.event.ListDataListener;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ListModelAdapter
extends AbstractListModel {
    protected ListValueModel listHolder;
    protected int listSize;
    protected ListChangeListener listChangeListener;

    private ListModelAdapter() {
        this.initialize();
    }

    public ListModelAdapter(ListValueModel listValueModel) {
        this();
        this.setModel(listValueModel);
    }

    public ListModelAdapter(CollectionValueModel collectionValueModel) {
        this();
        this.setModel(collectionValueModel);
    }

    protected void initialize() {
        this.listSize = 0;
        this.listChangeListener = this.buildListChangeListener();
    }

    protected ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent listChangeEvent) {
                ListModelAdapter.this.itemsAdded(listChangeEvent);
            }

            public void itemsRemoved(ListChangeEvent listChangeEvent) {
                ListModelAdapter.this.itemsRemoved(listChangeEvent);
            }

            public void itemsReplaced(ListChangeEvent listChangeEvent) {
                ListModelAdapter.this.itemsReplaced(listChangeEvent);
            }

            public void listChanged(ListChangeEvent listChangeEvent) {
                ListModelAdapter.this.listChanged();
            }

            public String toString() {
                return "list listener";
            }
        };
    }

    public int getSize() {
        return this.listHolder.size();
    }

    public Object getElementAt(int n) {
        return this.listHolder.getItem(n);
    }

    public void addListDataListener(ListDataListener listDataListener) {
        if (this.hasNoListDataListeners()) {
            this.engageModel();
            this.listSize = this.listHolder.size();
        }
        super.addListDataListener(listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        super.removeListDataListener(listDataListener);
        if (this.hasNoListDataListeners()) {
            this.disengageModel();
            this.listSize = 0;
        }
    }

    public ListValueModel getModel() {
        return this.listHolder;
    }

    public void setModel(ListValueModel listValueModel) {
        if (listValueModel == null) {
            throw new NullPointerException();
        }
        boolean bl = this.hasListDataListeners();
        if (bl) {
            this.disengageModel();
        }
        this.listHolder = listValueModel;
        if (bl) {
            this.engageModel();
            this.listChanged();
        }
    }

    public void setModel(CollectionValueModel collectionValueModel) {
        this.setModel(new CollectionListValueModelAdapter(collectionValueModel));
    }

    protected boolean hasNoListDataListeners() {
        return this.getListDataListeners().length == 0;
    }

    protected boolean hasListDataListeners() {
        return !this.hasNoListDataListeners();
    }

    protected void engageModel() {
        this.listHolder.addListChangeListener("value", this.listChangeListener);
    }

    protected void disengageModel() {
        this.listHolder.removeListChangeListener("value", this.listChangeListener);
    }

    protected void itemsAdded(ListChangeEvent listChangeEvent) {
        int n = listChangeEvent.getIndex();
        int n2 = n + listChangeEvent.size() - 1;
        this.fireIntervalAdded(this, n, n2);
        this.listSize += listChangeEvent.size();
    }

    protected void itemsRemoved(ListChangeEvent listChangeEvent) {
        int n = listChangeEvent.getIndex();
        int n2 = n + listChangeEvent.size() - 1;
        this.fireIntervalRemoved(this, n, n2);
        this.listSize -= listChangeEvent.size();
    }

    protected void itemsReplaced(ListChangeEvent listChangeEvent) {
        int n = listChangeEvent.getIndex();
        int n2 = n + listChangeEvent.size() - 1;
        this.fireContentsChanged(this, n, n2);
    }

    protected void listChanged() {
        if (this.listSize != 0) {
            this.fireIntervalRemoved(this, 0, this.listSize - 1);
        }
        this.listSize = this.listHolder.size();
        if (this.listSize != 0) {
            this.fireIntervalAdded(this, 0, this.listSize - 1);
        } else {
            this.fireContentsChanged(this, 0, -1);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.listHolder);
    }
}

