/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ListSpinnerModelAdapter
extends SpinnerListModel {
    private Object defaultValue;
    private PropertyValueModel valueHolder;
    private PropertyChangeListener valueChangeListener;

    public ListSpinnerModelAdapter(PropertyValueModel propertyValueModel) {
        this(propertyValueModel, propertyValueModel.getValue());
    }

    public ListSpinnerModelAdapter(PropertyValueModel propertyValueModel, Object object) {
        this(propertyValueModel, new Object[]{object}, object);
    }

    public ListSpinnerModelAdapter(PropertyValueModel propertyValueModel, Object[] objectArray) {
        this(propertyValueModel, objectArray, objectArray[0]);
    }

    public ListSpinnerModelAdapter(PropertyValueModel propertyValueModel, Object[] objectArray, Object object) {
        this(propertyValueModel, Arrays.asList(objectArray), object);
    }

    public ListSpinnerModelAdapter(PropertyValueModel propertyValueModel, List list) {
        this(propertyValueModel, list, list.get(0));
    }

    public ListSpinnerModelAdapter(PropertyValueModel propertyValueModel, List list, Object object) {
        super(list);
        this.valueHolder = propertyValueModel;
        this.valueChangeListener = this.buildValueChangeListener();
        this.defaultValue = object;
    }

    private PropertyChangeListener buildValueChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ListSpinnerModelAdapter.this.synchronize(propertyChangeEvent.getNewValue());
            }

            public String toString() {
                return "value listener";
            }
        };
    }

    public Object getValue() {
        if (this.getChangeListeners().length == 0) {
            super.setValue(this.spinnerValueOf(this.valueHolder.getValue()));
        }
        return super.getValue();
    }

    public void setValue(Object object) {
        super.setValue(object);
        this.valueHolder.setValue(object);
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.getChangeListeners().length == 0) {
            this.valueHolder.addPropertyChangeListener("value", this.valueChangeListener);
            this.synchronize(this.valueHolder.getValue());
        }
        super.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        super.removeChangeListener(changeListener);
        if (this.getChangeListeners().length == 0) {
            this.valueHolder.removePropertyChangeListener("value", this.valueChangeListener);
        }
    }

    protected Object getDefaultValue() {
        return this.defaultValue;
    }

    protected Object spinnerValueOf(Object object) {
        return object == null ? this.getDefaultValue() : object;
    }

    void synchronize(Object object) {
        Object object2 = this.spinnerValueOf(object);
        if (!this.getValue().equals(object2)) {
            this.setValue(object2);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.valueHolder);
    }
}

