/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;

public class TableModelAdapter
extends AbstractTableModel {
    private ListValueModel listHolder;
    private ListChangeListener listChangeListener;
    private ArrayList rows;
    private ColumnAdapter columnAdapter;
    private PropertyChangeListener cellListener;

    private TableModelAdapter() {
        this.initialize();
    }

    public TableModelAdapter(ListValueModel listValueModel, ColumnAdapter columnAdapter) {
        this();
        if (listValueModel == null) {
            throw new NullPointerException();
        }
        this.listHolder = listValueModel;
        this.columnAdapter = columnAdapter;
    }

    public TableModelAdapter(CollectionValueModel collectionValueModel, ColumnAdapter columnAdapter) {
        this(new CollectionListValueModelAdapter(collectionValueModel), columnAdapter);
    }

    private void initialize() {
        this.listChangeListener = this.buildListChangeListener();
        this.rows = new ArrayList();
        this.cellListener = this.buildCellListener();
    }

    private ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent listChangeEvent) {
                TableModelAdapter.this.addRows(listChangeEvent.getIndex(), listChangeEvent.size(), listChangeEvent.items());
            }

            public void itemsRemoved(ListChangeEvent listChangeEvent) {
                TableModelAdapter.this.removeRows(listChangeEvent.getIndex(), listChangeEvent.size());
            }

            public void itemsReplaced(ListChangeEvent listChangeEvent) {
                TableModelAdapter.this.replaceRows(listChangeEvent.getIndex(), listChangeEvent.items());
            }

            public void listChanged(ListChangeEvent listChangeEvent) {
                TableModelAdapter.this.rebuildTable();
            }

            public String toString() {
                return "list listener";
            }
        };
    }

    private PropertyChangeListener buildCellListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TableModelAdapter.this.cellChanged((PropertyValueModel)propertyChangeEvent.getSource());
            }

            public String toString() {
                return "cell listener";
            }
        };
    }

    public int getColumnCount() {
        return this.columnAdapter.getColumnCount();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public String getColumnName(int n) {
        return this.columnAdapter.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this.columnAdapter.getColumnClass(n);
    }

    public boolean isCellEditable(int n, int n2) {
        return this.columnAdapter.isColumnEditable(n2);
    }

    public Object getValueAt(int n, int n2) {
        PropertyValueModel[] propertyValueModelArray = (PropertyValueModel[])this.rows.get(n);
        return propertyValueModelArray[n2].getValue();
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n < this.rows.size()) {
            PropertyValueModel[] propertyValueModelArray = (PropertyValueModel[])this.rows.get(n);
            propertyValueModelArray[n2].setValue(object);
        }
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        if (this.hasNoTableModelListeners()) {
            this.engageModel();
        }
        super.addTableModelListener(tableModelListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        super.removeTableModelListener(tableModelListener);
        if (this.hasNoTableModelListeners()) {
            this.disengageModel();
        }
    }

    public ListValueModel getModel() {
        return this.listHolder;
    }

    public void setModel(ListValueModel listValueModel) {
        if (listValueModel == null) {
            throw new NullPointerException();
        }
        boolean bl = this.hasTableModelListeners();
        if (bl) {
            this.disengageModel();
        }
        this.listHolder = listValueModel;
        if (bl) {
            this.engageModel();
            this.fireTableDataChanged();
        }
    }

    public void setModel(CollectionValueModel collectionValueModel) {
        this.setModel(new CollectionListValueModelAdapter(collectionValueModel));
    }

    protected boolean hasNoTableModelListeners() {
        return this.listenerList.getListenerCount(TableModelListener.class) == 0;
    }

    protected boolean hasTableModelListeners() {
        return !this.hasNoTableModelListeners();
    }

    private void engageModel() {
        this.listHolder.addListChangeListener("value", this.listChangeListener);
        this.engageAllCells();
    }

    private void engageAllCells() {
        this.rows.ensureCapacity(this.listHolder.size());
        Iterator iterator = (Iterator)this.listHolder.getValue();
        while (iterator.hasNext()) {
            PropertyValueModel[] propertyValueModelArray = this.columnAdapter.cellModels(iterator.next());
            this.engageRow(propertyValueModelArray);
            this.rows.add(propertyValueModelArray);
        }
    }

    private void engageRow(PropertyValueModel[] propertyValueModelArray) {
        int n = propertyValueModelArray.length;
        while (n-- > 0) {
            propertyValueModelArray[n].addPropertyChangeListener("value", this.cellListener);
        }
    }

    private void disengageModel() {
        this.disengageAllCells();
        this.listHolder.removeListChangeListener("value", this.listChangeListener);
    }

    private void disengageAllCells() {
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            this.disengageRow((PropertyValueModel[])iterator.next());
        }
        this.rows.clear();
    }

    private void disengageRow(PropertyValueModel[] propertyValueModelArray) {
        int n = propertyValueModelArray.length;
        while (n-- > 0) {
            propertyValueModelArray[n].removePropertyChangeListener("value", this.cellListener);
        }
    }

    void cellChanged(PropertyValueModel propertyValueModel) {
        int n = this.rows.size();
        while (n-- > 0) {
            PropertyValueModel[] propertyValueModelArray = (PropertyValueModel[])this.rows.get(n);
            int n2 = propertyValueModelArray.length;
            while (n2-- > 0) {
                if (propertyValueModelArray[n2] != propertyValueModel) continue;
                this.fireTableCellUpdated(n, n2);
            }
        }
    }

    void addRows(int n, int n2, Iterator iterator) {
        ArrayList<PropertyValueModel[]> arrayList = new ArrayList<PropertyValueModel[]>(n2);
        while (iterator.hasNext()) {
            PropertyValueModel[] propertyValueModelArray = this.columnAdapter.cellModels(iterator.next());
            this.engageRow(propertyValueModelArray);
            arrayList.add(propertyValueModelArray);
        }
        this.rows.addAll(n, arrayList);
        this.fireTableRowsInserted(n, n + n2 - 1);
    }

    void removeRows(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            PropertyValueModel[] propertyValueModelArray = (PropertyValueModel[])this.rows.remove(n);
            this.disengageRow(propertyValueModelArray);
        }
        this.fireTableRowsDeleted(n, n + n2 - 1);
    }

    void replaceRows(int n, Iterator iterator) {
        int n2 = n;
        while (iterator.hasNext()) {
            PropertyValueModel[] propertyValueModelArray = (PropertyValueModel[])this.rows.get(n2);
            this.disengageRow(propertyValueModelArray);
            propertyValueModelArray = this.columnAdapter.cellModels(iterator.next());
            this.engageRow(propertyValueModelArray);
            this.rows.set(n2, propertyValueModelArray);
            ++n2;
        }
        this.fireTableRowsUpdated(n, --n2);
    }

    void rebuildTable() {
        this.disengageAllCells();
        this.engageAllCells();
        this.fireTableDataChanged();
    }
}

