/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ToggleButtonModelAdapter
extends JToggleButton.ToggleButtonModel {
    protected boolean defaultValue;
    protected PropertyValueModel booleanHolder;
    protected PropertyChangeListener booleanChangeListener;

    private ToggleButtonModelAdapter() {
        this.initialize();
    }

    public ToggleButtonModelAdapter(PropertyValueModel propertyValueModel, boolean bl) {
        this();
        if (propertyValueModel == null) {
            throw new NullPointerException();
        }
        this.booleanHolder = propertyValueModel;
        this.defaultValue = bl;
    }

    public ToggleButtonModelAdapter(PropertyValueModel propertyValueModel) {
        this(propertyValueModel, false);
    }

    protected void initialize() {
        this.booleanChangeListener = this.buildBooleanChangeListener();
    }

    protected PropertyChangeListener buildBooleanChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ToggleButtonModelAdapter.this.booleanChanged(propertyChangeEvent);
            }

            public String toString() {
                return "boolean listener";
            }
        };
    }

    public void setSelected(boolean bl) {
        if (this.isSelected() != bl) {
            super.setSelected(bl);
            this.booleanHolder.setValue(bl);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        super.removeActionListener(actionListener);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    public void addItemListener(ItemListener itemListener) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addItemListener(itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        super.removeItemListener(itemListener);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        super.removeChangeListener(changeListener);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    protected boolean hasNoListeners() {
        return this.listenerList.getListenerCount() == 0;
    }

    protected boolean getDefaultValue() {
        return this.defaultValue;
    }

    protected void setSelected(Boolean bl) {
        if (bl == null) {
            this.setSelected(this.getDefaultValue());
        } else {
            this.setSelected((boolean)bl);
        }
    }

    protected void booleanChanged(PropertyChangeEvent propertyChangeEvent) {
        this.setSelected((Boolean)propertyChangeEvent.getNewValue());
    }

    protected void engageModel() {
        this.booleanHolder.addPropertyChangeListener("value", this.booleanChangeListener);
        this.setSelected((Boolean)this.booleanHolder.getValue());
    }

    protected void disengageModel() {
        this.booleanHolder.removePropertyChangeListener("value", this.booleanChangeListener);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.booleanHolder);
    }
}

