/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.AbstractTreeModel;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeListener;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class TreeModelAdapter
extends AbstractTreeModel {
    private PropertyValueModel rootHolder;
    private PropertyChangeListener rootListener;
    private StateChangeListener nodeStateListener;
    private PropertyChangeListener nodeValueListener;
    private ListChangeListener childrenListener;
    private TreeNodeValueModel root;
    IdentityHashMap childrenLists;
    IdentityHashMap parents;

    public TreeModelAdapter(PropertyValueModel propertyValueModel) {
        if (propertyValueModel == null) {
            throw new NullPointerException();
        }
        this.rootHolder = propertyValueModel;
    }

    public TreeModelAdapter(TreeNodeValueModel treeNodeValueModel) {
        this(new ReadOnlyPropertyValueModel(treeNodeValueModel));
    }

    protected void initialize() {
        super.initialize();
        this.rootListener = this.buildRootListener();
        this.nodeStateListener = this.buildNodeStateListener();
        this.nodeValueListener = this.buildNodeValueListener();
        this.childrenListener = this.buildChildrenListener();
        this.childrenLists = new IdentityHashMap();
        this.parents = new IdentityHashMap();
    }

    private PropertyChangeListener buildRootListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TreeModelAdapter.this.rootChanged();
            }

            public String toString() {
                return "root listener";
            }
        };
    }

    private PropertyChangeListener buildNodeValueListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TreeModelAdapter.this.nodeChanged((TreeNodeValueModel)propertyChangeEvent.getSource());
            }

            public String toString() {
                return "node value listener";
            }
        };
    }

    private StateChangeListener buildNodeStateListener() {
        return new StateChangeListener(){

            public void stateChanged(StateChangeEvent stateChangeEvent) {
                TreeModelAdapter.this.nodeChanged((TreeNodeValueModel)stateChangeEvent.getSource());
            }

            public String toString() {
                return "node state listener";
            }
        };
    }

    private ListChangeListener buildChildrenListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent listChangeEvent) {
                new EventChangePolicy(listChangeEvent).addChildren();
            }

            public void itemsRemoved(ListChangeEvent listChangeEvent) {
                new EventChangePolicy(listChangeEvent).removeChildren();
            }

            public void itemsReplaced(ListChangeEvent listChangeEvent) {
                new EventChangePolicy(listChangeEvent).replaceChildren();
            }

            public void listChanged(ListChangeEvent listChangeEvent) {
                new EventChangePolicy(listChangeEvent).rebuildChildren();
            }

            public String toString() {
                return "children listener";
            }
        };
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object object, int n) {
        return ((TreeNodeValueModel)object).getChild(n);
    }

    public int getChildCount(Object object) {
        return ((TreeNodeValueModel)object).childrenSize();
    }

    public boolean isLeaf(Object object) {
        return ((TreeNodeValueModel)object).isLeaf();
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        ((TreeNodeValueModel)treePath.getLastPathComponent()).setValue(object);
    }

    public int getIndexOfChild(Object object, Object object2) {
        return ((TreeNodeValueModel)object).indexOfChild((TreeNodeValueModel)object2);
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        if (this.hasNoTreeModelListeners()) {
            this.engageModel();
        }
        super.addTreeModelListener(treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        super.removeTreeModelListener(treeModelListener);
        if (this.hasNoTreeModelListeners()) {
            this.disengageModel();
        }
    }

    private void engageModel() {
        this.rootHolder.addPropertyChangeListener("value", this.rootListener);
        this.root = (TreeNodeValueModel)this.rootHolder.getValue();
        if (this.root == null) {
            throw new NullPointerException();
        }
        this.engageNode(this.root);
        this.addRoot();
    }

    private void addRoot() {
        this.addNode(0, this.root);
    }

    private void disengageModel() {
        this.removeRoot();
        this.disengageNode(this.root);
        this.root = null;
        this.rootHolder.removePropertyChangeListener("value", this.rootListener);
    }

    private void removeRoot() {
        this.removeNode(0, this.root);
    }

    void rootChanged() {
        TreeNodeValueModel treeNodeValueModel = (TreeNodeValueModel)this.rootHolder.getValue();
        if (treeNodeValueModel == null) {
            throw new NullPointerException();
        }
        this.removeRoot();
        TreeNodeValueModel treeNodeValueModel2 = this.root;
        this.root = treeNodeValueModel;
        this.engageNode(this.root);
        this.fireTreeRootReplaced(this.root);
        this.disengageNode(treeNodeValueModel2);
        this.addRoot();
    }

    void nodeChanged(TreeNodeValueModel treeNodeValueModel) {
        TreeNodeValueModel treeNodeValueModel2 = treeNodeValueModel.getParent();
        if (treeNodeValueModel2 == null) {
            this.fireTreeRootChanged(treeNodeValueModel);
        } else {
            this.fireTreeNodeChanged(treeNodeValueModel2.path(), treeNodeValueModel2.indexOfChild(treeNodeValueModel), treeNodeValueModel);
        }
    }

    void addChildren(Object[] objectArray, int[] nArray, Object[] objectArray2) {
        int n;
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            this.engageNode((TreeNodeValueModel)objectArray2[n]);
        }
        this.fireTreeNodesInserted(objectArray, nArray, objectArray2);
        for (n = 0; n < n2; ++n) {
            this.addNode(nArray[n], (TreeNodeValueModel)objectArray2[n]);
        }
    }

    private void engageNode(TreeNodeValueModel treeNodeValueModel) {
        treeNodeValueModel.addStateChangeListener(this.nodeStateListener);
        treeNodeValueModel.addPropertyChangeListener("value", this.nodeValueListener);
        treeNodeValueModel.getChildrenModel().addListChangeListener("value", this.childrenListener);
    }

    private void addNode(int n, TreeNodeValueModel treeNodeValueModel) {
        this.addNodeToInternalTree(treeNodeValueModel.getParent(), n, treeNodeValueModel, treeNodeValueModel.getChildrenModel());
        new NodeChangePolicy(treeNodeValueModel).addChildren();
    }

    private void addNodeToInternalTree(TreeNodeValueModel treeNodeValueModel, int n, TreeNodeValueModel treeNodeValueModel2, ListValueModel listValueModel) {
        ArrayList<TreeNodeValueModel> arrayList = (ArrayList<TreeNodeValueModel>)this.childrenLists.get(treeNodeValueModel);
        if (arrayList == null) {
            arrayList = new ArrayList<TreeNodeValueModel>();
            this.childrenLists.put(treeNodeValueModel, arrayList);
        }
        arrayList.add(n, treeNodeValueModel2);
        this.parents.put(listValueModel, treeNodeValueModel2);
    }

    void removeChildren(Object[] objectArray, int[] nArray, Object[] objectArray2) {
        int n;
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            this.removeNode(nArray[n] - n, (TreeNodeValueModel)objectArray2[n]);
        }
        this.fireTreeNodesRemoved(objectArray, nArray, objectArray2);
        for (n = 0; n < n2; ++n) {
            this.disengageNode((TreeNodeValueModel)objectArray2[n]);
        }
    }

    private void removeNode(int n, TreeNodeValueModel treeNodeValueModel) {
        new NodeChangePolicy(treeNodeValueModel).removeChildren();
        this.removeNodeFromInternalTree(treeNodeValueModel.getParent(), n, treeNodeValueModel, treeNodeValueModel.getChildrenModel());
    }

    private void removeNodeFromInternalTree(TreeNodeValueModel treeNodeValueModel, int n, TreeNodeValueModel treeNodeValueModel2, ListValueModel listValueModel) {
        this.parents.remove(listValueModel);
        List list = (List)this.childrenLists.get(treeNodeValueModel);
        list.remove(n);
        if (list.isEmpty()) {
            this.childrenLists.remove(treeNodeValueModel);
        }
    }

    private void disengageNode(TreeNodeValueModel treeNodeValueModel) {
        treeNodeValueModel.getChildrenModel().removeListChangeListener("value", this.childrenListener);
        treeNodeValueModel.removePropertyChangeListener("value", this.nodeValueListener);
        treeNodeValueModel.removeStateChangeListener(this.nodeStateListener);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.root);
    }

    private class NodeChangePolicy
    extends ChangePolicy {
        private TreeNodeValueModel node;

        NodeChangePolicy(TreeNodeValueModel treeNodeValueModel) {
            this.node = treeNodeValueModel;
        }

        TreeNodeValueModel parent() {
            return this.node;
        }

        int childrenStartIndex() {
            return 0;
        }

        int childrenSize() {
            return this.node.getChildrenModel().size();
        }

        Iterator children() {
            return (Iterator)this.node.getChildrenModel().getValue();
        }
    }

    private class EventChangePolicy
    extends ChangePolicy {
        private ListChangeEvent event;

        EventChangePolicy(ListChangeEvent listChangeEvent) {
            this.event = listChangeEvent;
        }

        TreeNodeValueModel parent() {
            return (TreeNodeValueModel)TreeModelAdapter.this.parents.get(this.event.getSource());
        }

        int childrenStartIndex() {
            return this.event.getIndex();
        }

        int childrenSize() {
            return this.event.size();
        }

        Iterator children() {
            return this.event.items();
        }

        void replaceChildren() {
            Object[] objectArray = this.parent().path();
            int[] nArray = this.childIndices();
            TreeModelAdapter.this.removeChildren(objectArray, nArray, this.replacedChildren());
            TreeModelAdapter.this.addChildren(objectArray, nArray, this.childArray());
        }

        void rebuildChildren() {
            TreeNodeValueModel treeNodeValueModel = this.parent();
            Object[] objectArray = treeNodeValueModel.path();
            List list = (List)TreeModelAdapter.this.childrenLists.get(treeNodeValueModel);
            int[] nArray = this.buildIndices(list.size());
            Object[] objectArray2 = this.buildArray(list.iterator(), list.size());
            TreeModelAdapter.this.removeChildren(objectArray, nArray, objectArray2);
            nArray = this.buildIndices(treeNodeValueModel.getChildrenModel().size());
            objectArray2 = this.buildArray((Iterator)treeNodeValueModel.getChildrenModel().getValue(), treeNodeValueModel.childrenSize());
            TreeModelAdapter.this.addChildren(objectArray, nArray, objectArray2);
        }

        Object[] replacedChildren() {
            return this.buildArray(this.event.replacedItems(), this.event.size());
        }
    }

    private abstract class ChangePolicy {
        ChangePolicy() {
        }

        void addChildren() {
            TreeModelAdapter.this.addChildren(this.parent().path(), this.childIndices(), this.childArray());
        }

        void removeChildren() {
            TreeModelAdapter.this.removeChildren(this.parent().path(), this.childIndices(), this.childArray());
        }

        int[] childIndices() {
            return this.buildIndices(this.childrenStartIndex(), this.childrenSize());
        }

        Object[] childArray() {
            return this.buildArray(this.children(), this.childrenSize());
        }

        Object[] buildArray(Iterator iterator, int n) {
            Object[] objectArray = new Object[n];
            int n2 = 0;
            while (iterator.hasNext()) {
                objectArray[n2] = iterator.next();
                ++n2;
            }
            return objectArray;
        }

        int[] buildIndices(int n) {
            return this.buildIndices(0, n);
        }

        private int[] buildIndices(int n, int n2) {
            int[] nArray = new int[n2];
            int n3 = n;
            for (int i = 0; i < n2; ++i) {
                nArray[i] = n3++;
            }
            return nArray;
        }

        abstract TreeNodeValueModel parent();

        abstract int childrenStartIndex();

        abstract int childrenSize();

        abstract Iterator children();
    }
}

