/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.cell;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;

public class CheckBoxTableCellRenderer
implements TableCellEditorAdapter.Renderer {
    private JCheckBox checkBox;
    protected TableCellEditorAdapter.ImmediateEditListener immediateEditListener;
    private static final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);

    public CheckBoxTableCellRenderer() {
        this.initialize();
    }

    public CheckBoxTableCellRenderer(String string, Icon icon) {
        this();
        this.setText(string);
        this.setIcon(icon);
    }

    public CheckBoxTableCellRenderer(String string) {
        this(string, null);
    }

    public CheckBoxTableCellRenderer(Icon icon) {
        this(null, icon);
    }

    protected void initialize() {
        this.checkBox = this.buildCheckBox();
        this.checkBox.setBorderPainted(true);
        this.checkBox.setBorderPaintedFlat(true);
    }

    protected JCheckBox buildCheckBox() {
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.addActionListener(this.buildActionListener());
        return jCheckBox;
    }

    private ActionListener buildActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CheckBoxTableCellRenderer.this.immediateEditListener != null) {
                    CheckBoxTableCellRenderer.this.immediateEditListener.immediateEdit();
                }
            }
        };
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.checkBox.setHorizontalAlignment(0);
        this.checkBox.setComponentOrientation(jTable.getComponentOrientation());
        this.checkBox.setFont(jTable.getFont());
        this.checkBox.setEnabled(jTable.isEnabled());
        this.checkBox.setForeground(this.foregroundColor(jTable, object, bl, bl2, n, n2));
        this.checkBox.setBackground(this.backgroundColor(jTable, object, bl, bl2, n, n2));
        this.checkBox.setOpaque(this.cellIsOpaqueIn(jTable, object, bl, bl2, n, n2));
        this.checkBox.setBorder(this.border(jTable, object, bl, bl2, n, n2));
        this.setValue(object);
        return this.checkBox;
    }

    protected Color foregroundColor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            if (bl2 && jTable.isCellEditable(n, n2)) {
                return UIManager.getColor("Table.focusCellForeground");
            }
            return jTable.getSelectionForeground();
        }
        return jTable.getForeground();
    }

    protected Color backgroundColor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            if (bl2 && jTable.isCellEditable(n, n2)) {
                return UIManager.getColor("Table.focusCellBackground");
            }
            return jTable.getSelectionBackground();
        }
        return jTable.getBackground();
    }

    protected Border border(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        return bl2 ? UIManager.getBorder("Table.focusCellHighlightBorder") : NO_FOCUS_BORDER;
    }

    protected boolean cellIsOpaqueIn(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Color color = this.checkBox.getBackground();
        Color color2 = jTable.getBackground();
        return !jTable.isOpaque() || !color.equals(color2);
    }

    protected void setValue(Object object) {
        if (object == null) {
            object = Boolean.FALSE;
        }
        this.checkBox.setSelected((Boolean)object);
    }

    public Object getValue() {
        return this.checkBox.isSelected();
    }

    public void setImmediateEditListener(TableCellEditorAdapter.ImmediateEditListener immediateEditListener) {
        this.immediateEditListener = immediateEditListener;
    }

    public void commit() {
    }

    public void setText(String string) {
        this.checkBox.setText(string);
    }

    public void setIcon(Icon icon) {
        this.checkBox.setIcon(icon);
    }

    public int getPreferredHeight() {
        return (int)this.checkBox.getPreferredSize().getHeight() + 2;
    }
}

