/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.cell;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.eclipse.persistence.tools.workbench.uitools.cell.TreeCellEditorAdapter;

public class CheckBoxTreeCellRenderer
implements TreeCellEditorAdapter.Renderer {
    private JCheckBox checkBox;
    protected boolean editing = false;
    protected TreeCellEditorAdapter.ImmediateEditListener immediateEditListener;
    private static final Border NO_FOCUS_BORDER_LTR = BorderFactory.createEmptyBorder(2, 2, 2, 3);
    private static final Border NO_FOCUS_BORDER_RTL = BorderFactory.createEmptyBorder(2, 3, 2, 2);
    private static final Border INNER_FOCUS_BORDER_LTR = BorderFactory.createEmptyBorder(1, 1, 1, 2);
    private static final Border INNER_FOCUS_BORDER_RTL = BorderFactory.createEmptyBorder(1, 2, 1, 1);

    public CheckBoxTreeCellRenderer() {
        this.initialize();
    }

    public CheckBoxTreeCellRenderer(String string, Icon icon) {
        this();
        this.setText(string);
        this.setIcon(icon);
    }

    public CheckBoxTreeCellRenderer(String string) {
        this(string, null);
    }

    public CheckBoxTreeCellRenderer(Icon icon) {
        this(null, icon);
    }

    protected void initialize() {
        this.checkBox = this.buildCheckBox();
        this.checkBox.setBorderPainted(true);
        this.checkBox.setBorderPaintedFlat(true);
    }

    protected JCheckBox buildCheckBox() {
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.addActionListener(this.buildActionListener());
        return jCheckBox;
    }

    private ActionListener buildActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CheckBoxTreeCellRenderer.this.immediateEditListener != null) {
                    CheckBoxTreeCellRenderer.this.immediateEditListener.immediateEdit();
                }
            }
        };
    }

    protected void setEditing(boolean bl) {
        this.editing = bl;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.checkBox.setHorizontalAlignment(10);
        this.checkBox.setComponentOrientation(jTree.getComponentOrientation());
        this.checkBox.setFont(jTree.getFont());
        this.checkBox.setEnabled(jTree.isEnabled());
        this.checkBox.setForeground(this.foregroundColor(jTree, object, bl, bl2, bl3, n, bl4));
        this.checkBox.setBackground(this.backgroundColor(jTree, object, bl, bl2, bl3, n, bl4));
        this.checkBox.setOpaque(this.cellIsOpaqueIn(jTree, object, bl, bl2, bl3, n, bl4));
        this.checkBox.setBorder(this.border(jTree, object, bl, bl2, bl3, n, bl4));
        this.setValue(object);
        return this.checkBox;
    }

    protected Color foregroundColor(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (bl) {
            if (this.editing) {
                return UIManager.getColor("Tree.textForeground");
            }
            return UIManager.getColor("Tree.selectionForeground");
        }
        return UIManager.getColor("Tree.textForeground");
    }

    protected Color backgroundColor(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (bl) {
            if (this.editing) {
                return UIManager.getColor("Tree.textBackground");
            }
            return UIManager.getColor("Tree.selectionBackground");
        }
        return UIManager.getColor("Tree.textBackground");
    }

    protected Border border(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        return bl4 ? BorderFactory.createCompoundBorder(this.outerFocusBorder(), this.innerFocusBorder()) : this.noFocusBorder();
    }

    protected Border innerFocusBorder() {
        return this.checkBox.getComponentOrientation().isLeftToRight() ? INNER_FOCUS_BORDER_LTR : INNER_FOCUS_BORDER_RTL;
    }

    protected Border outerFocusBorder() {
        return this.editing ? UIManager.getBorder("Tree.editorBorder") : BorderFactory.createLineBorder(UIManager.getColor("Tree.selectionBorderColor"), 1);
    }

    protected Border noFocusBorder() {
        return this.checkBox.getComponentOrientation().isLeftToRight() ? NO_FOCUS_BORDER_LTR : NO_FOCUS_BORDER_RTL;
    }

    protected boolean cellIsOpaqueIn(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Color color = this.checkBox.getBackground();
        Color color2 = jTree.getBackground();
        return !jTree.isOpaque() || !color.equals(color2);
    }

    protected void setValue(Object object) {
        this.checkBox.setSelected((Boolean)object);
    }

    public Object getValue() {
        return this.checkBox.isSelected();
    }

    public void setImmediateEditListener(TreeCellEditorAdapter.ImmediateEditListener immediateEditListener) {
        this.immediateEditListener = immediateEditListener;
    }

    public void setText(String string) {
        this.checkBox.setText(string);
    }

    public void setIcon(Icon icon) {
        this.checkBox.setIcon(icon);
    }

    public int getPreferredHeight() {
        return (int)this.checkBox.getPreferredSize().getHeight() + 4;
    }

    protected void addActionListener(ActionListener actionListener) {
        this.checkBox.addActionListener(actionListener);
    }
}

