/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.cell;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.EmptyIcon;
import org.eclipse.persistence.tools.workbench.uitools.swing.NonCachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;

public class ComboBoxTableCellRenderer
implements TableCellEditorAdapter.Renderer {
    private JComboBox comboBox;
    private CachingComboBoxModel model;
    private ListCellRenderer renderer;
    Object value;
    private static int height = -1;
    private boolean fakeFocusFlag;
    protected TableCellEditorAdapter.ImmediateEditListener immediateEditListener;
    private static Color defaultForeground;
    private static Color defaultBackground;
    private static final Border NO_FOCUS_BORDER;
    public static JLabel prototypeLabel;

    private ComboBoxTableCellRenderer() {
        this.initialize();
    }

    public ComboBoxTableCellRenderer(ComboBoxModel comboBoxModel) {
        this(new NonCachingComboBoxModel(comboBoxModel));
    }

    public ComboBoxTableCellRenderer(CachingComboBoxModel cachingComboBoxModel) {
        this();
        this.model = cachingComboBoxModel;
    }

    public ComboBoxTableCellRenderer(ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer) {
        this(new NonCachingComboBoxModel(comboBoxModel), listCellRenderer);
    }

    public ComboBoxTableCellRenderer(CachingComboBoxModel cachingComboBoxModel, ListCellRenderer listCellRenderer) {
        this(cachingComboBoxModel);
        this.renderer = listCellRenderer;
    }

    protected void initialize() {
        if (height == -1) {
            JComboBox<String> jComboBox = new JComboBox<String>();
            jComboBox.addItem("m");
            height = jComboBox.getPreferredSize().height + 2;
            defaultForeground = jComboBox.getForeground();
            defaultBackground = jComboBox.getBackground();
        }
    }

    protected JComboBox buildComboBox() {
        JComboBox jComboBox = new JComboBox(){
            private boolean fakeFocus;

            public boolean hasFocus() {
                return this.fakeFocus || super.hasFocus();
            }

            public void paint(Graphics graphics) {
                this.fakeFocus = ComboBoxTableCellRenderer.this.fakeFocusFlag;
                super.paint(graphics);
                this.fakeFocus = false;
            }

            public void setRenderer(final ListCellRenderer listCellRenderer) {
                super.setRenderer(new ListCellRenderer(){

                    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                        if (object == prototypeLabel) {
                            return prototypeLabel;
                        }
                        return listCellRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
                    }
                });
            }

            public int getSelectedIndex() {
                boolean bl;
                boolean bl2 = bl = !ComboBoxTableCellRenderer.this.listIsCached();
                if (bl) {
                    ComboBoxTableCellRenderer.this.cacheList();
                }
                int n = super.getSelectedIndex();
                if (bl) {
                    ComboBoxTableCellRenderer.this.uncacheList();
                }
                return n;
            }
        };
        jComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        jComboBox.addActionListener(this.buildActionListener());
        jComboBox.addPopupMenuListener(this.buildPopupMenuListener());
        jComboBox.setPrototypeDisplayValue(prototypeLabel);
        this.getListBox(jComboBox).setPrototypeCellValue(prototypeLabel);
        return jComboBox;
    }

    private JList getListBox(JComboBox jComboBox) {
        return (JList)ClassTools.getFieldValue((Object)jComboBox.getUI(), (String)"listBox");
    }

    private ActionListener buildActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (ComboBoxTableCellRenderer.this.value != object) {
                    ComboBoxTableCellRenderer.this.value = jComboBox.getSelectedItem();
                    ComboBoxTableCellRenderer.this.immediateEdit();
                }
            }
        };
    }

    void immediateEdit() {
        if (this.immediateEditListener != null) {
            this.immediateEditListener.immediateEdit();
        }
    }

    private PopupMenuListener buildPopupMenuListener() {
        return new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                if (ComboBoxTableCellRenderer.this.listIsCached()) {
                    ComboBoxTableCellRenderer.this.uncacheList();
                }
                ComboBoxTableCellRenderer.this.cacheList();
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                if (ComboBoxTableCellRenderer.this.listIsCached()) {
                    ComboBoxTableCellRenderer.this.uncacheList();
                }
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                if (ComboBoxTableCellRenderer.this.listIsCached()) {
                    ComboBoxTableCellRenderer.this.uncacheList();
                }
            }
        };
    }

    private void cacheList() {
        this.model.cacheList();
    }

    private void uncacheList() {
        this.model.uncacheList();
    }

    private boolean listIsCached() {
        return this.model.isCached();
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        boolean bl3 = this.fakeFocusFlag = bl || bl2;
        if (this.comboBox == null) {
            this.comboBox = this.buildComboBox();
            this.comboBox.setComponentOrientation(jTable.getComponentOrientation());
            this.comboBox.setModel(this.model);
            if (this.renderer != null) {
                this.comboBox.setRenderer(this.renderer);
            }
            this.comboBox.setFont(jTable.getFont());
            this.comboBox.setEnabled(jTable.isEnabled());
            this.comboBox.setBorder(this.border(jTable, object, bl, bl2, n, n2));
        }
        this.model.setSelectedItem(object);
        return this.comboBox;
    }

    protected Color foregroundColor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            if (bl2 && jTable.isCellEditable(n, n2)) {
                return defaultForeground;
            }
            return jTable.getSelectionForeground();
        }
        return defaultForeground;
    }

    protected Color backgroundColor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            if (bl2 && jTable.isCellEditable(n, n2)) {
                return defaultBackground;
            }
            return jTable.getSelectionBackground();
        }
        return defaultBackground;
    }

    protected Border border(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        return bl2 ? UIManager.getBorder("Table.focusCellHighlightBorder") : NO_FOCUS_BORDER;
    }

    public Object getValue() {
        return this.value;
    }

    public void setImmediateEditListener(TableCellEditorAdapter.ImmediateEditListener immediateEditListener) {
        this.immediateEditListener = immediateEditListener;
    }

    public void commit() {
    }

    public int getPreferredHeight() {
        return height;
    }

    static {
        NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        prototypeLabel = new JLabel("Prototype", new EmptyIcon(16), 10);
    }
}

