/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.cell;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.eclipse.persistence.tools.workbench.uitools.cell.LabeledTreeCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TreeCellEditorAdapter;

public class ComboBoxTreeCellRenderer
extends LabeledTreeCellRenderer
implements TreeCellEditorAdapter.Renderer {
    protected TreeCellEditorAdapter.ImmediateEditListener immediateEditListener;
    protected Color defaultComboBoxForeground;
    protected Color defaultComboBoxBackground;

    public ComboBoxTreeCellRenderer(ComboBoxModel comboBoxModel, String string, Icon icon) {
        super(string, icon);
        this.setModel(comboBoxModel);
    }

    public ComboBoxTreeCellRenderer(ComboBoxModel comboBoxModel, String string) {
        super(string);
        this.setModel(comboBoxModel);
    }

    public ComboBoxTreeCellRenderer(ComboBoxModel comboBoxModel, Icon icon) {
        super(icon);
        this.setModel(comboBoxModel);
    }

    public ComboBoxTreeCellRenderer(ComboBoxModel comboBoxModel) {
        this.setModel(comboBoxModel);
    }

    public ComboBoxTreeCellRenderer(ComboBoxModel comboBoxModel, String string, Icon icon, ListCellRenderer listCellRenderer) {
        this(comboBoxModel, string, icon);
        this.setRenderer(listCellRenderer);
    }

    public ComboBoxTreeCellRenderer(ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer) {
        this(comboBoxModel);
        this.setRenderer(listCellRenderer);
    }

    protected JComponent buildComponent() {
        JComboBox jComboBox = new JComboBox();
        jComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        jComboBox.addActionListener(this.buildActionListener());
        this.defaultComboBoxForeground = jComboBox.getForeground();
        this.defaultComboBoxBackground = jComboBox.getBackground();
        return jComboBox;
    }

    private ActionListener buildActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (ComboBoxTreeCellRenderer.this.getValue() != object) {
                    ComboBoxTreeCellRenderer.this.setValue(jComboBox.getSelectedItem());
                    ComboBoxTreeCellRenderer.this.immediateEdit();
                }
            }
        };
    }

    void immediateEdit() {
        if (this.immediateEditListener != null) {
            this.immediateEditListener.immediateEdit();
        }
    }

    protected JComboBox getComboBox() {
        return (JComboBox)this.component;
    }

    protected void setForeground(Color color) {
        super.setForeground(color);
        if (color == UIManager.getColor("Tree.textForeground")) {
            this.component.setForeground(this.defaultComboBoxForeground);
        }
    }

    protected void setBackground(Color color) {
        super.setBackground(color);
        if (color == UIManager.getColor("Tree.textBackground")) {
            this.component.setBackground(this.defaultComboBoxBackground);
        }
    }

    protected void setValue(Object object) {
        this.getComboBox().setSelectedItem(object);
    }

    public Object getValue() {
        return this.getComboBox().getSelectedItem();
    }

    public void setImmediateEditListener(TreeCellEditorAdapter.ImmediateEditListener immediateEditListener) {
        this.immediateEditListener = immediateEditListener;
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        this.getComboBox().setModel(comboBoxModel);
    }

    public void setRenderer(ListCellRenderer listCellRenderer) {
        this.getComboBox().setRenderer(listCellRenderer);
    }

    protected void addActionListener(ActionListener actionListener) {
        this.getComboBox().addActionListener(actionListener);
    }
}

