/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.cell;

import java.awt.Color;
import java.awt.Component;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;

public class SpinnerTableCellRenderer
implements TableCellEditorAdapter.Renderer {
    protected JSpinner spinner;
    protected TableCellEditorAdapter.ImmediateEditListener immediateEditListener;

    public SpinnerTableCellRenderer() {
        this.initialize();
    }

    public SpinnerTableCellRenderer(SpinnerModel spinnerModel) {
        this();
        this.setModel(spinnerModel);
    }

    protected void initialize() {
        this.spinner = this.buildSpinner();
    }

    protected JSpinner buildSpinner() {
        JSpinner jSpinner = new JSpinner();
        jSpinner.addChangeListener(this.buildChangeListener());
        return jSpinner;
    }

    private ChangeListener buildChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (SpinnerTableCellRenderer.this.immediateEditListener != null) {
                    SpinnerTableCellRenderer.this.immediateEditListener.immediateEdit();
                }
            }
        };
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.spinner.setComponentOrientation(jTable.getComponentOrientation());
        this.spinner.setFont(jTable.getFont());
        this.spinner.setEnabled(jTable.isEnabled());
        JComponent jComponent = this.editor();
        jComponent.setForeground(this.foregroundColor(jTable, object, bl, bl2, n, n2));
        jComponent.setBackground(this.backgroundColor(jTable, object, bl, bl2, n, n2));
        this.spinner.setBorder(this.border(jTable, object, bl, bl2, n, n2));
        this.setValue(object);
        return this.spinner;
    }

    protected Color foregroundColor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            if (bl2 && jTable.isCellEditable(n, n2)) {
                return UIManager.getColor("Table.focusCellForeground");
            }
            return jTable.getSelectionForeground();
        }
        return jTable.getForeground();
    }

    protected Color backgroundColor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            if (bl2 && jTable.isCellEditable(n, n2)) {
                return UIManager.getColor("Table.focusCellBackground");
            }
            return jTable.getSelectionBackground();
        }
        return jTable.getBackground();
    }

    protected Border border(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl2) {
            return UIManager.getBorder("Table.focusCellHighlightBorder");
        }
        if (bl) {
            return BorderFactory.createLineBorder(jTable.getSelectionBackground(), 1);
        }
        return BorderFactory.createLineBorder(jTable.getBackground(), 1);
    }

    protected JComponent editor() {
        JComponent jComponent = this.spinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            jComponent = ((JSpinner.DefaultEditor)jComponent).getTextField();
        }
        return jComponent;
    }

    protected void setValue(Object object) {
        if (object == null) {
            object = new Integer(0);
        }
        this.spinner.setValue(object);
    }

    public Object getValue() {
        return this.spinner.getValue();
    }

    public void setImmediateEditListener(TableCellEditorAdapter.ImmediateEditListener immediateEditListener) {
        this.immediateEditListener = immediateEditListener;
    }

    public void commit() {
        try {
            this.spinner.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void setModel(SpinnerModel spinnerModel) {
        this.spinner.setModel(spinnerModel);
    }

    public int getPreferredHeight() {
        return (int)this.spinner.getPreferredSize().getHeight() + 2;
    }
}

