/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.cell;

import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TableCellEditorAdapter
extends AbstractCellEditor
implements TableCellEditor {
    private Renderer renderer;

    private TableCellEditorAdapter() {
    }

    public TableCellEditorAdapter(Renderer renderer) {
        this();
        this.initialize(renderer);
    }

    protected void initialize(Renderer renderer) {
        this.renderer = renderer;
        renderer.setImmediateEditListener(this.buildImmediateEditListener());
    }

    private ImmediateEditListener buildImmediateEditListener() {
        return new ImmediateEditListener(){

            public void immediateEdit() {
                TableCellEditorAdapter.this.stopCellEditing();
            }
        };
    }

    public Object getCellEditorValue() {
        return this.renderer.getValue();
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        return this.renderer.getTableCellRendererComponent(jTable, object, bl, true, n, n2);
    }

    public boolean stopCellEditing() {
        this.renderer.commit();
        return super.stopCellEditing();
    }

    public static interface ImmediateEditListener {
        public void immediateEdit();
    }

    public static interface Renderer
    extends TableCellRenderer {
        public Object getValue();

        public void setImmediateEditListener(ImmediateEditListener var1);

        public void commit();
    }
}

