/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.chooser;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxUI;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;
import org.eclipse.persistence.tools.workbench.uitools.chooser.SimpleListBrowser;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.Combo;
import org.eclipse.persistence.tools.workbench.uitools.swing.EmptyIcon;
import org.eclipse.persistence.tools.workbench.uitools.swing.NonCachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;

public class ListChooser
extends Combo {
    int longListSize = 20;
    public static final int DEFAULT_LONG_LIST_SIZE = 20;
    public static final String LONG_LIST_SIZE_PROPERTY = "longListSize";
    static JLabel prototypeLabel = new JLabel("Prototype", new EmptyIcon(17), 10);
    boolean choosable = true;
    public static final String CHOOSABLE_PROPERTY = "choosable";
    private ListBrowser browser;
    private NodeSelector nodeSelector;
    boolean popupAlreadyInProgress;

    public ListChooser(ComboBoxModel comboBoxModel) {
        this(comboBoxModel, (NodeSelector)new NodeSelector.DefaultNodeSelector());
    }

    public ListChooser(CachingComboBoxModel cachingComboBoxModel) {
        this(cachingComboBoxModel, (NodeSelector)new NodeSelector.DefaultNodeSelector());
    }

    public ListChooser(ComboBoxModel comboBoxModel, NodeSelector nodeSelector) {
        this(new NonCachingComboBoxModel(comboBoxModel), nodeSelector);
    }

    public ListChooser(CachingComboBoxModel cachingComboBoxModel, NodeSelector nodeSelector) {
        super((ComboBoxModel)cachingComboBoxModel);
        this.initialize();
        this.nodeSelector = nodeSelector;
    }

    protected void initialize() {
        this.addPopupMenuListener(this.buildPopupMenuListener());
        this.setRenderer((ListCellRenderer)new DefaultListCellRenderer());
        this.addKeyListener(this.buildF3KeyListener());
        this.setPrototypeDisplayValue(prototypeLabel);
        this.getListBox().setPrototypeCellValue(prototypeLabel);
    }

    private JList getListBox() {
        return (JList)ClassTools.getFieldValue((Object)this.ui, (String)"listBox");
    }

    private PopupMenuListener buildPopupMenuListener() {
        return new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                ListChooser.this.aboutToShowPopup();
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public String toString() {
                return "pop-up menu listener";
            }
        };
    }

    void aboutToShowPopup() {
        if (this.popupAlreadyInProgress) {
            return;
        }
        this.popupAlreadyInProgress = true;
        EventQueue.invokeLater(new PopupHandler());
    }

    private KeyListener buildF3KeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 114) {
                    ListChooser.this.goToSelectedItem();
                }
            }

            public String toString() {
                return "F3 key listener";
            }
        };
    }

    public void goToSelectedItem() {
        if (this.getSelectedItem() != null) {
            this.nodeSelector.selectNodeFor(this.getSelectedItem());
        }
    }

    protected void browse() {
        if (this.browser == null) {
            this.browser = this.buildBrowser();
        }
        this.browser.browse(this);
    }

    protected ListBrowser buildBrowser() {
        return new SimpleListBrowser();
    }

    public void setSelectedIndex(int n) {
        if (this.choosable) {
            super.setSelectedIndex(n);
        }
    }

    private void updateArrowButton() {
        try {
            BasicComboBoxUI basicComboBoxUI = (BasicComboBoxUI)this.getUI();
            JButton jButton = (JButton)ClassTools.getFieldValue((Object)basicComboBoxUI, (String)"arrowButton");
            jButton.setEnabled(this.isEnabled() && this.choosable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void cacheList() {
        ((CachingComboBoxModel)this.getModel()).cacheList();
    }

    void uncacheList() {
        ((CachingComboBoxModel)this.getModel()).uncacheList();
    }

    boolean listIsCached() {
        return ((CachingComboBoxModel)this.getModel()).isCached();
    }

    public int getLongListSize() {
        return this.longListSize;
    }

    public void setLongListSize(int n) {
        int n2 = this.longListSize;
        this.longListSize = n;
        this.firePropertyChange(LONG_LIST_SIZE_PROPERTY, n2, n);
    }

    public boolean isChoosable() {
        return this.choosable;
    }

    public void setChoosable(boolean bl) {
        boolean bl2 = this.choosable;
        this.choosable = bl;
        this.firePropertyChange(CHOOSABLE_PROPERTY, bl2, bl);
        this.updateArrowButton();
    }

    private boolean selectedIndexIsNoneSelectedItem(int n) {
        return n == -1 && this.getModel().getSize() > 0 && this.getModel().getElementAt(0) == null;
    }

    public int getSelectedIndex() {
        int n;
        boolean bl;
        boolean bl2 = bl = !this.listIsCached();
        if (bl) {
            this.cacheList();
        }
        if (this.selectedIndexIsNoneSelectedItem(n = super.getSelectedIndex())) {
            n = 0;
        }
        if (bl) {
            this.uncacheList();
        }
        return n;
    }

    public void setRenderer(final ListCellRenderer listCellRenderer) {
        super.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object == prototypeLabel) {
                    return prototypeLabel;
                }
                return listCellRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
            }
        });
    }

    private class PopupHandler
    implements Runnable {
        private MouseEvent lastMouseEvent;
        private JComponent eventComponent;
        private Point componentLocation;
        private Point mouseLocation;

        private PopupHandler() {
            this.initialize();
        }

        private void initialize() {
            AWTEvent aWTEvent = EventQueue.getCurrentEvent();
            if (aWTEvent instanceof MouseEvent) {
                this.lastMouseEvent = (MouseEvent)aWTEvent;
                this.eventComponent = (JComponent)this.lastMouseEvent.getSource();
                this.componentLocation = this.eventComponent.getLocationOnScreen();
                this.mouseLocation = this.lastMouseEvent.getPoint();
            } else {
                this.eventComponent = null;
                this.componentLocation = null;
                this.mouseLocation = null;
            }
        }

        public void run() {
            ListChooser.this.hidePopup();
            ListChooser.this.cacheList();
            if (ListChooser.this.choosable) {
                if (ListChooser.this.getModel().getSize() > ListChooser.this.longListSize) {
                    this.checkComboBoxButton();
                    ListChooser.this.browse();
                } else {
                    ListChooser.this.showPopup();
                    this.checkMousePosition();
                }
            }
            if (ListChooser.this.listIsCached()) {
                ListChooser.this.uncacheList();
            }
            ListChooser.this.popupAlreadyInProgress = false;
        }

        private void checkComboBoxButton() {
            try {
                BasicComboBoxUI basicComboBoxUI = (BasicComboBoxUI)ListChooser.this.getUI();
                JButton jButton = (JButton)ClassTools.getFieldValue((Object)basicComboBoxUI, (String)"arrowButton");
                jButton.getModel().setPressed(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void checkMousePosition() {
            boolean bl;
            if (this.eventComponent == null) {
                return;
            }
            Point point = this.eventComponent.getLocationOnScreen();
            boolean bl2 = bl = point.x - this.componentLocation.x != 0 || point.y - this.componentLocation.y != 0;
            if (bl) {
                try {
                    new Robot().mouseMove(point.x + this.mouseLocation.x, point.y + this.mouseLocation.y);
                }
                catch (AWTException aWTException) {
                    // empty catch block
                }
            }
        }
    }

    public static interface ListBrowser {
        public void browse(ListChooser var1);
    }
}

