/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxEditor;
import org.eclipse.persistence.tools.workbench.utility.string.BidiStringConverter;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ComboBoxEditorAdapter
implements ComboBoxEditor {
    private final BidiStringConverter converter;
    private final ComboBoxEditor delegate;
    private final Object nullValue;

    public ComboBoxEditorAdapter(ComboBoxEditor comboBoxEditor, BidiStringConverter bidiStringConverter) {
        this(comboBoxEditor, bidiStringConverter, null);
    }

    public ComboBoxEditorAdapter(ComboBoxEditor comboBoxEditor, BidiStringConverter bidiStringConverter, Object object) {
        this.delegate = comboBoxEditor;
        this.converter = bidiStringConverter;
        this.nullValue = object;
    }

    public void addActionListener(ActionListener actionListener) {
        this.delegate.addActionListener(actionListener);
    }

    public Component getEditorComponent() {
        return this.delegate.getEditorComponent();
    }

    public Object getItem() {
        String string = (String)this.delegate.getItem();
        if (string != null) {
            string = string.trim();
        }
        if (StringTools.stringIsEmpty((String)string)) {
            string = null;
        } else if (string == this.nullValue()) {
            string = null;
        }
        Object object = this.converter.convertToObject(string);
        if (object == null) {
            object = "";
        }
        return object;
    }

    protected Object nullValue() {
        return this.nullValue;
    }

    public void removeActionListener(ActionListener actionListener) {
        this.delegate.removeActionListener(actionListener);
    }

    public void selectAll() {
        this.delegate.selectAll();
    }

    public void setItem(Object object) {
        if (object == this.nullValue()) {
            object = null;
        }
        object = this.converter.convertToString(object);
        this.delegate.setItem(object);
    }
}

