/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.awt.Component;
import java.awt.Image;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;

final class ComboCellRenderer
implements ListCellRenderer,
UIResource {
    final ListCellRenderer cellRenderer;
    final CellRendererAdapter cellRendererAdapter;
    private final Component prototypeRenderer;

    ComboCellRenderer(ListCellRenderer listCellRenderer, CellRendererAdapter cellRendererAdapter, Component component) {
        this.cellRenderer = listCellRenderer;
        this.prototypeRenderer = component;
        this.cellRendererAdapter = cellRendererAdapter;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object == this.prototypeRenderer) {
            return this.prototypeRenderer;
        }
        JLabel jLabel = (JLabel)this.cellRenderer.getListCellRendererComponent(jList, null, n, bl, bl2);
        jLabel.setEnabled(jList.isEnabled());
        this.updateRenderer(jLabel, object);
        if (bl && !jList.hasFocus() && jList.isFocusable()) {
            jLabel.setForeground(jList.getForeground());
            jLabel.setBackground(UIManager.getColor("Panel.background"));
        }
        if (!jList.isEnabled() && jLabel.getIcon() != null && jLabel.getDisabledIcon() == null && jLabel.getIcon() instanceof ImageIcon) {
            ImageIcon imageIcon = (ImageIcon)jLabel.getIcon();
            Image image = GrayFilter.createDisabledImage(imageIcon.getImage());
            jLabel.setIcon(new ImageIcon(image));
        }
        return jLabel;
    }

    private void updateRenderer(JLabel jLabel, Object object) {
        jLabel.setText(this.cellRendererAdapter.buildText(object));
        jLabel.setIcon(this.cellRendererAdapter.buildIcon(object));
        jLabel.setToolTipText(this.cellRendererAdapter.buildToolTipText(object));
        jLabel.getAccessibleContext().setAccessibleName(this.cellRendererAdapter.buildAccessibleName(object));
    }
}

