/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class CompositeIcon
implements Icon,
Cloneable,
Serializable,
Accessible,
SwingConstants {
    Icon[] icons;
    private int[] gaps;
    private int orientation;
    public static final int[] VALID_ORIENTATION_VALUES = new int[]{0, 1};
    private int alignment;
    public static final int[] VALID_HORIZONTAL_ALIGNMENT_VALUES = new int[]{0, 1, 3};
    public static final int[] VALID_VERTICAL_ALIGNMENT_VALUES = new int[]{0, 10, 11};
    private boolean overrideLeftToRight;
    private String description;
    private AccessibleContext accessibleContext;
    private static final Icon[] EMPTY_ICONS = new Icon[0];
    private static final int[] EMPTY_GAPS = new int[0];
    private static final long serialVersionUID = 1L;

    public CompositeIcon(Icon[] iconArray, int[] nArray, int n, int n2, String string) {
        if (iconArray.length == 0) {
            if (nArray.length != 0) {
                throw new IllegalArgumentException("if there are no icons, there can be no gaps either");
            }
        } else if (nArray.length != iconArray.length - 1) {
            throw new IllegalArgumentException("if there are icons, there must be 1 fewer gaps than icons");
        }
        this.icons = iconArray;
        this.gaps = nArray;
        this.checkOrientation(n);
        this.orientation = n;
        this.setAlignment(n2);
        this.overrideLeftToRight = false;
        this.setDescription(string);
    }

    public CompositeIcon(Icon[] iconArray, int[] nArray) {
        this(iconArray, nArray, 0, 0, null);
    }

    public CompositeIcon() {
        this(EMPTY_ICONS, EMPTY_GAPS);
    }

    public CompositeIcon(Icon icon) {
        this(new Icon[]{icon}, EMPTY_GAPS);
    }

    public CompositeIcon(Icon icon, int n, Icon icon2) {
        this(new Icon[]{icon, icon2}, new int[]{n});
    }

    public CompositeIcon(Icon icon, Icon icon2) {
        this(icon, 0, icon2);
    }

    public CompositeIcon(Icon[] iconArray, int n) {
        this(iconArray, CompositeIcon.buildFixedGapsFor(iconArray.length, n));
    }

    public CompositeIcon(Icon[] iconArray) {
        this(iconArray, 0);
    }

    public CompositeIcon(List list, int n) {
        this(list.toArray(new Icon[list.size()]), n);
    }

    public CompositeIcon(List list) {
        this(list, 0);
    }

    public int getIconWidth() {
        Icon[] iconArray = this.icons;
        int n = iconArray.length;
        if (this.orientation == 0) {
            int[] nArray = this.gaps;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = nArray.length;
            for (int i = 0; i < n; ++i) {
                Icon icon = iconArray[i];
                if (icon != null) {
                    int n6 = n4 = n4 >= (n2 += icon.getIconWidth()) ? n4 : n2;
                }
                if (i >= n5) continue;
                n4 = n4 >= (n2 += nArray[i]) ? n4 : n2;
                n3 = n3 <= n2 ? n3 : n2;
            }
            return n4 - n3;
        }
        int n7 = 0;
        for (int i = 0; i < n; ++i) {
            Icon icon = iconArray[i];
            if (icon == null) continue;
            int n8 = icon.getIconWidth();
            n7 = n7 >= n8 ? n7 : n8;
        }
        return n7;
    }

    public int getIconHeight() {
        Icon[] iconArray = this.icons;
        int n = iconArray.length;
        if (this.orientation == 1) {
            int[] nArray = this.gaps;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = nArray.length;
            for (int i = 0; i < n; ++i) {
                Icon icon = iconArray[i];
                if (icon != null) {
                    int n6 = n4 = n4 >= (n2 += icon.getIconHeight()) ? n4 : n2;
                }
                if (i >= n5) continue;
                n4 = n4 >= (n2 += nArray[i]) ? n4 : n2;
                n3 = n3 <= n2 ? n3 : n2;
            }
            return n4 - n3;
        }
        int n7 = 0;
        for (int i = 0; i < n; ++i) {
            Icon icon = iconArray[i];
            if (icon == null) continue;
            int n8 = icon.getIconHeight();
            n7 = n7 >= n8 ? n7 : n8;
        }
        return n7;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.orientation == 0) {
            this.paintIconHorizontally(component, graphics, n, n2);
        } else {
            this.paintIconVertically(component, graphics, n, n2);
        }
    }

    private void paintIconHorizontally(Component component, Graphics graphics, int n, int n2) {
        if (this.isLeftToRight(component)) {
            this.paintIconLeftToRight(component, graphics, n, n2);
        } else {
            this.paintIconRightToLeft(component, graphics, n, n2);
        }
    }

    private void paintIconLeftToRight(Component component, Graphics graphics, int n, int n2) {
        switch (this.alignment) {
            case 0: {
                this.paintIconLeftToRightCenterAligned(component, graphics, n, n2);
                break;
            }
            case 1: {
                this.paintIconLeftToRightTopAligned(component, graphics, n, n2);
                break;
            }
            case 3: {
                this.paintIconLeftToRightBottomAligned(component, graphics, n, n2);
                break;
            }
            default: {
                throw new IllegalStateException("illegal alignment: " + this.alignment);
            }
        }
    }

    private void paintIconLeftToRightCenterAligned(Component component, Graphics graphics, int n, int n2) {
        Icon[] iconArray = this.icons;
        int n3 = iconArray.length;
        int[] nArray = this.gaps;
        int n4 = nArray.length;
        int n5 = this.getIconHeight();
        int n6 = n + this.calculateHorizontalStartOffset();
        for (int i = 0; i < n3; ++i) {
            Icon icon = iconArray[i];
            if (icon != null) {
                icon.paintIcon(component, graphics, n6, n2 + (n5 - icon.getIconHeight() >> 1));
                n6 += icon.getIconWidth();
            }
            if (i >= n4) continue;
            n6 += nArray[i];
        }
    }

    private void paintIconLeftToRightTopAligned(Component component, Graphics graphics, int n, int n2) {
        Icon[] iconArray = this.icons;
        int n3 = iconArray.length;
        int[] nArray = this.gaps;
        int n4 = nArray.length;
        int n5 = n + this.calculateHorizontalStartOffset();
        for (int i = 0; i < n3; ++i) {
            Icon icon = iconArray[i];
            if (icon != null) {
                icon.paintIcon(component, graphics, n5, n2);
                n5 += icon.getIconWidth();
            }
            if (i >= n4) continue;
            n5 += nArray[i];
        }
    }

    private void paintIconLeftToRightBottomAligned(Component component, Graphics graphics, int n, int n2) {
        Icon[] iconArray = this.icons;
        int n3 = iconArray.length;
        int[] nArray = this.gaps;
        int n4 = nArray.length;
        int n5 = n2 + this.getIconHeight();
        int n6 = n + this.calculateHorizontalStartOffset();
        for (int i = 0; i < n3; ++i) {
            Icon icon = iconArray[i];
            if (icon != null) {
                icon.paintIcon(component, graphics, n6, n5 - icon.getIconHeight());
                n6 += icon.getIconWidth();
            }
            if (i >= n4) continue;
            n6 += nArray[i];
        }
    }

    private int calculateHorizontalStartOffset() {
        Icon[] iconArray = this.icons;
        int[] nArray = this.gaps;
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        for (int i = 0; i < n3; ++i) {
            Icon icon = iconArray[i];
            if (icon != null) {
                n += icon.getIconWidth();
            }
            n2 = n2 <= (n += nArray[i]) ? n2 : n;
        }
        return n2 < 0 ? -n2 : n2;
    }

    private void paintIconRightToLeft(Component component, Graphics graphics, int n, int n2) {
        switch (this.alignment) {
            case 0: {
                this.paintIconRightToLeftCenterAligned(component, graphics, n, n2);
                break;
            }
            case 1: {
                this.paintIconRightToLeftTopAligned(component, graphics, n, n2);
                break;
            }
            case 3: {
                this.paintIconRightToLeftBottomAligned(component, graphics, n, n2);
                break;
            }
            default: {
                throw new IllegalStateException("illegal alignment: " + this.alignment);
            }
        }
    }

    private void paintIconRightToLeftCenterAligned(Component component, Graphics graphics, int n, int n2) {
        Icon[] iconArray = this.icons;
        int n3 = iconArray.length;
        int[] nArray = this.gaps;
        int n4 = nArray.length;
        int n5 = this.getIconHeight();
        int n6 = n + this.getIconWidth() - this.calculateHorizontalStartOffset();
        for (int i = 0; i < n3; ++i) {
            Icon icon = iconArray[i];
            if (icon != null) {
                icon.paintIcon(component, graphics, n6 -= icon.getIconWidth(), n2 + (n5 - icon.getIconHeight() >> 1));
            }
            if (i >= n4) continue;
            n6 -= nArray[i];
        }
    }

    private void paintIconRightToLeftTopAligned(Component component, Graphics graphics, int n, int n2) {
        Icon[] iconArray = this.icons;
        int n3 = iconArray.length;
        int[] nArray = this.gaps;
        int n4 = nArray.length;
        int n5 = n + this.getIconWidth() - this.calculateHorizontalStartOffset();
        for (int i = 0; i < n3; ++i) {
            Icon icon = iconArray[i];
            if (icon != null) {
                icon.paintIcon(component, graphics, n5 -= icon.getIconWidth(), n2);
            }
            if (i >= n4) continue;
            n5 -= nArray[i];
        }
    }

    private void paintIconRightToLeftBottomAligned(Component component, Graphics graphics, int n, int n2) {
        Icon[] iconArray = this.icons;
        int n3 = iconArray.length;
        int[] nArray = this.gaps;
        int n4 = nArray.length;
        int n5 = n2 + this.getIconHeight();
        int n6 = n + this.getIconWidth() - this.calculateHorizontalStartOffset();
        for (int i = 0; i < n3; ++i) {
            Icon icon = iconArray[i];
            if (icon != null) {
                icon.paintIcon(component, graphics, n6 -= icon.getIconWidth(), n5 - icon.getIconHeight());
            }
            if (i >= n4) continue;
            n6 -= nArray[i];
        }
    }

    private void paintIconVertically(Component component, Graphics graphics, int n, int n2) {
        if (this.isLeftToRight(component)) {
            this.paintIconTopToBottomLeadingEdgeOnLeft(component, graphics, n, n2);
        } else {
            this.paintIconTopToBottomLeadingEdgeOnRight(component, graphics, n, n2);
        }
    }

    private void paintIconTopToBottomLeadingEdgeOnLeft(Component component, Graphics graphics, int n, int n2) {
        switch (this.alignment) {
            case 0: {
                this.paintIconTopToBottomCenterAligned(component, graphics, n, n2);
                break;
            }
            case 10: {
                this.paintIconTopToBottomLeftAligned(component, graphics, n, n2);
                break;
            }
            case 11: {
                this.paintIconTopToBottomRightAligned(component, graphics, n, n2);
                break;
            }
            default: {
                throw new IllegalStateException("illegal alignment: " + this.alignment);
            }
        }
    }

    private void paintIconTopToBottomCenterAligned(Component component, Graphics graphics, int n, int n2) {
        Icon[] iconArray = this.icons;
        int n3 = iconArray.length;
        int[] nArray = this.gaps;
        int n4 = nArray.length;
        int n5 = this.getIconWidth();
        int n6 = n2 + this.calculateVerticalStartOffset();
        for (int i = 0; i < n3; ++i) {
            Icon icon = iconArray[i];
            if (icon != null) {
                icon.paintIcon(component, graphics, n + (n5 - icon.getIconWidth() >> 1), n6);
                n6 += icon.getIconHeight();
            }
            if (i >= n4) continue;
            n6 += nArray[i];
        }
    }

    private void paintIconTopToBottomLeftAligned(Component component, Graphics graphics, int n, int n2) {
        Icon[] iconArray = this.icons;
        int n3 = iconArray.length;
        int[] nArray = this.gaps;
        int n4 = nArray.length;
        int n5 = n2 + this.calculateVerticalStartOffset();
        for (int i = 0; i < n3; ++i) {
            Icon icon = iconArray[i];
            if (icon != null) {
                icon.paintIcon(component, graphics, n, n5);
                n5 += icon.getIconHeight();
            }
            if (i >= n4) continue;
            n5 += nArray[i];
        }
    }

    private void paintIconTopToBottomRightAligned(Component component, Graphics graphics, int n, int n2) {
        Icon[] iconArray = this.icons;
        int n3 = iconArray.length;
        int[] nArray = this.gaps;
        int n4 = nArray.length;
        int n5 = n + this.getIconWidth();
        int n6 = n2 + this.calculateVerticalStartOffset();
        for (int i = 0; i < n3; ++i) {
            Icon icon = iconArray[i];
            if (icon != null) {
                icon.paintIcon(component, graphics, n5 - icon.getIconWidth(), n6);
                n6 += icon.getIconHeight();
            }
            if (i >= n4) continue;
            n6 += nArray[i];
        }
    }

    private int calculateVerticalStartOffset() {
        Icon[] iconArray = this.icons;
        int[] nArray = this.gaps;
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        for (int i = 0; i < n3; ++i) {
            Icon icon = iconArray[i];
            if (icon != null) {
                n += icon.getIconHeight();
            }
            n2 = n2 <= (n += nArray[i]) ? n2 : n;
        }
        return n2 < 0 ? -n2 : n2;
    }

    private void paintIconTopToBottomLeadingEdgeOnRight(Component component, Graphics graphics, int n, int n2) {
        switch (this.alignment) {
            case 0: {
                this.paintIconTopToBottomCenterAligned(component, graphics, n, n2);
                break;
            }
            case 10: {
                this.paintIconTopToBottomRightAligned(component, graphics, n, n2);
                break;
            }
            case 11: {
                this.paintIconTopToBottomLeftAligned(component, graphics, n, n2);
                break;
            }
            default: {
                throw new IllegalStateException("illegal alignment: " + this.alignment);
            }
        }
    }

    public Object clone() {
        CompositeIcon compositeIcon;
        try {
            compositeIcon = (CompositeIcon)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        compositeIcon.icons = new Icon[this.icons.length];
        System.arraycopy(this.icons, 0, compositeIcon.icons, 0, this.icons.length);
        compositeIcon.gaps = new int[this.gaps.length];
        System.arraycopy(this.gaps, 0, compositeIcon.gaps, 0, this.gaps.length);
        compositeIcon.accessibleContext = null;
        return compositeIcon;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleCompositeIcon();
        }
        return this.accessibleContext;
    }

    public String toString() {
        return "CompositeIcon(" + this.icons.length + " icons)";
    }

    public Icon getIcon(int n) {
        return this.icons[n];
    }

    public void setIcon(int n, Icon icon) {
        this.icons[n] = icon;
    }

    public int iconCount() {
        return this.icons.length;
    }

    public int getGap(int n) {
        return this.gaps[n];
    }

    public void setGap(int n, int n2) {
        this.gaps[n] = n2;
    }

    public int gapCount() {
        return this.gaps.length;
    }

    private void addIcons(Icon[] iconArray) {
        Icon[] iconArray2 = this.icons;
        int n = iconArray2.length;
        int n2 = iconArray.length;
        Icon[] iconArray3 = new Icon[n + n2];
        System.arraycopy(iconArray2, 0, iconArray3, 0, n);
        System.arraycopy(iconArray, 0, iconArray3, n, n2);
        this.icons = iconArray3;
    }

    private void addGaps(int[] nArray) {
        int[] nArray2 = this.gaps;
        int n = nArray2.length;
        int n2 = nArray.length;
        int[] nArray3 = new int[n + n2];
        System.arraycopy(nArray2, 0, nArray3, 0, n);
        System.arraycopy(nArray, 0, nArray3, n, n2);
        this.gaps = nArray3;
    }

    public void addAll(Icon[] iconArray, int[] nArray) {
        if (iconArray.length == 0) {
            return;
        }
        if (this.icons.length == 0) {
            if (nArray.length != iconArray.length - 1) {
                throw new IllegalArgumentException("there must be 1 fewer gaps than icons with the first addition to the composite");
            }
        } else if (nArray.length != iconArray.length) {
            throw new IllegalArgumentException("there must be same number of gaps as icons on subsequent additions to the composite");
        }
        this.addIcons(iconArray);
        this.addGaps(nArray);
    }

    public void addAll(Icon[] iconArray, int n) {
        this.addAll(iconArray, CompositeIcon.buildFixedGapsFor(iconArray.length, n));
    }

    public void addAll(Icon[] iconArray) {
        this.addAll(iconArray, 0);
    }

    public void addAll(List list, int n) {
        this.addAll(list.toArray(new Icon[list.size()]), n);
    }

    public void addAll(List list) {
        this.addAll(list, 0);
    }

    public void add(Icon icon, int n) {
        if (this.icons.length == 0) {
            this.icons = new Icon[]{icon};
        } else {
            this.addAll(new Icon[]{icon}, new int[]{n});
        }
    }

    public void add(Icon icon) {
        this.add(icon, 0);
    }

    public void clear() {
        this.icons = EMPTY_ICONS;
        this.gaps = EMPTY_GAPS;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        if (this.orientation == n) {
            return;
        }
        this.checkOrientation(n);
        this.alignment = 0;
        this.orientation = n;
    }

    private void checkOrientation(int n) {
        if (!CollectionTools.contains((int[])VALID_ORIENTATION_VALUES, (int)n)) {
            throw new IllegalArgumentException("invalid orientation: " + n);
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        this.checkAlignment(n);
        this.alignment = n;
    }

    private void checkAlignment(int n) {
        if (this.orientation == 0) {
            if (!CollectionTools.contains((int[])VALID_HORIZONTAL_ALIGNMENT_VALUES, (int)n)) {
                throw new IllegalArgumentException("invalid horizontal alignment: " + n);
            }
        } else if (!CollectionTools.contains((int[])VALID_VERTICAL_ALIGNMENT_VALUES, (int)n)) {
            throw new IllegalArgumentException("invalid vertical alignment: " + n);
        }
    }

    public boolean isOverrideLeftToRight() {
        return this.overrideLeftToRight;
    }

    public void setOverrideLeftToRight(boolean bl) {
        this.overrideLeftToRight = bl;
    }

    private boolean isLeftToRight(Component component) {
        return this.overrideLeftToRight || component.getComponentOrientation().isLeftToRight();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    private static int[] buildFixedGapsFor(int n, int n2) {
        if (n == 0) {
            return EMPTY_GAPS;
        }
        return CollectionTools.fill((int[])new int[n - 1], (int)n2);
    }

    protected class AccessibleCompositeIcon
    extends AccessibleContext
    implements AccessibleIcon,
    Serializable {
        protected AccessibleCompositeIcon() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ICON;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public Accessible getAccessibleParent() {
            return null;
        }

        public int getAccessibleIndexInParent() {
            return -1;
        }

        public int getAccessibleChildrenCount() {
            Icon[] iconArray = CompositeIcon.this.icons;
            int n = iconArray.length;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (!(iconArray[i] instanceof Accessible)) continue;
                ++n2;
            }
            return n2;
        }

        public Accessible getAccessibleChild(int n) {
            Icon[] iconArray = CompositeIcon.this.icons;
            int n2 = iconArray.length;
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                Icon icon = iconArray[i];
                if (!(icon instanceof Accessible)) continue;
                if (n3 == n) {
                    return (Accessible)((Object)icon);
                }
                ++n3;
            }
            return null;
        }

        public Locale getLocale() {
            return null;
        }

        public String getAccessibleIconDescription() {
            return CompositeIcon.this.getDescription();
        }

        public void setAccessibleIconDescription(String string) {
            CompositeIcon.this.setDescription(string);
        }

        public int getAccessibleIconHeight() {
            return CompositeIcon.this.getIconHeight();
        }

        public int getAccessibleIconWidth() {
            return CompositeIcon.this.getIconWidth();
        }
    }
}

