/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.eclipse.persistence.tools.workbench.uitools.ComponentVisibilityEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;

public final class ExpandablePane
extends JPanel {
    private Icon buttonCollapsedDisabledImage;
    private Icon buttonCollapsedFocusImage;
    private Icon buttonCollapsedImage;
    private Icon buttonCollapsedPressedImage;
    private String buttonCollapsedText;
    private Icon buttonExpandedDisabledImage;
    private Icon buttonExpandedFocusImage;
    private Icon buttonExpandedImage;
    private Icon buttonExpandedPressedImage;
    private String buttonExpandedText;
    private ChangeSupport changeSupport;
    private JToggleButton expandButton;
    private PropertyValueModel expandedHolder;
    String FAKE_FOCUS = "fakeFocus";

    public ExpandablePane(String string, String string2, Icon icon, Icon icon2, Icon icon3, Icon icon4, Icon icon5, Icon icon6, Icon icon7, Icon icon8, JComponent jComponent, boolean bl) {
        super(new GridBagLayout());
        this.initialize(string, string2, icon, icon2, icon3, icon4, icon5, icon6, icon7, icon8, jComponent, bl);
    }

    public ExpandablePane(String string, String string2, Icon icon, Icon icon2, JComponent jComponent, boolean bl) {
        this(string, string2, icon, icon2, null, null, null, null, null, null, jComponent, true);
    }

    public ExpandablePane(String string, String string2, JComponent jComponent) {
        this(string, string2, null, null, null, null, null, null, null, null, jComponent, true);
    }

    public ExpandablePane(String string, String string2, JComponent jComponent, boolean bl) {
        this(string, string2, null, null, jComponent, bl);
    }

    public void addExpansionPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener("value", propertyChangeListener);
    }

    private ActionListener buildActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpandablePane.this.expandedHolder.setValue((Boolean)ExpandablePane.this.expandedHolder.getValue() == false);
                ExpandablePane.this.updateExpandButtonText();
                ExpandablePane.this.updatePressedIcon();
                ExpandablePane.this.changeSupport.firePropertyChanged("value", (Boolean)ExpandablePane.this.expandedHolder.getValue() == false, ((Boolean)ExpandablePane.this.expandedHolder.getValue()).booleanValue());
            }
        };
    }

    private void initialize(String string, String string2, Icon icon, Icon icon2, Icon icon3, Icon icon4, Icon icon5, Icon icon6, Icon icon7, Icon icon8, JComponent jComponent, boolean bl) {
        if (jComponent == null) {
            throw new IllegalStateException("The internal panel cannot be null");
        }
        this.buttonExpandedText = string;
        this.buttonCollapsedText = string2;
        this.buttonExpandedImage = icon;
        this.buttonCollapsedImage = icon2;
        this.buttonExpandedDisabledImage = icon3;
        this.buttonCollapsedDisabledImage = icon4;
        this.buttonExpandedFocusImage = icon5;
        this.buttonCollapsedFocusImage = icon6;
        this.buttonExpandedPressedImage = icon7;
        this.buttonCollapsedPressedImage = icon8;
        this.changeSupport = new ChangeSupport((Object)this);
        this.expandedHolder = new SimplePropertyValueModel(bl);
        this.initializeLayout(jComponent);
        new ComponentVisibilityEnabler((ValueModel)this.expandedHolder, jComponent);
        this.setExpanded(bl);
        this.setOpaque(false);
    }

    private void initializeLayout(JComponent jComponent) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        boolean bl = this.isExpanded();
        this.expandButton = new ToggleButton();
        this.expandButton.setBorderPainted(false);
        this.expandButton.setContentAreaFilled(false);
        this.expandButton.setCursor(Cursor.getPredefinedCursor(12));
        this.expandButton.setSelected(bl);
        this.expandButton.addActionListener(this.buildActionListener());
        this.expandButton.putClientProperty(this.FAKE_FOCUS, false);
        Insets insets = this.expandButton.getInsets();
        insets.right = 4;
        insets.left = 4;
        this.expandButton.setMargin(insets);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.expandButton, gridBagConstraints);
        this.updateExpandButtonIcon();
        this.updateExpandButtonText();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
    }

    public boolean isExpanded() {
        return (Boolean)this.expandedHolder.getValue();
    }

    public void removeExpansionPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener("value", propertyChangeListener);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.expandButton.setEnabled(bl);
    }

    public void setExpanded(boolean bl) {
        this.expandButton.setSelected(bl);
    }

    private void updateExpandButtonIcon() {
        this.expandButton.setIcon(this.buttonExpandedImage);
        this.expandButton.setSelectedIcon(this.buttonCollapsedImage);
        this.expandButton.setPressedIcon(this.buttonExpandedPressedImage);
        this.expandButton.setDisabledIcon(this.buttonExpandedDisabledImage);
        this.expandButton.setDisabledSelectedIcon(this.buttonCollapsedDisabledImage);
        this.expandButton.setRolloverIcon(this.buttonExpandedFocusImage);
        this.expandButton.setRolloverSelectedIcon(this.buttonCollapsedFocusImage);
    }

    private void updateExpandButtonText() {
        this.expandButton.setText(this.isExpanded() ? this.buttonCollapsedText : this.buttonExpandedText);
    }

    private void updatePressedIcon() {
        if (this.expandButton.isSelected()) {
            this.expandButton.setPressedIcon(this.buttonCollapsedPressedImage);
        } else {
            this.expandButton.setPressedIcon(this.buttonExpandedPressedImage);
        }
    }

    private static class ToggleButton
    extends JToggleButton {
        private final Rectangle iconRect;
        private final Rectangle textRect;
        private final Rectangle viewRect = new Rectangle();

        ToggleButton() {
            this.textRect = new Rectangle();
            this.iconRect = new Rectangle();
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.isEnabled()) {
                this.paintUnderline(graphics);
            }
        }

        private void paintUnderline(Graphics graphics) {
            Insets insets = this.getInsets();
            this.viewRect.x = insets.left;
            this.viewRect.y = insets.top;
            this.viewRect.width = this.getWidth() - (insets.right + this.viewRect.x);
            this.viewRect.height = this.getHeight() - (insets.bottom + this.viewRect.y);
            this.textRect.height = 0;
            this.textRect.width = 0;
            this.textRect.y = 0;
            this.textRect.x = 0;
            this.iconRect.height = 0;
            this.iconRect.width = 0;
            this.iconRect.y = 0;
            this.iconRect.x = 0;
            SwingUtilities.layoutCompoundLabel(this, this.getFontMetrics(this.getFont()), this.getText(), this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, this.getText() == null ? 0 : this.getIconTextGap());
            graphics.setColor(this.getForeground());
            graphics.drawLine(this.textRect.x, this.textRect.y + this.textRect.height - 2, this.textRect.x + this.textRect.width, this.textRect.y + this.textRect.height - 2);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            if (bl) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

