/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ExtendedListModel
extends AbstractListModel
implements ListModel {
    protected ListModel listModel;
    protected List prefix;
    protected List suffix;

    public ExtendedListModel(List list, ListModel listModel, List list2) {
        this.initialize(listModel);
        this.prefix = new ArrayList(list);
        this.suffix = new ArrayList(list2);
    }

    public ExtendedListModel(Object object, ListModel listModel, Object object2) {
        this(Collections.singletonList(object), listModel, Collections.singletonList(object2));
    }

    public ExtendedListModel(List list, ListModel listModel) {
        this(list, listModel, Collections.EMPTY_LIST);
    }

    public ExtendedListModel(Object object, ListModel listModel) {
        this(Collections.singletonList(object), listModel, Collections.EMPTY_LIST);
    }

    public ExtendedListModel(ListModel listModel, List list) {
        this(Collections.EMPTY_LIST, listModel, list);
    }

    public ExtendedListModel(ListModel listModel, Object object) {
        this(Collections.EMPTY_LIST, listModel, Collections.singletonList(object));
    }

    public ExtendedListModel(ListModel listModel) {
        this(Collections.singletonList(null), listModel, Collections.EMPTY_LIST);
    }

    protected void initialize(ListModel listModel) {
        this.listModel = listModel;
        this.listModel.addListDataListener(this.buildListDataListener());
    }

    protected ListDataListener buildListDataListener() {
        return new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                ExtendedListModel.this.intervalAdded(listDataEvent);
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                ExtendedListModel.this.intervalRemoved(listDataEvent);
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                ExtendedListModel.this.contentsChanged(listDataEvent);
            }

            public String toString() {
                return "list data listener";
            }
        };
    }

    void intervalAdded(ListDataEvent listDataEvent) {
        int n = this.prefix.size();
        this.fireIntervalAdded(this, listDataEvent.getIndex0() + n, listDataEvent.getIndex1() + n);
    }

    void intervalRemoved(ListDataEvent listDataEvent) {
        int n = this.prefix.size();
        this.fireIntervalRemoved(this, listDataEvent.getIndex0() + n, listDataEvent.getIndex1() + n);
    }

    void contentsChanged(ListDataEvent listDataEvent) {
        int n = this.prefix.size();
        int n2 = listDataEvent.getIndex0() == -1 ? -1 : listDataEvent.getIndex0() + n;
        int n3 = listDataEvent.getIndex1() == -1 ? -1 : listDataEvent.getIndex1() + n;
        this.fireContentsChanged(this, n2, n3);
    }

    public int getSize() {
        return this.prefix.size() + this.listModel.getSize() + this.suffix.size();
    }

    public Object getElementAt(int n) {
        int n2 = this.prefix.size();
        if (n < n2) {
            return this.prefix.get(n);
        }
        if (n >= n2 + this.listModel.getSize()) {
            return this.suffix.get(n - (n2 + this.listModel.getSize()));
        }
        return this.listModel.getElementAt(n - n2);
    }
}

