/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.eclipse.persistence.tools.workbench.uitools.app.NullPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;

public class LabelPanel
extends JPanel {
    private JLabel label;

    public LabelPanel(PropertyValueModel propertyValueModel, PropertyValueModel propertyValueModel2) {
        super(new BorderLayout());
        this.initialize(propertyValueModel, propertyValueModel2);
    }

    public LabelPanel(PropertyValueModel propertyValueModel) {
        this(NullPropertyValueModel.instance(), propertyValueModel);
    }

    protected void initialize(PropertyValueModel propertyValueModel, PropertyValueModel propertyValueModel2) {
        if (propertyValueModel == null || propertyValueModel2 == null) {
            throw new NullPointerException();
        }
        propertyValueModel.addPropertyChangeListener("value", this.buildIconListener());
        propertyValueModel2.addPropertyChangeListener("value", this.buildTextListener());
        this.initializeLayout();
        this.setIcon((Icon)propertyValueModel.getValue());
        this.setText((String)propertyValueModel2.getValue());
    }

    protected PropertyChangeListener buildIconListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LabelPanel.this.setIcon((Icon)propertyChangeEvent.getNewValue());
            }

            public String toString() {
                return "icon listener";
            }
        };
    }

    protected PropertyChangeListener buildTextListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LabelPanel.this.setText((String)propertyChangeEvent.getNewValue());
            }

            public String toString() {
                return "text listener";
            }
        };
    }

    protected void initializeLayout() {
        this.label = this.buildLabel();
        this.label.setBorder(this.buildBorder());
        this.add((Component)this.label, "Before");
    }

    protected JLabel buildLabel() {
        return new JLabel();
    }

    protected Border buildBorder() {
        return BorderFactory.createEmptyBorder();
    }

    protected JLabel getLabel() {
        return this.label;
    }

    protected void setText(String string) {
        this.getLabel().setText(string);
    }

    protected void setIcon(Icon icon) {
        this.getLabel().setIcon(icon);
    }
}

