/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpinnerWithDefaultHandler {
    private ValueModel defaultValueHolder;
    private boolean installingFormatter;
    private boolean showEmptyString;
    private JSpinner spinner;
    private JFormattedTextField textField;
    private boolean valueBeingChanged;
    static final Number DEFAULT_VALUE = -1;

    public SpinnerWithDefaultHandler(ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, Comparable<? extends Number> comparable, Comparable<? extends Number> comparable2, Number number) {
        this.initialize(valueModel, propertyValueModel, valueModel2, comparable, comparable2, number);
    }

    private PropertyChangeListener buildDefaultValuePropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SpinnerWithDefaultHandler.this.spinnerModel().setDefaultValue((Number)propertyChangeEvent.getNewValue());
            }
        };
    }

    private FocusListener buildFocusListener() {
        return new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                SpinnerWithDefaultHandler.this.updateTextFieldOnFocusGained();
            }

            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    SpinnerWithDefaultHandler.this.updateTextFieldOnFocusLost();
                }
            }
        };
    }

    private NumberFormatter buildFormatter(JSpinner.NumberEditor numberEditor) {
        NumberFormatter numberFormatter = (NumberFormatter)this.textField.getFormatter();
        NumberFormatter numberFormatter2 = this.buildNumberFormatter(numberEditor);
        numberFormatter2.setMaximum(numberFormatter.getMaximum());
        numberFormatter2.setMinimum(numberFormatter.getMinimum());
        numberFormatter2.setValueClass(numberFormatter.getValueClass());
        numberFormatter2.setOverwriteMode(numberFormatter.getOverwriteMode());
        numberFormatter2.setAllowsInvalid(numberFormatter.getAllowsInvalid());
        numberFormatter2.setCommitsOnValidEdit(true);
        return numberFormatter2;
    }

    private ChangeListener buildModelChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SpinnerWithDefaultHandler.this.updateTextFieldForegroundColor();
            }
        };
    }

    private NumberFormatter buildNumberFormatter(JSpinner.NumberEditor numberEditor) {
        return new NumberFormatter(numberEditor.getFormat()){

            public Object stringToValue(String string) throws ParseException {
                if (SpinnerWithDefaultHandler.this.defaultValue().equals(string)) {
                    return DEFAULT_VALUE;
                }
                if (string.length() == 0) {
                    return null;
                }
                return super.stringToValue(string);
            }

            public String valueToString(Object object) throws ParseException {
                if (SpinnerWithDefaultHandler.this.installingFormatter) {
                    object = SpinnerWithDefaultHandler.this.spinnerModel().getActualNumber();
                    if (object == null) {
                        object = DEFAULT_VALUE;
                    }
                } else {
                    if (SpinnerWithDefaultHandler.this.showEmptyString) {
                        return "";
                    }
                    if (SpinnerWithDefaultHandler.this.textField.hasFocus() && !SpinnerWithDefaultHandler.this.valueBeingChanged) {
                        return SpinnerWithDefaultHandler.this.textField.getText();
                    }
                }
                if (object == DEFAULT_VALUE) {
                    return SpinnerWithDefaultHandler.this.defaultValue();
                }
                return super.valueToString(object);
            }
        };
    }

    private PropertyChangeListener buildPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SpinnerWithDefaultHandler.this.subjectChanged(propertyChangeEvent.getNewValue() == null);
            }
        };
    }

    protected JSpinner buildSpinner(SpinnerNumberModel spinnerNumberModel) {
        return new JSpinner(spinnerNumberModel);
    }

    private String defaultValue() {
        Number number = (Number)this.defaultValueHolder.getValue();
        if (number == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        stringBuilder.append(number);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public final JSpinner getSpinner() {
        return this.spinner;
    }

    private void initialize(ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, Comparable comparable, Comparable comparable2, Number number) {
        this.defaultValueHolder = valueModel2;
        valueModel.addPropertyChangeListener("value", this.buildPropertyChangeListener());
        valueModel2.addPropertyChangeListener("value", this.buildDefaultValuePropertyChangeListener());
        SpinnerModel spinnerModel = new SpinnerModel(propertyValueModel, valueModel2, comparable, comparable2, number);
        this.spinner = this.buildSpinner(spinnerModel);
        spinnerModel.addChangeListener(this.buildModelChangeListener());
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)this.spinner.getEditor();
        this.textField = numberEditor.getTextField();
        this.textField.setFocusLostBehavior(3);
        this.textField.addFocusListener(this.buildFocusListener());
        this.installNumberFormatter(propertyValueModel, numberEditor);
        this.updateTextFieldForegroundColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installNumberFormatter(ValueModel valueModel, JSpinner.NumberEditor numberEditor) {
        try {
            this.installingFormatter = true;
            NumberFormatter numberFormatter = this.buildFormatter(numberEditor);
            if (valueModel.getValue() != null) {
                this.textField.setValue(valueModel.getValue());
            }
            this.textField.setFormatterFactory(new DefaultFormatterFactory(numberFormatter));
        }
        finally {
            this.installingFormatter = false;
        }
    }

    private SpinnerModel spinnerModel() {
        return (SpinnerModel)this.spinner.getModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subjectChanged(boolean bl) {
        if (bl) {
            try {
                this.showEmptyString = true;
                this.textField.setValue(DEFAULT_VALUE);
            }
            finally {
                this.showEmptyString = false;
            }
        } else {
            this.spinnerModel().synchronize(this.spinnerModel().getActualNumber());
        }
    }

    private void updateTextFieldForegroundColor() {
        if (this.spinnerModel().getActualNumber() == null) {
            this.textField.setForeground(Color.GRAY);
        } else {
            this.textField.setForeground(UIManager.getColor("TextField.foreground"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTextFieldOnFocusGained() {
        if (this.spinnerModel().getActualNumber() == null) {
            try {
                this.showEmptyString = true;
                this.textField.setValue(DEFAULT_VALUE);
                this.textField.setForeground(UIManager.getColor("TextField.foreground"));
            }
            finally {
                this.showEmptyString = false;
            }
        }
    }

    private void updateTextFieldOnFocusLost() {
        String string = this.textField.getText();
        if (string.length() == 0 || string.equals(DEFAULT_VALUE.toString())) {
            this.textField.setValue(DEFAULT_VALUE);
            this.textField.setForeground(Color.GRAY);
        }
    }

    private class SpinnerModel
    extends NumberSpinnerModelAdapter {
        private Number value;

        SpinnerModel(PropertyValueModel propertyValueModel, ValueModel valueModel, Comparable comparable, Comparable comparable2, Number number) {
            super(propertyValueModel, comparable, comparable2, number, SpinnerWithDefaultHandler.this.defaultValueHolder.getValue() != null ? (Number)((Number)SpinnerWithDefaultHandler.this.defaultValueHolder.getValue()) : (Number)0);
            this.synchronizeValue();
        }

        Object getActualNumber() {
            return this.numberHolder.getValue();
        }

        public Number getNumber() {
            return this.value;
        }

        public Number getValue() {
            return this.value;
        }

        protected void setDefaultValue(Number number) {
            super.setDefaultValue(number);
            if (this.value == DEFAULT_VALUE) {
                this.fireStateChanged();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object object) {
            if (object != DEFAULT_VALUE && !SpinnerWithDefaultHandler.this.installingFormatter) {
                try {
                    SpinnerWithDefaultHandler.this.valueBeingChanged = object != null;
                    SpinnerWithDefaultHandler.this.showEmptyString = object == null;
                    this.value = object == null ? (Number)DEFAULT_VALUE : (Number)((Number)object);
                    super.setValue(object);
                }
                finally {
                    SpinnerWithDefaultHandler.this.valueBeingChanged = false;
                    SpinnerWithDefaultHandler.this.showEmptyString = false;
                }
            }
        }

        protected void synchronize(Object object) {
            this.value = object == null ? (Number)DEFAULT_VALUE : (Number)((Number)object);
            super.synchronize(this.value);
            if (object == null && this.getSuperValue() == DEFAULT_VALUE) {
                this.fireStateChanged();
            }
        }

        private void synchronizeValue() {
            this.value = (Number)this.numberHolder.getValue();
            if (this.value == null) {
                this.value = DEFAULT_VALUE;
            }
        }
    }
}

