/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class TextFieldWithDefaultHandler {
    private CellRendererAdapter cellRendererAdapter;
    private ValueModel defaultValueHolder;
    private boolean locked;
    private boolean showDefaultValue;
    private ValueModel subjectHolder;
    private JTextField textField;
    private boolean valueSet;

    public TextFieldWithDefaultHandler(JTextField jTextField, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2) {
        this(jTextField, valueModel, propertyValueModel, valueModel2, null);
    }

    public TextFieldWithDefaultHandler(JTextField jTextField, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, CellRendererAdapter cellRendererAdapter) {
        this.initialize(jTextField, valueModel, propertyValueModel, valueModel2, cellRendererAdapter);
    }

    private CellRendererAdapter buildCellRendererAdapter() {
        return new AbstractCellRendererAdapter(){

            public String buildText(Object object) {
                return (String)object;
            }
        };
    }

    private Document buildDocument(PropertyValueModel propertyValueModel, Document document) {
        return new DocumentAdapter(this.buildValueHolder(propertyValueModel), document);
    }

    private FocusListener buildFocusListener() {
        return new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    TextFieldWithDefaultHandler.this.updateTextFieldOnFocusGained();
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    TextFieldWithDefaultHandler.this.updateTextFieldOnFocusLost();
                }
            }
        };
    }

    private PropertyChangeListener buildPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TextFieldWithDefaultHandler.this.updateTextFieldForegroundColor((String)propertyChangeEvent.getNewValue());
            }
        };
    }

    private PropertyChangeListener buildSubjectPropertyChangeListener() {
        return new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (TextFieldWithDefaultHandler.this.locked) {
                    return;
                }
                try {
                    TextFieldWithDefaultHandler.this.locked = true;
                    TextFieldWithDefaultHandler.this.showDefaultValue = TextFieldWithDefaultHandler.this.subjectHolder.getValue() == null;
                    if (TextFieldWithDefaultHandler.this.showDefaultValue) {
                        TextFieldWithDefaultHandler.this.valueSet = false;
                    }
                    if (!TextFieldWithDefaultHandler.this.valueSet) {
                        String string = (String)TextFieldWithDefaultHandler.this.defaultValue();
                        TextFieldWithDefaultHandler.this.textField.setText(string);
                        TextFieldWithDefaultHandler.this.updateTextFieldForegroundColor(string);
                    }
                }
                finally {
                    TextFieldWithDefaultHandler.this.locked = false;
                    TextFieldWithDefaultHandler.this.valueSet = false;
                    TextFieldWithDefaultHandler.this.showDefaultValue = false;
                }
            }
        };
    }

    private PropertyValueModel buildValueHolder(PropertyValueModel propertyValueModel) {
        InternalPropertyValueModel internalPropertyValueModel = new InternalPropertyValueModel(propertyValueModel);
        internalPropertyValueModel.addPropertyChangeListener("value", this.buildPropertyChangeListener());
        return internalPropertyValueModel;
    }

    private Object defaultValue() {
        if (this.subjectHolder.getValue() == null) {
            return "";
        }
        Object object = this.defaultValueHolder.getValue();
        if (StringTools.stringIsEmpty((String)((String)object))) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        stringBuilder.append(object);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public final JTextField getTextField() {
        return this.textField;
    }

    private void initialize(JTextField jTextField, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, CellRendererAdapter cellRendererAdapter) {
        this.textField = jTextField;
        this.defaultValueHolder = valueModel2;
        this.subjectHolder = valueModel;
        this.cellRendererAdapter = cellRendererAdapter != null ? cellRendererAdapter : this.buildCellRendererAdapter();
        this.subjectHolder.addPropertyChangeListener("value", this.buildSubjectPropertyChangeListener());
        if (propertyValueModel != null) {
            Document document = this.buildDocument(propertyValueModel, jTextField.getDocument());
            jTextField.setDocument(new PlainDocument());
            jTextField.setDocument(document);
        }
        jTextField.addFocusListener(this.buildFocusListener());
        this.updateTextFieldForegroundColor(jTextField.getText());
    }

    private void updateTextFieldForegroundColor(String string) {
        if (this.defaultValue().equals(string)) {
            this.textField.setForeground(Color.GRAY);
        } else {
            this.textField.setForeground(UIManager.getColor("TextField.foreground"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTextFieldOnFocusGained() {
        if (this.textField.getText().equals(this.defaultValue())) {
            this.locked = true;
            try {
                this.textField.setText("");
                this.textField.setForeground(UIManager.getColor("TextField.foreground"));
            }
            finally {
                this.locked = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTextFieldOnFocusLost() {
        if (this.textField.getText().trim().length() == 0) {
            this.locked = true;
            try {
                this.textField.setText((String)this.defaultValue());
                this.textField.setForeground(Color.GRAY);
            }
            finally {
                this.locked = false;
            }
        }
    }

    private final class InternalPropertyValueModel
    extends TransformationPropertyValueModel {
        InternalPropertyValueModel(PropertyValueModel propertyValueModel) {
            super(propertyValueModel);
        }

        private String formatNewValue(String string) {
            return string == null ? null : TextFieldWithDefaultHandler.this.cellRendererAdapter.buildText(string);
        }

        protected Object reverseTransform(Object object) {
            return TextFieldWithDefaultHandler.this.defaultValue().equals(object) ? null : object;
        }

        public void setValue(Object object) {
            if (!TextFieldWithDefaultHandler.this.locked) {
                super.setValue(object);
            }
        }

        protected Object transform(Object object) {
            if (TextFieldWithDefaultHandler.this.showDefaultValue) {
                return TextFieldWithDefaultHandler.this.defaultValue();
            }
            return TextFieldWithDefaultHandler.this.textField.hasFocus() || object != null ? this.formatNewValue((String)object) : TextFieldWithDefaultHandler.this.defaultValue();
        }

        protected void valueChanged(PropertyChangeEvent propertyChangeEvent) {
            TextFieldWithDefaultHandler.this.valueSet = true;
            super.valueChanged(propertyChangeEvent);
        }
    }
}

