/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.utils.rename;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.persistence.utils.rename.RenameFileData;
import org.eclipse.persistence.utils.rename.RenameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageRenamer {
    private static int BUFSIZ = 4096;
    private List<File> ignoreFiles = new ArrayList<File>();
    private List<RenameValue> renameValues = new ArrayList<RenameValue>();
    private int numberOfTotalFile = 0;
    private int numberOfChangedFile = 0;
    File sourceRootDirFile;
    File destinationRootDir;

    public PackageRenamer(String string, String string2, Properties properties) {
        this.sourceRootDirFile = this.buildAndCheckExistingDirFile(string);
        this.destinationRootDir = this.buildAndCheckDestinationFile(string2);
        this.initialize(this.sourceRootDirFile, properties);
    }

    public List<File> getIgnoreFiles() {
        return this.ignoreFiles;
    }

    public List<RenameValue> getRenameValues() {
        return this.renameValues;
    }

    public void binaryCopy(File file, File file2) throws FileNotFoundException, IOException {
        int n;
        Object object;
        byte[] byArray = new byte[BUFSIZ];
        FileInputStream fileInputStream = new FileInputStream(file);
        String string = file2.getParent();
        if (string != null && !((File)(object = new File(string))).exists()) {
            ((File)object).mkdirs();
        }
        object = new FileOutputStream(file2);
        while ((n = fileInputStream.read(byArray)) != -1) {
            ((FileOutputStream)object).write(byArray, 0, n);
        }
        fileInputStream.close();
        ((FileOutputStream)object).close();
    }

    private boolean bufferContainsNullChar(byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != 0) continue;
            return true;
        }
        return false;
    }

    public File buildAndCheckDestinationFile(String string) {
        if (string == null) {
            throw new RuntimeException("Invalid destination directory entered.");
        }
        File file = new File(string);
        if (PackageRenamer.directoryIsSubdirectory(this.sourceRootDirFile, file)) {
            throw new RuntimeException("Invalid destination directory entered:  '" + string + "'" + "It cannot be a sub-directory of the source directory.");
        }
        return file;
    }

    public File buildAndCheckExistingDirFile(String string) {
        if (string == null) {
            throw new RuntimeException("Invalid source directory entered.");
        }
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            throw new RuntimeException("Input Directory:  '" + string + "'" + "does not exist or is not a directory.");
        }
        return file;
    }

    protected static String parseFileExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static boolean directoryIsSubdirectory(File file, File file2) {
        if (file2 == null) {
            return false;
        }
        if (file.equals(file2)) {
            return true;
        }
        return PackageRenamer.directoryIsSubdirectory(file, file2.getParentFile());
    }

    public boolean isExtensionSupported(String string) {
        return string.equalsIgnoreCase("java") || string.equalsIgnoreCase("xml");
    }

    public void run() {
        System.out.println("LOG MESSAGES FROM packageRenamer");
        System.out.println("");
        System.out.println("INPUT: -----------------> " + this.sourceRootDirFile.toString());
        System.out.println("OUTPUT: ----------------> " + this.destinationRootDir.toString());
        System.out.println("List of changed file(s): ");
        this.traverseSourceDirectory(this.sourceRootDirFile);
        System.out.println("Total Changed File(s): ------> " + this.numberOfChangedFile);
        System.out.println("Total File(s):         ------> " + this.numberOfTotalFile);
    }

    public void runSearchAndReplacePackageName(File file) {
        CharSequence charSequence;
        Object object2;
        Object object3;
        if (this.getIgnoreFiles().contains(file)) {
            return;
        }
        String string = "";
        String string2 = file.toString();
        String string3 = file.toString().substring(this.sourceRootDirFile.toString().length() + 1);
        String string4 = this.renameFile(string3);
        String string5 = this.destinationRootDir.toString() + File.separator + string4;
        File file2 = new File(string5);
        if (file2.exists()) {
            System.out.println("WARNING: Skipping pre-existing: " + file2);
            return;
        }
        System.out.print("MIGRATING: " + string2);
        try {
            object3 = new FileInputStream(new File(string2));
            object2 = new byte[BUFSIZ];
            charSequence = new StringBuffer((int)new File(string2).length());
            int n = 0;
            while ((n = ((FileInputStream)object3).read((byte[])object2)) != -1) {
                if (this.bufferContainsNullChar((byte[])object2, n)) {
                    ((FileInputStream)object3).close();
                    this.binaryCopy(file, new File(string5));
                    return;
                }
                String object4 = new String((byte[])object2, 0, n);
                charSequence.append(object4);
            }
            ((FileInputStream)object3).close();
            string = new String((StringBuffer)charSequence);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unexpected exception was thrown during file manipulation." + iOException.getMessage());
        }
        System.out.print(" -> ");
        object3 = new RenameFileData(string, false);
        object2 = null;
        charSequence = null;
        if (string3.lastIndexOf(92) >= 0) {
            string3 = string3.substring(0, string3.lastIndexOf(92));
            string4 = string4.substring(0, string4.lastIndexOf(92));
        }
        object2 = string3.replace('\\', '.');
        charSequence = string4.replace('\\', '.');
        object3 = new RenameValue("package " + (String)object2 + ";", "package " + (String)charSequence + ";").replace((RenameFileData)object3);
        for (RenameValue renameValue : this.getRenameValues()) {
            object3 = renameValue.replace((RenameFileData)object3);
        }
        if (((RenameFileData)object3).isChanged()) {
            ++this.numberOfChangedFile;
        }
        System.out.println(file2);
        try {
            file2.getParentFile().mkdirs();
            FileWriter fileWriter = new FileWriter(file2);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.print(((RenameFileData)object3).getFileContentsString());
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Could not find file to write:  '" + string5 + "'" + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unexpected exception was thrown while writing the file: '" + string5 + "', " + iOException.getMessage());
        }
    }

    public String renameFile(String string) {
        String string2;
        String string3 = PackageRenamer.parseFileExtension(string);
        String string4 = string.substring(0, string.length() - (string3.length() + 1));
        String string5 = string2 = string4.replace('\\', '.');
        RenameFileData renameFileData = new RenameFileData(string5, true);
        for (RenameValue renameValue : this.getRenameValues()) {
            renameFileData = renameValue.replace(renameFileData);
        }
        renameFileData.setFileContentsString(renameFileData.getFileContentsString().replace('.', '\\'));
        if (string3 != null && string3.length() > 0) {
            renameFileData.setFileContentsString(renameFileData.getFileContentsString() + "." + string3);
        }
        return renameFileData.getFileContentsString();
    }

    public void traverseSourceDirectory(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                if (file2.getName().equalsIgnoreCase(".svn")) continue;
                this.traverseSourceDirectory(file2);
                continue;
            }
            ++this.numberOfTotalFile;
            String string = PackageRenamer.parseFileExtension(file2.getName());
            if (!this.isExtensionSupported(string)) continue;
            this.runSearchAndReplacePackageName(file2);
        }
    }

    private void initialize(File file, Properties properties) {
        for (Object object : properties.keySet()) {
            String string = (String)object;
            String string2 = properties.getProperty(string);
            if (string2.equalsIgnoreCase("ignore")) {
                File file2 = new File(file, string.replace('.', '\\'));
                if (file2.exists() && file2.isDirectory()) {
                    this.addIgnoreFolder(file2, this.ignoreFiles);
                    continue;
                }
                File file3 = new File(file, string.replace('.', '\\') + ".java");
                if (!file3.exists()) continue;
                this.ignoreFiles.add(file3);
                continue;
            }
            this.renameValues.add(new RenameValue(string, string2));
        }
        Collections.sort(this.renameValues, RenameValue.renameValueComparator());
    }

    private void addIgnoreFolder(File file, List<File> list) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isFile() && this.isExtensionSupported(PackageRenamer.parseFileExtension(file2.getName()))) {
                list.add(file2);
                continue;
            }
            if (!file2.isDirectory() || file2.getName().equalsIgnoreCase(".svn")) continue;
            this.addIgnoreFolder(file2, list);
        }
    }
}

