/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.dbws;

import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.dbws.DBWSModel;
import org.eclipse.persistence.descriptors.ClassExtractor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.xr.Attachment;
import org.eclipse.persistence.internal.xr.CollectionResult;
import org.eclipse.persistence.internal.xr.DeleteOperation;
import org.eclipse.persistence.internal.xr.InsertOperation;
import org.eclipse.persistence.internal.xr.JPQLQueryHandler;
import org.eclipse.persistence.internal.xr.NamedQueryHandler;
import org.eclipse.persistence.internal.xr.Operation;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.ProcedureArgument;
import org.eclipse.persistence.internal.xr.ProcedureOutputArgument;
import org.eclipse.persistence.internal.xr.QNameTransformer;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.Result;
import org.eclipse.persistence.internal.xr.SQLQueryHandler;
import org.eclipse.persistence.internal.xr.StoredFunctionQueryHandler;
import org.eclipse.persistence.internal.xr.StoredProcedureQueryHandler;
import org.eclipse.persistence.internal.xr.UpdateOperation;
import org.eclipse.persistence.internal.xr.XRServiceModel;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormat;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLChoiceCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLTransformationMapping;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.xml.sax.Attributes;

public class DBWSModelProject
extends Project {
    public NamespaceResolver ns;

    public DBWSModelProject() {
        this.setName("DBWSModelProject");
        this.ns = new NamespaceResolver();
        this.ns.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.ns.put("xsd", "http://www.w3.org/2001/XMLSchema");
        this.addDescriptor(this.buildServiceDescriptor());
        this.addDescriptor(this.buildAttachmentDescriptor());
        this.addDescriptor(this.buildResultDescriptor());
        this.addDescriptor(this.buildCollectionResultDescriptor());
        this.addDescriptor(this.buildParameterDescriptor());
        this.addDescriptor(this.buildSimpleXMLFormatDescriptor());
        this.addDescriptor(this.buildNamedQueryDescriptor());
        this.addDescriptor(this.buildSqlQueryDescriptor());
        this.addDescriptor(this.buildJpqlQueryDescriptor());
        this.addDescriptor(this.buildStoredProcedureQueryDescriptor());
        this.addDescriptor(this.buildProcedureArgumentDescriptor());
        this.addDescriptor(this.buildProcedureOutputArgumentDescriptor());
        this.addDescriptor(this.buildStoredFunctionQueryDescriptor());
        this.addDescriptor(this.buildQueryDescriptor());
        this.addDescriptor(this.buildInsertDescriptor());
        this.addDescriptor(this.buildDeleteDescriptor());
        this.addDescriptor(this.buildUpdateDescriptor());
        for (XMLDescriptor xMLDescriptor : this.getDescriptors().values()) {
            xMLDescriptor.setNamespaceResolver(this.ns);
        }
    }

    protected XMLDescriptor buildServiceDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(DBWSModel.class);
        xMLDescriptor.setDefaultRootElement("dbws");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("name");
        xMLDirectMapping.setXPath("name/text()");
        xMLDescriptor.addMapping(xMLDirectMapping);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName("sessionsFile");
        xMLDirectMapping2.setXPath("sessions-file/text()");
        xMLDescriptor.addMapping(xMLDirectMapping2);
        XMLChoiceCollectionMapping xMLChoiceCollectionMapping = new XMLChoiceCollectionMapping();
        xMLChoiceCollectionMapping.setAttributeName("operations");
        xMLChoiceCollectionMapping.setAttributeAccessor(new AttributeAccessor(){

            public Object getAttributeValueFromObject(Object object) {
                return ((XRServiceModel)object).getOperationsList();
            }

            public void setAttributeValueInObject(Object object, Object object2) {
                Vector vector = (Vector)object2;
                XRServiceModel xRServiceModel = (XRServiceModel)object;
                Map<String, Operation> map = xRServiceModel.getOperations();
                for (Object e : vector) {
                    if (!(e instanceof Operation)) continue;
                    Operation operation = (Operation)e;
                    map.put(operation.getName(), operation);
                }
            }
        });
        xMLChoiceCollectionMapping.addChoiceElement("insert", InsertOperation.class);
        xMLChoiceCollectionMapping.addChoiceElement("query", QueryOperation.class);
        xMLChoiceCollectionMapping.addChoiceElement("update", UpdateOperation.class);
        xMLChoiceCollectionMapping.addChoiceElement("delete", DeleteOperation.class);
        xMLDescriptor.addMapping(xMLChoiceCollectionMapping);
        return xMLDescriptor;
    }

    protected XMLDescriptor buildQueryDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(QueryOperation.class);
        xMLDescriptor.setDefaultRootElement("query");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("name");
        xMLDirectMapping.setXPath("name/text()");
        xMLDescriptor.addMapping(xMLDirectMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("parameters");
        xMLCompositeCollectionMapping.setReferenceClass(Parameter.class);
        xMLCompositeCollectionMapping.setXPath("parameter");
        xMLDescriptor.addMapping(xMLCompositeCollectionMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("result");
        xMLCompositeObjectMapping.setReferenceClass(Result.class);
        xMLCompositeObjectMapping.setXPath("result");
        xMLDescriptor.addMapping(xMLCompositeObjectMapping);
        XMLChoiceObjectMapping xMLChoiceObjectMapping = new XMLChoiceObjectMapping();
        xMLChoiceObjectMapping.setAttributeName("queryHandler");
        xMLChoiceObjectMapping.addChoiceElement("jpql", JPQLQueryHandler.class);
        xMLChoiceObjectMapping.addChoiceElement("named-query", NamedQueryHandler.class);
        xMLChoiceObjectMapping.addChoiceElement("sql", SQLQueryHandler.class);
        xMLChoiceObjectMapping.addChoiceElement("stored-procedure", StoredProcedureQueryHandler.class);
        xMLChoiceObjectMapping.addChoiceElement("stored-function", StoredFunctionQueryHandler.class);
        xMLDescriptor.addMapping(xMLChoiceObjectMapping);
        return xMLDescriptor;
    }

    protected XMLDescriptor buildParameterDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(Parameter.class);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("name");
        xMLDirectMapping.setXPath("name/text()");
        xMLDescriptor.addMapping(xMLDirectMapping);
        XMLTransformationMapping xMLTransformationMapping = new XMLTransformationMapping();
        xMLTransformationMapping.setAttributeName("type");
        QNameTransformer qNameTransformer = new QNameTransformer("type/text()");
        xMLTransformationMapping.addFieldTransformer("type/text()", (FieldTransformer)qNameTransformer);
        xMLTransformationMapping.setAttributeTransformer(qNameTransformer);
        xMLDescriptor.addMapping(xMLTransformationMapping);
        return xMLDescriptor;
    }

    protected XMLDescriptor buildAttachmentDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(Attachment.class);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("mimeType");
        xMLDirectMapping.setXPath("mime-type/text()");
        xMLDescriptor.addMapping(xMLDirectMapping);
        return xMLDescriptor;
    }

    protected XMLDescriptor buildResultDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(Result.class);
        xMLDescriptor.setDefaultRootElement("result");
        XMLTransformationMapping xMLTransformationMapping = new XMLTransformationMapping();
        xMLTransformationMapping.setAttributeName("type");
        QNameTransformer qNameTransformer = new QNameTransformer("type/text()");
        xMLTransformationMapping.addFieldTransformer("type/text()", (FieldTransformer)qNameTransformer);
        xMLTransformationMapping.setAttributeTransformer(qNameTransformer);
        xMLDescriptor.addMapping(xMLTransformationMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("attachment");
        xMLCompositeObjectMapping.setXPath("attachment");
        xMLCompositeObjectMapping.setReferenceClass(Attachment.class);
        xMLDescriptor.addMapping(xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("simpleXMLFormat");
        xMLCompositeObjectMapping2.setXPath("simple-xml-format");
        xMLCompositeObjectMapping2.setReferenceClass(SimpleXMLFormat.class);
        xMLDescriptor.addMapping(xMLCompositeObjectMapping2);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeAccessor(new AttributeAccessor(){

            public String getAttributeName() {
                return "isCollection";
            }

            public Object getAttributeValueFromObject(Object object) throws DescriptorException {
                if (object instanceof CollectionResult) {
                    return Boolean.TRUE;
                }
                return null;
            }

            public void setAttributeValueInObject(Object object, Object object2) throws DescriptorException {
            }
        });
        xMLDirectMapping.setXPath("@isCollection");
        xMLDescriptor.addMapping(xMLDirectMapping);
        XMLField xMLField = new XMLField("@isCollection");
        xMLField.setSchemaType(XMLConstants.BOOLEAN_QNAME);
        xMLDescriptor.getInheritancePolicy().setClassIndicatorField(xMLField);
        xMLDescriptor.getInheritancePolicy().setClassExtractor(new ClassExtractor(){

            @Override
            public Class<?> extractClassFromRow(Record record, Session session) {
                Class<Result> clazz = Result.class;
                UnmarshalRecord unmarshalRecord = (UnmarshalRecord)record;
                Attributes attributes = unmarshalRecord.getAttributes();
                if (attributes != null) {
                    int n = attributes.getLength();
                    for (int i = 0; i < n; ++i) {
                        String string;
                        String string2 = attributes.getQName(i);
                        if (!string2.equals("isCollection") || !(string = attributes.getValue(i)).equalsIgnoreCase("true")) continue;
                        clazz = CollectionResult.class;
                        break;
                    }
                }
                return clazz;
            }
        });
        return xMLDescriptor;
    }

    protected XMLDescriptor buildCollectionResultDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(CollectionResult.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(Result.class);
        xMLDescriptor.setDefaultRootElement("result");
        return xMLDescriptor;
    }

    protected XMLDescriptor buildSimpleXMLFormatDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(SimpleXMLFormat.class);
        xMLDescriptor.setDefaultRootElement("simple-xml-format");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("simpleXMLFormatTag");
        xMLDirectMapping.setXPath("simple-xml-format-tag/text()");
        xMLDescriptor.addMapping(xMLDirectMapping);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName("xmlTag");
        xMLDirectMapping2.setXPath("simple-xml-tag/text()");
        xMLDescriptor.addMapping(xMLDirectMapping2);
        return xMLDescriptor;
    }

    protected XMLDescriptor buildNamedQueryDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(NamedQueryHandler.class);
        xMLDescriptor.setDefaultRootElement("named-query");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("name");
        xMLDirectMapping.setXPath("name/text()");
        xMLDescriptor.addMapping(xMLDirectMapping);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName("descriptor");
        xMLDirectMapping2.setXPath("descriptor/text()");
        xMLDescriptor.addMapping(xMLDirectMapping2);
        return xMLDescriptor;
    }

    protected XMLDescriptor buildSqlQueryDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(SQLQueryHandler.class);
        xMLDescriptor.setDefaultRootElement("sql");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("sqlString");
        xMLDirectMapping.setXPath("text()");
        xMLDirectMapping.setIsCDATA(true);
        xMLDescriptor.addMapping(xMLDirectMapping);
        return xMLDescriptor;
    }

    protected XMLDescriptor buildJpqlQueryDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(JPQLQueryHandler.class);
        xMLDescriptor.setDefaultRootElement("jpql");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("jpqlString");
        xMLDirectMapping.setXPath("text()");
        xMLDirectMapping.setIsCDATA(true);
        xMLDescriptor.addMapping(xMLDirectMapping);
        return xMLDescriptor;
    }

    protected XMLDescriptor buildStoredProcedureQueryDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(StoredProcedureQueryHandler.class);
        xMLDescriptor.setDefaultRootElement("stored-procedure");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("name");
        xMLDirectMapping.setXPath("name/text()");
        xMLDescriptor.addMapping(xMLDirectMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("inArguments");
        xMLCompositeCollectionMapping.setXPath("in-argument");
        xMLCompositeCollectionMapping.setReferenceClass(ProcedureArgument.class);
        xMLDescriptor.addMapping(xMLCompositeCollectionMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping2 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping2.setAttributeName("inOutArguments");
        xMLCompositeCollectionMapping2.setXPath("inout-argument");
        xMLCompositeCollectionMapping2.setReferenceClass(ProcedureOutputArgument.class);
        xMLDescriptor.addMapping(xMLCompositeCollectionMapping2);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping3 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping3.setAttributeName("outArguments");
        xMLCompositeCollectionMapping3.setXPath("out-argument");
        xMLCompositeCollectionMapping3.setReferenceClass(ProcedureOutputArgument.class);
        xMLDescriptor.addMapping(xMLCompositeCollectionMapping3);
        return xMLDescriptor;
    }

    protected XMLDescriptor buildStoredFunctionQueryDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(StoredFunctionQueryHandler.class);
        xMLDescriptor.setDefaultRootElement("stored-function");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("name");
        xMLDirectMapping.setXPath("name/text()");
        xMLDescriptor.addMapping(xMLDirectMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("inArguments");
        xMLCompositeCollectionMapping.setXPath("in-argument");
        xMLCompositeCollectionMapping.setReferenceClass(ProcedureArgument.class);
        xMLDescriptor.addMapping(xMLCompositeCollectionMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping2 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping2.setAttributeName("inOutArguments");
        xMLCompositeCollectionMapping2.setXPath("inout-argument");
        xMLCompositeCollectionMapping2.setReferenceClass(ProcedureOutputArgument.class);
        xMLDescriptor.addMapping(xMLCompositeCollectionMapping2);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping3 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping3.setAttributeName("outArguments");
        xMLCompositeCollectionMapping3.setXPath("out-argument");
        xMLCompositeCollectionMapping3.setReferenceClass(ProcedureOutputArgument.class);
        xMLDescriptor.addMapping(xMLCompositeCollectionMapping3);
        return xMLDescriptor;
    }

    protected XMLDescriptor buildProcedureArgumentDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(ProcedureArgument.class);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("name");
        xMLDirectMapping.setXPath("name");
        xMLDescriptor.addMapping(xMLDirectMapping);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName("parameterName");
        xMLDirectMapping2.setXPath("parameter");
        xMLDescriptor.addMapping(xMLDirectMapping2);
        XMLDirectMapping xMLDirectMapping3 = new XMLDirectMapping();
        xMLDirectMapping3.setAttributeName("complexTypeName");
        xMLDirectMapping3.setXPath("complex-type");
        xMLDescriptor.addMapping(xMLDirectMapping3);
        return xMLDescriptor;
    }

    protected XMLDescriptor buildProcedureOutputArgumentDescriptor() {
        XMLDescriptor xMLDescriptor = this.buildProcedureArgumentDescriptor();
        xMLDescriptor.setJavaClass(ProcedureOutputArgument.class);
        XMLTransformationMapping xMLTransformationMapping = new XMLTransformationMapping();
        xMLTransformationMapping.setAttributeName("resultType");
        QNameTransformer qNameTransformer = new QNameTransformer("type/text()");
        xMLTransformationMapping.addFieldTransformer("type/text()", (FieldTransformer)qNameTransformer);
        xMLTransformationMapping.setAttributeTransformer(qNameTransformer);
        xMLDescriptor.addMapping(xMLTransformationMapping);
        return xMLDescriptor;
    }

    protected XMLDescriptor buildInsertDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(InsertOperation.class);
        xMLDescriptor.setDefaultRootElement("insert");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("name");
        xMLDirectMapping.setXPath("name/text()");
        xMLDescriptor.addMapping(xMLDirectMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("parameters");
        xMLCompositeCollectionMapping.setReferenceClass(Parameter.class);
        xMLCompositeCollectionMapping.setXPath("parameter");
        xMLDescriptor.addMapping(xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }

    protected XMLDescriptor buildDeleteDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(DeleteOperation.class);
        xMLDescriptor.setDefaultRootElement("delete");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("name");
        xMLDirectMapping.setXPath("name/text()");
        xMLDescriptor.addMapping(xMLDirectMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("parameters");
        xMLCompositeCollectionMapping.setReferenceClass(Parameter.class);
        xMLCompositeCollectionMapping.setXPath("parameter");
        xMLDescriptor.addMapping(xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }

    protected XMLDescriptor buildUpdateDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(UpdateOperation.class);
        xMLDescriptor.setDefaultRootElement("update");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("name");
        xMLDirectMapping.setXPath("name/text()");
        xMLDescriptor.addMapping(xMLDirectMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("parameters");
        xMLCompositeCollectionMapping.setReferenceClass(Parameter.class);
        xMLCompositeCollectionMapping.setXPath("parameter");
        xMLDescriptor.addMapping(xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }
}

