/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.annotations.IdValidation;
import org.eclipse.persistence.descriptors.AllFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ChangedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventManager;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.descriptors.FieldsLockingPolicy;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.descriptors.InterfacePolicy;
import org.eclipse.persistence.descriptors.ReturningPolicy;
import org.eclipse.persistence.descriptors.SelectedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.TablePerClassPolicy;
import org.eclipse.persistence.descriptors.TimestampLockingPolicy;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.descriptors.WrapperPolicy;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.DeferredChangeDetectionPolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangePolicy;
import org.eclipse.persistence.descriptors.copying.CloneCopyPolicy;
import org.eclipse.persistence.descriptors.copying.CopyPolicy;
import org.eclipse.persistence.descriptors.copying.InstantiationCopyPolicy;
import org.eclipse.persistence.descriptors.copying.PersistenceEntityCopyPolicy;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.NoExpiryCacheInvalidationPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.HistoryPolicy;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.descriptors.CascadeLockingPolicy;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.descriptors.PersistenceObjectAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.PersistenceObjectInstantiationPolicy;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.MappingCompare;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.querykeys.DirectQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.remote.DistributedSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDescriptor
implements Cloneable,
Serializable {
    protected Class javaClass;
    protected String javaClassName;
    protected Vector<DatabaseTable> tables = NonSynchronizedVector.newInstance(3);
    protected transient DatabaseTable defaultTable;
    protected List<DatabaseField> primaryKeyFields;
    protected transient Map<DatabaseTable, Map<DatabaseField, DatabaseField>> additionalTablePrimaryKeyFields;
    protected transient Vector<DatabaseTable> multipleTableInsertOrder;
    protected transient Map<DatabaseTable, Set<DatabaseTable>> multipleTableForeignKeys;
    protected transient Vector<DatabaseField> fields;
    protected transient Vector<DatabaseField> allFields;
    protected Vector<DatabaseMapping> mappings = NonSynchronizedVector.newInstance();
    protected List<DatabaseMapping> lockableMappings;
    protected Map<String, QueryKey> queryKeys;
    protected Class identityMapClass;
    protected Class remoteIdentityMapClass = null;
    protected int identityMapSize = -1;
    protected int remoteIdentityMapSize = -1;
    protected String sequenceNumberName;
    protected DatabaseField sequenceNumberField;
    protected transient String sessionName;
    protected boolean shouldAlwaysRefreshCache = false;
    protected boolean shouldOnlyRefreshCacheIfNewerVersion = false;
    protected boolean shouldDisableCacheHits = false;
    protected transient Vector constraintDependencies;
    protected transient String amendmentMethodName;
    protected transient Class amendmentClass;
    protected transient String amendmentClassName;
    protected boolean shouldAlwaysRefreshCacheOnRemote = false;
    protected boolean shouldDisableCacheHitsOnRemote = false;
    protected String alias;
    protected boolean shouldBeReadOnly = false;
    protected boolean shouldAlwaysConformResultsInUnitOfWork = false;
    protected Boolean isIsolated;
    protected boolean shouldRegisterResultsInUnitOfWork = true;
    protected DescriptorEventManager eventManager;
    protected DescriptorQueryManager queryManager;
    protected ObjectBuilder objectBuilder;
    protected CopyPolicy copyPolicy;
    protected String copyPolicyClassName;
    protected InstantiationPolicy instantiationPolicy;
    protected InheritancePolicy inheritancePolicy;
    protected InterfacePolicy interfacePolicy;
    protected OptimisticLockingPolicy optimisticLockingPolicy;
    protected Vector cascadeLockingPolicies;
    protected WrapperPolicy wrapperPolicy;
    protected ObjectChangePolicy changePolicy;
    protected ReturningPolicy returningPolicy;
    protected HistoryPolicy historyPolicy;
    protected CMPPolicy cmpPolicy;
    protected FetchGroupManager fetchGroupManager;
    protected Map properties;
    protected transient int initializationStage = 0;
    protected transient int interfaceInitializationStage = 0;
    protected static final int UNINITIALIZED = 0;
    protected static final int PREINITIALIZED = 1;
    protected static final int INITIALIZED = 2;
    protected static final int POST_INITIALIZED = 3;
    protected static final int ERROR = -1;
    protected int descriptorType = 0;
    protected static final int NORMAL = 0;
    protected static final int INTERFACE = 1;
    protected static final int AGGREGATE = 2;
    protected static final int AGGREGATE_COLLECTION = 3;
    protected boolean shouldOrderMappings = true;
    protected CacheInvalidationPolicy cacheInvalidationPolicy = null;
    protected boolean shouldAcquireCascadedLocks = false;
    protected boolean hasSimplePrimaryKey = false;
    protected int cacheSynchronizationType = 1;
    public static final int UNDEFINED_OBJECT_CHANGE_BEHAVIOR = 0;
    public static final int SEND_OBJECT_CHANGES = 1;
    public static final int INVALIDATE_CHANGED_OBJECTS = 2;
    public static final int SEND_NEW_OBJECTS_WITH_CHANGES = 3;
    public static final int DO_NOT_SEND_CHANGES = 4;
    protected int unitOfWorkCacheIsolationLevel = -1;
    public static final int UNDEFINED_ISOLATATION = -1;
    public static final int USE_SESSION_CACHE_AFTER_TRANSACTION = 0;
    public static final int ISOLATE_NEW_DATA_AFTER_TRANSACTION = 1;
    public static final int ISOLATE_CACHE_AFTER_TRANSACTION = 2;
    public static final int ISOLATE_CACHE_ALWAYS = 3;
    public static boolean shouldUseFullChangeSetsForNewObjects = false;
    protected boolean isNativeConnectionRequired;
    protected IdValidation idValidation;
    protected boolean isIDSpecified = false;
    protected Class cacheInterceptorClass;
    protected String cacheInterceptorClassName;
    protected QueryRedirector defaultQueryRedirector;
    protected QueryRedirector defaultReadAllQueryRedirector;
    protected QueryRedirector defaultReadObjectQueryRedirector;
    protected QueryRedirector defaultReportQueryRedirector;
    protected QueryRedirector defaultUpdateObjectQueryRedirector;
    protected QueryRedirector defaultInsertObjectQueryRedirector;
    protected QueryRedirector defaultDeleteObjectQueryRedirector;
    protected String defaultQueryRedirectorClassName;
    protected String defaultReadAllQueryRedirectorClassName;
    protected String defaultReadObjectQueryRedirectorClassName;
    protected String defaultReportQueryRedirectorClassName;
    protected String defaultUpdateObjectQueryRedirectorClassName;
    protected String defaultInsertObjectQueryRedirectorClassName;
    protected String defaultDeleteObjectQueryRedirectorClassName;
    protected Sequence sequence;
    protected List<DatabaseMapping> mappingsPostCalculateChanges;
    protected List<DatabaseMapping> mappingsPostCalculateChangesOnDeleted;
    protected transient List<DatabaseField> additionalAggregateCollectionKeyFields;
    protected List<DatabaseMapping> preDeleteMappings;

    public ClassDescriptor() {
        this.primaryKeyFields = new ArrayList<DatabaseField>(2);
        this.fields = NonSynchronizedVector.newInstance();
        this.allFields = NonSynchronizedVector.newInstance();
        this.constraintDependencies = NonSynchronizedVector.newInstance(2);
        this.multipleTableForeignKeys = new HashMap<DatabaseTable, Set<DatabaseTable>>(5);
        this.queryKeys = new HashMap<String, QueryKey>(5);
        this.objectBuilder = new ObjectBuilder(this);
        this.cascadeLockingPolicies = NonSynchronizedVector.newInstance();
    }

    public void addAbstractQueryKey(String string) {
        QueryKey queryKey = new QueryKey();
        queryKey.setName(string);
        this.addQueryKey(queryKey);
    }

    public void addCascadeLockingPolicy(CascadeLockingPolicy cascadeLockingPolicy) {
        Object object;
        this.cascadeLockingPolicies.add(cascadeLockingPolicy);
        if (this.hasInheritance()) {
            object = this.getInheritancePolicy().getAllChildDescriptors().iterator();
            while (object.hasNext()) {
                ((ClassDescriptor)object.next()).addCascadeLockingPolicy(cascadeLockingPolicy);
            }
        }
        if (!(this.usesOptimisticLocking() && this.getOptimisticLockingPolicy().isCascaded() || !this.isInitialized(2))) {
            object = this.getMappings().elements();
            while (object.hasMoreElements()) {
                this.prepareCascadeLockingPolicy((DatabaseMapping)object.nextElement());
            }
        }
    }

    public void addConstraintDependencies(Class clazz) {
        this.addConstraintDependency(clazz);
    }

    public void addConstraintDependency(Class clazz) {
        this.getConstraintDependencies().add(clazz);
    }

    public DatabaseMapping addDirectMapping(String string, String string2) {
        DirectToFieldMapping directToFieldMapping = new DirectToFieldMapping();
        directToFieldMapping.setAttributeName(string);
        directToFieldMapping.setFieldName(string2);
        return this.addMapping(directToFieldMapping);
    }

    public DatabaseMapping addDirectMapping(String string, String string2, String string3, String string4) {
        DirectToFieldMapping directToFieldMapping = new DirectToFieldMapping();
        directToFieldMapping.setAttributeName(string);
        directToFieldMapping.setSetMethodName(string3);
        directToFieldMapping.setGetMethodName(string2);
        directToFieldMapping.setFieldName(string4);
        return this.addMapping(directToFieldMapping);
    }

    public void addDirectQueryKey(String string, String string2) {
        DirectQueryKey directQueryKey = new DirectQueryKey();
        DatabaseField databaseField = new DatabaseField(string2);
        directQueryKey.setName(string);
        directQueryKey.setField(databaseField);
        this.getQueryKeys().put(string, directQueryKey);
    }

    public void addForeignKeyFieldNameForMultipleTable(String string, String string2) throws DescriptorException {
        this.addForeignKeyFieldForMultipleTable(new DatabaseField(string), new DatabaseField(string2));
    }

    public void addForeignKeyFieldForMultipleTable(DatabaseField databaseField, DatabaseField databaseField2) throws DescriptorException {
        if (!databaseField.hasTableName() || !databaseField2.hasTableName()) {
            throw DescriptorException.multipleTablePrimaryKeyMustBeFullyQualified(this);
        }
        this.setAdditionalTablePrimaryKeyFields(databaseField.getTable(), databaseField2, databaseField);
        Set<DatabaseTable> set = this.getMultipleTableForeignKeys().get(databaseField2.getTable());
        if (set == null) {
            set = new HashSet<DatabaseTable>(3);
            this.getMultipleTableForeignKeys().put(databaseField2.getTable(), set);
        }
        set.add(databaseField.getTable());
    }

    public DatabaseMapping addMapping(DatabaseMapping databaseMapping) {
        if (databaseMapping.getDescriptor() == null) {
            databaseMapping.setDescriptor(this);
        }
        this.getMappings().addElement(databaseMapping);
        return databaseMapping;
    }

    protected void validateMappingType(DatabaseMapping databaseMapping) {
        if (!databaseMapping.isRelationalMapping()) {
            throw DescriptorException.invalidMappingType(databaseMapping);
        }
    }

    public void addPrimaryKeyFieldName(String string) {
        this.getPrimaryKeyFields().add(new DatabaseField(string));
    }

    public void addPrimaryKeyField(DatabaseField databaseField) {
        this.getPrimaryKeyFields().add(databaseField);
    }

    public void addQueryKey(QueryKey queryKey) {
        this.getQueryKeys().put(queryKey.getName(), queryKey);
    }

    public void addTable(DatabaseTable databaseTable) {
        this.getTables().addElement(databaseTable);
    }

    public void addTableName(String string) {
        this.addTable(new DatabaseTable(string));
    }

    public void adjustMultipleTableInsertOrder() {
        if (this.getMultipleTableInsertOrder() == null || this.getMultipleTableInsertOrder().isEmpty()) {
            this.createMultipleTableInsertOrder();
        } else {
            this.verifyMultipleTableInsertOrder();
        }
        this.toggleAdditionalTablePrimaryKeyFields();
    }

    public void alwaysConformResultsInUnitOfWork() {
        this.setShouldAlwaysConformResultsInUnitOfWork(true);
    }

    public void alwaysRefreshCache() {
        this.setShouldAlwaysRefreshCache(true);
    }

    public void alwaysRefreshCacheOnRemote() {
        this.setShouldAlwaysRefreshCacheOnRemote(true);
    }

    public void applyAmendmentMethod() {
        this.applyAmendmentMethod(null);
    }

    public void applyAmendmentMethod(DescriptorEvent descriptorEvent) {
        if (this.getAmendmentClass() == null || this.getAmendmentMethodName() == null) {
            return;
        }
        Method method = null;
        Class[] classArray = new Class[]{ClassDescriptor.class};
        try {
            method = Helper.getDeclaredMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), classArray);
        }
        catch (Exception exception) {
            classArray[0] = ClassDescriptor.class;
            try {
                method = Helper.getDeclaredMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), classArray);
            }
            catch (Exception exception2) {
                throw DescriptorException.invalidAmendmentMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), exception2, this);
            }
        }
        Object[] objectArray = new Object[]{this};
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                AccessController.doPrivileged(new PrivilegedMethodInvoker(method, null, objectArray));
            } else {
                PrivilegedAccessHelper.invokeMethod(method, null, objectArray);
            }
        }
        catch (Exception exception) {
            throw DescriptorException.errorOccuredInAmendmentMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), exception, this);
        }
    }

    public boolean arePrimaryKeyFields(Vector vector) {
        if (vector.size() != this.getPrimaryKeyFields().size()) {
            return false;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            if (this.getPrimaryKeyFields().contains(databaseField)) continue;
            return false;
        }
        return true;
    }

    protected void assignDefaultValues(AbstractSession abstractSession) {
        if (this.identityMapSize == -1) {
            this.identityMapSize = abstractSession.getProject().getDefaultIdentityMapSize();
        }
        if (this.identityMapClass == null) {
            this.identityMapClass = abstractSession.getProject().getDefaultIdentityMapClass();
        }
        if (this.isIsolated == null) {
            this.isIsolated = abstractSession.getProject().getDefaultIsIsolated();
        }
    }

    public DatabaseCall buildCallFromStatement(SQLStatement sQLStatement, AbstractSession abstractSession) {
        DatabaseCall databaseCall = sQLStatement.buildCall(abstractSession);
        if (this.isNativeConnectionRequired()) {
            databaseCall.setIsNativeConnectionRequired(true);
        }
        return databaseCall;
    }

    public Vector buildDirectValuesFromFieldValue(Object object) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public DatabaseField buildField(String string) {
        DatabaseField databaseField = new DatabaseField(string);
        DatabaseTable databaseTable = databaseField.hasTableName() ? this.getTable(databaseField.getTableName()) : (this.getDefaultTable() != null ? this.getDefaultTable() : this.getTable(this.getTableName()));
        databaseField.setTable(databaseTable);
        return databaseField;
    }

    public DatabaseField buildField(DatabaseField databaseField) {
        return this.buildField(databaseField, null);
    }

    public DatabaseField buildField(DatabaseField databaseField, DatabaseTable databaseTable) {
        DatabaseField databaseField2 = this.getObjectBuilder().getFieldsMap().get(databaseField);
        if (databaseField2 == null) {
            databaseField2 = databaseField;
            DatabaseTable databaseTable2 = databaseTable != null && databaseField.hasTableName() && databaseField.getTableName().equals(databaseTable.getName()) ? databaseTable : (databaseField.hasTableName() ? this.getTable(databaseField.getTableName()) : this.getDefaultTable());
            databaseField.setTable(databaseTable2);
            this.getObjectBuilder().getFieldsMap().put(databaseField2, databaseField2);
        }
        return databaseField2;
    }

    public Object buildFieldValueFromDirectValues(Vector vector, String string, AbstractSession abstractSession) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Object buildFieldValueFromForeignKeys(Vector vector, String string, AbstractSession abstractSession) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Object buildFieldValueFromNestedRow(AbstractRecord abstractRecord, AbstractSession abstractSession) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Object buildFieldValueFromNestedRows(Vector vector, String string, AbstractSession abstractSession) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public AbstractRecord buildNestedRowFromFieldValue(Object object) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Vector buildNestedRowsFromFieldValue(Object object, AbstractSession abstractSession) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    protected void checkDatabase(AbstractSession abstractSession) {
        if (abstractSession.getIntegrityChecker().shouldCheckDatabase()) {
            for (DatabaseTable databaseTable : this.getTables()) {
                if (abstractSession.getIntegrityChecker().checkTable(databaseTable, abstractSession)) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    Vector vector = abstractSession.getAccessor().getColumnInfo(null, null, databaseTable.getName(), null, abstractSession);
                    if (vector.isEmpty() && abstractSession.getPlatform().shouldForceFieldNamesToUpperCase()) {
                        vector = abstractSession.getAccessor().getColumnInfo(null, null, databaseTable.getName().toLowerCase(), null, abstractSession);
                    }
                    for (AbstractRecord abstractRecord : vector) {
                        if (abstractSession.getPlatform().shouldForceFieldNamesToUpperCase()) {
                            arrayList.add(((String)abstractRecord.get("COLUMN_NAME")).toUpperCase());
                            continue;
                        }
                        arrayList.add(abstractRecord.get("COLUMN_NAME"));
                    }
                    for (DatabaseField databaseField : this.getFields()) {
                        if (!databaseField.getTable().equals(databaseTable) || arrayList.contains(databaseField.getName())) continue;
                        abstractSession.getIntegrityChecker().handleError(DescriptorException.fieldIsNotPresentInDatabase(this, databaseTable.getName(), databaseField.getName()));
                    }
                    continue;
                }
                abstractSession.getIntegrityChecker().handleError(DescriptorException.tableIsNotPresentInDatabase(this));
            }
        }
    }

    public void checkInheritanceTreeAggregateSettings(AbstractSession abstractSession, AggregateMapping aggregateMapping) throws DescriptorException {
        if (!this.hasInheritance()) {
            return;
        }
        if (this.isChildDescriptor()) {
            Class clazz = this.getInheritancePolicy().getParentClass();
            if (clazz == this.getJavaClass()) {
                throw DescriptorException.parentClassIsSelf(this);
            }
            abstractSession.getDescriptor(clazz).checkInheritanceTreeAggregateSettings(abstractSession, aggregateMapping);
        } else {
            this.checkInheritanceTreeAggregateSettingsForChildren(abstractSession, aggregateMapping);
        }
    }

    private void checkInheritanceTreeAggregateSettingsForChildren(AbstractSession abstractSession, AggregateMapping aggregateMapping) throws DescriptorException {
        if (!this.isAggregateDescriptor()) {
            abstractSession.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregate(this.getJavaClass().getName(), aggregateMapping));
        }
        Enumeration enumeration = this.getInheritancePolicy().getChildDescriptors().elements();
        while (enumeration.hasMoreElements()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)enumeration.nextElement();
            classDescriptor.checkInheritanceTreeAggregateSettingsForChildren(abstractSession, aggregateMapping);
        }
    }

    protected void createMultipleTableInsertOrder() {
        int n = 0;
        if (this.isChildDescriptor()) {
            n = this.getInheritancePolicy().getParentDescriptor().getTables().size();
            this.setMultipleTableInsertOrder((Vector)this.getInheritancePolicy().getParentDescriptor().getMultipleTableInsertOrder().clone());
            if (n == this.getTables().size()) {
                return;
            }
        }
        if (this.getMultipleTableForeignKeys().isEmpty()) {
            if (n == 0) {
                this.setMultipleTableInsertOrder((Vector)this.getTables().clone());
            } else {
                for (int i = n; i < this.getTables().size(); ++i) {
                    this.getMultipleTableInsertOrder().add(this.getTables().get(i));
                }
            }
            return;
        }
        this.verifyMultipleTablesForeignKeysTables();
        int[][] nArray = this.createTableComparison(this.getTables(), n);
        this.createMultipleTableInsertOrderFromComparison(nArray, n);
    }

    protected void verifyMultipleTableInsertOrder() {
        Object object;
        int n = 0;
        if (this.isChildDescriptor() && (n = this.getInheritancePolicy().getParentDescriptor().getTables().size()) + this.getMultipleTableInsertOrder().size() == this.getTables().size()) {
            object = this.getMultipleTableInsertOrder();
            this.setMultipleTableInsertOrder((Vector)this.getInheritancePolicy().getParentDescriptor().getMultipleTableInsertOrder().clone());
            this.getMultipleTableInsertOrder().addAll((Collection<DatabaseTable>)object);
        }
        if (this.getMultipleTableInsertOrder().size() != this.getTables().size()) {
            throw DescriptorException.multipleTableInsertOrderMismatch(this);
        }
        if (n == this.getTables().size()) {
            return;
        }
        if (this.getMultipleTableForeignKeys().isEmpty()) {
            return;
        }
        this.verifyMultipleTablesForeignKeysTables();
        object = this.createTableComparison(this.getMultipleTableInsertOrder(), n);
        for (int i = n; i < this.getMultipleTableInsertOrder().size(); ++i) {
            for (int j = i + 1; j < this.getTables().size(); ++j) {
                if (object[i - n][j - n] <= 0) continue;
                throw DescriptorException.insertOrderConflictsWithMultipleTableForeignKeys(this, this.getMultipleTableInsertOrder().get(i), this.getMultipleTableInsertOrder().get(j));
            }
        }
    }

    protected void verifyMultipleTablesForeignKeysTables() {
        for (Map.Entry<DatabaseTable, Set<DatabaseTable>> entry : this.getMultipleTableForeignKeys().entrySet()) {
            DatabaseTable databaseTable = entry.getKey();
            if (this.getTables().indexOf(databaseTable) == -1) {
                throw DescriptorException.illegalTableNameInMultipleTableForeignKeyField(this, databaseTable);
            }
            for (DatabaseTable databaseTable2 : entry.getValue()) {
                if (this.getTables().indexOf(databaseTable2) != -1) continue;
                throw DescriptorException.illegalTableNameInMultipleTableForeignKeyField(this, databaseTable);
            }
        }
    }

    protected int[][] createTableComparison(Vector vector, int n) {
        int n2 = vector.size();
        int[][] nArray = new int[n2 - n][n2 - n];
        for (Map.Entry<DatabaseTable, Set<DatabaseTable>> entry : this.getMultipleTableForeignKeys().entrySet()) {
            DatabaseTable databaseTable = entry.getKey();
            int n3 = vector.indexOf(databaseTable) - n;
            if (n3 < 0) continue;
            Set<DatabaseTable> set = entry.getValue();
            for (DatabaseTable databaseTable2 : set) {
                int n4 = vector.indexOf(databaseTable2) - n;
                if (n4 >= 0) {
                    if (nArray[n3][n4] == 1) {
                        throw DescriptorException.insertOrderCyclicalDependencyBetweenTwoTables(this, databaseTable2, databaseTable);
                    }
                    nArray[n3][n4] = -1;
                    nArray[n4][n3] = 1;
                    continue;
                }
                throw DescriptorException.insertOrderChildBeforeParent(this, databaseTable2, databaseTable);
            }
        }
        return nArray;
    }

    protected void createMultipleTableInsertOrderFromComparison(int[][] nArray, int n) {
        int[] nArray2;
        int n2 = this.getTables().size();
        boolean bl = this.createTableOrder(0, n2 - n, nArray2 = new int[n2 - n], nArray);
        if (bl) {
            if (n == 0) {
                this.setMultipleTableInsertOrder(NonSynchronizedVector.newInstance(n2));
            }
            for (int i = 0; i < n2 - n; ++i) {
                this.getMultipleTableInsertOrder().add(this.getTables().get(nArray2[i] + n));
            }
        } else {
            throw DescriptorException.insertOrderCyclicalDependencyBetweenThreeOrMoreTables(this);
        }
    }

    protected boolean createTableOrder(int n, int n2, int[] nArray, int[][] nArray2) {
        int n3;
        int n4;
        int n5;
        if (n == n2) {
            return true;
        }
        int[] nArray3 = new int[n2 - n];
        int n6 = 0;
        for (n5 = 0; n5 < n2; ++n5) {
            n4 = 0;
            for (n3 = 0; n3 < n && n4 == 0; ++n3) {
                if (n5 != nArray[n3]) continue;
                n4 = 1;
            }
            if (n4 != 0) continue;
            nArray3[n6] = n5;
            ++n6;
        }
        n5 = 0;
        for (n4 = 0; n4 < n2 - n && n5 == 0; ++n4) {
            n3 = 1;
            for (int i = 0; i < n2 - n && n3 != 0; ++i) {
                if (n4 == i || nArray2[nArray3[n4]][nArray3[i]] <= 0) continue;
                n3 = 0;
            }
            if (n3 == 0) continue;
            nArray[n] = nArray3[n4];
            n5 = this.createTableOrder(n + 1, n2, nArray, nArray2) ? 1 : 0;
        }
        return n5 != 0;
    }

    public Object clone() {
        Object object;
        ArrayList<DatabaseField> arrayList;
        ClassDescriptor classDescriptor = null;
        try {
            classDescriptor = (ClassDescriptor)super.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        Object object2 = this.getMappings().elements();
        while (object2.hasMoreElements()) {
            arrayList = (DatabaseMapping)object2.nextElement().clone();
            ((DatabaseMapping)((Object)arrayList)).setDescriptor(classDescriptor);
            ((Vector)nonSynchronizedVector).addElement(arrayList);
        }
        classDescriptor.setMappings(nonSynchronizedVector);
        object2 = new HashMap(this.getQueryKeys().size() + 2);
        arrayList = this.getQueryKeys().values().iterator();
        while (arrayList.hasNext()) {
            object = (QueryKey)((QueryKey)arrayList.next()).clone();
            ((QueryKey)object).setDescriptor(classDescriptor);
            object2.put(((QueryKey)object).getName(), object);
        }
        classDescriptor.setQueryKeys((Map<String, QueryKey>)object2);
        arrayList = new ArrayList<DatabaseField>(this.getPrimaryKeyFields().size());
        object = this.getPrimaryKeyFields();
        for (int i = 0; i < object.size(); ++i) {
            DatabaseField databaseField = (DatabaseField)((DatabaseField)object.get(i)).clone();
            arrayList.add(databaseField);
        }
        classDescriptor.setPrimaryKeyFields(arrayList);
        classDescriptor.setFields(NonSynchronizedVector.newInstance());
        if (classDescriptor.hasInheritance()) {
            classDescriptor.setInheritancePolicy((InheritancePolicy)this.getInheritancePolicy().clone());
            classDescriptor.getInheritancePolicy().setDescriptor(classDescriptor);
        }
        if (classDescriptor.hasReturningPolicy()) {
            classDescriptor.setReturningPolicy((ReturningPolicy)this.getReturningPolicy().clone());
            classDescriptor.getReturningPolicy().setDescriptor(classDescriptor);
        }
        classDescriptor.setObjectBuilder((ObjectBuilder)this.getObjectBuilder().clone());
        classDescriptor.getObjectBuilder().setDescriptor(classDescriptor);
        classDescriptor.setEventManager((DescriptorEventManager)this.getEventManager().clone());
        classDescriptor.getEventManager().setDescriptor(classDescriptor);
        classDescriptor.setQueryManager((DescriptorQueryManager)this.getQueryManager().clone());
        classDescriptor.getQueryManager().setDescriptor(classDescriptor);
        if (this.hasFetchGroupManager()) {
            classDescriptor.setFetchGroupManager((FetchGroupManager)this.getFetchGroupManager().clone());
        }
        classDescriptor.setIsIsolated(this.isIsolated());
        classDescriptor.setInstantiationPolicy((InstantiationPolicy)this.getInstantiationPolicy().clone());
        classDescriptor.setCopyPolicy((CopyPolicy)this.getCopyPolicy().clone());
        if (this.getOptimisticLockingPolicy() != null) {
            classDescriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)this.getOptimisticLockingPolicy().clone());
        }
        classDescriptor.setObjectChangePolicy(this.getObjectChangePolicyInternal());
        return classDescriptor;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Object object;
        block107: {
            Class clazz;
            block106: {
                block105: {
                    block104: {
                        block103: {
                            block102: {
                                block101: {
                                    block100: {
                                        CopyPolicy copyPolicy;
                                        Class clazz2;
                                        Class clazz3;
                                        block99: {
                                            block98: {
                                                block97: {
                                                    clazz3 = null;
                                                    clazz2 = null;
                                                    clazz = null;
                                                    copyPolicy = null;
                                                    try {
                                                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                                            try {
                                                                clazz3 = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getJavaClassName(), true, classLoader));
                                                                break block97;
                                                            }
                                                            catch (PrivilegedActionException privilegedActionException) {
                                                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.getJavaClassName(), privilegedActionException.getException());
                                                            }
                                                        }
                                                        clazz3 = PrivilegedAccessHelper.getClassForName(this.getJavaClassName(), true, classLoader);
                                                    }
                                                    catch (ClassNotFoundException classNotFoundException) {
                                                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getJavaClassName(), classNotFoundException);
                                                    }
                                                }
                                                try {
                                                    if (this.getAmendmentClassName() == null) break block98;
                                                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                                        try {
                                                            clazz2 = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getAmendmentClassName(), true, classLoader));
                                                            break block98;
                                                        }
                                                        catch (PrivilegedActionException privilegedActionException) {
                                                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.getAmendmentClassName(), privilegedActionException.getException());
                                                        }
                                                    }
                                                    clazz2 = PrivilegedAccessHelper.getClassForName(this.getAmendmentClassName(), true, classLoader);
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.getAmendmentClassName(), classNotFoundException);
                                                }
                                            }
                                            try {
                                                object = null;
                                                if (this.copyPolicy != null || this.getCopyPolicyClassName() == null) break block99;
                                                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                                    try {
                                                        object = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getCopyPolicyClassName(), true, classLoader));
                                                    }
                                                    catch (PrivilegedActionException privilegedActionException) {
                                                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getCopyPolicyClassName(), privilegedActionException.getException());
                                                    }
                                                } else {
                                                    object = PrivilegedAccessHelper.getClassForName(this.getCopyPolicyClassName(), true, classLoader);
                                                }
                                                if (object == null) break block99;
                                                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                                    try {
                                                        copyPolicy = (CopyPolicy)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass((Class)object));
                                                        break block99;
                                                    }
                                                    catch (PrivilegedActionException privilegedActionException) {
                                                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getCopyPolicyClassName(), privilegedActionException.getException());
                                                    }
                                                }
                                                copyPolicy = (CopyPolicy)PrivilegedAccessHelper.newInstanceFromClass((Class)object);
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.getCopyPolicyClassName(), classNotFoundException);
                                            }
                                            catch (IllegalAccessException illegalAccessException) {
                                                throw ValidationException.reflectiveExceptionWhileCreatingClassInstance(this.getCopyPolicyClassName(), illegalAccessException);
                                            }
                                            catch (InstantiationException instantiationException) {
                                                throw ValidationException.reflectiveExceptionWhileCreatingClassInstance(this.getCopyPolicyClassName(), instantiationException);
                                            }
                                        }
                                        this.setJavaClass(clazz3);
                                        if (clazz2 != null) {
                                            this.setAmendmentClass(clazz2);
                                        }
                                        if (copyPolicy != null) {
                                            this.setCopyPolicy(copyPolicy);
                                        }
                                        try {
                                            if (this.cacheInterceptorClass != null || this.cacheInterceptorClassName == null) break block100;
                                            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                                try {
                                                    this.cacheInterceptorClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.cacheInterceptorClassName, true, classLoader));
                                                    break block100;
                                                }
                                                catch (PrivilegedActionException privilegedActionException) {
                                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.cacheInterceptorClassName, privilegedActionException.getException());
                                                }
                                            }
                                            this.cacheInterceptorClass = PrivilegedAccessHelper.getClassForName(this.cacheInterceptorClassName, true, classLoader);
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.cacheInterceptorClassName, classNotFoundException);
                                        }
                                    }
                                    if (this.defaultQueryRedirectorClassName != null) {
                                        try {
                                            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                                try {
                                                    clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.defaultQueryRedirectorClassName, true, classLoader));
                                                }
                                                catch (PrivilegedActionException privilegedActionException) {
                                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultQueryRedirectorClassName, privilegedActionException.getException());
                                                }
                                                try {
                                                    this.setDefaultQueryRedirector((QueryRedirector)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz)));
                                                    break block101;
                                                }
                                                catch (PrivilegedActionException privilegedActionException) {
                                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultQueryRedirectorClassName, privilegedActionException.getException());
                                                }
                                            }
                                            clazz = PrivilegedAccessHelper.getClassForName(this.defaultQueryRedirectorClassName, true, classLoader);
                                            this.setDefaultQueryRedirector((QueryRedirector)PrivilegedAccessHelper.newInstanceFromClass(clazz));
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultQueryRedirectorClassName, classNotFoundException);
                                        }
                                        catch (Exception exception) {
                                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultQueryRedirectorClassName, exception);
                                        }
                                    }
                                }
                                if (this.defaultReadObjectQueryRedirectorClassName != null) {
                                    try {
                                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                            try {
                                                clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.defaultReadObjectQueryRedirectorClassName, true, classLoader));
                                            }
                                            catch (PrivilegedActionException privilegedActionException) {
                                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadObjectQueryRedirectorClassName, privilegedActionException.getException());
                                            }
                                            try {
                                                this.setDefaultReadObjectQueryRedirector((QueryRedirector)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz)));
                                                break block102;
                                            }
                                            catch (PrivilegedActionException privilegedActionException) {
                                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadObjectQueryRedirectorClassName, privilegedActionException.getException());
                                            }
                                        }
                                        clazz = PrivilegedAccessHelper.getClassForName(this.defaultReadObjectQueryRedirectorClassName, true, classLoader);
                                        this.setDefaultReadObjectQueryRedirector((QueryRedirector)PrivilegedAccessHelper.newInstanceFromClass(clazz));
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadObjectQueryRedirectorClassName, classNotFoundException);
                                    }
                                    catch (Exception exception) {
                                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadObjectQueryRedirectorClassName, exception);
                                    }
                                }
                            }
                            if (this.defaultReadAllQueryRedirectorClassName != null) {
                                try {
                                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                        try {
                                            clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.defaultReadAllQueryRedirectorClassName, true, classLoader));
                                        }
                                        catch (PrivilegedActionException privilegedActionException) {
                                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadAllQueryRedirectorClassName, privilegedActionException.getException());
                                        }
                                        try {
                                            this.setDefaultReadAllQueryRedirector((QueryRedirector)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz)));
                                            break block103;
                                        }
                                        catch (PrivilegedActionException privilegedActionException) {
                                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadAllQueryRedirectorClassName, privilegedActionException.getException());
                                        }
                                    }
                                    clazz = PrivilegedAccessHelper.getClassForName(this.defaultReadAllQueryRedirectorClassName, true, classLoader);
                                    this.setDefaultReadAllQueryRedirector((QueryRedirector)PrivilegedAccessHelper.newInstanceFromClass(clazz));
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadAllQueryRedirectorClassName, classNotFoundException);
                                }
                                catch (Exception exception) {
                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadAllQueryRedirectorClassName, exception);
                                }
                            }
                        }
                        if (this.defaultReportQueryRedirectorClassName != null) {
                            try {
                                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                    try {
                                        clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.defaultReportQueryRedirectorClassName, true, classLoader));
                                    }
                                    catch (PrivilegedActionException privilegedActionException) {
                                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReportQueryRedirectorClassName, privilegedActionException.getException());
                                    }
                                    try {
                                        this.setDefaultReportQueryRedirector((QueryRedirector)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz)));
                                        break block104;
                                    }
                                    catch (PrivilegedActionException privilegedActionException) {
                                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReportQueryRedirectorClassName, privilegedActionException.getException());
                                    }
                                }
                                clazz = PrivilegedAccessHelper.getClassForName(this.defaultReportQueryRedirectorClassName, true, classLoader);
                                this.setDefaultReportQueryRedirector((QueryRedirector)PrivilegedAccessHelper.newInstanceFromClass(clazz));
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReportQueryRedirectorClassName, classNotFoundException);
                            }
                            catch (Exception exception) {
                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReportQueryRedirectorClassName, exception);
                            }
                        }
                    }
                    if (this.defaultInsertObjectQueryRedirectorClassName != null) {
                        try {
                            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                try {
                                    clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.defaultInsertObjectQueryRedirectorClassName, true, classLoader));
                                }
                                catch (PrivilegedActionException privilegedActionException) {
                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultInsertObjectQueryRedirectorClassName, privilegedActionException.getException());
                                }
                                try {
                                    this.setDefaultInsertObjectQueryRedirector((QueryRedirector)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz)));
                                    break block105;
                                }
                                catch (PrivilegedActionException privilegedActionException) {
                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultInsertObjectQueryRedirectorClassName, privilegedActionException.getException());
                                }
                            }
                            clazz = PrivilegedAccessHelper.getClassForName(this.defaultInsertObjectQueryRedirectorClassName, true, classLoader);
                            this.setDefaultInsertObjectQueryRedirector((QueryRedirector)PrivilegedAccessHelper.newInstanceFromClass(clazz));
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultInsertObjectQueryRedirectorClassName, classNotFoundException);
                        }
                        catch (Exception exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultInsertObjectQueryRedirectorClassName, exception);
                        }
                    }
                }
                if (this.defaultUpdateObjectQueryRedirectorClassName != null) {
                    try {
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.defaultUpdateObjectQueryRedirectorClassName, true, classLoader));
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultUpdateObjectQueryRedirectorClassName, privilegedActionException.getException());
                            }
                            try {
                                this.setDefaultUpdateObjectQueryRedirector((QueryRedirector)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz)));
                                break block106;
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultUpdateObjectQueryRedirectorClassName, privilegedActionException.getException());
                            }
                        }
                        clazz = PrivilegedAccessHelper.getClassForName(this.defaultUpdateObjectQueryRedirectorClassName, true, classLoader);
                        this.setDefaultUpdateObjectQueryRedirector((QueryRedirector)PrivilegedAccessHelper.newInstanceFromClass(clazz));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultUpdateObjectQueryRedirectorClassName, classNotFoundException);
                    }
                    catch (Exception exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultUpdateObjectQueryRedirectorClassName, exception);
                    }
                }
            }
            if (this.defaultDeleteObjectQueryRedirectorClassName != null) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.defaultDeleteObjectQueryRedirectorClassName, true, classLoader));
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultDeleteObjectQueryRedirectorClassName, privilegedActionException.getException());
                        }
                        try {
                            this.setDefaultDeleteObjectQueryRedirector((QueryRedirector)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz)));
                            break block107;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultDeleteObjectQueryRedirectorClassName, privilegedActionException.getException());
                        }
                    }
                    clazz = PrivilegedAccessHelper.getClassForName(this.defaultDeleteObjectQueryRedirectorClassName, true, classLoader);
                    this.setDefaultDeleteObjectQueryRedirector((QueryRedirector)PrivilegedAccessHelper.newInstanceFromClass(clazz));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultDeleteObjectQueryRedirectorClassName, classNotFoundException);
                }
                catch (Exception exception) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultDeleteObjectQueryRedirectorClassName, exception);
                }
            }
        }
        object = this.getMappings().iterator();
        while (object.hasNext()) {
            ((DatabaseMapping)object.next()).convertClassNamesToClasses(classLoader);
        }
        if (this.inheritancePolicy != null) {
            this.inheritancePolicy.convertClassNamesToClasses(classLoader);
        }
        if (this.interfacePolicy != null) {
            this.interfacePolicy.convertClassNamesToClasses(classLoader);
        }
        if (this.instantiationPolicy != null) {
            this.instantiationPolicy.convertClassNamesToClasses(classLoader);
        }
        if (this.hasCMPPolicy()) {
            this.getCMPPolicy().convertClassNamesToClasses(classLoader);
        }
        if (this.queryManager != null) {
            this.queryManager.convertClassNamesToClasses(classLoader);
        }
    }

    public void createCopyPolicy(String string) {
        if (string.equals("clone")) {
            this.useCloneCopyPolicy();
            return;
        }
        if (string.equals("constructor")) {
            this.useInstantiationCopyPolicy();
            return;
        }
    }

    public void createInstantiationPolicy(String string) {
        if (string.equals("static method")) {
            return;
        }
        if (string.equals("constructor")) {
            this.useDefaultConstructorInstantiationPolicy();
            return;
        }
        if (string.equals("factory")) {
            return;
        }
    }

    public void descriptorIsAggregate() {
        this.setDescriptorType(2);
    }

    public void descriptorIsAggregateCollection() {
        this.setDescriptorType(3);
    }

    public void descriptorIsForInterface() {
        this.setDescriptorType(1);
    }

    public void descriptorIsNormal() {
        this.setDescriptorType(0);
    }

    public void disableCacheHits() {
        this.setShouldDisableCacheHits(true);
    }

    public void disableCacheHitsOnRemote() {
        this.setShouldDisableCacheHitsOnRemote(true);
    }

    public void dontAlwaysConformResultsInUnitOfWork() {
        this.setShouldAlwaysConformResultsInUnitOfWork(false);
    }

    public void dontAlwaysRefreshCache() {
        this.setShouldAlwaysRefreshCache(false);
    }

    public void dontAlwaysRefreshCacheOnRemote() {
        this.setShouldAlwaysRefreshCacheOnRemote(false);
    }

    public void dontDisableCacheHits() {
        this.setShouldDisableCacheHits(false);
    }

    public void dontDisableCacheHitsOnRemote() {
        this.setShouldDisableCacheHitsOnRemote(false);
    }

    public void dontOnlyRefreshCacheIfNewerVersion() {
        this.setShouldOnlyRefreshCacheIfNewerVersion(false);
    }

    protected DatabaseTable extractDefaultTable() {
        if (this.getTables().isEmpty()) {
            if (this.isChildDescriptor()) {
                return this.getInheritancePolicy().getParentDescriptor().extractDefaultTable();
            }
            return null;
        }
        return this.getTables().get(0);
    }

    public List<DatabaseField> getAdditionalAggregateCollectionKeyFields() {
        if (this.additionalAggregateCollectionKeyFields == null) {
            this.additionalAggregateCollectionKeyFields = new ArrayList<DatabaseField>();
        }
        return this.additionalAggregateCollectionKeyFields;
    }

    public Map<DatabaseTable, Map<DatabaseField, DatabaseField>> getAdditionalTablePrimaryKeyFields() {
        if (this.additionalTablePrimaryKeyFields == null) {
            this.additionalTablePrimaryKeyFields = new HashMap<DatabaseTable, Map<DatabaseField, DatabaseField>>(5);
        }
        return this.additionalTablePrimaryKeyFields;
    }

    public String getAlias() {
        if (this.alias == null && this.getJavaClassName() != null) {
            this.alias = Helper.getShortClassName(this.getJavaClassName());
        }
        return this.alias;
    }

    public Vector<DatabaseField> getAllFields() {
        return this.allFields;
    }

    public Class getAmendmentClass() {
        return this.amendmentClass;
    }

    public String getAmendmentClassName() {
        if (this.amendmentClassName == null && this.amendmentClass != null) {
            this.amendmentClassName = this.amendmentClass.getName();
        }
        return this.amendmentClassName;
    }

    public String getAmendmentMethodName() {
        return this.amendmentMethodName;
    }

    public ObjectChangePolicy getObjectChangePolicy() {
        if (this.changePolicy == null) {
            this.changePolicy = new DeferredChangeDetectionPolicy();
        }
        return this.changePolicy;
    }

    public ObjectChangePolicy getObjectChangePolicyInternal() {
        return this.changePolicy;
    }

    public HistoryPolicy getHistoryPolicy() {
        return this.historyPolicy;
    }

    public Class getCacheInterceptorClass() {
        return this.cacheInterceptorClass;
    }

    public String getCacheInterceptorClassName() {
        return this.cacheInterceptorClassName;
    }

    public CacheInvalidationPolicy getCacheInvalidationPolicy() {
        if (this.cacheInvalidationPolicy == null) {
            this.cacheInvalidationPolicy = new NoExpiryCacheInvalidationPolicy();
        }
        return this.cacheInvalidationPolicy;
    }

    public int getCacheSynchronizationType() {
        return this.cacheSynchronizationType;
    }

    public Vector getCascadeLockingPolicies() {
        return this.cascadeLockingPolicies;
    }

    public Vector getConstraintDependencies() {
        return this.constraintDependencies;
    }

    public CopyPolicy getCopyPolicy() {
        if (this.copyPolicy == null) {
            this.setCopyPolicy(new InstantiationCopyPolicy());
        }
        return this.copyPolicy;
    }

    public String getCopyPolicyClassName() {
        return this.copyPolicyClassName;
    }

    public DatabaseTable getDefaultTable() {
        return this.defaultTable;
    }

    public int getDescriptorType() {
        return this.descriptorType;
    }

    public String getDescriptorTypeValue() {
        if (this.isAggregateCollectionDescriptor()) {
            return "Aggregate collection";
        }
        if (this.isAggregateDescriptor()) {
            return "Aggregate";
        }
        if (this.isDescriptorForInterface()) {
            return "Interface";
        }
        return "Normal";
    }

    public DescriptorEventManager getDescriptorEventManager() {
        return this.getEventManager();
    }

    public DescriptorEventManager getEventManager() {
        if (this.eventManager == null) {
            this.setEventManager(new DescriptorEventManager());
        }
        return this.eventManager;
    }

    public Vector<DatabaseField> getFields() {
        return this.fields;
    }

    public Class getIdentityMapClass() {
        return this.identityMapClass;
    }

    public int getIdentityMapSize() {
        return this.identityMapSize;
    }

    public InheritancePolicy getDescriptorInheritancePolicy() {
        return this.getInheritancePolicy();
    }

    public InheritancePolicy getInheritancePolicy() {
        if (this.inheritancePolicy == null) {
            this.setInheritancePolicy(new InheritancePolicy(this));
        }
        return this.inheritancePolicy;
    }

    public InheritancePolicy getInheritancePolicyOrNull() {
        return this.inheritancePolicy;
    }

    public InstantiationPolicy getInstantiationPolicy() {
        if (this.instantiationPolicy == null) {
            this.setInstantiationPolicy(new InstantiationPolicy());
        }
        return this.instantiationPolicy;
    }

    public InterfacePolicy getInterfacePolicy() {
        if (this.interfacePolicy == null) {
            this.setInterfacePolicy(new InterfacePolicy(this));
        }
        return this.interfacePolicy;
    }

    public InterfacePolicy getInterfacePolicyOrNull() {
        return this.interfacePolicy;
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public String getJavaClassName() {
        if (this.javaClassName == null && this.javaClass != null) {
            this.javaClassName = this.javaClass.getName();
        }
        return this.javaClassName;
    }

    public List<DatabaseMapping> getLockableMappings() {
        if (this.lockableMappings == null) {
            this.lockableMappings = new ArrayList<DatabaseMapping>();
        }
        return this.lockableMappings;
    }

    public DatabaseMapping getMappingForAttributeName(String string) {
        Enumeration<DatabaseMapping> enumeration = this.mappings.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = enumeration.nextElement();
            if (databaseMapping.getAttributeName() == null || !databaseMapping.getAttributeName().equals(string)) continue;
            return databaseMapping;
        }
        return null;
    }

    public DatabaseMapping removeMappingForAttributeName(String string) {
        DatabaseMapping databaseMapping = this.getMappingForAttributeName(string);
        this.getMappings().remove(databaseMapping);
        return databaseMapping;
    }

    public Vector<DatabaseMapping> getMappings() {
        return this.mappings;
    }

    public Vector getMultipleTableForeignKeyAssociations() {
        Vector<Association> vector = new Vector<Association>(this.getAdditionalTablePrimaryKeyFields().size() * 2);
        for (Map<DatabaseField, DatabaseField> map : this.getAdditionalTablePrimaryKeyFields().values()) {
            for (DatabaseField databaseField : map.keySet()) {
                if (!this.getMultipleTableForeignKeys().containsKey(databaseField.getTable())) continue;
                Association association = new Association(databaseField.getQualifiedName(), map.get(databaseField).getQualifiedName());
                vector.addElement(association);
            }
        }
        return vector;
    }

    public Map<DatabaseTable, Set<DatabaseTable>> getMultipleTableForeignKeys() {
        return this.multipleTableForeignKeys;
    }

    public Vector<DatabaseTable> getMultipleTableInsertOrder() throws DescriptorException {
        return this.multipleTableInsertOrder;
    }

    public Vector getMultipleTablePrimaryKeyAssociations() {
        Vector<Association> vector = new Vector<Association>(this.getAdditionalTablePrimaryKeyFields().size() * 2);
        for (Map<DatabaseField, DatabaseField> map : this.getAdditionalTablePrimaryKeyFields().values()) {
            for (DatabaseField databaseField : map.keySet()) {
                if (this.getMultipleTableForeignKeys().containsKey(databaseField.getTable())) continue;
                Association association = new Association(databaseField.getQualifiedName(), map.get(databaseField).getQualifiedName());
                vector.addElement(association);
            }
        }
        return vector;
    }

    public ObjectBuilder getObjectBuilder() {
        return this.objectBuilder;
    }

    public OptimisticLockingPolicy getOptimisticLockingPolicy() {
        return this.optimisticLockingPolicy;
    }

    public List<DatabaseMapping> getPreDeleteMappings() {
        if (this.preDeleteMappings == null) {
            this.preDeleteMappings = new ArrayList<DatabaseMapping>();
        }
        return this.preDeleteMappings;
    }

    public Vector<String> getPrimaryKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getPrimaryKeyFields().size());
        List<DatabaseField> list = this.getPrimaryKeyFields();
        for (int i = 0; i < list.size(); ++i) {
            vector.addElement(list.get(i).getQualifiedName());
        }
        return vector;
    }

    public List<DatabaseField> getPrimaryKeyFields() {
        return this.primaryKeyFields;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap(5);
        }
        return this.properties;
    }

    public Object getProperty(String string) {
        return this.getProperties().get(string);
    }

    public QueryKey getQueryKeyNamed(String string) {
        return this.getQueryKeys().get(string);
    }

    public Map<String, QueryKey> getQueryKeys() {
        return this.queryKeys;
    }

    public DescriptorQueryManager getDescriptorQueryManager() {
        return this.getQueryManager();
    }

    public DescriptorQueryManager getQueryManager() {
        if (this.queryManager == null) {
            this.setQueryManager(new DescriptorQueryManager());
        }
        return this.queryManager;
    }

    public Class getRemoteIdentityMapClass() {
        if (this.remoteIdentityMapClass == null) {
            this.remoteIdentityMapClass = this.getIdentityMapClass();
        }
        return this.remoteIdentityMapClass;
    }

    public ClassDescriptor getRootDescriptor() {
        if (this.hasInheritance()) {
            return this.getInheritancePolicy().getRootParentDescriptor();
        }
        return this;
    }

    public int getRemoteIdentityMapSize() {
        if (this.remoteIdentityMapSize == -1) {
            this.remoteIdentityMapSize = this.getIdentityMapSize();
        }
        return this.remoteIdentityMapSize;
    }

    public ReturningPolicy getReturningPolicy() {
        return this.returningPolicy;
    }

    public DatabaseField getSequenceNumberField() {
        return this.sequenceNumberField;
    }

    public String getSequenceNumberFieldName() {
        if (this.getSequenceNumberField() == null) {
            return null;
        }
        return this.getSequenceNumberField().getQualifiedName();
    }

    public String getSequenceNumberName() {
        return this.sequenceNumberName;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public DatabaseTable getTable(String string) throws DescriptorException {
        if (this.getTables().isEmpty()) {
            return null;
        }
        Enumeration<DatabaseTable> enumeration = this.getTables().elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            DatabaseTable databaseTable = enumeration.nextElement();
            if (string.indexOf(32) != -1 && (string2 = databaseTable.getName()).substring(1, string2.length() - 1).equals(string)) {
                return databaseTable;
            }
            if (!databaseTable.getName().equals(string)) continue;
            return databaseTable;
        }
        if (this.isAggregateDescriptor()) {
            return this.getDefaultTable();
        }
        throw DescriptorException.tableNotPresent(string, this);
    }

    public String getTableName() {
        if (this.getTables().isEmpty()) {
            return null;
        }
        return this.getTables().get(0).getName();
    }

    public Vector getTableNames() {
        Vector<String> vector = new Vector<String>(this.getTables().size());
        Enumeration<DatabaseTable> enumeration = this.getTables().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement().getQualifiedName());
        }
        return vector;
    }

    public TablePerClassPolicy getTablePerClassPolicy() {
        return (TablePerClassPolicy)this.interfacePolicy;
    }

    public Vector<DatabaseTable> getTables() {
        return this.tables;
    }

    public DatabaseField getTypedField(DatabaseField databaseField) {
        DatabaseField databaseField2;
        boolean bl = this.hasMultipleTables() && !databaseField.hasTableName();
        DatabaseField databaseField3 = null;
        for (int i = 0; i < this.getFields().size(); ++i) {
            DatabaseField databaseField4 = this.getFields().get(i);
            if (!databaseField.equals(databaseField4) || databaseField4.getType() == null) continue;
            databaseField3 = databaseField4;
            if (!bl || databaseField4.getTable().equals(this.getDefaultTable())) break;
        }
        if (databaseField3 == null && this.hasReturningPolicy() && (databaseField2 = this.getReturningPolicy().getField(databaseField)) != null && databaseField2.getType() != null) {
            databaseField3 = databaseField2;
        }
        if (databaseField3 != null) {
            databaseField3 = (DatabaseField)databaseField3.clone();
            if (!databaseField.hasTableName()) {
                databaseField3.setTableName("");
            }
        }
        return databaseField3;
    }

    public WrapperPolicy getWrapperPolicy() {
        return this.wrapperPolicy;
    }

    public boolean hasDependencyOnParts() {
        Enumeration<DatabaseMapping> enumeration = this.getMappings().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = enumeration.nextElement();
            if (!databaseMapping.hasDependency()) continue;
            return true;
        }
        return false;
    }

    public boolean hasInheritance() {
        return this.inheritancePolicy != null;
    }

    public boolean hasInterfacePolicy() {
        return this.interfacePolicy != null;
    }

    public boolean hasMultipleTables() {
        return this.getTables().size() > 1;
    }

    public boolean hasPreDeleteMappings() {
        return this.preDeleteMappings != null;
    }

    public boolean hasPrivatelyOwnedParts() {
        Enumeration<DatabaseMapping> enumeration = this.getMappings().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = enumeration.nextElement();
            if (!databaseMapping.isPrivateOwned()) continue;
            return true;
        }
        return false;
    }

    public boolean hasQueryKeyOrMapping(String string) {
        return this.getQueryKeys().containsKey(string) || this.getObjectBuilder().getMappingForAttributeName(string) != null;
    }

    public boolean hasReturningPolicy() {
        return this.returningPolicy != null;
    }

    public boolean hasWrapperPolicy() {
        return this.wrapperPolicy != null;
    }

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        ClassDescriptor classDescriptor;
        int n;
        Object object2;
        if (this.shouldBeReadOnly() && !abstractSession.getDefaultReadOnlyClasses().contains(this.getJavaClass())) {
            abstractSession.getDefaultReadOnlyClasses().add(this.getJavaClass());
        }
        if (this.getHistoryPolicy() != null) {
            abstractSession.getProject().setHasGenericHistorySupport(true);
        }
        if (this.isIsolated()) {
            abstractSession.getProject().setHasIsolatedClasses(true);
        }
        if (this.isInitialized(2) || this.isInvalid()) {
            return;
        }
        this.setInitializationStage(2);
        if (this.isChildDescriptor()) {
            this.getInheritancePolicy().getParentDescriptor().initialize(abstractSession);
            if (this.getInheritancePolicy().getParentDescriptor().isIsolated()) {
                this.setIsIsolated(true);
            }
            this.getInheritancePolicy().initializeOptimisticLocking();
        }
        if (this.shouldOrderMappings()) {
            object2 = this.getMappings();
            Object[] object3 = new Object[((Vector)object2).size()];
            for (n = 0; n < ((Vector)object2).size(); ++n) {
                object3[n] = ((Vector)object2).elementAt(n);
            }
            Arrays.sort(object3, new MappingCompare());
            object2 = NonSynchronizedVector.newInstance(object3.length);
            for (n = 0; n < object3.length; ++n) {
                ((Vector)object2).addElement(object3[n]);
            }
            this.setMappings((Vector<DatabaseMapping>)object2);
        }
        object2 = this.getMappings().elements();
        while (object2.hasMoreElements()) {
            DatabaseMapping databaseMapping = (DatabaseMapping)object2.nextElement();
            this.validateMappingType(databaseMapping);
            databaseMapping.initialize(abstractSession);
            if (databaseMapping.isLockableMapping()) {
                this.getLockableMappings().add(databaseMapping);
            }
            if (databaseMapping.isForeignReferenceMapping() && ((ForeignReferenceMapping)databaseMapping).getIndirectionPolicy() instanceof ProxyIndirectionPolicy) {
                abstractSession.getProject().setHasProxyIndirection(true);
            }
            if (this.usesOptimisticLocking() && this.getOptimisticLockingPolicy().isCascaded() || this.hasCascadeLockingPolicies()) {
                this.prepareCascadeLockingPolicy(databaseMapping);
            }
            if (databaseMapping.isIDMapping()) {
                this.setIsIDSpecified(true);
            }
            Helper.addAllUniqueToVector(this.getFields(), databaseMapping.getFields());
        }
        if (this.hasMappingsPostCalculateChangesOnDeleted()) {
            abstractSession.getProject().setHasMappingsPostCalculateChangesOnDeleted(true);
        }
        if (!this.isAggregateDescriptor() && !this.isChildDescriptor() && this.usesOptimisticLocking()) {
            this.getOptimisticLockingPolicy().initializeProperties();
        }
        for (QueryKey queryKey : this.getQueryKeys().values()) {
            queryKey.initialize(this);
        }
        if (this.hasInheritance()) {
            this.getInheritancePolicy().initialize(abstractSession);
            if (this.getInheritancePolicy().isChildDescriptor()) {
                for (DatabaseMapping databaseMapping : this.getInheritancePolicy().getParentDescriptor().getMappings()) {
                    if (databaseMapping.isAggregateObjectMapping() || databaseMapping.isForeignReferenceMapping() && !databaseMapping.isDirectCollectionMapping() && !((ForeignReferenceMapping)databaseMapping).usesIndirection()) {
                        this.getLockableMappings().add(databaseMapping);
                    }
                    if (!databaseMapping.isIDMapping()) continue;
                    this.setIsIDSpecified(true);
                }
            }
        }
        if (this.hasInheritance() && this.shouldOrderMappings()) {
            object2 = this.getMappings();
            Object[] objectArray = new Object[((Vector)object2).size()];
            for (n = 0; n < ((Vector)object2).size(); ++n) {
                objectArray[n] = ((Vector)object2).elementAt(n);
            }
            Arrays.sort(objectArray, new MappingCompare());
            object2 = NonSynchronizedVector.newInstance(objectArray.length);
            for (n = 0; n < objectArray.length; ++n) {
                ((Vector)object2).addElement(objectArray[n]);
            }
            this.setMappings((Vector<DatabaseMapping>)object2);
        }
        this.setAllFields((Vector)this.getFields().clone());
        this.getObjectBuilder().initialize(abstractSession);
        if (this.shouldOrderMappings()) {
            for (int i = this.getObjectBuilder().getPrimaryKeyMappings().size() - 1; i >= 0; --i) {
                DatabaseMapping databaseMapping = this.getObjectBuilder().getPrimaryKeyMappings().get(i);
                if (databaseMapping == null || !databaseMapping.isDirectToFieldMapping()) continue;
                this.getMappings().remove(databaseMapping);
                this.getMappings().add(0, databaseMapping);
                DatabaseField databaseField = ((AbstractDirectMapping)databaseMapping).getField();
                this.getFields().remove(databaseField);
                this.getFields().add(0, databaseField);
                this.getAllFields().remove(databaseField);
                this.getAllFields().add(0, databaseField);
            }
        }
        if (this.usesOptimisticLocking() && !this.isChildDescriptor()) {
            this.getOptimisticLockingPolicy().initialize(abstractSession);
        }
        if (this.hasInterfacePolicy() || this.isDescriptorForInterface()) {
            this.interfaceInitialization(abstractSession);
        }
        if (this.hasWrapperPolicy()) {
            this.getWrapperPolicy().initialize(abstractSession);
        }
        if (this.hasReturningPolicy()) {
            this.getReturningPolicy().initialize(abstractSession);
        }
        this.getQueryManager().initialize(abstractSession);
        this.getEventManager().initialize(abstractSession);
        this.getCopyPolicy().initialize(abstractSession);
        this.getInstantiationPolicy().initialize(abstractSession);
        if (this.getHistoryPolicy() != null) {
            this.getHistoryPolicy().initialize(abstractSession);
        } else if (this.hasInheritance() && (classDescriptor = this.getInheritancePolicy().getParentDescriptor()) != null && classDescriptor.getHistoryPolicy() != null) {
            this.setHistoryPolicy((HistoryPolicy)classDescriptor.getHistoryPolicy().clone());
        }
        if (this.getCMPPolicy() != null) {
            this.getCMPPolicy().initialize(this, abstractSession);
        }
        if (this.hasFetchGroupManager()) {
            this.getFetchGroupManager().initialize(abstractSession);
        }
        if (this.getObjectChangePolicyInternal() == null && ChangeTracker.class.isAssignableFrom(this.getJavaClass()) && Arrays.asList(this.getJavaClass().getInterfaces()).contains(PersistenceWeavedChangeTracking.class) && this.supportsChangeTracking(abstractSession.getProject())) {
            this.setObjectChangePolicy(new AttributeChangeTrackingPolicy());
        }
        this.getObjectChangePolicy().initialize(abstractSession, this);
        if (this.getUnitOfWorkCacheIsolationLevel() == -1) {
            if (this.isIsolated()) {
                this.setUnitOfWorkCacheIsolationLevel(3);
            } else {
                this.setUnitOfWorkCacheIsolationLevel(1);
            }
        }
        if (this.getIdValidation() == null) {
            if (this.getPrimaryKeyFields().size() > 1) {
                this.setIdValidation(IdValidation.NULL);
            } else {
                this.setIdValidation(IdValidation.ZERO);
            }
        }
        if (this.defaultReadAllQueryRedirector == null) {
            this.defaultReadAllQueryRedirector = this.defaultQueryRedirector;
        }
        if (this.defaultReadObjectQueryRedirector == null) {
            this.defaultReadObjectQueryRedirector = this.defaultQueryRedirector;
        }
        if (this.defaultReportQueryRedirector == null) {
            this.defaultReportQueryRedirector = this.defaultQueryRedirector;
        }
        if (this.defaultInsertObjectQueryRedirector == null) {
            this.defaultInsertObjectQueryRedirector = this.defaultQueryRedirector;
        }
        if (this.defaultUpdateObjectQueryRedirector == null) {
            this.defaultUpdateObjectQueryRedirector = this.defaultQueryRedirector;
        }
    }

    public void initializeAggregateInheritancePolicy(AbstractSession abstractSession) {
        ClassDescriptor classDescriptor = abstractSession.getDescriptor(this.getInheritancePolicy().getParentClass());
        classDescriptor.getInheritancePolicy().addChildDescriptor(this);
    }

    public void initializeMultipleTablePrimaryKeyFields() {
        Map<DatabaseField, DatabaseField> map;
        boolean bl;
        int n = this.getTables().size() - 1;
        boolean bl2 = bl = this.hasInheritance() && this.getInheritancePolicy().isChildDescriptor();
        if (bl) {
            n = this.getTables().size() - this.getInheritancePolicy().getParentDescriptor().getTables().size();
        }
        if (n < 1) {
            return;
        }
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Expression expression = this.getQueryManager().getMultipleTableJoinExpression();
        for (int i = this.getTables().size() - n; i < this.getTables().size(); ++i) {
            Cloneable cloneable;
            Cloneable cloneable2;
            DatabaseTable databaseTable = this.getTables().get(i);
            map = this.getAdditionalTablePrimaryKeyFields().get(databaseTable);
            if (map != null) {
                if (this.getQueryManager().hasCustomMultipleTableJoinExpression()) continue;
                for (DatabaseField databaseField : map.keySet()) {
                    DatabaseField databaseField2 = map.get(databaseField);
                    cloneable2 = databaseField2.getTable();
                    if (!this.getFields().contains(databaseField)) {
                        this.getFields().addElement(databaseField);
                    }
                    if (!this.getFields().contains(databaseField2)) {
                        this.getFields().addElement(databaseField2);
                    }
                    cloneable = expressionBuilder.getField(databaseField2).equal(expressionBuilder.getField(databaseField));
                    expression = ((Expression)cloneable).and(expression);
                    this.getQueryManager().getTablesJoinExpressions().put(cloneable2, cloneable);
                    if (!bl) continue;
                    this.getInheritancePolicy().addChildTableJoinExpressionToAllParents((DatabaseTable)cloneable2, (Expression)cloneable);
                }
                continue;
            }
            HashMap hashMap = new HashMap(this.getPrimaryKeyFields().size() + 1);
            this.getAdditionalTablePrimaryKeyFields().put(databaseTable, hashMap);
            List<DatabaseField> list = this.getPrimaryKeyFields();
            for (int j = 0; j < list.size(); ++j) {
                cloneable2 = list.get(j);
                cloneable = (DatabaseField)((DatabaseField)cloneable2).clone();
                ((DatabaseField)cloneable).setTable(databaseTable);
                hashMap.put(cloneable2, cloneable);
                this.getFields().addElement((DatabaseField)cloneable);
                if (this.getQueryManager().hasCustomMultipleTableJoinExpression()) continue;
                Expression expression2 = expressionBuilder.getField((DatabaseField)cloneable).equal(expressionBuilder.getField((DatabaseField)cloneable2));
                expression = expression2.and(expression);
                this.getQueryManager().getTablesJoinExpressions().put(databaseTable, expression2);
                if (!bl) continue;
                this.getInheritancePolicy().addChildTableJoinExpressionToAllParents(databaseTable, expression2);
            }
        }
        if (expression != null) {
            this.getQueryManager().setInternalMultipleTableJoinExpression(expression);
        }
        if (this.getQueryManager().hasCustomMultipleTableJoinExpression()) {
            Map map2 = SQLSelectStatement.mapTableToExpression(expression, this.getTables());
            this.getQueryManager().getTablesJoinExpressions().putAll(map2);
            if (bl) {
                for (int i = this.getTables().size() - n; i < this.getTables().size(); ++i) {
                    map = this.getTables().elementAt(i);
                    this.getInheritancePolicy().addChildTableJoinExpressionToAllParents((DatabaseTable)((Object)map), (Expression)map2.get(map));
                }
            }
        }
    }

    protected void initializeProperties(AbstractSession abstractSession) throws DescriptorException {
        if (!this.isAggregateDescriptor()) {
            if (!this.isChildDescriptor()) {
                for (int i = 0; i < this.getPrimaryKeyFields().size(); ++i) {
                    DatabaseField databaseField = this.getPrimaryKeyFields().get(i);
                    databaseField = this.buildField(databaseField);
                    this.getPrimaryKeyFields().set(i, databaseField);
                }
                List list = (List)((ArrayList)this.getPrimaryKeyFields()).clone();
                for (int i = 0; i < list.size(); ++i) {
                    DatabaseField databaseField = (DatabaseField)list.get(i);
                    if (databaseField.getTable().equals(this.getDefaultTable())) continue;
                    this.getPrimaryKeyFields().remove(databaseField);
                }
            }
            if (this.getSequenceNumberField() != null) {
                this.setSequenceNumberField(this.buildField(this.getSequenceNumberField()));
            }
        }
        this.setSessionName(abstractSession.getName());
    }

    public void interfaceInitialization(AbstractSession abstractSession) throws DescriptorException {
        if (this.isInterfaceInitialized(2)) {
            return;
        }
        this.setInterfaceInitializationStage(2);
        if (this.isInterfaceChildDescriptor()) {
            Enumeration enumeration = this.getInterfacePolicy().getParentInterfaces().elements();
            while (enumeration.hasMoreElements()) {
                Class clazz = (Class)enumeration.nextElement();
                ClassDescriptor classDescriptor = abstractSession.getDescriptor(clazz);
                classDescriptor.interfaceInitialization(abstractSession);
                if (this.isDescriptorForInterface()) {
                    this.setQueryKeys(Helper.concatenateMaps(this.getQueryKeys(), classDescriptor.getQueryKeys()));
                } else {
                    for (String string : classDescriptor.getQueryKeys().keySet()) {
                        if (this.hasQueryKeyOrMapping(string)) continue;
                        abstractSession.getIntegrityChecker().handleError(DescriptorException.childDoesNotDefineAbstractQueryKeyOfParent(this, classDescriptor, string));
                    }
                }
                if (classDescriptor != this) continue;
                return;
            }
        }
        this.getInterfacePolicy().initialize(abstractSession);
    }

    protected boolean isAbstract() {
        return Modifier.isAbstract(this.getJavaClass().getModifiers());
    }

    public boolean isAggregateCollectionDescriptor() {
        return this.descriptorType == 3;
    }

    public boolean isAggregateDescriptor() {
        return this.descriptorType == 2;
    }

    public boolean isChildDescriptor() {
        return this.hasInheritance() && this.getInheritancePolicy().isChildDescriptor();
    }

    public boolean isDescriptorForInterface() {
        return this.getDescriptorType() == 1;
    }

    public boolean isDescriptorTypeAggregate() {
        return this.descriptorType == 3 || this.descriptorType == 2;
    }

    public boolean isFullyInitialized() {
        return this.initializationStage == 3;
    }

    public boolean isIDSpecified() {
        return this.isIDSpecified;
    }

    protected boolean isInitialized(int n) {
        return this.initializationStage >= n;
    }

    public boolean isInterfaceChildDescriptor() {
        return this.hasInterfacePolicy() && this.getInterfacePolicy().isInterfaceChildDescriptor();
    }

    protected boolean isInterfaceInitialized(int n) {
        return this.interfaceInitializationStage >= n;
    }

    public boolean isInvalid() {
        return this.initializationStage == -1;
    }

    public boolean isIsolated() {
        if (this.isIsolated == null) {
            return false;
        }
        return this.isIsolated;
    }

    public boolean isMultipleTableDescriptor() {
        return this.getTables().size() > 1;
    }

    public boolean isObjectRelationalDataTypeDescriptor() {
        return false;
    }

    public boolean isPrimaryKeySetAfterInsert(AbstractSession abstractSession) {
        return this.usesSequenceNumbers() && this.getSequence().shouldAcquireValueAfterInsert() || this.hasReturningPolicy() && this.getReturningPolicy().isUsedToSetPrimaryKey();
    }

    public boolean shouldUseFullChangeSetsForNewObjects() {
        return this.cacheSynchronizationType == 3 || shouldUseFullChangeSetsForNewObjects;
    }

    public void onlyRefreshCacheIfNewerVersion() {
        this.setShouldOnlyRefreshCacheIfNewerVersion(true);
    }

    public void postInitialize(AbstractSession abstractSession) throws DescriptorException {
        int n;
        Cloneable cloneable;
        Enumeration<DatabaseMapping> enumeration;
        if (this.isInitialized(3) || this.isInvalid()) {
            return;
        }
        this.setInitializationStage(3);
        if (this.hasInheritance()) {
            enumeration = this.getInheritancePolicy().getChildDescriptors().elements();
            while (enumeration.hasMoreElements()) {
                ((ClassDescriptor)((Object)enumeration.nextElement())).postInitialize(abstractSession);
            }
        }
        enumeration = this.getMappings().elements();
        while (enumeration.hasMoreElements()) {
            cloneable = enumeration.nextElement();
            ((DatabaseMapping)cloneable).postInitialize(abstractSession);
            if (this.shouldAcquireCascadedLocks()) continue;
            if (cloneable instanceof ForeignReferenceMapping && !((ForeignReferenceMapping)cloneable).usesIndirection()) {
                this.setShouldAcquireCascadedLocks(true);
            }
            if (!(cloneable instanceof AggregateObjectMapping) || !((DatabaseMapping)cloneable).getReferenceDescriptor().shouldAcquireCascadedLocks()) continue;
            this.setShouldAcquireCascadedLocks(true);
        }
        if (this.hasInheritance()) {
            this.getInheritancePolicy().postInitialize(abstractSession);
        }
        for (n = this.getPrimaryKeyFields().size() - 1; n >= 0; --n) {
            cloneable = this.getPrimaryKeyFields().get(n);
            int n2 = this.getFields().indexOf(cloneable);
            if (n2 == -1) continue;
            cloneable = this.getFields().get(n2);
            this.getPrimaryKeyFields().set(n, (DatabaseField)cloneable);
        }
        for (n = 0; n < this.getFields().size(); ++n) {
            DatabaseMapping databaseMapping;
            cloneable = this.getFields().elementAt(n);
            if (((DatabaseField)cloneable).getType() == null && (databaseMapping = this.getObjectBuilder().getMappingForField((DatabaseField)cloneable)) != null) {
                ((DatabaseField)cloneable).setType(databaseMapping.getFieldClassification((DatabaseField)cloneable));
            }
            ((DatabaseField)cloneable).setIndex(n);
        }
        this.getObjectBuilder().postInitialize(abstractSession);
        this.validateAfterInitialization(abstractSession);
        this.checkDatabase(abstractSession);
    }

    public void preInitialize(AbstractSession abstractSession) throws DescriptorException {
        if (this.isInitialized(1)) {
            return;
        }
        this.setInitializationStage(1);
        this.assignDefaultValues(abstractSession);
        if (FetchGroupTracker.class.isAssignableFrom(this.getJavaClass()) && this.getFetchGroupManager() == null) {
            this.setFetchGroupManager(new FetchGroupManager());
        }
        if (Arrays.asList(this.getJavaClass().getInterfaces()).contains(PersistenceObject.class)) {
            boolean bl = false;
            for (DatabaseMapping databaseMapping : this.getMappings()) {
                if (databaseMapping.isUsingMethodAccess()) {
                    if (databaseMapping.isOneToOneMapping() && ((ForeignReferenceMapping)databaseMapping).usesIndirection()) break;
                    bl = true;
                    break;
                }
                databaseMapping.setAttributeAccessor(new PersistenceObjectAttributeAccessor(databaseMapping.getAttributeName()));
            }
            if (!bl) {
                if (this.copyPolicy == null) {
                    this.setCopyPolicy(new PersistenceEntityCopyPolicy());
                }
                if (!this.isAbstract()) {
                    try {
                        this.setInstantiationPolicy(new PersistenceObjectInstantiationPolicy((PersistenceObject)this.getJavaClass().newInstance()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        for (DatabaseTable databaseTable : this.getTables()) {
            if (databaseTable.getName().indexOf(32) == -1) continue;
            String string = ((DatasourcePlatform)abstractSession.getDatasourcePlatform()).getIdentifierQuoteCharacter();
            if (databaseTable.getName().indexOf(string) != -1) continue;
            databaseTable.setName(string + databaseTable.getName() + string);
        }
        Enumeration<DatabaseMapping> enumeration = this.getMappings().elements();
        while (enumeration.hasMoreElements()) {
            try {
                DatabaseMapping databaseMapping = enumeration.nextElement();
                databaseMapping.preInitialize(abstractSession);
            }
            catch (DescriptorException descriptorException) {
                abstractSession.getIntegrityChecker().handleError(descriptorException);
            }
        }
        this.validateBeforeInitialization(abstractSession);
        this.preInitializeInheritancePolicy(abstractSession);
        if (this.hasInheritance()) {
            this.getInheritancePolicy().preInitialize(abstractSession);
        } else {
            this.setInternalDefaultTable();
        }
        this.verifyTableQualifiers(abstractSession.getDatasourcePlatform());
        this.initializeProperties(abstractSession);
        if (!this.isAggregateDescriptor()) {
            this.adjustMultipleTableInsertOrder();
            this.initializeMultipleTablePrimaryKeyFields();
        }
        if (this.hasInterfacePolicy()) {
            this.preInterfaceInitialization(abstractSession);
        }
        this.getQueryManager().preInitialize(abstractSession);
    }

    protected void prepareCascadeLockingPolicy(DatabaseMapping databaseMapping) {
        if (databaseMapping.isPrivateOwned() && databaseMapping.isForeignReferenceMapping()) {
            if (databaseMapping.isCascadedLockingSupported()) {
                if (((ForeignReferenceMapping)databaseMapping).hasCustomSelectionQuery()) {
                    throw ValidationException.unsupportedCascadeLockingMappingWithCustomQuery(databaseMapping);
                }
                if (this.isDescriptorTypeAggregate()) {
                    throw ValidationException.unsupportedCascadeLockingDescriptor(this);
                }
                databaseMapping.prepareCascadeLockingPolicy();
            } else {
                throw ValidationException.unsupportedCascadeLockingMapping(databaseMapping);
            }
        }
    }

    protected void preInitializeInheritancePolicy(AbstractSession abstractSession) throws DescriptorException {
        if (this.isChildDescriptor() && this.requiresInitialization()) {
            if (this.getInheritancePolicy().getParentClass().equals(this.getJavaClass())) {
                this.setInterfaceInitializationStage(-1);
                throw DescriptorException.parentClassIsSelf(this);
            }
            ClassDescriptor classDescriptor = abstractSession.getDescriptor(this.getInheritancePolicy().getParentClass());
            classDescriptor.getInheritancePolicy().addChildDescriptor(this);
            this.getInheritancePolicy().setParentDescriptor(classDescriptor);
            classDescriptor.preInitialize(abstractSession);
        }
    }

    public void preInterfaceInitialization(AbstractSession abstractSession) throws DescriptorException {
        if (this.isInterfaceInitialized(1)) {
            return;
        }
        this.setInterfaceInitializationStage(1);
        this.assignDefaultValues(abstractSession);
        if (this.isInterfaceChildDescriptor()) {
            Enumeration enumeration = this.getInterfacePolicy().getParentInterfaces().elements();
            while (enumeration.hasMoreElements()) {
                Class clazz = (Class)enumeration.nextElement();
                ClassDescriptor classDescriptor = abstractSession.getDescriptor(clazz);
                if (classDescriptor == null || classDescriptor.getJavaClass() == this.getJavaClass() || classDescriptor.getInterfacePolicy().usesImplementorDescriptor()) {
                    abstractSession.getProject().getDescriptors().put(clazz, this);
                    abstractSession.clearLastDescriptorAccessed();
                    continue;
                }
                if (!classDescriptor.isDescriptorForInterface()) {
                    throw DescriptorException.descriptorForInterfaceIsMissing(clazz.getName());
                }
                classDescriptor.preInterfaceInitialization(abstractSession);
                classDescriptor.getInterfacePolicy().addChildDescriptor(this);
                this.getInterfacePolicy().addParentDescriptor(classDescriptor);
            }
        }
    }

    public void rehashFieldDependancies(AbstractSession abstractSession) {
        this.getObjectBuilder().rehashFieldDependancies(abstractSession);
        Enumeration<DatabaseMapping> enumeration = this.getMappings().elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().rehashFieldDependancies(abstractSession);
        }
    }

    public void reInitializeJoinedAttributes() {
        if (!this.isInitialized(3)) {
            return;
        }
        this.getObjectBuilder().initializeJoinedAttributes();
        if (this.hasInheritance()) {
            Vector vector = this.getInheritancePolicy().getChildDescriptors();
            for (int i = 0; i < vector.size(); ++i) {
                ClassDescriptor classDescriptor = (ClassDescriptor)vector.elementAt(i);
                classDescriptor.reInitializeJoinedAttributes();
            }
        }
    }

    public void remoteInitialization(DistributedSession distributedSession) {
        Enumeration<DatabaseMapping> enumeration = this.getMappings().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = enumeration.nextElement();
            databaseMapping.remoteInitialization(distributedSession);
        }
        this.getEventManager().remoteInitialization(distributedSession);
        this.getInstantiationPolicy().initialize(distributedSession);
        this.getCopyPolicy().initialize(distributedSession);
        if (this.hasInheritance()) {
            this.getInheritancePolicy().remoteInitialization(distributedSession);
        }
    }

    public void removeProperty(String string) {
        this.getProperties().remove(string);
    }

    public boolean requiresInitialization() {
        return !this.isAggregateDescriptor() && !this.isDescriptorForInterface() && !this.isAggregateCollectionDescriptor();
    }

    protected void selfValidationAfterInitialization(AbstractSession abstractSession) throws DescriptorException {
        if (!(this.hasInheritance() && (this.getInheritancePolicy().shouldReadSubclasses() || this.isAbstract()) || this.hasTablePerClassPolicy() && this.isAbstract() || !abstractSession.getIntegrityChecker().shouldCheckInstantiationPolicy())) {
            this.getInstantiationPolicy().buildNewInstance();
        }
        if (this.hasReturningPolicy()) {
            this.getReturningPolicy().validationAfterDescriptorInitialization(abstractSession);
        }
        this.getObjectBuilder().validate(abstractSession);
    }

    protected void selfValidationBeforeInitialization(AbstractSession abstractSession) throws DescriptorException {
        if (this.isChildDescriptor()) {
            ClassDescriptor classDescriptor = abstractSession.getDescriptor(this.getInheritancePolicy().getParentClass());
            if (classDescriptor == null) {
                abstractSession.getIntegrityChecker().handleError(DescriptorException.parentDescriptorNotSpecified(this.getInheritancePolicy().getParentClass().getName(), this));
            }
        } else if (this.getTables().isEmpty() && !this.isAggregateDescriptor()) {
            abstractSession.getIntegrityChecker().handleError(DescriptorException.tableNotSpecified(this));
        }
        if (!this.isChildDescriptor() && !this.isAggregateDescriptor() && !this.isAggregateCollectionDescriptor() && this.getPrimaryKeyFieldNames().isEmpty()) {
            abstractSession.getIntegrityChecker().handleError(DescriptorException.primaryKeyFieldsNotSepcified(this));
        }
        if (this.getIdentityMapClass() == ClassConstants.NoIdentityMap_Class && this.getQueryManager().getDoesExistQuery().shouldCheckCacheForDoesExist()) {
            abstractSession.getIntegrityChecker().handleError(DescriptorException.identityMapNotSpecified(this));
        }
        if (this.getSequenceNumberName() != null && this.getSequenceNumberField() == null || this.getSequenceNumberName() == null && this.getSequenceNumberField() != null) {
            abstractSession.getIntegrityChecker().handleError(DescriptorException.sequenceNumberPropertyNotSpecified(this));
        }
    }

    protected void setAdditionalTablePrimaryKeyFields(DatabaseTable databaseTable, DatabaseField databaseField, DatabaseField databaseField2) {
        Map<DatabaseField, DatabaseField> map = this.getAdditionalTablePrimaryKeyFields().get(databaseTable);
        if (map == null) {
            map = new HashMap<DatabaseField, DatabaseField>(2);
            this.getAdditionalTablePrimaryKeyFields().put(databaseTable, map);
        }
        map.put(databaseField, databaseField2);
    }

    protected void toggleAdditionalTablePrimaryKeyFields() {
        if (this.additionalTablePrimaryKeyFields == null) {
            return;
        }
        int n = 1;
        if (this.isChildDescriptor()) {
            n = this.getInheritancePolicy().getParentDescriptor().getTables().size();
        }
        Map<DatabaseTable, Map<DatabaseField, DatabaseField>> map = this.additionalTablePrimaryKeyFields;
        this.additionalTablePrimaryKeyFields = null;
        for (Map.Entry<DatabaseTable, Map<DatabaseField, DatabaseField>> entry : map.entrySet()) {
            DatabaseTable databaseTable = entry.getKey();
            boolean bl = this.getTables().indexOf(databaseTable) < n;
            int n2 = this.getMultipleTableInsertOrder().indexOf(databaseTable);
            Map<DatabaseField, DatabaseField> map2 = entry.getValue();
            for (Map.Entry<DatabaseField, DatabaseField> entry2 : map2.entrySet()) {
                DatabaseField databaseField = entry2.getKey();
                DatabaseField databaseField2 = entry2.getValue();
                DatabaseTable databaseTable2 = databaseField.getTable();
                boolean bl2 = this.getTables().indexOf(databaseTable2) < n;
                int n3 = this.getMultipleTableInsertOrder().indexOf(databaseTable2);
                if (!bl2 && (bl || n2 > n3)) {
                    this.setAdditionalTablePrimaryKeyFields(databaseTable2, databaseField2, databaseField);
                    continue;
                }
                this.setAdditionalTablePrimaryKeyFields(databaseTable, databaseField, databaseField2);
            }
        }
    }

    public void setAdditionalTablePrimaryKeyFields(Map<DatabaseTable, Map<DatabaseField, DatabaseField>> map) {
        this.additionalTablePrimaryKeyFields = map;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    protected void setAllFields(Vector<DatabaseField> vector) {
        this.allFields = vector;
    }

    public void setAmendmentClass(Class clazz) {
        this.amendmentClass = clazz;
    }

    public void setAmendmentClassName(String string) {
        this.amendmentClassName = string;
    }

    public void setAmendmentMethodName(String string) {
        this.amendmentMethodName = string;
    }

    public void setCacheSynchronizationType(int n) {
        if (!this.isIsolated()) {
            this.cacheSynchronizationType = n;
        }
    }

    public void setObjectChangePolicy(ObjectChangePolicy objectChangePolicy) {
        this.changePolicy = objectChangePolicy;
    }

    public void setHistoryPolicy(HistoryPolicy historyPolicy) {
        this.historyPolicy = historyPolicy;
        if (historyPolicy != null) {
            historyPolicy.setDescriptor(this);
        }
    }

    public void setCacheInterceptorClass(Class clazz) {
        this.cacheInterceptorClass = clazz;
    }

    public void setCacheInterceptorClassName(String string) {
        this.cacheInterceptorClassName = string;
    }

    public void setCacheInvalidationPolicy(CacheInvalidationPolicy cacheInvalidationPolicy) {
        this.cacheInvalidationPolicy = cacheInvalidationPolicy;
    }

    public void setConstraintDependencies(Vector vector) {
        this.constraintDependencies = vector;
    }

    public void setCopyPolicy(CopyPolicy copyPolicy) {
        this.copyPolicy = copyPolicy;
        if (copyPolicy != null) {
            copyPolicy.setDescriptor(this);
        }
    }

    public void setCopyPolicyClassName(String string) {
        this.copyPolicyClassName = string;
    }

    public void setDefaultTable(DatabaseTable databaseTable) {
        this.defaultTable = databaseTable;
    }

    public void setDefaultTableName(String string) {
        this.setDefaultTable(new DatabaseTable(string));
    }

    public void setDescriptorType(int n) {
        this.descriptorType = n;
    }

    public void setDescriptorTypeValue(String string) {
        if (string.equals("Aggregate collection")) {
            this.descriptorIsAggregateCollection();
        } else if (string.equals("Aggregate")) {
            this.descriptorIsAggregate();
        } else if (string.equals("Interface")) {
            this.descriptorIsForInterface();
        } else {
            this.descriptorIsNormal();
        }
    }

    public void setEventManager(DescriptorEventManager descriptorEventManager) {
        this.eventManager = descriptorEventManager;
        if (descriptorEventManager != null) {
            descriptorEventManager.setDescriptor(this);
        }
    }

    public void setExistenceChecking(String string) throws DescriptorException {
        this.getQueryManager().setExistenceCheck(string);
    }

    public void setFields(Vector<DatabaseField> vector) {
        this.fields = vector;
    }

    public void setForeignKeyFieldNamesForMultipleTable(Vector vector) throws DescriptorException {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Association association = (Association)enumeration.nextElement();
            this.addForeignKeyFieldNameForMultipleTable((String)association.getKey(), (String)association.getValue());
        }
    }

    public void setIdentityMapClass(Class clazz) {
        this.identityMapClass = clazz;
    }

    public void setIdentityMapSize(int n) {
        this.identityMapSize = n;
    }

    public void setInheritancePolicy(InheritancePolicy inheritancePolicy) {
        this.inheritancePolicy = inheritancePolicy;
        if (inheritancePolicy != null) {
            inheritancePolicy.setDescriptor(this);
        }
    }

    public void setReturningPolicy(ReturningPolicy returningPolicy) {
        this.returningPolicy = returningPolicy;
        if (returningPolicy != null) {
            returningPolicy.setDescriptor(this);
        }
    }

    protected void setInitializationStage(int n) {
        this.initializationStage = n;
    }

    public void setInstantiationPolicy(InstantiationPolicy instantiationPolicy) {
        this.instantiationPolicy = instantiationPolicy;
        if (instantiationPolicy != null) {
            instantiationPolicy.setDescriptor(this);
        }
    }

    protected void setInterfaceInitializationStage(int n) {
        this.interfaceInitializationStage = n;
    }

    public void setInterfacePolicy(InterfacePolicy interfacePolicy) {
        this.interfacePolicy = interfacePolicy;
        if (interfacePolicy != null) {
            interfacePolicy.setDescriptor(this);
        }
    }

    public void setInternalDefaultTable() {
        if (this.getDefaultTable() == null) {
            this.setDefaultTable(this.extractDefaultTable());
        }
    }

    public void setInternalDefaultTable(DatabaseTable databaseTable) {
        if (this.getDefaultTable() == null) {
            this.setDefaultTable(databaseTable);
        }
    }

    public void setIsIDSpecified(boolean bl) {
        this.isIDSpecified = bl;
    }

    public void setIsIsolated(boolean bl) {
        this.isIsolated = bl;
        if (bl) {
            this.cacheSynchronizationType = 4;
        }
    }

    public boolean shouldIsolateObjectsInUnitOfWork() {
        return this.getUnitOfWorkCacheIsolationLevel() == 3;
    }

    public boolean shouldIsolateObjectsInUnitOfWorkEarlyTransaction() {
        return this.getUnitOfWorkCacheIsolationLevel() == 2;
    }

    public boolean shouldUseSessionCacheInUnitOfWorkEarlyTransaction() {
        return this.getUnitOfWorkCacheIsolationLevel() == 0;
    }

    public int getUnitOfWorkCacheIsolationLevel() {
        return this.unitOfWorkCacheIsolationLevel;
    }

    public void setUnitOfWorkCacheIsolationLevel(int n) {
        this.unitOfWorkCacheIsolationLevel = n;
    }

    public void setJavaClass(Class clazz) {
        this.javaClass = clazz;
    }

    public void setJavaClassName(String string) {
        this.javaClassName = string;
    }

    public void setJavaInterface(Class clazz) {
        this.javaClass = clazz;
        this.descriptorIsForInterface();
    }

    public void setJavaInterfaceName(String string) {
        this.javaClassName = string;
        this.descriptorIsForInterface();
    }

    public void setLockableMappings(List<DatabaseMapping> list) {
        this.lockableMappings = list;
    }

    public void setMappings(Vector<DatabaseMapping> vector) {
        Enumeration<DatabaseMapping> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = enumeration.nextElement();
            if (databaseMapping.getDescriptor() != null) continue;
            databaseMapping.setDescriptor(this);
        }
        this.mappings = vector;
    }

    protected void setMultipleTableForeignKeys(Map<DatabaseTable, Set<DatabaseTable>> map) {
        this.multipleTableForeignKeys = map;
    }

    public void setMultipleTableInsertOrder(Vector<DatabaseTable> vector) {
        this.multipleTableInsertOrder = vector;
    }

    protected void setObjectBuilder(ObjectBuilder objectBuilder) {
        this.objectBuilder = objectBuilder;
    }

    public void setOptimisticLockingPolicy(OptimisticLockingPolicy optimisticLockingPolicy) {
        this.optimisticLockingPolicy = optimisticLockingPolicy;
        if (optimisticLockingPolicy != null) {
            optimisticLockingPolicy.setDescriptor(this);
        }
    }

    public void setPrimaryKeyFieldName(String string) {
        this.addPrimaryKeyFieldName(string);
    }

    public void setPrimaryKeyFieldNames(Vector vector) {
        this.setPrimaryKeyFields(new ArrayList<DatabaseField>(vector.size()));
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addPrimaryKeyFieldName((String)enumeration.nextElement());
        }
    }

    public void setPrimaryKeyFields(List<DatabaseField> list) {
        this.primaryKeyFields = list;
    }

    public void setProperties(Map map) {
        this.properties = map;
    }

    public void setProperty(String string, Object object) {
        this.getProperties().put(string, object);
    }

    public void setQueryKeys(Map<String, QueryKey> map) {
        this.queryKeys = map;
    }

    public void setQueryManager(DescriptorQueryManager descriptorQueryManager) {
        this.queryManager = descriptorQueryManager;
        if (descriptorQueryManager != null) {
            descriptorQueryManager.setDescriptor(this);
        }
    }

    public void setRemoteIdentityMapClass(Class clazz) {
        this.remoteIdentityMapClass = clazz;
    }

    public void setRemoteIdentityMapSize(int n) {
        this.remoteIdentityMapSize = n;
    }

    public void setSequenceNumberField(DatabaseField databaseField) {
        this.sequenceNumberField = databaseField;
    }

    public void setSequenceNumberFieldName(String string) {
        if (string == null) {
            this.setSequenceNumberField(null);
        } else {
            this.setSequenceNumberField(new DatabaseField(string));
        }
    }

    public void setSequenceNumberName(String string) {
        this.sequenceNumberName = string;
    }

    protected void setSessionName(String string) {
        this.sessionName = string;
    }

    public void setShouldAlwaysConformResultsInUnitOfWork(boolean bl) {
        this.shouldAlwaysConformResultsInUnitOfWork = bl;
    }

    public void setShouldAlwaysRefreshCache(boolean bl) {
        this.shouldAlwaysRefreshCache = bl;
    }

    public void setShouldAlwaysRefreshCacheOnRemote(boolean bl) {
        this.shouldAlwaysRefreshCacheOnRemote = bl;
    }

    public void setShouldBeReadOnly(boolean bl) {
        this.shouldBeReadOnly = bl;
    }

    public void setReadOnly() {
        this.setShouldBeReadOnly(true);
    }

    public void setShouldDisableCacheHits(boolean bl) {
        this.shouldDisableCacheHits = bl;
    }

    public void setShouldDisableCacheHitsOnRemote(boolean bl) {
        this.shouldDisableCacheHitsOnRemote = bl;
    }

    public void setShouldOnlyRefreshCacheIfNewerVersion(boolean bl) {
        this.shouldOnlyRefreshCacheIfNewerVersion = bl;
    }

    public void setShouldOrderMappings(boolean bl) {
        this.shouldOrderMappings = bl;
    }

    public void setShouldRegisterResultsInUnitOfWork(boolean bl) {
        this.shouldRegisterResultsInUnitOfWork = bl;
    }

    public void setTableName(String string) throws DescriptorException {
        if (!this.getTables().isEmpty()) {
            throw DescriptorException.onlyOneTableCanBeAddedWithThisMethod(this);
        }
        this.addTableName(string);
    }

    public void setTableNames(Vector vector) {
        this.setTables(NonSynchronizedVector.newInstance(vector.size()));
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addTableName((String)enumeration.nextElement());
        }
    }

    public void setTablePerClassPolicy(TablePerClassPolicy tablePerClassPolicy) {
        this.interfacePolicy = tablePerClassPolicy;
        if (this.interfacePolicy != null) {
            this.interfacePolicy.setDescriptor(this);
        }
    }

    public void setTableQualifier(String string) {
        Enumeration<DatabaseTable> enumeration = this.getTables().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseTable databaseTable = enumeration.nextElement();
            databaseTable.setTableQualifier(string);
        }
    }

    public void setTables(Vector<DatabaseTable> vector) {
        this.tables = vector;
    }

    public void setWrapperPolicy(WrapperPolicy wrapperPolicy) {
        this.wrapperPolicy = wrapperPolicy;
        if (wrapperPolicy != null) {
            wrapperPolicy.setDescriptor(this);
        }
        this.getObjectBuilder().setHasWrapperPolicy(wrapperPolicy != null);
    }

    public boolean shouldAlwaysConformResultsInUnitOfWork() {
        return this.shouldAlwaysConformResultsInUnitOfWork;
    }

    public boolean shouldAlwaysRefreshCache() {
        return this.shouldAlwaysRefreshCache;
    }

    public boolean shouldAlwaysRefreshCacheOnRemote() {
        return this.shouldAlwaysRefreshCacheOnRemote;
    }

    public boolean shouldBeReadOnly() {
        return this.shouldBeReadOnly;
    }

    public boolean shouldDisableCacheHits() {
        return this.shouldDisableCacheHits;
    }

    public boolean shouldDisableCacheHitsOnRemote() {
        return this.shouldDisableCacheHitsOnRemote;
    }

    public boolean shouldOnlyRefreshCacheIfNewerVersion() {
        return this.shouldOnlyRefreshCacheIfNewerVersion;
    }

    public boolean shouldOrderMappings() {
        return this.shouldOrderMappings;
    }

    public boolean hasSimplePrimaryKey() {
        return this.hasSimplePrimaryKey;
    }

    public boolean hasTablePerClassPolicy() {
        return this.hasInterfacePolicy() && this.interfacePolicy.isTablePerClassPolicy();
    }

    public void setHasSimplePrimaryKey(boolean bl) {
        this.hasSimplePrimaryKey = bl;
    }

    public boolean shouldAcquireCascadedLocks() {
        return this.shouldAcquireCascadedLocks;
    }

    public void setShouldAcquireCascadedLocks(boolean bl) {
        this.shouldAcquireCascadedLocks = bl;
    }

    public boolean shouldUseCacheIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.CacheIdentityMap_Class;
    }

    public boolean shouldUseFullIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.FullIdentityMap_Class;
    }

    public boolean shouldUseSoftIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.SoftIdentityMap_Class;
    }

    public boolean shouldUseRemoteSoftIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.SoftIdentityMap_Class;
    }

    public boolean shouldUseHardCacheWeakIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.HardCacheWeakIdentityMap_Class;
    }

    public boolean shouldUseNoIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.NoIdentityMap_Class;
    }

    public boolean shouldRegisterResultsInUnitOfWork() {
        return this.shouldRegisterResultsInUnitOfWork;
    }

    public boolean shouldUseRemoteCacheIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.CacheIdentityMap_Class;
    }

    public boolean shouldUseRemoteFullIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.FullIdentityMap_Class;
    }

    public boolean shouldUseRemoteHardCacheWeakIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.HardCacheWeakIdentityMap_Class;
    }

    public boolean shouldUseRemoteNoIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.NoIdentityMap_Class;
    }

    public boolean shouldUseRemoteSoftCacheWeakIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.SoftCacheWeakIdentityMap_Class;
    }

    public boolean shouldUseRemoteWeakIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.WeakIdentityMap_Class;
    }

    public boolean shouldUseSoftCacheWeakIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.SoftCacheWeakIdentityMap_Class;
    }

    public boolean shouldUseWeakIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.WeakIdentityMap_Class;
    }

    public boolean supportsChangeTracking(Project project) {
        OptimisticLockingPolicy optimisticLockingPolicy = this.getOptimisticLockingPolicy();
        if (optimisticLockingPolicy != null && optimisticLockingPolicy instanceof FieldsLockingPolicy) {
            return false;
        }
        Vector<DatabaseMapping> vector = this.getMappings();
        for (DatabaseMapping databaseMapping : vector) {
            if (databaseMapping.isChangeTrackingSupported(project)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getJavaClassName() + " --> " + this.getTables() + ")";
    }

    public void useAllFieldsLocking() {
        this.setOptimisticLockingPolicy(new AllFieldsLockingPolicy());
    }

    public void useCacheIdentityMap() {
        this.setIdentityMapClass(ClassConstants.CacheIdentityMap_Class);
    }

    public void useChangedFieldsLocking() {
        this.setOptimisticLockingPolicy(new ChangedFieldsLockingPolicy());
    }

    public void useCloneCopyPolicy() {
        this.useCloneCopyPolicy("clone");
    }

    public void useCloneCopyPolicy(String string) {
        CloneCopyPolicy cloneCopyPolicy = new CloneCopyPolicy();
        cloneCopyPolicy.setMethodName(string);
        this.setCopyPolicy(cloneCopyPolicy);
    }

    public void useInstantiationCopyPolicy() {
        this.setCopyPolicy(new InstantiationCopyPolicy());
    }

    public void useDefaultConstructorInstantiationPolicy() {
        this.getInstantiationPolicy().useDefaultConstructorInstantiationPolicy();
    }

    public void useFactoryInstantiationPolicy(Class clazz, String string) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(clazz, string);
    }

    public void useFactoryInstantiationPolicy(String string, String string2) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(string, string2);
    }

    public void useFactoryInstantiationPolicy(Class clazz, String string, String string2) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(clazz, string, string2);
    }

    public void useFactoryInstantiationPolicy(String string, String string2, String string3) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(string, string2, string3);
    }

    public void useFactoryInstantiationPolicy(Object object, String string) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(object, string);
    }

    public void useFullIdentityMap() {
        this.setIdentityMapClass(ClassConstants.FullIdentityMap_Class);
    }

    public void useHardCacheWeakIdentityMap() {
        this.setIdentityMapClass(ClassConstants.HardCacheWeakIdentityMap_Class);
    }

    public void useSoftIdentityMap() {
        this.setIdentityMapClass(ClassConstants.SoftIdentityMap_Class);
    }

    public void useRemoteSoftIdentityMap() {
        this.setRemoteIdentityMapClass(ClassConstants.SoftIdentityMap_Class);
    }

    public void useMethodInstantiationPolicy(String string) {
        this.getInstantiationPolicy().useMethodInstantiationPolicy(string);
    }

    public void useNoIdentityMap() {
        this.setIdentityMapClass(ClassConstants.NoIdentityMap_Class);
    }

    public void useRemoteCacheIdentityMap() {
        this.setRemoteIdentityMapClass(ClassConstants.CacheIdentityMap_Class);
    }

    public void useRemoteFullIdentityMap() {
        this.setRemoteIdentityMapClass(ClassConstants.FullIdentityMap_Class);
    }

    public void useRemoteHardCacheWeakIdentityMap() {
        this.setRemoteIdentityMapClass(ClassConstants.HardCacheWeakIdentityMap_Class);
    }

    public void useRemoteNoIdentityMap() {
        this.setRemoteIdentityMapClass(ClassConstants.NoIdentityMap_Class);
    }

    public void useRemoteSoftCacheWeakIdentityMap() {
        this.setRemoteIdentityMapClass(ClassConstants.SoftCacheWeakIdentityMap_Class);
    }

    public void useRemoteWeakIdentityMap() {
        this.setRemoteIdentityMapClass(ClassConstants.WeakIdentityMap_Class);
    }

    public void useSelectedFieldsLocking(Vector vector) {
        SelectedFieldsLockingPolicy selectedFieldsLockingPolicy = new SelectedFieldsLockingPolicy();
        selectedFieldsLockingPolicy.setLockFieldNames(vector);
        this.setOptimisticLockingPolicy(selectedFieldsLockingPolicy);
    }

    public boolean usesFieldLocking() {
        return this.usesOptimisticLocking() && this.getOptimisticLockingPolicy() instanceof FieldsLockingPolicy;
    }

    public void useSoftCacheWeakIdentityMap() {
        this.setIdentityMapClass(ClassConstants.SoftCacheWeakIdentityMap_Class);
    }

    public boolean usesOptimisticLocking() {
        return this.optimisticLockingPolicy != null;
    }

    public boolean usesVersionLocking() {
        return this.usesOptimisticLocking() && this.getOptimisticLockingPolicy() instanceof VersionLockingPolicy;
    }

    public boolean usesSequenceNumbers() {
        return this.sequenceNumberField != null;
    }

    public void useTimestampLocking(String string) {
        this.useTimestampLocking(string, true);
    }

    public void useTimestampLocking(String string, boolean bl) {
        TimestampLockingPolicy timestampLockingPolicy = new TimestampLockingPolicy(string);
        if (bl) {
            timestampLockingPolicy.storeInCache();
        } else {
            timestampLockingPolicy.storeInObject();
        }
        this.setOptimisticLockingPolicy(timestampLockingPolicy);
    }

    public void useVersionLocking(String string) {
        this.useVersionLocking(string, true);
    }

    public void useVersionLocking(String string, boolean bl) {
        VersionLockingPolicy versionLockingPolicy = new VersionLockingPolicy(string);
        if (bl) {
            versionLockingPolicy.storeInCache();
        } else {
            versionLockingPolicy.storeInObject();
        }
        this.setOptimisticLockingPolicy(versionLockingPolicy);
    }

    public void useWeakIdentityMap() {
        this.setIdentityMapClass(ClassConstants.WeakIdentityMap_Class);
    }

    protected void validateAfterInitialization(AbstractSession abstractSession) {
        this.selfValidationAfterInitialization(abstractSession);
        Enumeration<DatabaseMapping> enumeration = this.getMappings().elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().validateAfterInitialization(abstractSession);
        }
    }

    protected void validateBeforeInitialization(AbstractSession abstractSession) {
        this.selfValidationBeforeInitialization(abstractSession);
        Enumeration<DatabaseMapping> enumeration = this.getMappings().elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().validateBeforeInitialization(abstractSession);
        }
    }

    protected void verifyTableQualifiers(Platform platform) {
        String string = platform.getTableQualifier();
        if (string.length() == 0) {
            return;
        }
        Enumeration<DatabaseTable> enumeration = this.getTables().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseTable databaseTable = enumeration.nextElement();
            if (databaseTable.getTableQualifier().length() != 0) continue;
            databaseTable.setTableQualifier(string);
        }
    }

    public CMPPolicy getCMPPolicy() {
        return this.cmpPolicy;
    }

    public void setCMPPolicy(CMPPolicy cMPPolicy) {
        this.cmpPolicy = cMPPolicy;
        if (this.cmpPolicy != null) {
            this.cmpPolicy.setDescriptor(this);
        }
    }

    public boolean hasPessimisticLockingPolicy() {
        return this.cmpPolicy != null && this.cmpPolicy.hasPessimisticLockingPolicy();
    }

    public FetchGroupManager getFetchGroupManager() {
        return this.fetchGroupManager;
    }

    public void setFetchGroupManager(FetchGroupManager fetchGroupManager) {
        this.fetchGroupManager = fetchGroupManager;
        if (fetchGroupManager != null) {
            fetchGroupManager.setDescriptor(this);
        }
    }

    public boolean isDescriptorForCMP() {
        return this.getCMPPolicy() != null;
    }

    public boolean hasFetchGroupManager() {
        return this.fetchGroupManager != null;
    }

    public boolean hasCascadeLockingPolicies() {
        return !this.cascadeLockingPolicies.isEmpty();
    }

    public boolean hasCMPPolicy() {
        return this.cmpPolicy != null;
    }

    public FetchGroup getDefaultFetchGroup() {
        if (!this.hasFetchGroupManager()) {
            return null;
        }
        return this.getFetchGroupManager().getDefaultFetchGroup();
    }

    public boolean isReturnTypeRequiredForReturningPolicy() {
        return true;
    }

    public void setIsNativeConnectionRequired(boolean bl) {
        this.isNativeConnectionRequired = bl;
    }

    public boolean isNativeConnectionRequired() {
        return this.isNativeConnectionRequired;
    }

    public void setIdValidation(IdValidation idValidation) {
        this.idValidation = idValidation;
    }

    public IdValidation getIdValidation() {
        return this.idValidation;
    }

    public QueryRedirector getDefaultQueryRedirector() {
        return this.defaultQueryRedirector;
    }

    public void setDefaultQueryRedirector(QueryRedirector queryRedirector) {
        this.defaultQueryRedirector = queryRedirector;
    }

    public QueryRedirector getDefaultReadAllQueryRedirector() {
        return this.defaultReadAllQueryRedirector;
    }

    public void setDefaultReadAllQueryRedirector(QueryRedirector queryRedirector) {
        this.defaultReadAllQueryRedirector = queryRedirector;
    }

    public QueryRedirector getDefaultReadObjectQueryRedirector() {
        return this.defaultReadObjectQueryRedirector;
    }

    public void setDefaultReadObjectQueryRedirector(QueryRedirector queryRedirector) {
        this.defaultReadObjectQueryRedirector = queryRedirector;
    }

    public QueryRedirector getDefaultReportQueryRedirector() {
        return this.defaultReportQueryRedirector;
    }

    public void setDefaultReportQueryRedirector(QueryRedirector queryRedirector) {
        this.defaultReportQueryRedirector = queryRedirector;
    }

    public QueryRedirector getDefaultUpdateObjectQueryRedirector() {
        return this.defaultUpdateObjectQueryRedirector;
    }

    public void setDefaultUpdateObjectQueryRedirector(QueryRedirector queryRedirector) {
        this.defaultUpdateObjectQueryRedirector = queryRedirector;
    }

    public QueryRedirector getDefaultInsertObjectQueryRedirector() {
        return this.defaultInsertObjectQueryRedirector;
    }

    public void setDefaultInsertObjectQueryRedirector(QueryRedirector queryRedirector) {
        this.defaultInsertObjectQueryRedirector = queryRedirector;
    }

    public QueryRedirector getDefaultDeleteObjectQueryRedirector() {
        return this.defaultDeleteObjectQueryRedirector;
    }

    public void setDefaultDeleteObjectQueryRedirector(QueryRedirector queryRedirector) {
        this.defaultDeleteObjectQueryRedirector = queryRedirector;
    }

    public void setDefaultQueryRedirectorClassName(String string) {
        this.defaultQueryRedirectorClassName = string;
    }

    public void setDefaultReadAllQueryRedirectorClassName(String string) {
        this.defaultReadAllQueryRedirectorClassName = string;
    }

    public void setDefaultReadObjectQueryRedirectorClassName(String string) {
        this.defaultReadObjectQueryRedirectorClassName = string;
    }

    public void setDefaultReportQueryRedirectorClassName(String string) {
        this.defaultReportQueryRedirectorClassName = string;
    }

    public void setDefaultUpdateObjectQueryRedirectorClassName(String string) {
        this.defaultUpdateObjectQueryRedirectorClassName = string;
    }

    public void setDefaultInsertObjectQueryRedirectorClassName(String string) {
        this.defaultInsertObjectQueryRedirectorClassName = string;
    }

    public void setDefaultDeleteObjectQueryRedirectorClassName(String string) {
        this.defaultDeleteObjectQueryRedirectorClassName = string;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public List<DatabaseMapping> getMappingsPostCalculateChanges() {
        return this.mappingsPostCalculateChanges;
    }

    public boolean hasMappingsPostCalculateChanges() {
        return this.mappingsPostCalculateChanges != null;
    }

    public void addMappingsPostCalculateChanges(DatabaseMapping databaseMapping) {
        if (this.mappingsPostCalculateChanges == null) {
            this.mappingsPostCalculateChanges = new ArrayList<DatabaseMapping>();
        }
        this.mappingsPostCalculateChanges.add(databaseMapping);
    }

    public List<DatabaseMapping> getMappingsPostCalculateChangesOnDeleted() {
        return this.mappingsPostCalculateChangesOnDeleted;
    }

    public boolean hasMappingsPostCalculateChangesOnDeleted() {
        return this.mappingsPostCalculateChangesOnDeleted != null;
    }

    public void addMappingsPostCalculateChangesOnDeleted(DatabaseMapping databaseMapping) {
        if (this.mappingsPostCalculateChangesOnDeleted == null) {
            this.mappingsPostCalculateChangesOnDeleted = new ArrayList<DatabaseMapping>();
        }
        this.mappingsPostCalculateChangesOnDeleted.add(databaseMapping);
    }
}

