/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.changetracking;

import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangeTrackingPolicy;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.changetracking.AggregateAttributeChangeListener;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class AttributeChangeTrackingPolicy
extends ObjectChangeTrackingPolicy {
    public ObjectChangeSet calculateChangesForExistingObject(Object object, UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWorkImpl unitOfWorkImpl, ClassDescriptor classDescriptor, boolean bl) {
        return this.calculateChanges(object, null, false, unitOfWorkChangeSet, unitOfWorkImpl, classDescriptor, bl);
    }

    public ObjectChangeSet createObjectChangeSet(Object object, Object object2, UnitOfWorkChangeSet unitOfWorkChangeSet, boolean bl, AbstractSession abstractSession, ClassDescriptor classDescriptor) {
        ObjectChangeSet objectChangeSet;
        if (!bl) {
            objectChangeSet = ((AttributeChangeListener)((ChangeTracker)object)._persistence_getPropertyChangeListener()).getObjectChangeSet();
            if (objectChangeSet != null) {
                if (objectChangeSet.getUOWChangeSet() != unitOfWorkChangeSet) {
                    objectChangeSet = unitOfWorkChangeSet.mergeObjectChanges(objectChangeSet, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet());
                }
                if (objectChangeSet.hasDeferredAttributes()) {
                    Iterator iterator = objectChangeSet.getDeferredSet().iterator();
                    while (iterator.hasNext()) {
                        DatabaseMapping databaseMapping = classDescriptor.getObjectBuilder().getMappingForAttributeName((String)iterator.next());
                        databaseMapping.calculateDeferredChanges((ChangeRecord)objectChangeSet.getChangesForAttributeNamed(databaseMapping.getAttributeName()), abstractSession);
                    }
                }
            } else {
                objectChangeSet = classDescriptor.getObjectBuilder().createObjectChangeSet(object, unitOfWorkChangeSet, bl, abstractSession);
            }
        } else {
            objectChangeSet = classDescriptor.getObjectBuilder().createObjectChangeSet(object, unitOfWorkChangeSet, bl, true, abstractSession);
            if (classDescriptor.shouldUseFullChangeSetsForNewObjects() || classDescriptor.isAggregateDescriptor()) {
                Vector<DatabaseMapping> vector = classDescriptor.getMappings();
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
                    objectChangeSet.addChange(databaseMapping.compareForChange(object, null, objectChangeSet, (UnitOfWorkImpl)abstractSession));
                }
            }
        }
        if (classDescriptor.usesOptimisticLocking() && objectChangeSet.getPrimaryKeys() != null) {
            objectChangeSet.setOptimisticLockingPolicyAndInitialWriteLockValue(classDescriptor.getOptimisticLockingPolicy(), abstractSession);
        }
        return objectChangeSet;
    }

    public boolean isAttributeChangeTrackingPolicy() {
        return true;
    }

    public void updateWithChanges(Object object, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl, ClassDescriptor classDescriptor) {
        this.clearChanges(object, unitOfWorkImpl, classDescriptor);
    }

    public void revertChanges(Object object, ClassDescriptor classDescriptor, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        this.clearChanges(object, unitOfWorkImpl, classDescriptor);
        map.put(object, object);
    }

    public void setAggregateChangeListener(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl, ClassDescriptor classDescriptor, String string) {
        ((ChangeTracker)object2)._persistence_setPropertyChangeListener(new AggregateAttributeChangeListener(classDescriptor, unitOfWorkImpl, (AttributeChangeListener)((ChangeTracker)object)._persistence_getPropertyChangeListener(), string, object2));
    }

    public PropertyChangeListener setChangeListener(Object object, UnitOfWorkImpl unitOfWorkImpl, ClassDescriptor classDescriptor) {
        AttributeChangeListener attributeChangeListener = new AttributeChangeListener(classDescriptor, unitOfWorkImpl, object);
        ((ChangeTracker)object)._persistence_setPropertyChangeListener(attributeChangeListener);
        return attributeChangeListener;
    }

    public void setChangeSetOnListener(ObjectChangeSet objectChangeSet, Object object) {
        ((AttributeChangeListener)((ChangeTracker)object)._persistence_getPropertyChangeListener()).setObjectChangeSet(objectChangeSet);
    }

    public Object buildBackupClone(Object object, ObjectBuilder objectBuilder, UnitOfWorkImpl unitOfWorkImpl) {
        return object;
    }
}

