/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.interactions;

import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.EISMappedRecord;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public abstract class EISInteraction
extends DatasourceCall {
    protected InteractionSpec interactionSpec;
    protected String functionName = "";
    protected String inputRecordName = "";
    protected Map properties;
    protected AbstractRecord inputRow;
    protected Vector arguments;
    protected Vector outputArgumentNames;
    protected Vector outputArguments;
    protected String outputResultPath = "";

    public void addOutputArgument(String string) {
        this.addOutputArgument(string, string);
    }

    public void addOutputArgument(String string, String string2) {
        this.getOutputArgumentNames().addElement(string);
        this.getOutputArguments().addElement(new DatabaseField(string2));
    }

    public Vector getArguments() {
        if (this.arguments == null) {
            this.arguments = new Vector();
        }
        return this.arguments;
    }

    public void setArguments(Vector vector) {
        this.arguments = vector;
    }

    public boolean hasArguments() {
        return this.arguments != null && !this.arguments.isEmpty();
    }

    public boolean isEISInteraction() {
        return true;
    }

    public String getOutputResultPath() {
        return this.outputResultPath;
    }

    public void setOutputResultPath(String string) {
        this.outputResultPath = string;
    }

    public Vector getOutputArgumentNames() {
        if (this.outputArgumentNames == null) {
            this.outputArgumentNames = new Vector();
        }
        return this.outputArgumentNames;
    }

    public Vector getOutputArguments() {
        if (this.outputArguments == null) {
            this.outputArguments = new Vector();
        }
        return this.outputArguments;
    }

    public void setOutputArguments(Vector vector) {
        this.outputArguments = vector;
    }

    public void setOutputArgumentNames(Vector vector) {
        this.outputArgumentNames = vector;
    }

    public boolean hasOutputArguments() {
        return this.outputArguments != null && !this.outputArguments.isEmpty();
    }

    public void prepare(AbstractSession abstractSession) {
        if (this.getInputRecordName().length() == 0) {
            if (this.getQuery() != null && this.getQuery().getDescriptor() instanceof EISDescriptor) {
                EISDescriptor eISDescriptor = (EISDescriptor)this.getQuery().getDescriptor();
                this.setInputRecordName(eISDescriptor.getDataTypeName());
            } else {
                this.setInputRecordName("input");
            }
        }
        super.prepare(abstractSession);
    }

    public Object createRecordElement(String string, Object mappedRecord, EISAccessor eISAccessor) {
        try {
            MappedRecord mappedRecord2 = mappedRecord;
            if (mappedRecord2 instanceof List) {
                List list = (List)mappedRecord2;
                MappedRecord mappedRecord3 = new Vector(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    mappedRecord3.add(this.createRecordElement(string, list.get(i), eISAccessor));
                }
                mappedRecord2 = mappedRecord3;
            } else if (mappedRecord instanceof AbstractRecord) {
                AbstractRecord abstractRecord = (AbstractRecord)mappedRecord;
                String string2 = string;
                if (abstractRecord.size() > 0) {
                    string2 = ((DatabaseField)abstractRecord.getFields().get(0)).getTableName();
                }
                MappedRecord mappedRecord4 = eISAccessor.getRecordFactory().createMappedRecord(string2);
                for (DatabaseField databaseField : abstractRecord.getFields()) {
                    Object object = this.createRecordElement(databaseField.getName(), abstractRecord.get(databaseField), eISAccessor);
                    eISAccessor.getEISPlatform().setValueInRecord(databaseField.getName(), object, mappedRecord4, eISAccessor);
                }
                mappedRecord2 = mappedRecord4;
            }
            return mappedRecord2;
        }
        catch (ResourceException resourceException) {
            throw EISException.resourceException(resourceException, eISAccessor, null);
        }
    }

    public InteractionSpec getInteractionSpec() {
        return this.interactionSpec;
    }

    public void setInteractionSpec(InteractionSpec interactionSpec) {
        this.interactionSpec = interactionSpec;
    }

    public String getLogString(Accessor accessor) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("Executing ");
        stringWriter.write(this.toString());
        stringWriter.write(Helper.cr());
        stringWriter.write("\tspec => ");
        stringWriter.write(String.valueOf(this.getInteractionSpec()));
        stringWriter.write(Helper.cr());
        stringWriter.write("\tproperties => ");
        stringWriter.write(String.valueOf(this.getProperties()));
        stringWriter.write(Helper.cr());
        stringWriter.write("\tinput => [");
        if (!this.getParameters().isEmpty()) {
            Enumeration enumeration = this.getParameters().elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                stringWriter.write(String.valueOf(e));
                if (enumeration.hasMoreElements()) {
                    stringWriter.write(", ");
                    continue;
                }
                stringWriter.write("]");
            }
        } else {
            stringWriter.write(String.valueOf(this.getInputRow()));
            stringWriter.write("]");
        }
        return stringWriter.toString();
    }

    public void translate(AbstractRecord abstractRecord, AbstractRecord abstractRecord2, AbstractSession abstractSession) {
        this.setInputRow(abstractRecord2);
        if (this.hasArguments()) {
            Vector<Object> vector = new Vector<Object>(this.getArguments().size());
            for (int i = 0; i < this.getArguments().size(); ++i) {
                Object e = this.getArguments().elementAt(i);
                if (e != null && e instanceof DatabaseField) {
                    DatabaseField databaseField = (DatabaseField)e;
                    Object object = abstractRecord.get(databaseField);
                    if (object == null && abstractRecord2 != null) {
                        object = abstractRecord2.get(databaseField);
                    }
                    vector.addElement(object);
                    continue;
                }
                vector.addElement(e);
            }
            this.setParameters(vector);
        }
    }

    public abstract Record createInputRecord(EISAccessor var1);

    public abstract AbstractRecord buildRow(Record var1, EISAccessor var2);

    public Vector buildRows(Record record, EISAccessor eISAccessor) {
        Vector<Object> vector = null;
        if (record instanceof IndexedRecord) {
            IndexedRecord indexedRecord = (IndexedRecord)record;
            vector = new Vector(indexedRecord.size());
            for (int i = 0; i < indexedRecord.size(); ++i) {
                Object object = indexedRecord.get(i);
                if (!(object instanceof Record)) {
                    vector.add(this.buildRow(record, eISAccessor));
                    return vector;
                }
                vector.addElement(this.buildRow((Record)object, eISAccessor));
            }
        } else if (record instanceof MappedRecord) {
            Object object;
            MappedRecord mappedRecord = (MappedRecord)record;
            if (this.getOutputResultPath().length() > 0) {
                object = mappedRecord.get((Object)this.getOutputResultPath());
                if (object instanceof IndexedRecord) {
                    return this.buildRows((Record)((IndexedRecord)object), eISAccessor);
                }
                if (object instanceof MappedRecord) {
                    mappedRecord = (MappedRecord)object;
                } else if (object instanceof List) {
                    List list = (List)object;
                    vector = new Vector(list.size());
                    for (int i = 0; i < list.size(); ++i) {
                        Object e = list.get(i);
                        if (e instanceof Record) {
                            vector.addElement(this.buildRow((Record)e, eISAccessor));
                            continue;
                        }
                        vector.add(e);
                    }
                    return vector;
                }
            }
            vector = new Vector(1);
            object = new EISMappedRecord((Map)mappedRecord, eISAccessor);
            vector.add(object);
        } else {
            vector = new Vector<Object>(1);
        }
        return vector;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String string) {
        this.functionName = string;
    }

    public String getInputRecordName() {
        return this.inputRecordName;
    }

    public void setInputRecordName(String string) {
        this.inputRecordName = string;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap(5);
        }
        return this.properties;
    }

    public Object getProperty(String string) {
        Object object = this.getProperties().get(string);
        if (object == null && this.getQuery() != null && this.getQuery().getDescriptor() != null) {
            object = this.getQuery().getDescriptor().getProperty(string);
        }
        return object;
    }

    public void setProperties(Map map) {
        this.properties = map;
    }

    public void setProperty(String string, Object object) {
        this.getProperties().put(string, object);
    }

    public AbstractRecord getInputRow() {
        return this.inputRow;
    }

    public void setInputRow(AbstractRecord abstractRecord) {
        this.inputRow = abstractRecord;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getFunctionName() + ")";
    }
}

