/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.codegen;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.codegen.HierarchyNode;
import org.eclipse.persistence.sessions.Project;

public class InheritanceHierarchyBuilder {
    public static HierarchyNode getNodeForClass(String string, Hashtable hashtable) {
        HierarchyNode hierarchyNode = (HierarchyNode)hashtable.get(string);
        if (hierarchyNode == null) {
            hierarchyNode = new HierarchyNode(string);
            hashtable.put(string, hierarchyNode);
        }
        return hierarchyNode;
    }

    public static Hashtable buildInheritanceHierarchyTree(Project project) {
        Map map = project.getDescriptors();
        Hashtable hashtable = new Hashtable(map.size());
        for (ClassDescriptor classDescriptor : map.values()) {
            String string = classDescriptor.getJavaClassName();
            if (string == null) {
                string = classDescriptor.getJavaClass().getName();
            }
            HierarchyNode hierarchyNode = InheritanceHierarchyBuilder.getNodeForClass(string, hashtable);
            if (!classDescriptor.hasInheritance() || classDescriptor.getInheritancePolicy().getParentClassName() == null) continue;
            HierarchyNode hierarchyNode2 = InheritanceHierarchyBuilder.getNodeForClass(classDescriptor.getInheritancePolicy().getParentClassName(), hashtable);
            hierarchyNode.setParent(hierarchyNode2);
        }
        return hashtable;
    }
}

