/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.BatchWritingMechanism;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.DatasourceAccessor;
import org.eclipse.persistence.internal.databaseaccess.DynamicSQLBatchWritingMechanism;
import org.eclipse.persistence.internal.databaseaccess.ParameterizedSQLBatchWritingMechanism;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.LOBValueWriter;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.helper.ThreadCursoredList;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Login;

public class DatabaseAccessor
extends DatasourceAccessor {
    public static boolean shouldUseDynamicStatements = true;
    protected Hashtable statementCache = new Hashtable(50);
    protected DatabaseMetaData metaData;
    protected BatchWritingMechanism activeBatchWritingMechanism;
    protected DynamicSQLBatchWritingMechanism dynamicSQLMechanism = new DynamicSQLBatchWritingMechanism(this);
    protected ParameterizedSQLBatchWritingMechanism parameterizedMechanism = new ParameterizedSQLBatchWritingMechanism(this);
    protected LOBValueWriter lobWriter = null;
    protected boolean shouldUseThreadCursors = false;
    protected Statement dynamicStatement;
    protected boolean isDynamicStatementInUse = false;

    public DatabaseAccessor() {
        this.activeBatchWritingMechanism = this.parameterizedMechanism;
    }

    public void flushSelectCalls(AbstractSession abstractSession) {
        if (this.lobWriter != null) {
            this.lobWriter.buildAndExecuteSelectCalls(abstractSession);
        }
    }

    public LOBValueWriter getLOBWriter() {
        if (this.lobWriter == null) {
            this.lobWriter = new LOBValueWriter(this);
        }
        return this.lobWriter;
    }

    public synchronized Statement allocateDynamicStatement(Connection connection) throws SQLException {
        if (this.dynamicStatement == null) {
            this.dynamicStatement = connection.createStatement();
        }
        if (this.isDynamicStatementInUse()) {
            return connection.createStatement();
        }
        this.setIsDynamicStatementInUse(true);
        return this.dynamicStatement;
    }

    public boolean isDynamicStatementInUse() {
        return this.isDynamicStatementInUse;
    }

    public synchronized void setIsDynamicStatementInUse(boolean bl) {
        this.isDynamicStatementInUse = bl;
    }

    public void basicBeginTransaction(AbstractSession abstractSession) throws DatabaseException {
        try {
            if (this.getPlatform().supportsAutoCommit()) {
                this.getConnection().setAutoCommit(false);
            } else {
                this.getPlatform().beginTransaction(this);
            }
        }
        catch (SQLException sQLException) {
            DatabaseException databaseException = this.processExceptionForCommError(abstractSession, sQLException, null);
            if (databaseException != null) {
                throw databaseException;
            }
            throw DatabaseException.sqlException(sQLException, this, abstractSession, false);
        }
    }

    protected void buildConnectLog(AbstractSession abstractSession) {
        try {
            if (abstractSession.shouldLog(4, "connection")) {
                DatabaseMetaData databaseMetaData = this.getConnectionMetaData();
                Object[] objectArray = new Object[]{databaseMetaData.getURL(), databaseMetaData.getUserName(), databaseMetaData.getDatabaseProductName(), databaseMetaData.getDatabaseProductVersion(), databaseMetaData.getDriverName(), databaseMetaData.getDriverVersion(), Helper.cr() + "\t"};
                abstractSession.log(4, "connection", "connected_user_database_driver", objectArray, this);
            }
        }
        catch (Exception exception) {
            abstractSession.warning("JDBC_driver_does_not_support_meta_data", "connection");
        }
    }

    public AbstractRecord buildOutputRow(CallableStatement callableStatement, DatabaseCall databaseCall, AbstractSession abstractSession) throws DatabaseException {
        try {
            return databaseCall.buildOutputRow(callableStatement);
        }
        catch (SQLException sQLException) {
            DatabaseException databaseException = this.processExceptionForCommError(abstractSession, sQLException, null);
            if (databaseException != null) {
                throw databaseException;
            }
            throw DatabaseException.sqlException(sQLException, this, abstractSession, false);
        }
    }

    public Vector buildSortedFields(Vector vector, ResultSet resultSet, AbstractSession abstractSession) throws DatabaseException {
        Vector<DatabaseField> vector2;
        try {
            Vector vector3 = this.getColumnNames(resultSet, abstractSession);
            if (vector == null) {
                vector2 = new Vector<DatabaseField>(vector3.size());
                Enumeration enumeration = vector3.elements();
                while (enumeration.hasMoreElements()) {
                    vector2.addElement(new DatabaseField((String)enumeration.nextElement()));
                }
            } else {
                vector2 = this.sortFields(vector, vector3);
            }
        }
        catch (SQLException sQLException) {
            DatabaseException databaseException = this.processExceptionForCommError(abstractSession, sQLException, null);
            if (databaseException != null) {
                throw databaseException;
            }
            throw DatabaseException.sqlException(sQLException, this, abstractSession, false);
        }
        return vector2;
    }

    protected void connectInternal(Login login, AbstractSession abstractSession) throws DatabaseException {
        super.connectInternal(login, abstractSession);
        this.checkTransactionIsolation(abstractSession);
    }

    protected void checkTransactionIsolation(AbstractSession abstractSession) throws DatabaseException {
        if (!this.isInTransaction && this.login != null && ((DatabaseLogin)this.login).getTransactionIsolation() != -1) {
            try {
                this.getConnection().setTransactionIsolation(((DatabaseLogin)this.login).getTransactionIsolation());
            }
            catch (SQLException sQLException) {
                DatabaseException databaseException = this.processExceptionForCommError(abstractSession, sQLException, null);
                if (databaseException != null) {
                    throw databaseException;
                }
                throw DatabaseException.sqlException(sQLException, this, abstractSession, false);
            }
        }
    }

    public void clearStatementCache(AbstractSession abstractSession) {
        if (this.hasStatementCache()) {
            Enumeration enumeration = this.getStatementCache().elements();
            while (enumeration.hasMoreElements()) {
                Statement statement = (Statement)enumeration.nextElement();
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            this.setStatementCache(null);
        }
        if (this.dynamicStatement != null) {
            try {
                this.dynamicStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.dynamicStatement = null;
            this.setIsDynamicStatementInUse(false);
        }
    }

    public Object clone() {
        DatabaseAccessor databaseAccessor = (DatabaseAccessor)super.clone();
        databaseAccessor.dynamicSQLMechanism = new DynamicSQLBatchWritingMechanism(databaseAccessor);
        databaseAccessor.activeBatchWritingMechanism = databaseAccessor.dynamicSQLMechanism;
        databaseAccessor.parameterizedMechanism = new ParameterizedSQLBatchWritingMechanism(databaseAccessor);
        return databaseAccessor;
    }

    public void closeCursor(ResultSet resultSet, AbstractSession abstractSession) throws DatabaseException {
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {
            DatabaseException databaseException = this.processExceptionForCommError(abstractSession, sQLException, null);
            if (databaseException != null) {
                throw databaseException;
            }
            throw DatabaseException.sqlException(sQLException, this, abstractSession, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStatement(Statement statement, AbstractSession abstractSession, DatabaseCall databaseCall) throws SQLException {
        if (statement == null) {
            this.decrementCallCount();
            return;
        }
        DatabaseQuery databaseQuery = databaseCall == null ? null : databaseCall.getQuery();
        try {
            abstractSession.startOperationProfile("sql execute", databaseQuery, Integer.MAX_VALUE);
            statement.close();
        }
        finally {
            abstractSession.endOperationProfile("sql execute", databaseQuery, Integer.MAX_VALUE);
            this.decrementCallCount();
            if (statement == this.dynamicStatement) {
                this.dynamicStatement = null;
                this.setIsDynamicStatementInUse(false);
            }
        }
    }

    public void commitTransaction(AbstractSession abstractSession) throws DatabaseException {
        this.writesCompleted(abstractSession);
        super.commitTransaction(abstractSession);
    }

    public void basicCommitTransaction(AbstractSession abstractSession) throws DatabaseException {
        try {
            if (this.getPlatform().supportsAutoCommit()) {
                this.getConnection().commit();
                this.getConnection().setAutoCommit(true);
            } else {
                this.getPlatform().commitTransaction(this);
            }
        }
        catch (SQLException sQLException) {
            DatabaseException databaseException = this.processExceptionForCommError(abstractSession, sQLException, null);
            if (databaseException != null) {
                throw databaseException;
            }
            throw DatabaseException.sqlException(sQLException, this, abstractSession, false);
        }
    }

    public AbstractRecord cursorRetrieveNextRow(Vector vector, ResultSet resultSet, AbstractSession abstractSession) throws DatabaseException {
        try {
            if (resultSet.next()) {
                return this.fetchRow(vector, resultSet, resultSet.getMetaData(), abstractSession);
            }
            return null;
        }
        catch (SQLException sQLException) {
            DatabaseException databaseException = this.processExceptionForCommError(abstractSession, sQLException, null);
            if (databaseException != null) {
                throw databaseException;
            }
            throw DatabaseException.sqlException(sQLException, this, abstractSession, false);
        }
    }

    public AbstractRecord cursorRetrievePreviousRow(Vector vector, ResultSet resultSet, AbstractSession abstractSession) throws DatabaseException {
        try {
            if (resultSet.previous()) {
                return this.fetchRow(vector, resultSet, resultSet.getMetaData(), abstractSession);
            }
            return null;
        }
        catch (SQLException sQLException) {
            DatabaseException databaseException = this.processExceptionForCommError(abstractSession, sQLException, null);
            if (databaseException != null) {
                throw databaseException;
            }
            throw DatabaseException.sqlException(sQLException, this, abstractSession, false);
        }
    }

    public void closeDatasourceConnection() throws DatabaseException {
        try {
            this.getConnection().close();
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, this, null, false);
        }
    }

    public void disconnect(AbstractSession abstractSession) throws DatabaseException {
        this.clearStatementCache(abstractSession);
        super.disconnect(abstractSession);
    }

    public void closeConnection() {
        this.clearStatementCache(null);
        super.closeConnection();
    }

    protected void executeBatchedStatement(PreparedStatement preparedStatement, AbstractSession abstractSession) throws DatabaseException {
        try {
            this.executeDirectNoSelect(preparedStatement, null, abstractSession);
        }
        catch (RuntimeException runtimeException) {
            try {
                this.closeStatement(preparedStatement, abstractSession, null);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw runtimeException;
        }
        try {
            this.closeStatement(preparedStatement, abstractSession, null);
        }
        catch (SQLException sQLException) {
            DatabaseException databaseException = this.processExceptionForCommError(abstractSession, sQLException, null);
            if (databaseException != null) {
                throw databaseException;
            }
            throw DatabaseException.sqlException(sQLException, this, abstractSession, false);
        }
    }

    public Object executeCall(Call call, AbstractRecord abstractRecord, AbstractSession abstractSession) throws DatabaseException {
        return this.basicExecuteCall(call, abstractRecord, abstractSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object basicExecuteCall(Call call, AbstractRecord abstractRecord, AbstractSession abstractSession) throws DatabaseException {
        Statement statement = null;
        Vector<AbstractRecord> vector = null;
        DatabaseCall databaseCall = null;
        ResultSet resultSet = null;
        try {
            databaseCall = (DatabaseCall)call;
        }
        catch (ClassCastException classCastException) {
            throw QueryException.invalidDatabaseCall(call);
        }
        if (this.login == null) {
            throw DatabaseException.databaseAccessorNotConnected();
        }
        if (this.isInBatchWritingMode(abstractSession)) {
            if (!(!databaseCall.isNothingReturned() || databaseCall.hasOptimisticLock() && !this.getPlatform().usesNativeBatchWriting() || databaseCall.shouldBuildOutputRow() || !this.getPlatform().usesJDBCBatchWriting() && databaseCall.hasParameters() || databaseCall.isLOBLocatorNeeded())) {
                this.getActiveBatchWritingMechanism().appendCall(abstractSession, databaseCall);
                return new Integer(1);
            }
            this.getActiveBatchWritingMechanism().executeBatchedStatements(abstractSession);
        }
        try {
            Object object;
            block40: {
                block42: {
                    block41: {
                        this.incrementCallCount(abstractSession);
                        if (abstractSession.shouldLog(3, "sql")) {
                            abstractSession.log(3, "sql", databaseCall.getLogString(this), null, this, false);
                        }
                        abstractSession.startOperationProfile("sql prepare", databaseCall.getQuery(), Integer.MAX_VALUE);
                        try {
                            statement = databaseCall.prepareStatement(this, abstractRecord, abstractSession);
                        }
                        finally {
                            abstractSession.endOperationProfile("sql prepare", databaseCall.getQuery(), Integer.MAX_VALUE);
                        }
                        if (!databaseCall.isNothingReturned()) break block41;
                        vector = this.executeNoSelect(databaseCall, statement, abstractSession);
                        if (!this.isInBatchWritingMode(abstractSession)) {
                            ++this.writeStatementsCount;
                        }
                        if (databaseCall.isLOBLocatorNeeded()) {
                            this.getLOBWriter().addCall(databaseCall);
                        }
                        break block40;
                    }
                    if (databaseCall.getReturnsResultSet() && (!databaseCall.getReturnsResultSet() || !databaseCall.shouldBuildOutputRow())) break block42;
                    vector = abstractSession.getPlatform().executeStoredProcedure(databaseCall, (PreparedStatement)statement, this, abstractSession);
                    if (!this.isInBatchWritingMode(abstractSession)) {
                        ++this.storedProcedureStatementsCount;
                    }
                    break block40;
                }
                resultSet = this.executeSelect(databaseCall, statement, abstractSession);
                if (!this.isInBatchWritingMode(abstractSession)) {
                    ++this.readStatementsCount;
                }
                if (!databaseCall.shouldIgnoreFirstRowMaxResultsSettings() && databaseCall.getFirstResult() != 0) {
                    resultSet.absolute(databaseCall.getFirstResult());
                }
                object = resultSet.getMetaData();
                databaseCall.matchFieldOrder(resultSet, this, abstractSession);
                if (databaseCall.isCursorReturned()) {
                    databaseCall.setStatement(statement);
                    databaseCall.setResult(resultSet);
                    return databaseCall;
                }
                abstractSession.startOperationProfile("row fetch", databaseCall.getQuery(), Integer.MAX_VALUE);
                try {
                    block44: {
                        block43: {
                            if (!databaseCall.isOneRowReturned()) break block43;
                            if (resultSet.next()) {
                                if (databaseCall.isLOBLocatorNeeded()) {
                                    this.getLOBWriter().fetchLocatorAndWriteValue(databaseCall, resultSet);
                                } else {
                                    vector = this.fetchRow(databaseCall.getFields(), resultSet, (ResultSetMetaData)object, abstractSession);
                                }
                                if (resultSet.next()) {
                                    abstractSession.getEventManager().moreRowsDetected(databaseCall);
                                }
                                break block44;
                            } else {
                                vector = null;
                            }
                            break block44;
                        }
                        boolean bl = resultSet.next();
                        Vector<AbstractRecord> vector2 = null;
                        if (bl) {
                            if (this.shouldUseThreadCursors()) {
                                Vector vector3 = this.buildThreadCursoredResult(databaseCall, resultSet, statement, (ResultSetMetaData)object, abstractSession);
                                return vector3;
                            }
                            vector2 = new Vector(20);
                            while (bl) {
                                vector2.addElement(this.fetchRow(databaseCall.getFields(), resultSet, (ResultSetMetaData)object, abstractSession));
                                bl = resultSet.next();
                            }
                        } else {
                            vector2 = new Vector<AbstractRecord>(0);
                        }
                        vector = vector2;
                    }
                    resultSet.close();
                }
                finally {
                    abstractSession.endOperationProfile("row fetch", databaseCall.getQuery(), Integer.MAX_VALUE);
                }
            }
            if (abstractSession.shouldLog(1, "sql")) {
                for (object = statement.getWarnings(); object != null; object = ((SQLWarning)object).getNextWarning()) {
                    String string = ((Throwable)object).getMessage() + ":" + ((SQLException)object).getSQLState() + " - " + ((Throwable)object).getCause();
                    abstractSession.log(1, "sql", string, null, this, false);
                }
            }
        }
        catch (SQLException sQLException) {
            DatabaseException databaseException = this.processExceptionForCommError(abstractSession, sQLException, databaseCall);
            try {
                this.closeStatement(statement, abstractSession, databaseCall);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (databaseException != null) throw databaseException;
            throw DatabaseException.sqlException(sQLException, databaseCall, this, abstractSession, false);
        }
        catch (RuntimeException runtimeException) {
            try {
                this.closeStatement(statement, abstractSession, databaseCall);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!(runtimeException instanceof DatabaseException)) throw runtimeException;
            ((DatabaseException)runtimeException).setCall(databaseCall);
            throw runtimeException;
        }
        try {
            this.releaseStatement(statement, databaseCall.getSQLString(), databaseCall, abstractSession);
            return vector;
        }
        catch (SQLException sQLException) {
            DatabaseException databaseException = this.processExceptionForCommError(abstractSession, sQLException, null);
            if (databaseException == null) throw DatabaseException.sqlException(sQLException, this, abstractSession, false);
            throw databaseException;
        }
    }

    protected Vector buildThreadCursoredResult(final DatabaseCall databaseCall, final ResultSet resultSet, final Statement statement, final ResultSetMetaData resultSetMetaData, final AbstractSession abstractSession) {
        final ThreadCursoredList threadCursoredList = new ThreadCursoredList(20);
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DatabaseException databaseException;
                abstractSession.startOperationProfile("row fetch", databaseCall.getQuery(), Integer.MAX_VALUE);
                try {
                    boolean bl = true;
                    while (bl) {
                        threadCursoredList.addElement(DatabaseAccessor.this.fetchRow(databaseCall.getFields(), resultSet, resultSetMetaData, abstractSession));
                        bl = resultSet.next();
                    }
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    databaseException = DatabaseAccessor.this.processExceptionForCommError(abstractSession, sQLException, databaseCall);
                    try {
                        DatabaseAccessor.this.closeStatement(statement, abstractSession, databaseCall);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (databaseException == null) {
                        threadCursoredList.throwException(DatabaseException.sqlException(sQLException, databaseCall, DatabaseAccessor.this, abstractSession, false));
                    }
                    threadCursoredList.throwException(databaseException);
                }
                catch (RuntimeException runtimeException) {
                    try {
                        DatabaseAccessor.this.closeStatement(statement, abstractSession, databaseCall);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (runtimeException instanceof DatabaseException) {
                        ((DatabaseException)runtimeException).setCall(databaseCall);
                    }
                    threadCursoredList.throwException(runtimeException);
                }
                finally {
                    abstractSession.endOperationProfile("row fetch", databaseCall.getQuery(), Integer.MAX_VALUE);
                }
                try {
                    DatabaseAccessor.this.releaseStatement(statement, databaseCall.getSQLString(), databaseCall, abstractSession);
                }
                catch (SQLException sQLException) {
                    databaseException = DatabaseAccessor.this.processExceptionForCommError(abstractSession, sQLException, databaseCall);
                    if (databaseException != null) {
                        threadCursoredList.throwException(databaseException);
                    }
                    threadCursoredList.throwException(DatabaseException.sqlException(sQLException, DatabaseAccessor.this, abstractSession, false));
                }
                threadCursoredList.setIsComplete(true);
            }
        };
        thread.start();
        return threadCursoredList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer executeDirectNoSelect(Statement statement, DatabaseCall databaseCall, AbstractSession abstractSession) throws DatabaseException {
        int n = 0;
        try {
            if (databaseCall != null) {
                abstractSession.startOperationProfile("sql execute", databaseCall.getQuery(), Integer.MAX_VALUE);
            } else {
                abstractSession.startOperationProfile("sql execute", null, Integer.MAX_VALUE);
            }
            n = databaseCall != null && databaseCall.isDynamicCall(abstractSession) ? statement.executeUpdate(databaseCall.getSQLString()) : ((PreparedStatement)statement).executeUpdate();
            if (!this.getPlatform().supportsAutoCommit() && !this.isInTransaction) {
                this.getPlatform().autoCommit(this);
            }
        }
        catch (SQLException sQLException) {
            if (!this.getPlatform().shouldIgnoreException(sQLException)) {
                DatabaseException databaseException = this.processExceptionForCommError(abstractSession, sQLException, databaseCall);
                if (databaseException != null) {
                    throw databaseException;
                }
                throw DatabaseException.sqlException(sQLException, this, abstractSession, false);
            }
        }
        finally {
            if (databaseCall != null) {
                abstractSession.endOperationProfile("sql execute", databaseCall.getQuery(), Integer.MAX_VALUE);
            } else {
                abstractSession.endOperationProfile("sql execute", null, Integer.MAX_VALUE);
            }
        }
        return new Integer(n);
    }

    protected int executeJDK12BatchStatement(Statement statement, DatabaseCall databaseCall, AbstractSession abstractSession, boolean bl) throws DatabaseException {
        int n = 0;
        try {
            n = this.getPlatform().executeBatch(statement, bl);
        }
        catch (SQLException sQLException) {
            Object var7_9 = null;
            DatabaseException databaseException = this.processExceptionForCommError(abstractSession, sQLException, databaseCall);
            if (databaseException != null) {
                throw databaseException;
            }
            try {
                this.closeStatement(statement, abstractSession, databaseCall);
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            if (var7_9 == null) {
                throw DatabaseException.sqlException(sQLException, this, abstractSession, false);
            }
            throw var7_9;
        }
        catch (RuntimeException runtimeException) {
            try {
                this.closeStatement(statement, abstractSession, databaseCall);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw runtimeException;
        }
        try {
            if (databaseCall != null) {
                this.releaseStatement(statement, databaseCall.getSQLString(), databaseCall, abstractSession);
            } else {
                this.closeStatement(statement, abstractSession, databaseCall);
            }
        }
        catch (SQLException sQLException) {
            DatabaseException databaseException = this.processExceptionForCommError(abstractSession, sQLException, databaseCall);
            if (databaseException != null) {
                throw databaseException;
            }
            throw DatabaseException.sqlException(sQLException, this, abstractSession, false);
        }
        return n;
    }

    protected Integer executeNoSelect(DatabaseCall databaseCall, Statement statement, AbstractSession abstractSession) throws DatabaseException {
        Integer n = this.executeDirectNoSelect(statement, databaseCall, abstractSession);
        if (databaseCall.shouldBuildOutputRow()) {
            AbstractRecord abstractRecord = this.buildOutputRow((CallableStatement)statement, databaseCall, abstractSession);
            databaseCall.getQuery().setProperty("output", abstractRecord);
            abstractSession.getEventManager().outputParametersDetected(abstractRecord, databaseCall);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeSelect(DatabaseCall databaseCall, Statement statement, AbstractSession abstractSession) throws SQLException {
        ResultSet resultSet;
        abstractSession.startOperationProfile("sql execute", databaseCall.getQuery(), Integer.MAX_VALUE);
        try {
            resultSet = databaseCall.isDynamicCall(abstractSession) ? statement.executeQuery(databaseCall.getSQLString()) : ((PreparedStatement)statement).executeQuery();
        }
        finally {
            abstractSession.endOperationProfile("sql execute", databaseCall.getQuery(), Integer.MAX_VALUE);
        }
        if (databaseCall.shouldBuildOutputRow()) {
            AbstractRecord abstractRecord = this.buildOutputRow((CallableStatement)statement, databaseCall, abstractSession);
            databaseCall.getQuery().setProperty("output", abstractRecord);
            abstractSession.getEventManager().outputParametersDetected(abstractRecord, databaseCall);
        }
        return resultSet;
    }

    protected AbstractRecord fetchRow(Vector vector, ResultSet resultSet, ResultSetMetaData resultSetMetaData, AbstractSession abstractSession) throws DatabaseException {
        int n = vector.size();
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(n);
        DatabasePlatform databasePlatform = this.getPlatform();
        boolean bl = databasePlatform.shouldOptimizeDataConversion();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = (DatabaseField)vector.elementAt(i);
            if (databaseField != null) {
                ((Vector)nonSynchronizedVector).add(this.getObject(resultSet, databaseField, resultSetMetaData, i + 1, databasePlatform, bl, abstractSession));
                continue;
            }
            ((Vector)nonSynchronizedVector).add(null);
        }
        return new DatabaseRecord(vector, nonSynchronizedVector);
    }

    public BatchWritingMechanism getActiveBatchWritingMechanism() {
        return this.activeBatchWritingMechanism;
    }

    public Vector getColumnInfo(String string, String string2, String string3, String string4, AbstractSession abstractSession) throws DatabaseException {
        Object[] objectArray;
        if (abstractSession.shouldLog(1, "query")) {
            objectArray = new Object[]{string, string2, string3, string4};
            abstractSession.log(1, "query", "query_column_meta_data_with_column", objectArray, this);
        }
        objectArray = new Vector();
        ResultSet resultSet = null;
        try {
            this.incrementCallCount(abstractSession);
            resultSet = this.getConnectionMetaData().getColumns(string, string2, string3, string4);
            Vector vector = this.buildSortedFields(null, resultSet, abstractSession);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                objectArray.addElement(this.fetchRow(vector, resultSet, resultSetMetaData, abstractSession));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            DatabaseException databaseException = this.processExceptionForCommError(abstractSession, sQLException, null);
            if (databaseException != null) {
                throw databaseException;
            }
            throw DatabaseException.sqlException(sQLException, this, abstractSession, false);
        }
        finally {
            this.decrementCallCount();
        }
        return objectArray;
    }

    protected Vector getColumnNames(ResultSet resultSet, AbstractSession abstractSession) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Vector<String> vector = new Vector<String>(resultSetMetaData.getColumnCount());
        for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
            String string = resultSetMetaData.getColumnLabel(i + 1);
            if (string == null || string.equals("")) {
                string = "C" + (i + 1);
            }
            if (this.getPlatform().shouldForceFieldNamesToUpperCase()) {
                string = string.toUpperCase();
            }
            vector.addElement(string);
        }
        return vector;
    }

    public Connection getConnection() throws DatabaseException {
        return (Connection)this.datasourceConnection;
    }

    public DatabasePlatform getPlatform() {
        return (DatabasePlatform)this.platform;
    }

    public DatabaseMetaData getConnectionMetaData() throws SQLException {
        return this.getConnection().getMetaData();
    }

    public Object getObject(ResultSet resultSet, DatabaseField databaseField, ResultSetMetaData resultSetMetaData, int n, DatabasePlatform databasePlatform, boolean bl, AbstractSession abstractSession) throws DatabaseException {
        Object object = null;
        try {
            int n2;
            block22: {
                n2 = databaseField.sqlType;
                if (n2 == -1) {
                    n2 = resultSetMetaData.getColumnType(n);
                    databaseField.setSqlType(n2);
                }
                if (bl) {
                    try {
                        object = this.getObjectThroughOptimizedDataConversion(resultSet, databaseField, n2, n, databasePlatform, abstractSession);
                        if (object == null) {
                            return null;
                        }
                        if (object == this) {
                            object = null;
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!abstractSession.shouldLog(6, "sql")) break block22;
                        abstractSession.logThrowable(6, "sql", sQLException);
                    }
                }
            }
            if (object == null) {
                if (n2 == -4 && databasePlatform.usesStreamsForBinding()) {
                    InputStream inputStream = resultSet.getBinaryStream(n);
                    if (inputStream != null) {
                        try {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            int n3 = inputStream.read();
                            while (n3 != -1) {
                                byteArrayOutputStream.write(n3);
                                n3 = inputStream.read();
                            }
                            object = byteArrayOutputStream.toByteArray();
                        }
                        catch (IOException iOException) {
                            throw DatabaseException.errorReadingBlobData();
                        }
                    } else {
                        object = null;
                    }
                } else {
                    object = databasePlatform.getObjectFromResultSet(resultSet, n, n2, abstractSession);
                    if (this.isBlob(n2)) {
                        object = databasePlatform.convertObject(object, ClassConstants.APBYTE);
                    }
                    if (this.isClob(n2)) {
                        object = databasePlatform.convertObject(object, ClassConstants.STRING);
                    }
                    if (this.isArray(n2)) {
                        object = ObjectRelationalDataTypeDescriptor.buildArrayObjectFromArray(object);
                    }
                    if (this.isStruct(n2, object)) {
                        object = ObjectRelationalDataTypeDescriptor.buildArrayObjectFromStruct(object);
                    }
                }
            }
            if (!bl && resultSet.wasNull()) {
                object = null;
            }
        }
        catch (SQLException sQLException) {
            DatabaseException databaseException = this.processExceptionForCommError(abstractSession, sQLException, null);
            if (databaseException != null) {
                throw databaseException;
            }
            throw DatabaseException.sqlException(sQLException, this, abstractSession, false);
        }
        return object;
    }

    protected Object getObjectThroughOptimizedDataConversion(ResultSet resultSet, DatabaseField databaseField, int n, int n2, DatabasePlatform databasePlatform, AbstractSession abstractSession) throws SQLException {
        Object object = this;
        Class clazz = databaseField.type;
        boolean bl = false;
        if (clazz == ClassConstants.PLONG || clazz == ClassConstants.LONG) {
            object = new Long(resultSet.getLong(n2));
            bl = (Long)object == 0L;
        } else if (n == 12 || n == 1) {
            object = resultSet.getString(n2);
            if (n == 1 && object != null && databasePlatform.shouldTrimStrings()) {
                object = Helper.rightTrimString((String)object);
            }
        } else if (clazz == ClassConstants.INTEGER || clazz == ClassConstants.PINT) {
            object = new Integer(resultSet.getInt(n2));
            bl = (Integer)object == 0;
        } else if (clazz == ClassConstants.FLOAT || clazz == ClassConstants.PFLOAT) {
            object = new Float(resultSet.getFloat(n2));
            bl = ((Float)object).floatValue() == 0.0f;
        } else if (clazz == ClassConstants.DOUBLE || clazz == ClassConstants.PDOUBLE) {
            object = new Double(resultSet.getDouble(n2));
            bl = (Double)object == 0.0;
        } else if (clazz == ClassConstants.SHORT || clazz == ClassConstants.PSHORT) {
            object = new Short(resultSet.getShort(n2));
            bl = (Short)object == 0;
        } else if (Helper.shouldOptimizeDates() && clazz != null && (n == 92 || n == 91 || n == 93)) {
            String string = resultSet.getString(n2);
            object = databasePlatform.convertObject(string, clazz);
        } else if (clazz != null && (n == 92 || n == 91 || n == 93)) {
            if (clazz == ClassConstants.SQLDATE) {
                object = resultSet.getDate(n2);
            } else if (clazz == ClassConstants.TIME) {
                object = resultSet.getTime(n2);
            } else if (clazz == ClassConstants.TIMESTAMP) {
                object = resultSet.getTimestamp(n2);
            }
        }
        if (bl && resultSet.wasNull()) {
            object = null;
        }
        return object;
    }

    protected boolean hasStatementCache() {
        return this.statementCache != null && !this.statementCache.isEmpty();
    }

    protected synchronized Hashtable getStatementCache() {
        if (this.statementCache == null) {
            this.statementCache = new Hashtable(50);
        }
        return this.statementCache;
    }

    public Vector getTableInfo(String string, String string2, String string3, String[] stringArray, AbstractSession abstractSession) throws DatabaseException {
        Object[] objectArray;
        if (abstractSession.shouldLog(1, "query")) {
            objectArray = new Object[]{string, string2, string3};
            abstractSession.log(1, "query", "query_column_meta_data", objectArray, this);
        }
        objectArray = new Vector();
        ResultSet resultSet = null;
        try {
            this.incrementCallCount(abstractSession);
            resultSet = this.getConnectionMetaData().getTables(string, string2, string3, stringArray);
            Vector vector = this.buildSortedFields(null, resultSet, abstractSession);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                objectArray.addElement(this.fetchRow(vector, resultSet, resultSetMetaData, abstractSession));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            DatabaseException databaseException = this.processExceptionForCommError(abstractSession, sQLException, null);
            if (databaseException != null) {
                throw databaseException;
            }
            throw DatabaseException.sqlException(sQLException, this, abstractSession, false);
        }
        finally {
            this.decrementCallCount();
        }
        return objectArray;
    }

    public boolean isDatasourceConnected() {
        try {
            return !this.getConnection().isClosed();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    protected boolean isInBatchWritingMode(AbstractSession abstractSession) {
        return this.getPlatform().usesBatchWriting() && this.isInTransaction;
    }

    public boolean shouldUseThreadCursors() {
        return this.shouldUseThreadCursors;
    }

    public void setShouldUseThreadCursors(boolean bl) {
        this.shouldUseThreadCursors = bl;
    }

    public Statement prepareStatement(DatabaseCall databaseCall, AbstractSession abstractSession) throws SQLException {
        return this.prepareStatement(databaseCall, abstractSession, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement prepareStatement(DatabaseCall databaseCall, AbstractSession abstractSession, boolean bl) throws SQLException {
        Object object;
        Statement statement = null;
        if (databaseCall.usesBinding(abstractSession) && databaseCall.shouldCacheStatement(abstractSession)) {
            Object object2 = object = this.getStatementCache();
            synchronized (object2) {
                statement = (PreparedStatement)object.get(databaseCall.getSQLString());
                if (statement != null) {
                    object.remove(databaseCall.getSQLString());
                }
            }
        }
        if (statement == null) {
            object = this.getConnection();
            if (object == null) {
                throw DatabaseException.databaseAccessorConnectionIsNull(this);
            }
            if (bl || databaseCall.isNativeConnectionRequired()) {
                object = this.getPlatform().getConnection(abstractSession, (Connection)object);
            }
            if (databaseCall.isCallableStatementRequired()) {
                if (databaseCall.isResultSetScrollable()) {
                    statement = object.prepareCall(databaseCall.getSQLString(), databaseCall.getResultSetType(), databaseCall.getResultSetConcurrency());
                    statement.setFetchSize(databaseCall.getResultSetFetchSize());
                } else {
                    statement = object.prepareCall(databaseCall.getSQLString());
                }
            } else if (databaseCall.isResultSetScrollable()) {
                statement = object.prepareStatement(databaseCall.getSQLString(), databaseCall.getResultSetType(), databaseCall.getResultSetConcurrency());
                statement.setFetchSize(databaseCall.getResultSetFetchSize());
            } else {
                statement = databaseCall.isDynamicCall(abstractSession) ? this.allocateDynamicStatement((Connection)object) : object.prepareStatement(databaseCall.getSQLString());
            }
        }
        return statement;
    }

    public DatabaseException processExceptionForCommError(AbstractSession abstractSession, SQLException sQLException, Call call) {
        if (abstractSession.getLogin().isConnectionHealthValidatedOnError() && (call == null || ((DatabaseCall)call).getQueryTimeout() == 0) && this.getConnection() != null && abstractSession.getServerPlatform().wasFailureCommunicationBased(sQLException, this, abstractSession)) {
            this.setIsValid(false);
            return DatabaseException.sqlException(sQLException, call, this, abstractSession, true);
        }
        return null;
    }

    protected void reconnect(AbstractSession abstractSession) {
        this.clearStatementCache(abstractSession);
        super.reconnect(abstractSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseStatement(Statement statement, String string, DatabaseCall databaseCall, AbstractSession abstractSession) throws SQLException {
        if (databaseCall.usesBinding(abstractSession) && databaseCall.shouldCacheStatement(abstractSession)) {
            Hashtable hashtable = this.getStatementCache();
            synchronized (hashtable) {
                PreparedStatement preparedStatement = (PreparedStatement)statement;
                if (!this.getStatementCache().containsKey(string)) {
                    preparedStatement.clearParameters();
                    this.resetStatementFromCall(preparedStatement, databaseCall);
                    if (this.getStatementCache().size() > this.getPlatform().getStatementCacheSize()) {
                        PreparedStatement preparedStatement2 = (PreparedStatement)this.getStatementCache().remove(this.getStatementCache().keys().nextElement());
                        this.closeStatement(preparedStatement2, abstractSession, databaseCall);
                    } else {
                        this.decrementCallCount();
                    }
                    this.getStatementCache().put(string, preparedStatement);
                } else {
                    this.closeStatement(statement, abstractSession, databaseCall);
                }
            }
        } else if (statement == this.dynamicStatement) {
            this.resetStatementFromCall(statement, databaseCall);
            this.setIsDynamicStatementInUse(false);
            this.decrementCallCount();
        } else {
            this.closeStatement(statement, abstractSession, databaseCall);
        }
    }

    protected void resetStatementFromCall(Statement statement, DatabaseCall databaseCall) throws SQLException {
        if (databaseCall.getQueryTimeout() > 0) {
            statement.setQueryTimeout(0);
        }
        if (databaseCall.getMaxRows() > 0) {
            statement.setMaxRows(0);
        }
        if (databaseCall.getResultSetFetchSize() > 0) {
            statement.setFetchSize(0);
        }
    }

    public void rollbackTransaction(AbstractSession abstractSession) throws DatabaseException {
        this.getActiveBatchWritingMechanism().clear();
        super.rollbackTransaction(abstractSession);
    }

    public void basicRollbackTransaction(AbstractSession abstractSession) throws DatabaseException {
        try {
            if (this.getPlatform().supportsAutoCommit()) {
                this.getConnection().rollback();
                this.getConnection().setAutoCommit(true);
            } else {
                this.getPlatform().rollbackTransaction(this);
            }
        }
        catch (SQLException sQLException) {
            DatabaseException databaseException = this.processExceptionForCommError(abstractSession, sQLException, null);
            if (databaseException != null) {
                throw databaseException;
            }
            throw DatabaseException.sqlException(sQLException, this, abstractSession, false);
        }
    }

    public void setActiveBatchWritingMechanismToParameterizedSQL() {
        this.activeBatchWritingMechanism = this.parameterizedMechanism;
        if (((DatabaseLogin)this.login).getMaxBatchWritingSize() == DatabasePlatform.DEFAULT_MAX_BATCH_WRITING_SIZE) {
            ((DatabaseLogin)this.login).setMaxBatchWritingSize(DatabasePlatform.DEFAULT_PARAMETERIZED_MAX_BATCH_WRITING_SIZE);
        }
    }

    public void setActiveBatchWritingMechanismToDynamicSQL() {
        this.activeBatchWritingMechanism = this.dynamicSQLMechanism;
        if (((DatabaseLogin)this.login).getMaxBatchWritingSize() == DatabasePlatform.DEFAULT_PARAMETERIZED_MAX_BATCH_WRITING_SIZE) {
            ((DatabaseLogin)this.login).setMaxBatchWritingSize(DatabasePlatform.DEFAULT_MAX_BATCH_WRITING_SIZE);
        }
    }

    protected void setStatementCache(Hashtable hashtable) {
        this.statementCache = hashtable;
    }

    protected Vector sortFields(Vector vector, Vector vector2) {
        Vector<DatabaseField> vector3 = new Vector<DatabaseField>(vector2.size());
        Vector vector4 = (Vector)vector.clone();
        Enumeration enumeration = vector2.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            DatabaseField databaseField = null;
            Enumeration enumeration2 = vector4.elements();
            while (enumeration2.hasMoreElements()) {
                databaseField = (DatabaseField)enumeration2.nextElement();
                if (databaseField == null) continue;
                if (DatabasePlatform.shouldIgnoreCaseOnFieldComparisons()) {
                    if (!databaseField.getName().equalsIgnoreCase(string)) continue;
                    bl = true;
                    vector3.addElement(databaseField);
                    break;
                }
                if (!databaseField.getName().equals(string)) continue;
                bl = true;
                vector3.addElement(databaseField);
                break;
            }
            if (bl) {
                vector4.removeElement(databaseField);
            } else {
                vector3.addElement(new DatabaseField());
            }
            bl = false;
        }
        return vector3;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("DatabaseAccessor(");
        if (this.isConnected()) {
            stringWriter.write(ToStringLocalization.buildMessage("connected", null));
        } else {
            stringWriter.write(ToStringLocalization.buildMessage("disconnected", null));
        }
        stringWriter.write(")");
        return stringWriter.toString();
    }

    private boolean isArray(int n) {
        return n == 2003;
    }

    private boolean isBlob(int n) {
        return n == 2004 || n == -4;
    }

    private boolean isClob(int n) {
        return n == 2005 || n == -1;
    }

    private boolean isStruct(int n, Object object) {
        return n == 2002 && object instanceof Struct;
    }

    public void writesCompleted(AbstractSession abstractSession) {
        if (this.isInBatchWritingMode(abstractSession)) {
            this.getActiveBatchWritingMechanism().executeBatchedStatements(abstractSession);
        }
    }
}

