/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.BaseExpression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class ParameterExpression
extends BaseExpression {
    protected DatabaseField field;
    protected Expression localBase;
    Object type;

    public ParameterExpression() {
    }

    public ParameterExpression(String string) {
        this(new DatabaseField(string));
    }

    public ParameterExpression(DatabaseField databaseField) {
        this.field = databaseField;
    }

    public ParameterExpression(String string, Expression expression, Object object) {
        this(new DatabaseField(string), expression);
        this.type = object;
    }

    public ParameterExpression(DatabaseField databaseField, Expression expression) {
        this.field = databaseField;
        this.localBase = expression;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ParameterExpression parameterExpression = (ParameterExpression)object;
        return this.getField() == parameterExpression.getField() || this.getField() != null && this.getField().equals(parameterExpression.getField());
    }

    public int computeHashCode() {
        int n = super.computeHashCode();
        if (this.getField() != null) {
            n += this.getField().hashCode();
        }
        return n;
    }

    public String basicDescription() {
        return String.valueOf(this.getField());
    }

    public String descriptionOfNodeType() {
        return "Parameter";
    }

    public Expression get(String string) {
        ParameterExpression parameterExpression = new ParameterExpression(string);
        parameterExpression.setBaseExpression(this);
        return parameterExpression;
    }

    public ExpressionBuilder getBuilder() {
        if (this.localBase == null) {
            if (this.getBaseExpression() != null) {
                return ((ParameterExpression)this.getBaseExpression()).getBuilder();
            }
            return null;
        }
        return this.localBase.getBuilder();
    }

    public DatabaseField getField() {
        return this.field;
    }

    public Expression getField(DatabaseField databaseField) {
        ParameterExpression parameterExpression = new ParameterExpression(databaseField);
        parameterExpression.setBaseExpression(this);
        return parameterExpression;
    }

    public Expression getLocalBase() {
        return this.localBase;
    }

    public Object getType() {
        return this.type;
    }

    public Object getValue(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.getField() == null) {
            return null;
        }
        Object object = null;
        if (this.getBaseExpression() != null) {
            object = ((ParameterExpression)this.getBaseExpression()).getValue(abstractRecord, abstractSession);
            if (object == null) {
                return null;
            }
            ClassDescriptor classDescriptor = abstractSession.getDescriptor(object);
            if (classDescriptor != null && classDescriptor.isAggregateDescriptor() && ((ParameterExpression)this.getBaseExpression()).getLocalBase().isObjectExpression()) {
                classDescriptor = ((ObjectExpression)((ParameterExpression)this.getBaseExpression()).getLocalBase()).getDescriptor();
            }
            if (classDescriptor == null) {
                this.validateParameterValueAgainstMapping(object, true);
            }
            if (classDescriptor != null) {
                object = classDescriptor.getObjectBuilder().unwrapObject(object, abstractSession);
                this.validateParameterValueAgainstMapping(object, true);
                abstractRecord.put(((ParameterExpression)this.getBaseExpression()).getField(), object);
                DatabaseMapping databaseMapping = classDescriptor.getObjectBuilder().getMappingForField(this.getField());
                if (databaseMapping != null) {
                    object = databaseMapping.valueFromObject(object, this.getField(), abstractSession);
                } else {
                    databaseMapping = classDescriptor.getObjectBuilder().getMappingForAttributeName(this.getField().getName());
                    if (databaseMapping != null) {
                        object = databaseMapping.getRealAttributeValueFromObject(object, abstractSession);
                    } else {
                        DatabaseField databaseField = classDescriptor.getObjectBuilder().getFieldForQueryKeyName(this.getField().getName());
                        if (databaseField != null && (databaseMapping = classDescriptor.getObjectBuilder().getMappingForField(this.getField())) != null) {
                            object = databaseMapping.valueFromObject(object, this.getField(), abstractSession);
                        }
                    }
                }
            }
        } else {
            object = abstractRecord == null ? AbstractRecord.noEntry : abstractRecord.getIndicatingNoEntry(this.getField());
            if (object == AbstractRecord.noEntry) {
                throw QueryException.parameterNameMismatch(this.getField().getName());
            }
            this.validateParameterValueAgainstMapping(object, false);
        }
        if (this.getLocalBase() != null) {
            object = this.getLocalBase().getFieldValue(object, abstractSession);
        }
        return object;
    }

    public boolean isParameterExpression() {
        return true;
    }

    public boolean isValueExpression() {
        return true;
    }

    protected void postCopyIn(Map map) {
        super.postCopyIn(map);
        if (this.getLocalBase() != null) {
            this.setLocalBase(this.getLocalBase().copiedVersionFrom(map));
        }
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        if (expressionSQLPrinter.shouldPrintParameterValues()) {
            Object object = this.getValue(expressionSQLPrinter.getTranslationRow(), expressionSQLPrinter.getSession());
            if (object instanceof Collection) {
                expressionSQLPrinter.printValuelist((Collection)object);
            } else if (this.getField() == null) {
                expressionSQLPrinter.printPrimitive(object);
            } else {
                expressionSQLPrinter.printParameter(this);
            }
        } else if (this.getField() != null) {
            expressionSQLPrinter.printParameter(this);
        }
    }

    public void printJava(ExpressionJavaPrinter expressionJavaPrinter) {
        ((DataExpression)this.getLocalBase()).getBaseExpression().printJava(expressionJavaPrinter);
        expressionJavaPrinter.printString(".getParameter(\"" + this.getField().getQualifiedName() + "\")");
    }

    public Expression rebuildOn(Expression expression) {
        ParameterExpression parameterExpression = (ParameterExpression)this.clone();
        parameterExpression.setLocalBase(this.localBase.rebuildOn(expression));
        return parameterExpression;
    }

    public void setLocalBase(Expression expression) {
        this.localBase = expression;
    }

    public Expression twistedForBaseAndContext(Expression expression, Expression expression2) {
        return expression2.getField(this.getField());
    }

    protected void validateParameterValueAgainstMapping(Object object, boolean bl) {
        Cloneable cloneable;
        Expression expression = null;
        if (bl) {
            cloneable = (ParameterExpression)this.getBaseExpression();
            expression = ((ParameterExpression)cloneable).getLocalBase();
        } else {
            expression = this.getLocalBase();
        }
        if (object != null && expression != null && expression.isObjectExpression() && (cloneable = ((ObjectExpression)expression).getMapping()) != null && ((DatabaseMapping)cloneable).isForeignReferenceMapping() && !((DatabaseMapping)cloneable).getReferenceDescriptor().getJavaClass().isInstance(object)) {
            throw QueryException.incorrectClassForObjectComparison(this.baseExpression, object, (DatabaseMapping)cloneable);
        }
    }

    public Object valueFromObject(Object object, AbstractSession abstractSession, AbstractRecord abstractRecord, int n, boolean bl) {
        if (this.getField() != null) {
            return this.getValue(abstractRecord, abstractSession);
        }
        throw QueryException.cannotConformExpression();
    }

    public void writeDescriptionOn(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(this.basicDescription());
    }

    public void writeFields(ExpressionSQLPrinter expressionSQLPrinter, Vector vector, SQLSelectStatement sQLSelectStatement) {
        if (expressionSQLPrinter.isFirstElementPrinted()) {
            expressionSQLPrinter.printString(", ");
        } else {
            expressionSQLPrinter.setIsFirstElementPrinted(true);
        }
        vector.addElement(new DatabaseField("*"));
        this.printSQL(expressionSQLPrinter);
    }

    public void writeSubexpressionsTo(BufferedWriter bufferedWriter, int n) throws IOException {
        if (this.getBaseExpression() != null) {
            this.getBaseExpression().toString(bufferedWriter, n);
        }
    }
}

