/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.expressions.CompoundExpression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.FieldExpression;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.expressions.TableAliasLookup;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.queries.ReportQuery;

public class RelationExpression
extends CompoundExpression {
    protected Boolean isObjectComparisonExpression;

    protected boolean allChildrenAreFields() {
        return this.getFirstChild().getFields().size() == 1 && this.getSecondChild().getFields().size() == 1;
    }

    protected void convertNodeToUseOuterJoin() {
        if (this.getOperator().getSelector() == 4 && this.allChildrenAreFields()) {
            this.setOperator(this.getOperator(6));
        }
    }

    public String descriptionOfNodeType() {
        return "Relation";
    }

    public boolean doesConform(Object object, AbstractSession abstractSession, AbstractRecord abstractRecord, int n, boolean bl) {
        Object object2 = this.getSecondChild().valueFromObject(object, abstractSession, abstractRecord, n, bl);
        Object object3 = this.getFirstChild().valueFromObject(object, abstractSession, abstractRecord, n, bl);
        if (object2 instanceof Collection) {
            if (this.getOperator().getSelector() == 13 || this.getOperator().getSelector() == 14) {
                if (this.isObjectComparison()) {
                    throw QueryException.cannotConformExpression();
                }
                if (object3 instanceof Vector) {
                    return this.doesAnyOfLeftValuesConform((Vector)object3, object2, abstractSession);
                }
                return this.getOperator().doesRelationConform(object3, object2);
            }
            Enumeration enumeration = ((Vector)object2).elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (object3 instanceof Vector && this.doesAnyOfLeftValuesConform((Vector)object3, e, abstractSession)) {
                    return true;
                }
                if (!this.doValuesConform(object3, e, abstractSession)) continue;
                return true;
            }
            return false;
        }
        if (object3 instanceof Vector) {
            return this.doesAnyOfLeftValuesConform((Vector)object3, object2, abstractSession);
        }
        return this.doValuesConform(object3, object2, abstractSession);
    }

    protected boolean doesAnyOfLeftValuesConform(Vector vector, Object object, AbstractSession abstractSession) {
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.get(i);
            if (!this.doValuesConform(e, object, abstractSession)) continue;
            return true;
        }
        return false;
    }

    protected boolean doValuesConform(Object object, Object object2, AbstractSession abstractSession) {
        if (this.isObjectComparison()) {
            return this.doesObjectConform(object, object2, abstractSession);
        }
        return this.getOperator().doesRelationConform(object, object2);
    }

    public boolean doesObjectConform(Object object, Object object2, AbstractSession abstractSession) {
        if (object == null && object2 == null) {
            return this.performSelector(true);
        }
        if (object == null || object2 == null) {
            return this.performSelector(false);
        }
        Class<?> clazz = object.getClass();
        if (clazz != object2.getClass()) {
            return this.performSelector(false);
        }
        ClassDescriptor classDescriptor = abstractSession.getDescriptor(clazz);
        if (classDescriptor.isAggregateDescriptor()) {
            throw QueryException.cannotConformExpression();
        }
        Vector vector = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, abstractSession);
        Vector vector2 = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object2, abstractSession);
        CacheKey cacheKey = new CacheKey(vector2);
        CacheKey cacheKey2 = new CacheKey(vector);
        return this.performSelector(cacheKey.equals(cacheKey2));
    }

    public boolean extractPrimaryKeyValues(boolean bl, ClassDescriptor classDescriptor, AbstractRecord abstractRecord, AbstractRecord abstractRecord2) {
        if (bl && this.getOperator().getSelector() != 4) {
            return false;
        }
        if (!bl && this.getOperator().getSelector() == 13) {
            return false;
        }
        DatabaseField databaseField = null;
        Object object = null;
        if (this.getSecondChild().isConstantExpression()) {
            object = ((ConstantExpression)this.getSecondChild()).getValue();
        } else if (this.getSecondChild().isParameterExpression() && abstractRecord2 != null) {
            object = abstractRecord2.get(((ParameterExpression)this.getSecondChild()).getField());
        } else if (this.getFirstChild().isConstantExpression()) {
            object = ((ConstantExpression)this.getFirstChild()).getValue();
        } else if (this.getFirstChild().isParameterExpression() && abstractRecord2 != null) {
            object = abstractRecord2.get(((ParameterExpression)this.getFirstChild()).getField());
        }
        if (object == null) {
            return false;
        }
        if (this.getFirstChild().isFieldExpression()) {
            FieldExpression fieldExpression = (FieldExpression)this.getFirstChild();
            if (!fieldExpression.getBaseExpression().isExpressionBuilder()) {
                return false;
            }
            databaseField = fieldExpression.getField();
        } else if (this.getFirstChild().isQueryKeyExpression()) {
            QueryKeyExpression queryKeyExpression = (QueryKeyExpression)this.getFirstChild();
            if (!queryKeyExpression.getBaseExpression().isExpressionBuilder()) {
                return false;
            }
            DatabaseMapping databaseMapping = classDescriptor.getObjectBuilder().getMappingForAttributeName(queryKeyExpression.getName());
            if (databaseMapping != null) {
                if (!databaseMapping.isPrimaryKeyMapping()) {
                    return false;
                }
                if (databaseMapping.isObjectReferenceMapping() || databaseMapping.isAggregateObjectMapping()) {
                    databaseMapping.writeFromAttributeIntoRow(object, abstractRecord, this.getSession());
                    return true;
                }
                if (!databaseMapping.isDirectToFieldMapping()) {
                    return false;
                }
                databaseField = ((AbstractDirectMapping)databaseMapping).getField();
            } else {
                databaseField = classDescriptor.getObjectBuilder().getFieldForQueryKeyName(queryKeyExpression.getName());
            }
        } else if (this.getSecondChild().isFieldExpression()) {
            FieldExpression fieldExpression = (FieldExpression)this.getSecondChild();
            if (!fieldExpression.getBaseExpression().isExpressionBuilder()) {
                return false;
            }
            databaseField = fieldExpression.getField();
        } else if (this.getSecondChild().isQueryKeyExpression()) {
            QueryKeyExpression queryKeyExpression = (QueryKeyExpression)this.getSecondChild();
            if (!queryKeyExpression.getBaseExpression().isExpressionBuilder()) {
                return false;
            }
            DatabaseMapping databaseMapping = classDescriptor.getObjectBuilder().getMappingForAttributeName(queryKeyExpression.getName());
            if (databaseMapping != null) {
                if (!databaseMapping.isPrimaryKeyMapping()) {
                    return false;
                }
                if (databaseMapping.isObjectReferenceMapping() || databaseMapping.isAggregateObjectMapping()) {
                    databaseMapping.writeFromAttributeIntoRow(object, abstractRecord, this.getSession());
                    return true;
                }
                if (!databaseMapping.isDirectToFieldMapping()) {
                    return false;
                }
                databaseField = ((AbstractDirectMapping)databaseMapping).getField();
            } else {
                databaseField = classDescriptor.getObjectBuilder().getFieldForQueryKeyName(queryKeyExpression.getName());
            }
        } else {
            return false;
        }
        if (databaseField == null || !classDescriptor.getPrimaryKeyFields().contains(databaseField)) {
            return false;
        }
        abstractRecord.put(databaseField, object);
        return true;
    }

    public boolean isEqualNull(ExpressionSQLPrinter expressionSQLPrinter) {
        if (this.isObjectComparison()) {
            return false;
        }
        if (this.getOperator().getSelector() != 4) {
            return false;
        }
        if (this.getSecondChild().isConstantExpression() && ((ConstantExpression)this.getSecondChild()).getValue() == null) {
            return true;
        }
        return this.getSecondChild().isParameterExpression() && expressionSQLPrinter.getTranslationRow() != null && ((ParameterExpression)this.getSecondChild()).getValue(expressionSQLPrinter.getTranslationRow(), expressionSQLPrinter.getSession()) == null;
    }

    public boolean isNotEqualNull(ExpressionSQLPrinter expressionSQLPrinter) {
        if (this.isObjectComparison()) {
            return false;
        }
        if (this.getOperator().getSelector() != 5) {
            return false;
        }
        if (this.getSecondChild().isConstantExpression() && ((ConstantExpression)this.getSecondChild()).getValue() == null) {
            return true;
        }
        return this.getSecondChild().isParameterExpression() && expressionSQLPrinter.getTranslationRow() != null && ((ParameterExpression)this.getSecondChild()).getValue(expressionSQLPrinter.getTranslationRow(), expressionSQLPrinter.getSession()) == null;
    }

    protected boolean isObjectComparison() {
        if (this.isObjectComparisonExpression == null) {
            DatabaseMapping databaseMapping;
            this.isObjectComparisonExpression = !this.firstChild.isObjectExpression() || ((ObjectExpression)this.firstChild).isAttribute() ? Boolean.FALSE : ((databaseMapping = ((ObjectExpression)this.firstChild).getMapping()) != null && databaseMapping.isDirectCollectionMapping() ? Boolean.FALSE : Boolean.valueOf(this.secondChild.isObjectExpression() || this.secondChild.isValueExpression() || this.secondChild.isFunctionExpression() && ((FunctionExpression)this.secondChild).getOperator().isAnyOrAll()));
        }
        return this.isObjectComparisonExpression;
    }

    public boolean isRelationExpression() {
        return true;
    }

    public Expression normalize(ExpressionNormalizer expressionNormalizer) {
        Object object;
        Expression expression;
        if (!this.isObjectComparison()) {
            return super.normalize(expressionNormalizer);
        }
        this.validateNode();
        if (this.getOperator().getSelector() != 4 && this.getOperator().getSelector() != 5) {
            throw QueryException.invalidOperatorForObjectComparison(this);
        }
        if (this.getSecondChild().isFunctionExpression() && ((FunctionExpression)(expression = (FunctionExpression)this.getSecondChild())).getOperator().isAnyOrAll()) {
            Expression expression2;
            SubSelectExpression subSelectExpression = (SubSelectExpression)((FunctionExpression)expression).getChildren().elementAt(1);
            ReportQuery reportQuery = subSelectExpression.getSubQuery();
            reportQuery.getItems().clear();
            reportQuery.addItem("one", new ConstantExpression(new Integer(1), reportQuery.getExpressionBuilder()));
            Expression expression3 = reportQuery.getSelectionCriteria();
            ExpressionBuilder expressionBuilder = reportQuery.getExpressionBuilder();
            ExpressionBuilder expressionBuilder2 = this.getFirstChild().getBuilder();
            if (((FunctionExpression)expression).getOperator().isAny()) {
                expression3 = this.getOperator().getSelector() == 4 ? expressionBuilder.equal(this.getFirstChild()).and(expression3) : expressionBuilder.notEqual(this.getFirstChild()).and(expression3);
                reportQuery.setSelectionCriteria(expression3);
                expression2 = expressionBuilder2.exists(reportQuery);
            } else {
                expression3 = this.getOperator().getSelector() == 4 ? expressionBuilder.notEqual(this.getFirstChild()).and(expression3) : expressionBuilder.equal(this.getFirstChild()).and(expression3);
                reportQuery.setSelectionCriteria(expression3);
                expression2 = expressionBuilder2.notExists(reportQuery);
            }
            return expression2.normalize(expressionNormalizer);
        }
        expression = null;
        ObjectExpression objectExpression = (ObjectExpression)this.getFirstChild();
        if (objectExpression.isExpressionBuilder() && this.getSecondChild().isQueryKeyExpression() && !((QueryKeyExpression)this.getSecondChild()).hasDerivedExpressions()) {
            objectExpression = (ExpressionBuilder)objectExpression.normalize(expressionNormalizer);
            object = new Vector(1);
            QueryKeyExpression queryKeyExpression = (QueryKeyExpression)this.getSecondChild();
            if (queryKeyExpression.hasBeenNormalized()) {
                queryKeyExpression.setHasBeenNormalized(false);
            }
            queryKeyExpression = (QueryKeyExpression)queryKeyExpression.normalize(expressionNormalizer, (Vector)object);
            if (!((Vector)object).isEmpty()) {
                expression = (Expression)((Vector)object).firstElement();
                if (objectExpression.getTableAliases() == null) {
                    TableAliasLookup tableAliasLookup = new TableAliasLookup();
                    objectExpression.setTableAliases(tableAliasLookup);
                    queryKeyExpression.setTableAliases(tableAliasLookup);
                } else {
                    queryKeyExpression.setTableAliases(objectExpression.getTableAliases());
                }
            }
        } else if (!objectExpression.isExpressionBuilder() && !((QueryKeyExpression)objectExpression).shouldQueryToManyRelationship() && ((QueryKeyExpression)objectExpression).getMapping() != null) {
            if (objectExpression.getBaseExpression() != null) {
                objectExpression.setBaseExpression(objectExpression.getBaseExpression().normalize(expressionNormalizer));
            }
            if (this.getSecondChild().isConstantExpression()) {
                object = ((ConstantExpression)this.getSecondChild()).getValue();
                expression = objectExpression.getMapping().buildObjectJoinExpression((Expression)objectExpression, object, this.getSession());
            } else if (this.getSecondChild().isObjectExpression() || this.getSecondChild().isParameterExpression()) {
                expression = objectExpression.getMapping().buildObjectJoinExpression((Expression)objectExpression, this.getSecondChild(), this.getSession());
            } else {
                throw QueryException.invalidUseOfToManyQueryKeyInExpression(this);
            }
        }
        if (expression == null) {
            objectExpression = (ObjectExpression)objectExpression.normalize(expressionNormalizer);
            if (this.getSecondChild().isConstantExpression()) {
                object = objectExpression.getDescriptor().getObjectBuilder().buildPrimaryKeyExpressionFromObject(((ConstantExpression)this.getSecondChild()).getValue(), this.getSession());
                expression = objectExpression.twist((Expression)object, objectExpression);
            } else if (this.getSecondChild().isObjectExpression() || this.getSecondChild().isParameterExpression()) {
                expression = objectExpression.twist(objectExpression.getDescriptor().getObjectBuilder().getPrimaryKeyExpression(), this.getSecondChild());
            } else {
                throw QueryException.invalidUseOfToManyQueryKeyInExpression(this);
            }
        }
        if (this.getOperator().getSelector() == 5) {
            expression = expression.not();
        }
        return expression.normalize(expressionNormalizer);
    }

    public boolean performSelector(boolean bl) {
        if (this.getOperator().getSelector() == 4) {
            return bl;
        }
        if (this.getOperator().getSelector() == 5) {
            return !bl;
        }
        throw QueryException.cannotConformExpression();
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        if (this.isEqualNull(expressionSQLPrinter)) {
            this.getFirstChild().isNull().printSQL(expressionSQLPrinter);
        } else if (this.isNotEqualNull(expressionSQLPrinter)) {
            this.getFirstChild().notNull().printSQL(expressionSQLPrinter);
        } else {
            super.printSQL(expressionSQLPrinter);
        }
    }

    public void printJava(ExpressionJavaPrinter expressionJavaPrinter) {
        ExpressionOperator expressionOperator = this.getPlatformOperator(expressionJavaPrinter.getPlatform());
        Expression expression = this.getFirstChild();
        Expression expression2 = this.getSecondChild();
        expressionOperator.printJavaDuo(expression, expression2, expressionJavaPrinter);
    }

    public void printSQLNoParens(ExpressionSQLPrinter expressionSQLPrinter) {
        ExpressionOperator expressionOperator = this.getPlatformOperator(expressionSQLPrinter.getPlatform());
        expressionOperator.printDuo(this.getFirstChild(), this.getSecondChild(), expressionSQLPrinter);
    }

    public void validateNode() {
        if (this.getFirstChild().isTableExpression()) {
            throw QueryException.cannotCompareTablesInExpression(((TableExpression)this.getFirstChild()).getTable());
        }
        if (this.getSecondChild().isTableExpression()) {
            throw QueryException.cannotCompareTablesInExpression(((TableExpression)this.getSecondChild()).getTable());
        }
    }
}

