/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.persistence.logging.SessionLog;

public class DBPlatformHelper {
    private static final String DEFAULTPLATFORM = "org.eclipse.persistence.platform.database.DatabasePlatform";
    private static final String PROPERTY_PATH = "org/eclipse/persistence/internal/helper/";
    private static final String VENDOR_NAME_TO_PLATFORM_RESOURCE_NAME = "org/eclipse/persistence/internal/helper/VendorNameToPlatformMapping.properties";
    private static Properties _nameToVendorPlatform = null;

    public static String getDBPlatform(String string, SessionLog sessionLog) {
        DBPlatformHelper.initializeNameToVendorPlatform(sessionLog);
        String string2 = null;
        if (string != null) {
            string2 = DBPlatformHelper.matchVendorNameInProperties(string, _nameToVendorPlatform, sessionLog);
        }
        if (sessionLog.shouldLog(3)) {
            sessionLog.log(3, "dbPlatformHelper_detectedVendorPlatform", string2);
        }
        if (string2 == null) {
            if (sessionLog.shouldLog(5)) {
                sessionLog.log(5, "dbPlatformHelper_defaultingPlatform", string, DEFAULTPLATFORM);
            }
            string2 = DEFAULTPLATFORM;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties initializeNameToVendorPlatform(SessionLog sessionLog) {
        Class<DBPlatformHelper> clazz = DBPlatformHelper.class;
        synchronized (DBPlatformHelper.class) {
            if (_nameToVendorPlatform == null) {
                _nameToVendorPlatform = new Properties();
                try {
                    DBPlatformHelper.loadFromResource(_nameToVendorPlatform, VENDOR_NAME_TO_PLATFORM_RESOURCE_NAME, DBPlatformHelper.class.getClassLoader());
                }
                catch (IOException iOException) {
                    sessionLog.log(6, "dbPlatformHelper_noMappingFound", VENDOR_NAME_TO_PLATFORM_RESOURCE_NAME);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _nameToVendorPlatform;
        }
    }

    private static String matchVendorNameInProperties(String string, Properties properties, SessionLog sessionLog) {
        String string2 = null;
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (string2 == null && iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string3 = (String)entry.getKey();
            String string4 = (String)entry.getValue();
            if (sessionLog.shouldLog(1)) {
                sessionLog.log(1, "dbPlatformHelper_regExprDbPlatform", string3, string4);
            }
            if (!DBPlatformHelper.matchPattern(string3, string, sessionLog)) continue;
            string2 = string4;
        }
        return string2;
    }

    private static boolean matchPattern(String string, String string2, SessionLog sessionLog) {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = Pattern.matches(string, string2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                if (!sessionLog.shouldLog(3)) break block2;
                sessionLog.log(3, "dbPlatformHelper_patternSyntaxException", patternSyntaxException);
            }
        }
        return bl;
    }

    private static void loadFromResource(Properties properties, String string, ClassLoader classLoader) throws IOException {
        DBPlatformHelper.load(properties, string, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(Properties properties, String string, ClassLoader classLoader) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(DBPlatformHelper.openResourceInputStream(string, classLoader));
        try {
            properties.load(bufferedInputStream);
        }
        finally {
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (Exception exception) {}
        }
    }

    private static InputStream openResourceInputStream(final String string, final ClassLoader classLoader) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (classLoader != null) {
                    return classLoader.getResourceAsStream(string);
                }
                return ClassLoader.getSystemResourceAsStream(string);
            }
        });
    }
}

