/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import java.lang.reflect.Method;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.DomHandler;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import org.eclipse.persistence.jaxb.JAXBErrorHandler;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.eclipse.persistence.sessions.Session;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomHandlerConverter
implements XMLConverter {
    private DomHandler domHandler;
    private XMLTransformer xmlTransformer;
    private Class<? extends DomHandler> domHandlerClass;
    private Class elementClass;
    private Class resultType;

    public DomHandlerConverter(Class<? extends DomHandler> clazz) {
        this.domHandlerClass = clazz;
    }

    @Override
    public void initialize(DatabaseMapping databaseMapping, Session session) {
        try {
            this.domHandler = this.domHandlerClass.newInstance();
            Method method = this.domHandlerClass.getDeclaredMethod("createUnmarshaller", ValidationEventHandler.class);
            this.resultType = method.getReturnType();
            Method method2 = this.domHandlerClass.getDeclaredMethod("getElement", this.resultType);
            this.elementClass = method2.getReturnType();
            this.xmlTransformer = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
            this.xmlTransformer.setFormattedOutput(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public Object convertDataValueToObjectValue(Object object, Session session, XMLUnmarshaller xMLUnmarshaller) {
        if (object instanceof Element) {
            ErrorHandler errorHandler = xMLUnmarshaller.getErrorHandler();
            Result result = null;
            result = errorHandler != null && errorHandler instanceof JAXBErrorHandler ? this.domHandler.createUnmarshaller(((JAXBErrorHandler)errorHandler).getValidationEventHandler()) : this.domHandler.createUnmarshaller(null);
            this.xmlTransformer.transform((Node)((Element)object), result);
            Object object2 = this.domHandler.getElement(result);
            return object2;
        }
        return object;
    }

    @Override
    public Object convertObjectValueToDataValue(Object object, Session session, XMLMarshaller xMLMarshaller) {
        if (this.elementClass.isAssignableFrom(object.getClass())) {
            Source source = this.domHandler.marshal(object, null);
            DOMResult dOMResult = new DOMResult();
            this.xmlTransformer.transform(source, (Result)dOMResult);
            return dOMResult.getNode();
        }
        return object;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public Object convertDataValueToObjectValue(Object object, Session session) {
        return null;
    }

    @Override
    public Object convertObjectValueToDataValue(Object object, Session session) {
        return null;
    }
}

