/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.oxm.XMLRoot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBElementAttributeAccessor
extends AttributeAccessor {
    private AttributeAccessor nestedAccessor;
    private ContainerPolicy containerPolicy;
    private boolean isContainer;
    private Map<QName, Class> qNamesToScopes;
    private static final String JAXB_ELEMENT_CLASSNAME = "javax.xml.bind.JAXBElement";

    public JAXBElementAttributeAccessor(AttributeAccessor attributeAccessor) {
        this.nestedAccessor = attributeAccessor;
        this.isContainer = false;
        this.qNamesToScopes = new HashMap<QName, Class>();
    }

    public JAXBElementAttributeAccessor(AttributeAccessor attributeAccessor, ContainerPolicy containerPolicy) {
        this.nestedAccessor = attributeAccessor;
        this.containerPolicy = containerPolicy;
        this.isContainer = true;
        this.qNamesToScopes = new HashMap<QName, Class>();
    }

    @Override
    public Object getAttributeValueFromObject(Object object) {
        Object object2 = this.nestedAccessor.getAttributeValueFromObject(object);
        if (this.isContainer) {
            Object object3 = this.containerPolicy.containerInstance(this.containerPolicy.sizeFor(object2));
            Object object4 = this.containerPolicy.iteratorFor(object2);
            while (this.containerPolicy.hasNext(object4)) {
                Object object5 = this.containerPolicy.next(object4, null);
                if (object5 instanceof JAXBElement) {
                    JAXBElement jAXBElement = (JAXBElement)object5;
                    XMLRoot xMLRoot = new XMLRoot();
                    xMLRoot.setLocalName(jAXBElement.getName().getLocalPart());
                    xMLRoot.setNamespaceURI(jAXBElement.getName().getNamespaceURI());
                    xMLRoot.setObject(jAXBElement.getValue());
                    this.containerPolicy.addInto((Object)xMLRoot, object3, null);
                    continue;
                }
                this.containerPolicy.addInto(object5, object3, null);
            }
            object2 = object3;
        } else if (object2 != null && object2.getClass().getName().equals(JAXB_ELEMENT_CLASSNAME)) {
            JAXBElement jAXBElement = (JAXBElement)object2;
            XMLRoot xMLRoot = new XMLRoot();
            xMLRoot.setLocalName(jAXBElement.getName().getLocalPart());
            xMLRoot.setNamespaceURI(jAXBElement.getName().getNamespaceURI());
            xMLRoot.setObject(jAXBElement.getValue());
            object2 = xMLRoot;
        }
        return object2;
    }

    @Override
    public void setAttributeValueInObject(Object object, Object object2) {
        Object object3 = object2;
        if (this.isContainer) {
            Object object4 = this.containerPolicy.containerInstance(this.containerPolicy.sizeFor(object3));
            Object object5 = this.containerPolicy.iteratorFor(object3);
            while (this.containerPolicy.hasNext(object5)) {
                Object object6 = this.containerPolicy.next(object5, null);
                Object object7 = this.unwrapObject(object6);
                this.containerPolicy.addInto(object7, object4, null);
            }
            object3 = object4;
        } else {
            object3 = this.unwrapObject(object3);
        }
        this.nestedAccessor.setAttributeValueInObject(object, object3);
    }

    @Override
    public void initializeAttributes(Class clazz) throws DescriptorException {
        this.nestedAccessor.initializeAttributes(clazz);
    }

    private Object unwrapObject(Object object) {
        if (object instanceof XMLRoot) {
            XMLRoot xMLRoot = (XMLRoot)object;
            QName qName = new QName(xMLRoot.getNamespaceURI(), xMLRoot.getLocalName());
            Object object2 = xMLRoot.getObject();
            if (object2 == null) {
                return this.createJAXBElement(qName, Object.class, xMLRoot.getObject());
            }
            return this.createJAXBElement(qName, xMLRoot.getObject().getClass(), xMLRoot.getObject());
        }
        if (object instanceof WrappedValue) {
            Object object3 = ((WrappedValue)object).getWrappedValue();
            Class clazz = ((WrappedValue)object).getWrappedValueClass();
            return this.createJAXBElement(((WrappedValue)object).getQName(), clazz, object3);
        }
        return object;
    }

    private JAXBElement createJAXBElement(QName qName, Class clazz, Object object) {
        if (object != null && object instanceof JAXBElement) {
            return (JAXBElement)object;
        }
        if (ClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(clazz)) {
            clazz = ClassConstants.XML_GREGORIAN_CALENDAR;
        } else if (ClassConstants.DURATION.isAssignableFrom(clazz)) {
            clazz = ClassConstants.DURATION;
        }
        Class clazz2 = this.qNamesToScopes.get(qName);
        return new JAXBElement(qName, clazz, clazz2, object);
    }

    public Map<QName, Class> getQNamesToScopes() {
        return this.qNamesToScopes;
    }

    public void setQNamesToScopes(Map<QName, Class> map) {
        this.qNamesToScopes = map;
    }
}

