/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;

public class MultiArgInstantiationPolicy
extends InstantiationPolicy {
    private String[] parameterTypeNames;
    private Class[] parameterTypes;
    private Object[] defaultValues;

    public void setParameterTypeNames(String[] stringArray) {
        this.parameterTypeNames = stringArray;
    }

    public void setParameterTypes(Class[] classArray) {
        this.parameterTypes = classArray;
    }

    public void setDefaultValues(Object[] objectArray) {
        this.defaultValues = objectArray;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.parameterTypes == null && this.parameterTypeNames != null) {
            Class[] classArray = new Class[this.parameterTypeNames.length];
            for (int i = 0; i < classArray.length; ++i) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            classArray[i] = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.parameterTypeNames[i], true, classLoader));
                            continue;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.parameterTypeNames[i], privilegedActionException.getException());
                        }
                    }
                    classArray[i] = PrivilegedAccessHelper.getClassForName(this.parameterTypeNames[i], true, classLoader);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.factoryClassName, classNotFoundException);
                }
            }
            this.parameterTypes = classArray;
        }
    }

    protected void initializeMethod() throws DescriptorException {
        Class<?> clazz = this.getFactory() == null ? this.getDescriptor().getJavaClass() : this.getFactory().getClass();
        if (this.parameterTypes == null) {
            this.setMethod(this.buildMethod(clazz, this.getMethodName(), new Class[0]));
        } else {
            this.setMethod(this.buildMethod(clazz, this.getMethodName(), this.parameterTypes));
        }
    }

    protected Object buildNewInstanceUsingFactory() throws DescriptorException {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getMethod(), this.getFactory(), this.defaultValues));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    if (exception instanceof IllegalAccessException) {
                        throw DescriptorException.illegalAccessWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), exception);
                    }
                    throw DescriptorException.targetInvocationWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), exception);
                }
            }
            return PrivilegedAccessHelper.invokeMethod(this.getMethod(), this.getFactory(), this.defaultValues);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DescriptorException.illegalAccessWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DescriptorException.targetInvocationWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), invocationTargetException);
        }
        catch (NullPointerException nullPointerException) {
            throw DescriptorException.nullPointerWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), nullPointerException);
        }
    }
}

