/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.Map;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAQuery
extends DatabaseQuery {
    private Enum lockMode;
    private String jpqlString;
    private Map<String, Object> hints;

    public JPAQuery() {
    }

    public JPAQuery(String string) {
        this.jpqlString = string;
    }

    public JPAQuery(String string, String string2, Enum enum_, Map<String, Object> map) {
        this.name = string;
        this.jpqlString = string2;
        this.flushOnExecute = null;
        this.hints = map;
        this.lockMode = enum_;
    }

    @Override
    public String getJPQLString() {
        return this.jpqlString;
    }

    @Override
    public void setJPQLString(String string) {
        this.jpqlString = string;
    }

    public Map<String, Object> getHints() {
        return this.hints;
    }

    public void setHints(Map<String, Object> map) {
        this.hints = map;
    }

    public DatabaseQuery getDatabaseQuery() {
        return (DatabaseQuery)this.getProperty("databasequery");
    }

    public void setDatabaseQuery(DatabaseQuery databaseQuery) {
        this.setProperty("databasequery", databaseQuery);
    }

    @Override
    public void prepare() {
        this.setDatabaseQuery(this.processJPQLQuery(this.getSession()));
    }

    public DatabaseQuery processJPQLQuery(Session session) {
        ClassLoader classLoader = session.getDatasourcePlatform().getConversionManager().getLoader();
        DatabaseQuery databaseQuery = EJBQueryImpl.buildEJBQLDatabaseQuery(this.getName(), this.jpqlString, session, this.lockMode, this.hints, classLoader);
        databaseQuery.setName(this.getName());
        return databaseQuery;
    }

    @Override
    public Object executeDatabaseQuery() throws DatabaseException, OptimisticLockException {
        return this.getSession().executeQuery(this.getDatabaseQuery());
    }
}

