/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Time;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.invalidation.DailyCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.history.AsOfSCNClause;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.CursorPolicy;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.DirectReadQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.ModifyAllQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ResultSetMappingQuery;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.queries.UpdateAllQuery;
import org.eclipse.persistence.queries.ValueReadQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryHintsHandler {
    public static void verify(Map map, String string, AbstractSession abstractSession) {
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            String string2 = (String)entry.getKey();
            QueryHintsHandler.verify(string2, entry.getValue(), string, abstractSession);
        }
    }

    public static void verify(String string, Object object, String string2, AbstractSession abstractSession) {
        Hint.verify(string, QueryHintsHandler.shouldUseDefault(object), object, string2, abstractSession);
    }

    public static DatabaseQuery apply(Map<String, Object> map, DatabaseQuery databaseQuery, ClassLoader classLoader) {
        if (map == null) {
            return databaseQuery;
        }
        DatabaseQuery databaseQuery2 = databaseQuery;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string = entry.getKey();
            if (entry.getValue() instanceof Object[]) {
                Object[] objectArray = (Object[])entry.getValue();
                for (int i = 0; i < objectArray.length; ++i) {
                    databaseQuery2 = QueryHintsHandler.apply(string, objectArray[i], databaseQuery2, classLoader);
                }
                continue;
            }
            databaseQuery2 = QueryHintsHandler.apply(string, entry.getValue(), databaseQuery2, classLoader);
        }
        return databaseQuery2;
    }

    public static DatabaseQuery apply(String string, Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
        return Hint.apply(string, QueryHintsHandler.shouldUseDefault(object), object, databaseQuery, classLoader);
    }

    public static boolean parseBooleanHint(Object object) {
        if (object == null) {
            return false;
        }
        return Boolean.valueOf(object.toString());
    }

    public static int parseIntegerHint(Object object, String string) {
        if (object == null) {
            return -1;
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw QueryException.queryHintContainedInvalidIntegerValue(string, object, numberFormatException);
        }
    }

    protected static boolean shouldUseDefault(Object object) {
        return object != null && object instanceof String && ((String)object).length() == 0;
    }

    protected static class RedirectorHint
    extends Hint {
        RedirectorHint() {
            super("eclipselink.query.redirector", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            try {
                Object object2 = object;
                if (object instanceof Class) {
                    object2 = RedirectorHint.newInstance((Class)object, databaseQuery, "eclipselink.query.redirector");
                } else if (object instanceof String) {
                    Class clazz = RedirectorHint.loadClass((String)object, databaseQuery, classLoader);
                    object2 = RedirectorHint.newInstance(clazz, databaseQuery, "eclipselink.query.redirector");
                }
                databaseQuery.setRedirector((QueryRedirector)object2);
            }
            catch (ClassCastException classCastException) {
                throw QueryException.unableToSetRedirectorOnQueryFromHint(databaseQuery, "eclipselink.query.redirector", object.getClass().getName(), classCastException);
            }
            return databaseQuery;
        }
    }

    protected static class ResultCollectionTypeHint
    extends Hint {
        ResultCollectionTypeHint() {
            super("eclipselink.result-collection-type", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (!databaseQuery.isReadAllQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{ResultCollectionTypeHint.getQueryId(databaseQuery), this.name, ResultCollectionTypeHint.getPrintValue(object)}));
            }
            Class clazz = null;
            clazz = object instanceof String ? ResultCollectionTypeHint.loadClass((String)object, databaseQuery, classLoader) : (Class)object;
            ((ReadAllQuery)databaseQuery).useCollectionClass(clazz);
            return databaseQuery;
        }
    }

    protected static class JDBCFirstResultHint
    extends Hint {
        JDBCFirstResultHint() {
            super("eclipselink.jdbc.first-result", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (!databaseQuery.isReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{JDBCFirstResultHint.getQueryId(databaseQuery), this.name, JDBCFirstResultHint.getPrintValue(object)}));
            }
            ((ReadQuery)databaseQuery).setFirstResult(QueryHintsHandler.parseIntegerHint(object, "eclipselink.jdbc.first-result"));
            return databaseQuery;
        }
    }

    protected static class JDBCMaxRowsHint
    extends Hint {
        JDBCMaxRowsHint() {
            super("eclipselink.jdbc.max-rows", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (!databaseQuery.isReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{JDBCMaxRowsHint.getQueryId(databaseQuery), this.name, JDBCMaxRowsHint.getPrintValue(object)}));
            }
            ((ReadQuery)databaseQuery).setMaxRows(QueryHintsHandler.parseIntegerHint(object, "eclipselink.jdbc.max-rows"));
            return databaseQuery;
        }
    }

    protected static class AsOfSCNHint
    extends Hint {
        AsOfSCNHint() {
            super("eclipselink.history.as-of.scn", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (!databaseQuery.isObjectLevelReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{AsOfSCNHint.getQueryId(databaseQuery), this.name, AsOfSCNHint.getPrintValue(object)}));
            }
            ((ObjectLevelReadQuery)databaseQuery).setAsOfClause(new AsOfSCNClause(QueryHintsHandler.parseIntegerHint(object, "eclipselink.history.as-of.scn")));
            return databaseQuery;
        }
    }

    protected static class AsOfHint
    extends Hint {
        AsOfHint() {
            super("eclipselink.history.as-of", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (!databaseQuery.isObjectLevelReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{AsOfHint.getQueryId(databaseQuery), this.name, AsOfHint.getPrintValue(object)}));
            }
            ((ObjectLevelReadQuery)databaseQuery).setAsOfClause(new AsOfClause(Helper.timeFromString((String)object)));
            return databaseQuery;
        }
    }

    protected static class JDBCFetchSizeHint
    extends Hint {
        JDBCFetchSizeHint() {
            super("eclipselink.jdbc.fetch-size", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (!databaseQuery.isReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{JDBCFetchSizeHint.getQueryId(databaseQuery), this.name, JDBCFetchSizeHint.getPrintValue(object)}));
            }
            ((ReadQuery)databaseQuery).setFetchSize(QueryHintsHandler.parseIntegerHint(object, "eclipselink.jdbc.fetch-size"));
            return databaseQuery;
        }
    }

    protected static class JDBCTimeoutHint
    extends Hint {
        JDBCTimeoutHint() {
            super("eclipselink.jdbc.timeout", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            databaseQuery.setQueryTimeout(QueryHintsHandler.parseIntegerHint(object, "eclipselink.jdbc.timeout"));
            return databaseQuery;
        }
    }

    protected static class HintHint
    extends Hint {
        HintHint() {
            super("eclipselink.sql.hint", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            databaseQuery.setHintString((String)object);
            return databaseQuery;
        }
    }

    protected static class FlushHint
    extends Hint {
        FlushHint() {
            super("eclipselink.flush", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            databaseQuery.setFlushOnExecute((Boolean)object);
            return databaseQuery;
        }
    }

    protected static class CacheStatementHint
    extends Hint {
        CacheStatementHint() {
            super("eclipselink.jdbc.cache-statement", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            databaseQuery.setShouldCacheStatement((Boolean)object);
            return databaseQuery;
        }
    }

    protected static class PrepareHint
    extends Hint {
        PrepareHint() {
            super("eclipselink.prepare", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            databaseQuery.setShouldPrepare((Boolean)object);
            return databaseQuery;
        }
    }

    protected static class MaintainCacheHint
    extends Hint {
        MaintainCacheHint() {
            super("eclipselink.maintain-cache", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            databaseQuery.setShouldMaintainCache((Boolean)object);
            return databaseQuery;
        }
    }

    protected static class ScrollableCursorHint
    extends Hint {
        ScrollableCursorHint() {
            super("eclipselink.cursor.scrollable", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (!((Boolean)object).booleanValue()) {
                if (databaseQuery.isReadAllQuery()) {
                    if (((ReadAllQuery)databaseQuery).getContainerPolicy().isScrollableCursorPolicy()) {
                        ((ReadAllQuery)databaseQuery).setContainerPolicy(ContainerPolicy.buildDefaultPolicy());
                    }
                } else if (databaseQuery.isDataReadQuery() && ((DataReadQuery)databaseQuery).getContainerPolicy().isScrollableCursorPolicy()) {
                    ((DataReadQuery)databaseQuery).setContainerPolicy(ContainerPolicy.buildDefaultPolicy());
                }
            } else if (databaseQuery.isReadAllQuery()) {
                if (!((ReadAllQuery)databaseQuery).getContainerPolicy().isScrollableCursorPolicy()) {
                    ((ReadAllQuery)databaseQuery).useScrollableCursor();
                }
            } else if (databaseQuery.isDataReadQuery()) {
                if (!((DataReadQuery)databaseQuery).getContainerPolicy().isScrollableCursorPolicy()) {
                    ((DataReadQuery)databaseQuery).useScrollableCursor();
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{ScrollableCursorHint.getQueryId(databaseQuery), this.name, ScrollableCursorHint.getPrintValue(object)}));
            }
            return databaseQuery;
        }
    }

    protected static class CursorSizeHint
    extends Hint {
        CursorSizeHint() {
            super("eclipselink.cursor.size-sql", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (databaseQuery.isReadAllQuery()) {
                if (!((ReadAllQuery)databaseQuery).getContainerPolicy().isCursoredStreamPolicy()) {
                    ((ReadAllQuery)databaseQuery).useCursoredStream();
                }
                ((CursoredStreamPolicy)((ReadAllQuery)databaseQuery).getContainerPolicy()).setSizeQuery(new ValueReadQuery((String)object));
            } else if (databaseQuery.isDataReadQuery()) {
                if (!((DataReadQuery)databaseQuery).getContainerPolicy().isCursoredStreamPolicy()) {
                    ((DataReadQuery)databaseQuery).useCursoredStream();
                }
                ((CursoredStreamPolicy)((ReadAllQuery)databaseQuery).getContainerPolicy()).setSizeQuery(new ValueReadQuery((String)object));
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{CursorSizeHint.getQueryId(databaseQuery), this.name, CursorSizeHint.getPrintValue(object)}));
            }
            return databaseQuery;
        }
    }

    protected static class CursorPageSizeHint
    extends Hint {
        CursorPageSizeHint() {
            super("eclipselink.cursor.page-size", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (databaseQuery.isReadAllQuery()) {
                if (!((ReadAllQuery)databaseQuery).getContainerPolicy().isCursorPolicy()) {
                    ((ReadAllQuery)databaseQuery).useCursoredStream();
                }
                ((CursorPolicy)((ReadAllQuery)databaseQuery).getContainerPolicy()).setPageSize(QueryHintsHandler.parseIntegerHint(object, "eclipselink.cursor.page-size"));
            } else if (databaseQuery.isDataReadQuery()) {
                if (!((DataReadQuery)databaseQuery).getContainerPolicy().isCursorPolicy()) {
                    ((DataReadQuery)databaseQuery).useCursoredStream();
                }
                ((CursorPolicy)((DataReadQuery)databaseQuery).getContainerPolicy()).setPageSize(QueryHintsHandler.parseIntegerHint(object, "eclipselink.cursor.page-size"));
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{CursorPageSizeHint.getQueryId(databaseQuery), this.name, CursorPageSizeHint.getPrintValue(object)}));
            }
            return databaseQuery;
        }
    }

    protected static class CursorInitialSizeHint
    extends Hint {
        CursorInitialSizeHint() {
            super("eclipselink.cursor.initial-size", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (databaseQuery.isReadAllQuery()) {
                if (!((ReadAllQuery)databaseQuery).getContainerPolicy().isCursoredStreamPolicy()) {
                    ((ReadAllQuery)databaseQuery).useCursoredStream();
                }
                ((CursoredStreamPolicy)((ReadAllQuery)databaseQuery).getContainerPolicy()).setInitialReadSize(QueryHintsHandler.parseIntegerHint(object, "eclipselink.cursor.initial-size"));
            } else if (databaseQuery.isDataReadQuery()) {
                if (!((DataReadQuery)databaseQuery).getContainerPolicy().isCursoredStreamPolicy()) {
                    ((DataReadQuery)databaseQuery).useCursoredStream();
                }
                ((CursoredStreamPolicy)((DataReadQuery)databaseQuery).getContainerPolicy()).setInitialReadSize(QueryHintsHandler.parseIntegerHint(object, "eclipselink.cursor.initial-size"));
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{CursorInitialSizeHint.getQueryId(databaseQuery), this.name, CursorInitialSizeHint.getPrintValue(object)}));
            }
            return databaseQuery;
        }
    }

    protected static class CursorHint
    extends Hint {
        CursorHint() {
            super("eclipselink.cursor", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (!((Boolean)object).booleanValue()) {
                if (databaseQuery.isReadAllQuery()) {
                    if (((ReadAllQuery)databaseQuery).getContainerPolicy().isCursoredStreamPolicy()) {
                        ((ReadAllQuery)databaseQuery).setContainerPolicy(ContainerPolicy.buildDefaultPolicy());
                    }
                } else if (databaseQuery.isDataReadQuery() && ((DataReadQuery)databaseQuery).getContainerPolicy().isCursoredStreamPolicy()) {
                    ((DataReadQuery)databaseQuery).setContainerPolicy(ContainerPolicy.buildDefaultPolicy());
                }
            } else if (databaseQuery.isReadAllQuery()) {
                if (!((ReadAllQuery)databaseQuery).getContainerPolicy().isCursoredStreamPolicy()) {
                    ((ReadAllQuery)databaseQuery).useCursoredStream();
                }
            } else if (databaseQuery.isDataReadQuery()) {
                if (!((DataReadQuery)databaseQuery).getContainerPolicy().isCursoredStreamPolicy()) {
                    ((DataReadQuery)databaseQuery).useCursoredStream();
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{CursorHint.getQueryId(databaseQuery), this.name, CursorHint.getPrintValue(object)}));
            }
            return databaseQuery;
        }
    }

    protected static class NativeConnectionHint
    extends Hint {
        NativeConnectionHint() {
            super("eclipselink.jdbc.native-connection", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            databaseQuery.setIsNativeConnectionRequired((Boolean)object);
            return databaseQuery;
        }
    }

    protected static class ReadOnlyHint
    extends Hint {
        ReadOnlyHint() {
            super("eclipselink.read-only", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (!databaseQuery.isObjectLevelReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{ReadOnlyHint.getQueryId(databaseQuery), this.name, ReadOnlyHint.getPrintValue(object)}));
            }
            ((ObjectLevelReadQuery)databaseQuery).setIsReadOnly((Boolean)object);
            return databaseQuery;
        }
    }

    protected static class LeftFetchHint
    extends Hint {
        LeftFetchHint() {
            super("eclipselink.left-join-fetch", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            Expression expression;
            ObjectLevelReadQuery objectLevelReadQuery;
            if (databaseQuery.isObjectLevelReadQuery() && !databaseQuery.isReportQuery()) {
                objectLevelReadQuery = (ObjectLevelReadQuery)databaseQuery;
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, ".");
                if (stringTokenizer.countTokens() < 2) {
                    throw QueryException.queryHintDidNotContainEnoughTokens(databaseQuery, "eclipselink.left-join-fetch", object);
                }
                String string = stringTokenizer.nextToken();
                ClassDescriptor classDescriptor = objectLevelReadQuery.getDescriptor();
                expression = objectLevelReadQuery.getExpressionBuilder();
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    ForeignReferenceMapping foreignReferenceMapping = null;
                    DatabaseMapping databaseMapping = classDescriptor.getObjectBuilder().getMappingForAttributeName(string2);
                    if (databaseMapping == null) {
                        throw QueryException.queryHintNavigatedNonExistantRelationship(databaseQuery, "eclipselink.left-join-fetch", object, string + "." + string2);
                    }
                    if (!databaseMapping.isForeignReferenceMapping()) {
                        throw QueryException.queryHintNavigatedIllegalRelationship(databaseQuery, "eclipselink.left-join-fetch", object, string + "." + string2);
                    }
                    foreignReferenceMapping = (ForeignReferenceMapping)databaseMapping;
                    classDescriptor = foreignReferenceMapping.getReferenceDescriptor();
                    expression = foreignReferenceMapping.isCollectionMapping() ? ((Expression)expression).anyOfAllowingNone(string2) : expression.getAllowingNull(string2);
                    string = string2;
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{LeftFetchHint.getQueryId(databaseQuery), this.name, LeftFetchHint.getPrintValue(object)}));
            }
            objectLevelReadQuery.addJoinedAttribute(expression);
            return databaseQuery;
        }
    }

    protected static class FetchHint
    extends Hint {
        FetchHint() {
            super("eclipselink.join-fetch", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            Expression expression;
            ObjectLevelReadQuery objectLevelReadQuery;
            if (databaseQuery.isObjectLevelReadQuery() && !databaseQuery.isReportQuery()) {
                objectLevelReadQuery = (ObjectLevelReadQuery)databaseQuery;
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, ".");
                if (stringTokenizer.countTokens() < 2) {
                    throw QueryException.queryHintDidNotContainEnoughTokens(databaseQuery, "eclipselink.join-fetch", object);
                }
                String string = stringTokenizer.nextToken();
                ClassDescriptor classDescriptor = objectLevelReadQuery.getDescriptor();
                expression = objectLevelReadQuery.getExpressionBuilder();
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    ForeignReferenceMapping foreignReferenceMapping = null;
                    DatabaseMapping databaseMapping = classDescriptor.getObjectBuilder().getMappingForAttributeName(string2);
                    if (databaseMapping == null) {
                        throw QueryException.queryHintNavigatedNonExistantRelationship(databaseQuery, "eclipselink.join-fetch", object, string + "." + string2);
                    }
                    if (!databaseMapping.isForeignReferenceMapping()) {
                        throw QueryException.queryHintNavigatedIllegalRelationship(databaseQuery, "eclipselink.join-fetch", object, string + "." + string2);
                    }
                    foreignReferenceMapping = (ForeignReferenceMapping)databaseMapping;
                    classDescriptor = foreignReferenceMapping.getReferenceDescriptor();
                    expression = foreignReferenceMapping.isCollectionMapping() ? ((Expression)expression).anyOf(string2) : expression.get(string2);
                    string = string2;
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{FetchHint.getQueryId(databaseQuery), this.name, FetchHint.getPrintValue(object)}));
            }
            objectLevelReadQuery.addJoinedAttribute(expression);
            return databaseQuery;
        }
    }

    protected static class BatchHint
    extends Hint {
        BatchHint() {
            super("eclipselink.batch", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            Expression expression;
            ReadAllQuery readAllQuery;
            if (databaseQuery.isReadAllQuery() && !databaseQuery.isReportQuery()) {
                readAllQuery = (ReadAllQuery)databaseQuery;
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, ".");
                if (stringTokenizer.countTokens() < 2) {
                    throw QueryException.queryHintDidNotContainEnoughTokens(databaseQuery, "eclipselink.batch", object);
                }
                String string = stringTokenizer.nextToken();
                ClassDescriptor classDescriptor = readAllQuery.getDescriptor();
                expression = readAllQuery.getExpressionBuilder();
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    ForeignReferenceMapping foreignReferenceMapping = null;
                    DatabaseMapping databaseMapping = classDescriptor.getObjectBuilder().getMappingForAttributeName(string2);
                    if (databaseMapping == null) {
                        throw QueryException.queryHintNavigatedNonExistantRelationship(databaseQuery, "eclipselink.batch", object, string + "." + string2);
                    }
                    if (!databaseMapping.isForeignReferenceMapping()) {
                        throw QueryException.queryHintNavigatedIllegalRelationship(databaseQuery, "eclipselink.batch", object, string + "." + string2);
                    }
                    foreignReferenceMapping = (ForeignReferenceMapping)databaseMapping;
                    classDescriptor = foreignReferenceMapping.getReferenceDescriptor();
                    expression = foreignReferenceMapping.isCollectionMapping() ? ((Expression)expression).anyOf(string2) : expression.get(string2);
                    string = string2;
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{BatchHint.getQueryId(databaseQuery), this.name, BatchHint.getPrintValue(object)}));
            }
            readAllQuery.addBatchReadAttribute(expression);
            return databaseQuery;
        }
    }

    protected static class QueryCacheExpiryTimeOfDayHint
    extends Hint {
        QueryCacheExpiryTimeOfDayHint() {
            super("eclipselink.query-results-cache.expiry-time-of-day", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (databaseQuery.isReadQuery()) {
                ReadQuery readQuery = (ReadQuery)databaseQuery;
                if (readQuery.getQueryResultsCachePolicy() == null) {
                    readQuery.cacheQueryResults();
                }
                try {
                    Time time = Helper.timeFromString((String)object);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(time);
                    readQuery.getQueryResultsCachePolicy().setCacheInvalidationPolicy(new DailyCacheInvalidationPolicy(calendar.get(11), calendar.get(12), calendar.get(13), 0));
                }
                catch (ConversionException conversionException) {
                    throw QueryException.queryHintContainedInvalidIntegerValue("eclipselink.query-results-cache.expiry-time-of-day", object, conversionException);
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{QueryCacheExpiryTimeOfDayHint.getQueryId(databaseQuery), this.name, QueryCacheExpiryTimeOfDayHint.getPrintValue(object)}));
            }
            return databaseQuery;
        }
    }

    protected static class QueryCacheExpiryHint
    extends Hint {
        QueryCacheExpiryHint() {
            super("eclipselink.query-results-cache.expiry", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (databaseQuery.isReadQuery()) {
                ReadQuery readQuery = (ReadQuery)databaseQuery;
                if (readQuery.getQueryResultsCachePolicy() == null) {
                    readQuery.cacheQueryResults();
                }
                try {
                    readQuery.getQueryResultsCachePolicy().setCacheInvalidationPolicy(new TimeToLiveCacheInvalidationPolicy(Integer.parseInt((String)object)));
                }
                catch (NumberFormatException numberFormatException) {
                    throw QueryException.queryHintContainedInvalidIntegerValue("eclipselink.query-results-cache.expiry", object, numberFormatException);
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{QueryCacheExpiryHint.getQueryId(databaseQuery), this.name, QueryCacheExpiryHint.getPrintValue(object)}));
            }
            return databaseQuery;
        }
    }

    protected static class QueryCacheSizeHint
    extends Hint {
        QueryCacheSizeHint() {
            super("eclipselink.query-results-cache.size", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (databaseQuery.isReadQuery()) {
                ReadQuery readQuery = (ReadQuery)databaseQuery;
                if (readQuery.getQueryResultsCachePolicy() == null) {
                    readQuery.cacheQueryResults();
                }
                try {
                    readQuery.getQueryResultsCachePolicy().setMaximumCachedResults(Integer.parseInt((String)object));
                }
                catch (NumberFormatException numberFormatException) {
                    throw QueryException.queryHintContainedInvalidIntegerValue("eclipselink.query-results-cache.size", object, numberFormatException);
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{QueryCacheSizeHint.getQueryId(databaseQuery), this.name, QueryCacheSizeHint.getPrintValue(object)}));
            }
            return databaseQuery;
        }
    }

    protected static class QueryCacheHint
    extends Hint {
        QueryCacheHint() {
            super("eclipselink.query-results-cache", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (databaseQuery.isReadQuery()) {
                if (((Boolean)object).booleanValue() && ((ReadQuery)databaseQuery).getQueryResultsCachePolicy() == null) {
                    ((ReadQuery)databaseQuery).cacheQueryResults();
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{QueryCacheHint.getQueryId(databaseQuery), this.name, QueryCacheHint.getPrintValue(object)}));
            }
            return databaseQuery;
        }
    }

    protected static class FetchGroupAttributeHint
    extends Hint {
        FetchGroupAttributeHint() {
            super("eclipselink.fetch-group.attribute", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            FetchGroup fetchGroup;
            if (databaseQuery.isObjectLevelReadQuery()) {
                fetchGroup = ((ObjectLevelReadQuery)databaseQuery).getFetchGroup();
                if (fetchGroup == null) {
                    fetchGroup = new FetchGroup();
                    ((ObjectLevelReadQuery)databaseQuery).setFetchGroup(fetchGroup);
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{FetchGroupAttributeHint.getQueryId(databaseQuery), this.name, FetchGroupAttributeHint.getPrintValue(object)}));
            }
            fetchGroup.addAttribute((String)object);
            return databaseQuery;
        }
    }

    protected static class FetchGroupHint
    extends Hint {
        FetchGroupHint() {
            super("eclipselink.fetch-group", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (!databaseQuery.isObjectLevelReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{FetchGroupHint.getQueryId(databaseQuery), this.name, FetchGroupHint.getPrintValue(object)}));
            }
            ((ObjectLevelReadQuery)databaseQuery).setFetchGroup((FetchGroup)object);
            return databaseQuery;
        }
    }

    protected static class FetchGroupNameHint
    extends Hint {
        FetchGroupNameHint() {
            super("eclipselink.fetch-group.name", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (!databaseQuery.isObjectLevelReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{FetchGroupNameHint.getQueryId(databaseQuery), this.name, FetchGroupNameHint.getPrintValue(object)}));
            }
            ((ObjectLevelReadQuery)databaseQuery).setFetchGroupName((String)object);
            return databaseQuery;
        }
    }

    protected static class FetchGroupDefaultHint
    extends Hint {
        FetchGroupDefaultHint() {
            super("eclipselink.fetch-group.default", "True");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (!databaseQuery.isObjectLevelReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{FetchGroupDefaultHint.getQueryId(databaseQuery), this.name, FetchGroupDefaultHint.getPrintValue(object)}));
            }
            ((ObjectLevelReadQuery)databaseQuery).setShouldUseDefaultFetchGroup((Boolean)object);
            return databaseQuery;
        }
    }

    protected static class InheritanceJoinHint
    extends Hint {
        InheritanceJoinHint() {
            super("eclipselink.inheritance.outer-join", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (!databaseQuery.isObjectLevelReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{InheritanceJoinHint.getQueryId(databaseQuery), this.name, InheritanceJoinHint.getPrintValue(object)}));
            }
            ((ObjectLevelReadQuery)databaseQuery).setShouldOuterJoinSubclasses((Boolean)object);
            return databaseQuery;
        }
    }

    protected static class ExclusiveHint
    extends Hint {
        ExclusiveHint() {
            super("eclipselink.exclusive-connection", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (!databaseQuery.isObjectBuildingQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{ExclusiveHint.getQueryId(databaseQuery), this.name, ExclusiveHint.getPrintValue(object)}));
            }
            ((ObjectBuildingQuery)databaseQuery).setShouldUseExclusiveConnection((Boolean)object);
            return databaseQuery;
        }
    }

    protected static class ResultSetConcurrencyHint
    extends Hint {
        ResultSetConcurrencyHint() {
            super("eclipselink.cursor.scrollable.result-set-concurrency", "Updatable");
            this.valueArray = new Object[][]{{"ReadOnly", 1007}, {"Updatable", 1008}};
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            int n = (Integer)object;
            if (databaseQuery.isReadAllQuery()) {
                if (!((ReadAllQuery)databaseQuery).getContainerPolicy().isScrollableCursorPolicy()) {
                    ((ReadAllQuery)databaseQuery).useScrollableCursor();
                }
                ((ScrollableCursorPolicy)((ReadAllQuery)databaseQuery).getContainerPolicy()).setResultSetConcurrency(n);
            } else if (databaseQuery.isDataReadQuery()) {
                if (!((DataReadQuery)databaseQuery).getContainerPolicy().isScrollableCursorPolicy()) {
                    ((DataReadQuery)databaseQuery).useScrollableCursor();
                }
                ((ScrollableCursorPolicy)((DataReadQuery)databaseQuery).getContainerPolicy()).setResultSetConcurrency(n);
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{ResultSetConcurrencyHint.getQueryId(databaseQuery), this.name, ResultSetConcurrencyHint.getPrintValue(object)}));
            }
            return databaseQuery;
        }
    }

    protected static class ResultSetTypeHint
    extends Hint {
        ResultSetTypeHint() {
            super("eclipselink.cursor.scrollable.result-set-type", "ScrollInsensitive");
            this.valueArray = new Object[][]{{"Forward", 1000}, {"ForwardOnly", 1003}, {"Reverse", 1001}, {"ScrollInsensitive", 1004}, {"ScrollSensitive", 1005}, {"Unknown", 1002}};
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            int n = (Integer)object;
            if (databaseQuery.isReadAllQuery()) {
                if (!((ReadAllQuery)databaseQuery).getContainerPolicy().isScrollableCursorPolicy()) {
                    ((ReadAllQuery)databaseQuery).useScrollableCursor();
                }
                ((ScrollableCursorPolicy)((ReadAllQuery)databaseQuery).getContainerPolicy()).setResultSetType(n);
            } else if (databaseQuery.isDataReadQuery()) {
                if (!((DataReadQuery)databaseQuery).getContainerPolicy().isScrollableCursorPolicy()) {
                    ((DataReadQuery)databaseQuery).useScrollableCursor();
                }
                ((ScrollableCursorPolicy)((DataReadQuery)databaseQuery).getContainerPolicy()).setResultSetType(n);
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{ResultSetTypeHint.getQueryId(databaseQuery), this.name, ResultSetTypeHint.getPrintValue(object)}));
            }
            return databaseQuery;
        }
    }

    protected static class IndirectionPolicyHint
    extends Hint {
        IndirectionPolicyHint() {
            super("eclipselink.cache-usage.indirection-policy", "Exception");
            this.valueArray = new Object[][]{{"Conform", 2}, {"NotConform", 2}, {"Trigger", 1}, {"Exception", 0}};
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (!databaseQuery.isObjectLevelReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{IndirectionPolicyHint.getQueryId(databaseQuery), this.name, IndirectionPolicyHint.getPrintValue(object)}));
            }
            ((ObjectLevelReadQuery)databaseQuery).setInMemoryQueryIndirectionPolicyState((Integer)object);
            return databaseQuery;
        }
    }

    protected static class ResultTypeHint
    extends Hint {
        ResultTypeHint() {
            super("eclipselink.result-type", "Array");
            this.valueArray = new Object[][]{{"Map", "Map"}, {"Array", "Array"}, {"Value", "Value"}, {"Attribute", "Attribute"}};
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (databaseQuery.isDataReadQuery()) {
                if (object == "Map") {
                    ((DataReadQuery)databaseQuery).setResultType(0);
                } else if (object == "Array") {
                    ((DataReadQuery)databaseQuery).setResultType(1);
                } else if (object == "Attribute") {
                    ((DataReadQuery)databaseQuery).setResultType(3);
                } else if (object == "Value") {
                    ((DataReadQuery)databaseQuery).setResultType(2);
                }
            } else if (databaseQuery.isReportQuery()) {
                if (object == "Map") {
                    ((ReportQuery)databaseQuery).setReturnType(0);
                } else if (object == "Array") {
                    ((ReportQuery)databaseQuery).setReturnType(5);
                } else if (object == "Attribute") {
                    ((ReportQuery)databaseQuery).setReturnType(3);
                } else if (object == "Value") {
                    ((ReportQuery)databaseQuery).setReturnType(2);
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{ResultTypeHint.getQueryId(databaseQuery), this.name, ResultTypeHint.getPrintValue(object)}));
            }
            return databaseQuery;
        }
    }

    protected static class RefreshHint
    extends Hint {
        RefreshHint() {
            super("eclipselink.refresh", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (!databaseQuery.isObjectBuildingQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{RefreshHint.getQueryId(databaseQuery), this.name, RefreshHint.getPrintValue(object)}));
            }
            ((ObjectBuildingQuery)databaseQuery).setShouldRefreshIdentityMapResult((Boolean)object);
            return databaseQuery;
        }
    }

    protected static class PessimisticLockTimeoutHint
    extends Hint {
        PessimisticLockTimeoutHint() {
            super("javax.persistence.lock.timeout", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (!databaseQuery.isObjectLevelReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{PessimisticLockTimeoutHint.getQueryId(databaseQuery), this.name, PessimisticLockTimeoutHint.getPrintValue(object)}));
            }
            ((ObjectLevelReadQuery)databaseQuery).setWaitTimeout(QueryHintsHandler.parseIntegerHint(object, "javax.persistence.lock.timeout"));
            return databaseQuery;
        }
    }

    protected static class PessimisticLockHint
    extends Hint {
        PessimisticLockHint() {
            super("eclipselink.pessimistic-lock", "NoLock");
            this.valueArray = new Object[][]{{"NoLock", (short)0}, {"Lock", (short)1}, {"LockNoWait", (short)2}};
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (!databaseQuery.isObjectBuildingQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{PessimisticLockHint.getQueryId(databaseQuery), this.name, PessimisticLockHint.getPrintValue(object)}));
            }
            ((ObjectBuildingQuery)databaseQuery).setLockMode((Short)object);
            return databaseQuery;
        }
    }

    protected static class QueryTypeHint
    extends Hint {
        QueryTypeHint() {
            super("eclipselink.query-type", "Auto");
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (object.equals("Auto")) {
                return databaseQuery;
            }
            DatabaseQuery databaseQuery2 = databaseQuery;
            if (object.equals("ReadAll")) {
                databaseQuery2 = new ReadAllQuery();
            } else if (object.equals("ReadObject")) {
                databaseQuery2 = new ReadObjectQuery();
            } else if (object.equals("Report")) {
                databaseQuery2 = new ReportQuery();
                if (databaseQuery.isObjectLevelReadQuery()) {
                    ((ReportQuery)databaseQuery2).addAttribute("root", ((ReportQuery)databaseQuery2).getExpressionBuilder());
                }
            } else if (object.equals("ResultSetMapping")) {
                databaseQuery2 = new ResultSetMappingQuery();
            } else if (object.equals("UpdateAll")) {
                databaseQuery2 = new UpdateAllQuery();
            } else if (object.equals("DeleteAll")) {
                databaseQuery2 = new DeleteAllQuery();
            } else if (object.equals("DataModify")) {
                databaseQuery2 = new DataModifyQuery();
            } else if (object.equals("DataRead")) {
                databaseQuery2 = new DataReadQuery();
            } else if (object.equals("DirectRead")) {
                databaseQuery2 = new DirectReadQuery();
            } else if (object.equals("ValueRead")) {
                databaseQuery2 = new ValueReadQuery();
            } else {
                Class clazz = QueryTypeHint.loadClass((String)object, databaseQuery, classLoader);
                databaseQuery2 = (DatabaseQuery)QueryTypeHint.newInstance(clazz, databaseQuery, "eclipselink.query-type");
            }
            databaseQuery2.copyFromQuery(databaseQuery);
            return databaseQuery2;
        }
    }

    protected static class CascadePolicyHint
    extends Hint {
        CascadePolicyHint() {
            super("eclipselink.refresh.cascade", "CascadeByMapping");
            this.valueArray = new Object[][]{{"NoCascading", 1}, {"CascadePrivateParts", 2}, {"CascadeAllParts", 3}, {"CascadeByMapping", 6}};
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            databaseQuery.setCascadePolicy((Integer)object);
            return databaseQuery;
        }
    }

    protected static class CacheUsageHint
    extends Hint {
        CacheUsageHint() {
            super("eclipselink.cache-usage", "UseEntityDefault");
            this.valueArray = new Object[][]{{"UseEntityDefault", -1}, {"DoNotCheckCache", 0}, {"CheckCacheByExactPrimaryKey", 1}, {"CheckCacheByPrimaryKey", 2}, {"CheckCacheThenDatabase", 3}, {"CheckCacheOnly", 4}, {"ConformResultsInUnitOfWork", 5}, {"NoCache", 0}, {"Invalidate", 1}};
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (databaseQuery.isObjectLevelReadQuery()) {
                int n = (Integer)object;
                ((ObjectLevelReadQuery)databaseQuery).setCacheUsage(n);
                if (n == 1 || n == 2 || n == 3) {
                    ReadObjectQuery readObjectQuery = new ReadObjectQuery();
                    readObjectQuery.copyFromQuery(databaseQuery);
                    return readObjectQuery;
                }
            } else if (databaseQuery.isModifyAllQuery()) {
                int n = (Integer)object;
                ((ModifyAllQuery)databaseQuery).setCacheUsage(n);
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-type-for-query-hint", new Object[]{CacheUsageHint.getQueryId(databaseQuery), this.name, CacheUsageHint.getPrintValue(object)}));
            }
            return databaseQuery;
        }
    }

    protected static class BindParametersHint
    extends Hint {
        BindParametersHint() {
            super("eclipselink.jdbc.bind-parameters", "PersistenceUnitDefault");
            this.valueArray = new Object[][]{{"PersistenceUnitDefault", null}, {"True", Boolean.TRUE}, {"False", Boolean.FALSE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            if (object == null) {
                databaseQuery.ignoreBindAllParameters();
            } else {
                databaseQuery.setShouldBindAllParameters((boolean)((Boolean)object));
            }
            return databaseQuery;
        }
    }

    protected static abstract class Hint {
        static HashMap mainMap = new HashMap();
        Object[] valueArray;
        HashMap valueMap;
        String name;
        String defaultValue;
        Object defaultValueToApply;
        boolean valueToApplyMayBeNull;

        Hint(String string, String string2) {
            this.name = string;
            this.defaultValue = string2;
        }

        abstract DatabaseQuery applyToDatabaseQuery(Object var1, DatabaseQuery var2, ClassLoader var3);

        static void verify(String string, boolean bl, Object object, String string2, AbstractSession abstractSession) {
            Hint hint = (Hint)mainMap.get(string);
            if (hint == null) {
                if (abstractSession != null) {
                    abstractSession.log(1, "query", "unknown_query_hint", new Object[]{Hint.getPrintValue(string2), string});
                }
                return;
            }
            hint.verify(object, bl, string2, abstractSession);
        }

        void verify(Object object, boolean bl, String string, AbstractSession abstractSession) {
            if (bl) {
                object = this.defaultValue;
            }
            if (abstractSession != null) {
                abstractSession.log(1, "query", "query_hint", new Object[]{Hint.getPrintValue(string), this.name, Hint.getPrintValue(object)});
            }
            if (!bl && this.valueMap != null && !this.valueMap.containsKey(Hint.getUpperCaseString(object))) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-query-hint-value", new Object[]{Hint.getPrintValue(string), this.name, Hint.getPrintValue(object)}));
            }
        }

        static DatabaseQuery apply(String string, boolean bl, Object object, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            Hint hint = (Hint)mainMap.get(string);
            if (hint == null) {
                return databaseQuery;
            }
            return hint.apply(object, bl, databaseQuery, classLoader);
        }

        DatabaseQuery apply(Object object, boolean bl, DatabaseQuery databaseQuery, ClassLoader classLoader) {
            String string;
            Object object2 = object;
            if (bl) {
                object2 = this.defaultValueToApply;
            } else if (this.valueMap != null && (object2 = this.valueMap.get(string = Hint.getUpperCaseString(object))) == null) {
                boolean bl2 = true;
                if (this.valueToApplyMayBeNull) {
                    boolean bl3 = bl2 = !this.valueMap.containsKey(string);
                }
                if (bl2) {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-query-hint-value", new Object[]{Hint.getQueryId(databaseQuery), this.name, Hint.getPrintValue(object)}));
                }
            }
            return this.applyToDatabaseQuery(object2, databaseQuery, classLoader);
        }

        static String getQueryId(DatabaseQuery databaseQuery) {
            String string = databaseQuery.getName();
            if (string == null) {
                string = databaseQuery.getEJBQLString();
            }
            return Hint.getPrintValue(string);
        }

        static String getPrintValue(Object object) {
            return object != null ? object.toString() : "null";
        }

        static String getUpperCaseString(Object object) {
            return object != null ? object.toString().toUpperCase() : null;
        }

        static Class loadClass(String string, DatabaseQuery databaseQuery, ClassLoader classLoader) throws QueryException {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return (Class)AccessController.doPrivileged(new PrivilegedClassForName(string, true, classLoader));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw QueryException.classNotFoundWhileUsingQueryHint(databaseQuery, string, privilegedActionException.getException());
                    }
                }
                return PrivilegedAccessHelper.getClassForName(string, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw QueryException.classNotFoundWhileUsingQueryHint(databaseQuery, string, classNotFoundException);
            }
        }

        static Object newInstance(Class clazz, DatabaseQuery databaseQuery, String string) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
                }
                return PrivilegedAccessHelper.newInstanceFromClass(clazz);
            }
            catch (Exception exception) {
                throw QueryException.errorInstantiatedClassForQueryHint(exception, databaseQuery, clazz, string);
            }
        }

        void initialize() {
            if (this.valueArray != null) {
                this.valueMap = new HashMap(this.valueArray.length);
                if (this.valueArray instanceof Object[][]) {
                    Object[][] objectArray = (Object[][])this.valueArray;
                    for (int i = 0; i < objectArray.length; ++i) {
                        this.valueMap.put(Hint.getUpperCaseString(objectArray[i][0]), objectArray[i][1]);
                        if (objectArray[i][1] != null) continue;
                        this.valueToApplyMayBeNull = true;
                    }
                } else {
                    for (int i = 0; i < this.valueArray.length; ++i) {
                        this.valueMap.put(Hint.getUpperCaseString(this.valueArray[i]), this.valueArray[i]);
                        if (this.valueArray[i] != null) continue;
                        this.valueToApplyMayBeNull = true;
                    }
                }
                this.defaultValueToApply = this.valueMap.get(this.defaultValue.toUpperCase());
            }
        }

        static void addHint(Hint hint) {
            hint.initialize();
            mainMap.put(hint.name, hint);
        }

        static {
            Hint.addHint(new BindParametersHint());
            Hint.addHint(new CacheUsageHint());
            Hint.addHint(new QueryTypeHint());
            Hint.addHint(new PessimisticLockHint());
            Hint.addHint(new PessimisticLockTimeoutHint());
            Hint.addHint(new RefreshHint());
            Hint.addHint(new CascadePolicyHint());
            Hint.addHint(new BatchHint());
            Hint.addHint(new FetchHint());
            Hint.addHint(new LeftFetchHint());
            Hint.addHint(new ReadOnlyHint());
            Hint.addHint(new JDBCTimeoutHint());
            Hint.addHint(new JDBCFetchSizeHint());
            Hint.addHint(new JDBCMaxRowsHint());
            Hint.addHint(new JDBCFirstResultHint());
            Hint.addHint(new ResultCollectionTypeHint());
            Hint.addHint(new RedirectorHint());
            Hint.addHint(new QueryCacheHint());
            Hint.addHint(new QueryCacheSizeHint());
            Hint.addHint(new QueryCacheExpiryHint());
            Hint.addHint(new QueryCacheExpiryTimeOfDayHint());
            Hint.addHint(new MaintainCacheHint());
            Hint.addHint(new PrepareHint());
            Hint.addHint(new CacheStatementHint());
            Hint.addHint(new FlushHint());
            Hint.addHint(new HintHint());
            Hint.addHint(new NativeConnectionHint());
            Hint.addHint(new CursorHint());
            Hint.addHint(new CursorInitialSizeHint());
            Hint.addHint(new CursorPageSizeHint());
            Hint.addHint(new ScrollableCursorHint());
            Hint.addHint(new CursorSizeHint());
            Hint.addHint(new FetchGroupHint());
            Hint.addHint(new FetchGroupNameHint());
            Hint.addHint(new FetchGroupDefaultHint());
            Hint.addHint(new FetchGroupAttributeHint());
            Hint.addHint(new ExclusiveHint());
            Hint.addHint(new InheritanceJoinHint());
            Hint.addHint(new AsOfHint());
            Hint.addHint(new AsOfSCNHint());
            Hint.addHint(new ResultTypeHint());
            Hint.addHint(new ResultSetTypeHint());
            Hint.addHint(new ResultSetConcurrencyHint());
            Hint.addHint(new IndirectionPolicyHint());
        }
    }
}

