/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.deployment.Archive;
import org.eclipse.persistence.internal.jpa.deployment.DirectoryArchive;
import org.eclipse.persistence.internal.jpa.deployment.DirectoryInsideJarURLArchive;
import org.eclipse.persistence.internal.jpa.deployment.JarFileArchive;
import org.eclipse.persistence.internal.jpa.deployment.JarInputStreamURLArchive;
import org.eclipse.persistence.internal.jpa.deployment.URLArchive;

public class ArchiveFactoryImpl {
    private Logger logger;

    public ArchiveFactoryImpl() {
        this(Logger.global);
    }

    public ArchiveFactoryImpl(Logger logger) {
        this.logger = logger;
    }

    public Archive createArchive(URL uRL) throws URISyntaxException, IOException {
        Archive archive;
        this.logger.entering("ArchiveFactoryImpl", "createArchive", new Object[]{uRL});
        String string = uRL.getProtocol();
        this.logger.logp(Level.FINER, "ArchiveFactoryImpl", "createArchive", "protocol = {0}", string);
        if ("file".equals(string)) {
            File file;
            URI uRI = Helper.toURI(uRL);
            try {
                file = new File(uRI);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                file = new File(uRL.getPath());
            }
            archive = file.isDirectory() ? new DirectoryArchive(file) : new JarFileArchive(new JarFile(file));
        } else {
            JarURLConnection jarURLConnection;
            JarEntry jarEntry;
            archive = "jar".equals(string) ? ((jarEntry = (jarURLConnection = (JarURLConnection)JarURLConnection.class.cast(uRL.openConnection())).getJarEntry()) == null ? new JarFileArchive(jarURLConnection.getJarFile()) : (jarEntry.isDirectory() ? new DirectoryInsideJarURLArchive(uRL) : new JarInputStreamURLArchive(uRL))) : (this.isJarInputStream(uRL) ? new JarInputStreamURLArchive(uRL) : new URLArchive(uRL));
        }
        this.logger.exiting("ArchiveFactoryImpl", "createArchive", archive);
        return archive;
    }

    private boolean isJarInputStream(URL uRL) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            if (inputStream == null) {
                return false;
            }
            JarInputStream jarInputStream = new JarInputStream(inputStream);
            jarInputStream.close();
            return true;
        }
        catch (IOException iOException) {
            if (inputStream != null) {
                inputStream.close();
            }
            return false;
        }
    }
}

