/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.deployment.Archive;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceInitializationHelper;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.jpa.PersistenceProvider;
import org.eclipse.persistence.logging.AbstractSessionLog;

public abstract class JPAInitializer {
    protected boolean shouldCreateInternalLoader = true;
    protected ClassLoader initializationClassloader = null;

    public static void initializeTopLinkLoggingFile() {
        String string = System.getProperty("eclipselink.logging.file");
        try {
            if (string != null) {
                AbstractSessionLog.getLog().setWriter(new FileWriter(string));
            }
        }
        catch (IOException iOException) {
            AbstractSessionLog.getLog().log(6, "cmp_init_default_logging_file_is_invalid", string, iOException);
        }
    }

    public boolean callPredeploy(PersistenceUnitInfo persistenceUnitInfo, Map map, PersistenceInitializationHelper persistenceInitializationHelper) {
        String string = persistenceUnitInfo.getPersistenceProviderClassName();
        if (this.isPersistenceProviderSupported(string)) {
            ClassLoader classLoader;
            String string2;
            EntityManagerSetupImpl entityManagerSetupImpl;
            String string3 = (String)map.get("eclipselink.session-name");
            if (string3 == null) {
                string3 = (String)persistenceUnitInfo.getProperties().get("eclipselink.session-name");
            }
            if (string3 == null) {
                string3 = "";
            }
            if ((entityManagerSetupImpl = EntityManagerFactoryProvider.getEntityManagerSetupImpl(string2 = PersistenceUnitProcessor.buildPersistenceUnitName(persistenceUnitInfo.getPersistenceUnitRootUrl(), persistenceUnitInfo.getPersistenceUnitName()) + string3)) != null && !entityManagerSetupImpl.isUndeployed()) {
                return false;
            }
            Set<String> set = PersistenceUnitProcessor.buildClassSet(persistenceUnitInfo, Thread.currentThread().getContextClassLoader());
            AbstractSessionLog.getLog().log(2, "cmp_init_invoke_predeploy", persistenceUnitInfo.getPersistenceUnitName());
            Map map2 = EntityManagerFactoryProvider.mergeMaps(map, persistenceUnitInfo.getProperties());
            this.checkWeaving(map2);
            if (persistenceUnitInfo instanceof SEPersistenceUnitInfo) {
                classLoader = this.createTempLoader(set);
                ((SEPersistenceUnitInfo)persistenceUnitInfo).setNewTempClassLoader(classLoader);
                ((SEPersistenceUnitInfo)persistenceUnitInfo).setClassLoader(persistenceInitializationHelper.getClassLoader(persistenceUnitInfo.getPersistenceUnitName(), map));
            }
            if (entityManagerSetupImpl == null) {
                entityManagerSetupImpl = new EntityManagerSetupImpl();
                EntityManagerFactoryProvider.addEntityManagerSetupImpl(string2, entityManagerSetupImpl);
                ++EntityManagerFactoryProvider.PUIUsageCount;
            }
            classLoader = entityManagerSetupImpl.predeploy(persistenceUnitInfo, map2);
            this.registerTransformer((ClassTransformer)classLoader, persistenceUnitInfo);
            return true;
        }
        return false;
    }

    public abstract void checkWeaving(Map var1);

    protected abstract ClassLoader createTempLoader(Collection var1);

    protected abstract ClassLoader createTempLoader(Collection var1, boolean var2);

    public void initialize(Map map, PersistenceInitializationHelper persistenceInitializationHelper) {
        this.initializeClassLoader(persistenceInitializationHelper);
        Set<Archive> set = PersistenceUnitProcessor.findPersistenceArchives(this.initializationClassloader);
        for (Archive archive : set) {
            AbstractSessionLog.getLog().log(2, "cmp_init_initialize", archive);
            this.initPersistenceUnits(archive, map, persistenceInitializationHelper);
        }
    }

    protected void initPersistenceUnits(Archive archive, Map map, PersistenceInitializationHelper persistenceInitializationHelper) {
        for (SEPersistenceUnitInfo sEPersistenceUnitInfo : PersistenceUnitProcessor.getPersistenceUnits(archive, this.initializationClassloader)) {
            EntityManagerFactoryProvider.persistenceUnits.put(PersistenceUnitProcessor.buildPersistenceUnitName(sEPersistenceUnitInfo.getPersistenceUnitRootUrl(), sEPersistenceUnitInfo.getPersistenceUnitName()), sEPersistenceUnitInfo);
            this.callPredeploy(sEPersistenceUnitInfo, map, persistenceInitializationHelper);
        }
    }

    public boolean isPersistenceProviderSupported(String string) {
        return string == null || string.equals("") || string.equals(EntityManagerFactoryProvider.class.getName()) || string.equals(PersistenceProvider.class.getName());
    }

    protected Set loadEntityClasses(Collection collection, ClassLoader classLoader) {
        HashSet hashSet = new HashSet();
        AbstractSessionLog.getLog().log(2, "cmp_loading_entities_using_loader", classLoader);
        for (String string : collection) {
            try {
                hashSet.add(classLoader.loadClass(string));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw ValidationException.entityClassNotFound(string, classLoader, classNotFoundException);
            }
        }
        return hashSet;
    }

    public abstract void registerTransformer(ClassTransformer var1, PersistenceUnitInfo var2);

    public void initializeClassLoader(PersistenceInitializationHelper persistenceInitializationHelper) {
    }
}

