/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.annotations.ExistenceType;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.descriptors.ReturningPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.CMP3Policy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.PropertyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.CollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ManyToManyAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappedKeyMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ObjectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.OneToOneAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.RelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListener;
import org.eclipse.persistence.mappings.DatabaseMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataDescriptor {
    private Class m_javaClass;
    private ClassAccessor m_classAccessor;
    private ClassDescriptor m_descriptor;
    private DatabaseTable m_primaryTable;
    private Enum m_existenceChecking;
    private MetadataDescriptor m_inheritanceRootDescriptor = null;
    private MetadataDescriptor m_inheritanceParentDescriptor = null;
    private boolean m_isCascadePersist = false;
    private boolean m_ignoreAnnotations = false;
    private boolean m_ignoreDefaultMappings = false;
    private boolean m_hasCache = false;
    private boolean m_hasCacheInterceptor = false;
    private boolean m_hasDefaultRedirectors = false;
    private boolean m_hasChangeTracking = false;
    private boolean m_hasCustomizer = false;
    private boolean m_hasReadOnly = false;
    private boolean m_hasCopyPolicy = false;
    private Boolean m_usesCascadedOptimisticLocking;
    private String m_defaultAccess = null;
    private String m_defaultSchema = null;
    private String m_defaultCatalog = null;
    private String m_embeddedIdAttributeName;
    private List<String> m_idAttributeNames = new ArrayList<String>();
    private List<String> m_orderByAttributeNames = new ArrayList<String>();
    private List<String> m_idOrderByAttributeNames = new ArrayList<String>();
    private List<MetadataDescriptor> m_embeddableDescriptors = new ArrayList<MetadataDescriptor>();
    private List<ObjectAccessor> m_derivedIDAccessors;
    private Class m_pkClass;
    private Map<String, Type> m_pkClassIDs = new HashMap<String, Type>();
    private Map<String, Type> m_genericTypes = new HashMap<String, Type>();
    private Map<String, MappingAccessor> m_accessors = new HashMap<String, MappingAccessor>();
    private Map<String, PropertyMetadata> m_properties = new HashMap<String, PropertyMetadata>();
    private Map<String, String> m_pkJoinColumnAssociations = new HashMap<String, String>();
    private Map<String, AttributeOverrideMetadata> m_attributeOverrides = new HashMap<String, AttributeOverrideMetadata>();
    private Map<String, AssociationOverrideMetadata> m_associationOverrides = new HashMap<String, AssociationOverrideMetadata>();
    private Map<String, Map<String, MetadataAccessor>> m_biDirectionalManyToManyAccessors = new HashMap<String, Map<String, MetadataAccessor>>();

    public MetadataDescriptor(Class clazz) {
        this.m_descriptor = new RelationalDescriptor();
        this.m_descriptor.setAlias("");
        this.m_descriptor.getQueryManager().checkDatabaseForDoesExist();
        this.m_derivedIDAccessors = new ArrayList<ObjectAccessor>();
        this.setJavaClass(clazz);
    }

    public MetadataDescriptor(Class clazz, ClassAccessor classAccessor) {
        this(clazz);
        this.setClassAccessor(classAccessor);
    }

    public void addAccessor(MappingAccessor mappingAccessor, MetadataDescriptor metadataDescriptor) {
        if (mappingAccessor != null) {
            this.m_accessors.put(mappingAccessor.getAttributeName(), mappingAccessor);
            mappingAccessor.setOwningDescriptor(metadataDescriptor);
            mappingAccessor.addConverters();
            this.preProcessEmbeddableAccessor(mappingAccessor.getReferenceClass(), metadataDescriptor);
            if (mappingAccessor.isMappedKeyMapAccessor()) {
                MappedKeyMapAccessor mappedKeyMapAccessor = (MappedKeyMapAccessor)((Object)mappingAccessor);
                Class clazz = mappedKeyMapAccessor.getMapKeyClass();
                if (clazz == null || clazz.equals(Void.TYPE)) {
                    clazz = mappingAccessor.getAccessibleObject().getMapKeyClass(this);
                    if (clazz == null && mappedKeyMapAccessor.getMapKey() == null) {
                        throw ValidationException.unableToDetermineMapKeyClass(mappingAccessor.getAttributeName(), mappingAccessor.getJavaClass());
                    }
                    mappedKeyMapAccessor.setMapKeyClass(clazz);
                }
                this.preProcessEmbeddableAccessor(clazz, metadataDescriptor);
            }
        }
    }

    public void addAssociationOverride(AssociationOverrideMetadata associationOverrideMetadata) {
        this.m_associationOverrides.put(associationOverrideMetadata.getName(), associationOverrideMetadata);
    }

    public void addAttributeOverride(AttributeOverrideMetadata attributeOverrideMetadata) {
        this.m_attributeOverrides.put(attributeOverrideMetadata.getName(), attributeOverrideMetadata);
    }

    public void addDefaultEventListener(EntityListener entityListener) {
        this.m_descriptor.getEventManager().addDefaultEventListener(entityListener);
    }

    public void addDerivedIDAccessor(ObjectAccessor objectAccessor) {
        this.m_derivedIDAccessors.add(objectAccessor);
    }

    public void addEmbeddableDescriptor(MetadataDescriptor metadataDescriptor) {
        this.m_embeddableDescriptors.add(metadataDescriptor);
    }

    public void addEntityListenerEventListener(EntityListener entityListener) {
        this.m_descriptor.getEventManager().addEntityListenerEventListener(entityListener);
    }

    public void addFieldForInsert(DatabaseField databaseField) {
        this.getReturningPolicy().addFieldForInsert(databaseField);
    }

    public void addFieldForInsertReturnOnly(DatabaseField databaseField) {
        this.getReturningPolicy().addFieldForInsertReturnOnly(databaseField);
    }

    public void addFieldForUpdate(DatabaseField databaseField) {
        this.getReturningPolicy().addFieldForUpdate(databaseField);
    }

    public void addIdAttributeName(String string) {
        this.m_idAttributeNames.add(string);
    }

    public void addForeignKeyFieldForMultipleTable(DatabaseField databaseField, DatabaseField databaseField2) {
        this.m_descriptor.addForeignKeyFieldForMultipleTable(databaseField, databaseField2);
        this.m_pkJoinColumnAssociations.put(databaseField.getName(), databaseField2.getName());
    }

    public void addGenericType(String string, Type type) {
        this.m_genericTypes.put(string, type);
    }

    public void addPKClassId(String string, Type type) {
        this.m_pkClassIDs.put(string, type);
    }

    public void addProperty(PropertyMetadata propertyMetadata) {
        if (propertyMetadata.shouldOverride(this.m_properties.get(propertyMetadata.getName()))) {
            this.m_properties.put(propertyMetadata.getName(), propertyMetadata);
            this.m_descriptor.getProperties().put(propertyMetadata.getName(), propertyMetadata.getConvertedValue());
        }
    }

    public void addPrimaryKeyField(DatabaseField databaseField) {
        this.m_descriptor.addPrimaryKeyField(databaseField);
    }

    public void addRelationshipAccessor(MappingAccessor mappingAccessor) {
        String string;
        this.getProject().addRelationshipAccessor(mappingAccessor);
        if (mappingAccessor.isManyToMany() && (string = ((ManyToManyAccessor)mappingAccessor).getMappedBy()) != null && !string.equals("")) {
            String string2 = ((ManyToManyAccessor)mappingAccessor).getReferenceClassName();
            if (!this.m_biDirectionalManyToManyAccessors.containsKey(string2)) {
                this.m_biDirectionalManyToManyAccessors.put(string2, new HashMap());
            }
            this.m_biDirectionalManyToManyAccessors.get(string2).put(string, mappingAccessor);
        }
    }

    public void addTable(DatabaseTable databaseTable) {
        this.m_descriptor.addTable(databaseTable);
    }

    public boolean excludeSuperclassListeners() {
        return this.m_descriptor.getEventManager().excludeSuperclassListeners();
    }

    public MappingAccessor getAccessorFor(String string) {
        MappingAccessor mappingAccessor = this.m_accessors.get(string);
        if (mappingAccessor == null && (mappingAccessor = this.m_accessors.get(MetadataMethod.getAttributeNameFromMethodName(string))) == null && this.isInheritanceSubclass() && !this.usesTablePerClassInheritanceStrategy()) {
            mappingAccessor = this.getInheritanceParentDescriptor().getAccessorFor(string);
        }
        if (mappingAccessor == null) {
            for (MetadataDescriptor metadataDescriptor : this.m_embeddableDescriptors) {
                String string2 = new String(string);
                if (string2.contains(".")) {
                    string2 = string2.substring(string.indexOf(".") + 1);
                }
                if ((mappingAccessor = metadataDescriptor.getAccessorFor(string2)) == null) continue;
                return mappingAccessor;
            }
        }
        return mappingAccessor;
    }

    public Collection<MappingAccessor> getAccessors() {
        return this.m_accessors.values();
    }

    public String getAlias() {
        return this.m_descriptor.getAlias();
    }

    public AssociationOverrideMetadata getAssociationOverrideFor(String string) {
        return this.m_associationOverrides.get(string);
    }

    public Collection<AssociationOverrideMetadata> getAssociationOverrides() {
        return this.m_associationOverrides.values();
    }

    public AttributeOverrideMetadata getAttributeOverrideFor(String string) {
        return this.m_attributeOverrides.get(string);
    }

    public Collection<AttributeOverrideMetadata> getAttributeOverrides() {
        return this.m_attributeOverrides.values();
    }

    public String getDefaultTableName() {
        String string = this.getAlias().toUpperCase();
        if (this.isInheritanceSubclass() && this.getInheritanceRootDescriptor().usesSingleTableInheritanceStrategy()) {
            string = this.getInheritanceRootDescriptor().getPrimaryTableName();
        }
        return string;
    }

    public ClassAccessor getClassAccessor() {
        return this.m_classAccessor;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.m_descriptor;
    }

    public CMPPolicy getCMPPolicy() {
        return this.m_descriptor.getCMPPolicy();
    }

    public String getDefaultAccess() {
        return this.m_defaultAccess;
    }

    public String getDefaultCatalog() {
        return this.m_defaultCatalog;
    }

    public String getDefaultSchema() {
        return this.m_defaultSchema;
    }

    public List<ObjectAccessor> getDerivedIDAccessors() {
        return this.m_derivedIDAccessors;
    }

    public String getEmbeddedIdAttributeName() {
        return this.m_embeddedIdAttributeName;
    }

    public EntityAccessor getEntityAccessor() {
        return (EntityAccessor)this.m_classAccessor;
    }

    public Type getGenericType(String string) {
        return this.m_genericTypes.get(string);
    }

    public String getIdAttributeName() {
        if (this.getIdAttributeNames().isEmpty()) {
            if (this.isInheritanceSubclass()) {
                return this.getInheritanceRootDescriptor().getIdAttributeName();
            }
            return "";
        }
        return this.getIdAttributeNames().get(0);
    }

    public List<String> getIdAttributeNames() {
        return this.m_idAttributeNames;
    }

    public List<String> getIdOrderByAttributeNames() {
        if (this.m_idOrderByAttributeNames.isEmpty()) {
            this.m_idOrderByAttributeNames = this.m_idAttributeNames.isEmpty() ? (this.isInheritanceSubclass() ? this.getInheritanceRootDescriptor().getIdAttributeNames() : this.getAccessorFor(this.getEmbeddedIdAttributeName()).getReferenceDescriptor().getOrderByAttributeNames()) : this.m_idAttributeNames;
        }
        return this.m_idOrderByAttributeNames;
    }

    public MetadataAccessor getBiDirectionalManyToManyAccessor(String string, String string2) {
        return this.m_biDirectionalManyToManyAccessors.get(string).get(string2);
    }

    public List<String> getOrderByAttributeNames() {
        if (this.m_orderByAttributeNames.isEmpty()) {
            for (DatabaseMapping databaseMapping : this.getMappings()) {
                if (!databaseMapping.isDirectToFieldMapping()) continue;
                this.m_orderByAttributeNames.add(databaseMapping.getAttributeName());
            }
        }
        return this.m_orderByAttributeNames;
    }

    public Class getJavaClass() {
        return this.m_javaClass;
    }

    public String getJavaClassName() {
        return this.m_descriptor.getJavaClassName();
    }

    public MetadataLogger getLogger() {
        return this.getProject().getLogger();
    }

    public MetadataDescriptor getInheritanceParentDescriptor() {
        return this.m_inheritanceParentDescriptor;
    }

    public MetadataDescriptor getInheritanceRootDescriptor() {
        return this.m_inheritanceRootDescriptor;
    }

    public DatabaseMapping getMappingForAttributeName(String string) {
        return this.getMappingForAttributeName(string, null);
    }

    public DatabaseMapping getMappingForAttributeName(String string, MetadataAccessor metadataAccessor) {
        MappingAccessor mappingAccessor = this.getAccessorFor(string);
        if (mappingAccessor != null) {
            if (mappingAccessor.isRelationship()) {
                RelationshipAccessor relationshipAccessor = (RelationshipAccessor)mappingAccessor;
                if (metadataAccessor != null && (relationshipAccessor.isOneToOne() || relationshipAccessor.isCollectionAccessor())) {
                    String string2 = null;
                    string2 = relationshipAccessor.isOneToOne() ? ((OneToOneAccessor)relationshipAccessor).getMappedBy() : ((CollectionAccessor)relationshipAccessor).getMappedBy();
                    if (string2 != null && string2.equals(metadataAccessor.getAttributeName())) {
                        throw ValidationException.circularMappedByReferences(metadataAccessor.getJavaClass(), metadataAccessor.getAttributeName(), this.getJavaClass(), string);
                    }
                }
                relationshipAccessor.processRelationship();
            }
            return mappingAccessor.getMapping();
        }
        return null;
    }

    public List<DatabaseMapping> getMappings() {
        return this.m_descriptor.getMappings();
    }

    public Class getPKClass() {
        return this.m_pkClass;
    }

    public String getPKClassName() {
        String string = null;
        if (this.m_descriptor.hasCMPPolicy()) {
            string = ((CMP3Policy)this.m_descriptor.getCMPPolicy()).getPKClassName();
        }
        return string;
    }

    public Map<String, Type> getPKClassIDs() {
        return this.m_pkClassIDs;
    }

    public String getPrimaryKeyFieldName() {
        return this.getPrimaryKeyFields().iterator().next().getName();
    }

    public List<String> getPrimaryKeyFieldNames() {
        List<DatabaseField> list = this.getPrimaryKeyFields();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (DatabaseField databaseField : list) {
            arrayList.add(databaseField.getName());
        }
        return arrayList;
    }

    public List<DatabaseField> getPrimaryKeyFields() {
        List<DatabaseField> list = this.m_descriptor.getPrimaryKeyFields();
        if (list.isEmpty() && this.isInheritanceSubclass()) {
            list = this.getInheritanceRootDescriptor().getPrimaryKeyFields();
        }
        return list;
    }

    public String getPrimaryKeyJoinColumnAssociation(String string) {
        String string2 = this.m_pkJoinColumnAssociations.get(string);
        if (string2 == null || !this.isInheritanceSubclass()) {
            return string;
        }
        return this.getInheritanceParentDescriptor().getPrimaryKeyJoinColumnAssociation(string2);
    }

    public DatabaseTable getPrimaryKeyTable() {
        return this.getPrimaryKeyFields().iterator().next().getTable();
    }

    public DatabaseTable getPrimaryTable() {
        if (this.m_primaryTable == null && this.isInheritanceSubclass()) {
            return this.getInheritanceRootDescriptor().getPrimaryTable();
        }
        if (this.m_descriptor.isAggregateDescriptor()) {
            return new DatabaseTable();
        }
        return this.m_primaryTable;
    }

    public String getPrimaryTableName() {
        return this.getPrimaryTable().getName();
    }

    public MetadataProject getProject() {
        return this.getClassAccessor().getProject();
    }

    protected ReturningPolicy getReturningPolicy() {
        if (!this.m_descriptor.hasReturningPolicy()) {
            this.m_descriptor.setReturningPolicy(new ReturningPolicy());
        }
        return this.m_descriptor.getReturningPolicy();
    }

    public DatabaseField getSequenceNumberField() {
        return this.m_descriptor.getSequenceNumberField();
    }

    public boolean hasAccessorFor(String string) {
        return this.getAccessorFor(string) != null;
    }

    public boolean hasAssociationOverrideFor(String string) {
        return this.m_associationOverrides.containsKey(string);
    }

    public boolean hasAttributeOverrideFor(String string) {
        return this.m_attributeOverrides.containsKey(string);
    }

    public boolean hasCompositePrimaryKey() {
        return this.getPrimaryKeyFields().size() > 1 || this.getPKClass() != null;
    }

    public boolean hasEmbeddedIdAttribute() {
        return this.m_embeddedIdAttributeName != null;
    }

    public boolean hasExistenceChecking() {
        return this.m_existenceChecking != null;
    }

    public boolean hasBiDirectionalManyToManyAccessorFor(String string, String string2) {
        if (this.m_biDirectionalManyToManyAccessors.containsKey(string)) {
            return this.m_biDirectionalManyToManyAccessors.get(string).containsKey(string2);
        }
        return false;
    }

    public boolean hasCache() {
        return this.m_hasCache;
    }

    public boolean hasCacheInterceptor() {
        return this.m_hasCacheInterceptor;
    }

    public boolean hasDefaultRedirectors() {
        return this.m_hasDefaultRedirectors;
    }

    public boolean hasChangeTracking() {
        return this.m_hasChangeTracking;
    }

    public boolean hasCopyPolicy() {
        return this.m_hasCopyPolicy;
    }

    public boolean hasCustomizer() {
        return this.m_hasCustomizer;
    }

    public boolean hasReadOnly() {
        return this.m_hasReadOnly;
    }

    public boolean hasMappingForAttributeName(String string) {
        return this.m_descriptor.getMappingForAttributeName(string) != null;
    }

    public boolean hasPrimaryKeyFields() {
        return this.m_descriptor.getPrimaryKeyFields().size() > 0;
    }

    public boolean ignoreAnnotations() {
        return this.m_ignoreAnnotations;
    }

    public boolean ignoreDefaultMappings() {
        return this.m_ignoreDefaultMappings;
    }

    public boolean isCascadePersist() {
        return this.m_isCascadePersist;
    }

    public boolean isEmbeddable() {
        return this.m_descriptor.isAggregateDescriptor();
    }

    public boolean isEmbeddableCollection() {
        return this.m_descriptor.isAggregateCollectionDescriptor();
    }

    public boolean isInheritanceSubclass() {
        return this.m_inheritanceParentDescriptor != null;
    }

    public boolean isPrimaryKeyField(DatabaseField databaseField) {
        for (DatabaseField databaseField2 : this.getPrimaryKeyFields()) {
            if (databaseField != databaseField2) continue;
            return true;
        }
        return false;
    }

    public boolean pkClassWasNotValidated() {
        return !this.m_pkClassIDs.isEmpty();
    }

    protected void preProcessEmbeddableAccessor(Class clazz, MetadataDescriptor metadataDescriptor) {
        EmbeddableAccessor embeddableAccessor;
        if (clazz != null && (embeddableAccessor = this.getProject().getEmbeddableAccessor(clazz)) != null && !embeddableAccessor.isPreProcessed()) {
            embeddableAccessor.setOwningDescriptor(metadataDescriptor);
            embeddableAccessor.preProcess();
        }
    }

    public void processAccessors(MetadataDescriptor metadataDescriptor) {
        for (MappingAccessor mappingAccessor : this.m_accessors.values()) {
            if (mappingAccessor.isProcessed()) continue;
            if (mappingAccessor.isDerivedId()) {
                this.m_derivedIDAccessors.add((ObjectAccessor)mappingAccessor);
                this.getProject().addAccessorWithDerivedIDs(this.m_classAccessor);
            }
            if (mappingAccessor.isDirectEmbeddableCollection() || mappingAccessor.isEmbedded()) {
                EmbeddableAccessor embeddableAccessor = this.getProject().getEmbeddableAccessor(mappingAccessor.getReferenceClass());
                if (embeddableAccessor == null) {
                    throw ValidationException.invalidEmbeddedAttribute(this.getJavaClass(), mappingAccessor.getAttributeName(), mappingAccessor.getReferenceClass());
                }
                embeddableAccessor.process(metadataDescriptor);
                this.addEmbeddableDescriptor(embeddableAccessor.getDescriptor());
                if (mappingAccessor.isEmbeddedId()) {
                    mappingAccessor.process();
                    continue;
                }
                this.getProject().addEmbeddableMappingAccessor(mappingAccessor);
                continue;
            }
            if (mappingAccessor.isDirectCollection()) {
                this.getProject().addDirectCollectionAccessor(mappingAccessor);
                continue;
            }
            if (mappingAccessor.isRelationship()) {
                this.addRelationshipAccessor(mappingAccessor);
                continue;
            }
            mappingAccessor.process();
        }
    }

    public void removePrimaryKeyField(DatabaseField databaseField) {
        this.getPrimaryKeyFields().remove(databaseField);
    }

    public void setAlias(String string) {
        this.m_descriptor.setAlias(string);
    }

    public void setClassAccessor(ClassAccessor classAccessor) {
        this.m_classAccessor = classAccessor;
        classAccessor.setDescriptor(this);
    }

    public void setDefaultAccess(String string) {
        this.m_defaultAccess = string;
    }

    public void setDefaultCatalog(String string) {
        this.m_defaultCatalog = string;
    }

    public void setDefaultSchema(String string) {
        this.m_defaultSchema = string;
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        this.m_descriptor = classDescriptor;
    }

    public void setEmbeddedIdAttributeName(String string) {
        this.m_embeddedIdAttributeName = string;
    }

    public void setEntityEventListener(EntityListener entityListener) {
        this.m_descriptor.getEventManager().setEntityEventListener(entityListener);
    }

    public void setExcludeDefaultListeners(boolean bl) {
        this.m_descriptor.getEventManager().setExcludeDefaultListeners(bl);
    }

    public void setExcludeSuperclassListeners(boolean bl) {
        this.m_descriptor.getEventManager().setExcludeSuperclassListeners(bl);
    }

    public void setExistenceChecking(Enum enum_) {
        this.m_existenceChecking = enum_;
        if (enum_.name().equals(ExistenceType.CHECK_CACHE.name())) {
            this.m_descriptor.getQueryManager().checkCacheForDoesExist();
        } else if (enum_.name().equals(ExistenceType.CHECK_DATABASE.name())) {
            this.m_descriptor.getQueryManager().checkDatabaseForDoesExist();
        } else if (enum_.name().equals(ExistenceType.ASSUME_EXISTENCE.name())) {
            this.m_descriptor.getQueryManager().assumeExistenceForDoesExist();
        } else if (enum_.name().equals(ExistenceType.ASSUME_NON_EXISTENCE.name())) {
            this.m_descriptor.getQueryManager().assumeNonExistenceForDoesExist();
        }
    }

    public void setHasCache() {
        this.m_hasCache = true;
    }

    public void setHasCacheInterceptor() {
        this.m_hasCacheInterceptor = true;
    }

    public void setHasDefaultRedirectors() {
        this.m_hasDefaultRedirectors = true;
    }

    public void setHasChangeTracking() {
        this.m_hasChangeTracking = true;
    }

    public void setHasCopyPolicy() {
        this.m_hasCopyPolicy = true;
    }

    public void setIgnoreAnnotations(boolean bl) {
        this.m_ignoreAnnotations = bl;
    }

    public void setIgnoreDefaultMappings(boolean bl) {
        this.m_ignoreDefaultMappings = bl;
    }

    public void setInheritanceParentDescriptor(MetadataDescriptor metadataDescriptor) {
        this.m_inheritanceParentDescriptor = metadataDescriptor;
    }

    public void setInheritanceRootDescriptor(MetadataDescriptor metadataDescriptor) {
        this.m_inheritanceRootDescriptor = metadataDescriptor;
    }

    public void setIsCascadePersist(boolean bl) {
        this.m_isCascadePersist = bl;
    }

    public void setIsEmbeddable() {
        this.m_descriptor.descriptorIsAggregate();
    }

    public void setIsEmbeddableCollection() {
        this.m_descriptor.descriptorIsAggregateCollection();
    }

    public void setJavaClass(Class clazz) {
        this.m_javaClass = clazz;
        this.m_descriptor.setJavaClassName(clazz.getName());
        if (clazz.isInterface()) {
            this.m_descriptor.setJavaInterfaceName(clazz.getName());
        }
    }

    public void setOptimisticLockingPolicy(OptimisticLockingPolicy optimisticLockingPolicy) {
        this.m_descriptor.setOptimisticLockingPolicy(optimisticLockingPolicy);
    }

    public void setPKClass(Class clazz) {
        this.m_pkClass = clazz;
        CMP3Policy cMP3Policy = new CMP3Policy();
        cMP3Policy.setPrimaryKeyClassName(clazz.getName());
        this.m_descriptor.setCMPPolicy(cMP3Policy);
    }

    public void setPrimaryTable(DatabaseTable databaseTable) {
        this.addTable(databaseTable);
        this.m_primaryTable = databaseTable;
    }

    public void setReadOnly(boolean bl) {
        if (bl) {
            this.m_descriptor.setReadOnly();
        }
        this.m_hasReadOnly = true;
    }

    public void setSequenceNumberField(DatabaseField databaseField) {
        this.m_descriptor.setSequenceNumberField(databaseField);
    }

    public void setSequenceNumberName(String string) {
        this.m_descriptor.setSequenceNumberName(string);
    }

    public void setUsesCascadedOptimisticLocking(Boolean bl) {
        this.m_usesCascadedOptimisticLocking = bl;
    }

    public boolean usesCascadedOptimisticLocking() {
        return this.m_usesCascadedOptimisticLocking != null && this.m_usesCascadedOptimisticLocking != false;
    }

    public boolean usesDefaultPropertyAccess() {
        return this.m_defaultAccess.equals("PROPERTY");
    }

    public boolean usesOptimisticLocking() {
        return this.m_descriptor.usesOptimisticLocking();
    }

    public boolean usesSingleTableInheritanceStrategy() {
        return ((EntityAccessor)this.m_classAccessor).getInheritance().usesSingleTableStrategy();
    }

    public boolean usesTablePerClassInheritanceStrategy() {
        return this.m_descriptor.hasTablePerClassPolicy();
    }

    public boolean usesVersionColumnOptimisticLocking() {
        return this.m_usesCascadedOptimisticLocking != null;
    }

    public void validatePKClassId(String string, Type type) {
        if (this.m_pkClassIDs.containsKey(string)) {
            Type type2 = this.m_pkClassIDs.get(string);
            if (type == type2) {
                this.m_pkClassIDs.remove(string);
            } else {
                throw ValidationException.invalidCompositePKAttribute(this.getJavaClass(), this.getPKClassName(), string, type2, type);
            }
        }
    }
}

