/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ORMetadata {
    private Annotation m_annotation;
    private MetadataAccessibleObject m_accessibleObject;
    private String m_xmlElement;

    protected ORMetadata() {
    }

    public ORMetadata(String string) {
        this.m_xmlElement = string;
    }

    public ORMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        this.m_annotation = annotation;
        this.m_accessibleObject = metadataAccessibleObject;
    }

    protected MetadataAccessibleObject getAccessibleObject() {
        return this.m_accessibleObject;
    }

    protected Annotation getAnnotation() {
        return this.m_annotation;
    }

    protected XMLEntityMappings getEntityMappings() {
        return this.m_accessibleObject.getEntityMappings();
    }

    protected String getIdentifier() {
        return "";
    }

    protected Object getLocation() {
        return this.m_accessibleObject.getLocation();
    }

    protected String getXMLElement() {
        return this.m_xmlElement;
    }

    protected boolean hasIdentifier() {
        return !this.getIdentifier().equals("");
    }

    protected Class initXMLClassName(String string) {
        return this.m_accessibleObject.getEntityMappings().getClassForName(string);
    }

    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        this.m_accessibleObject = metadataAccessibleObject;
    }

    protected void initXMLObject(ORMetadata oRMetadata, MetadataAccessibleObject metadataAccessibleObject) {
        if (oRMetadata != null) {
            oRMetadata.initXMLObject(metadataAccessibleObject);
        }
    }

    protected void initXMLObjects(List list, MetadataAccessibleObject metadataAccessibleObject) {
        for (ORMetadata oRMetadata : list) {
            oRMetadata.initXMLObject(metadataAccessibleObject);
        }
    }

    protected boolean loadedFromAnnotation() {
        return this.m_annotation != null || this.m_accessibleObject.getLocation() instanceof AnnotatedElement;
    }

    protected boolean loadedFromEclipseLinkXML() {
        if (this.loadedFromXML()) {
            return this.m_accessibleObject.getLocation().toString().contains("META-INF/eclipselink-orm.xml");
        }
        return false;
    }

    protected boolean loadedFromXML() {
        return this.m_xmlElement != null;
    }

    protected void merge(ORMetadata oRMetadata) {
    }

    protected List mergeORObjectLists(List list, List list2) {
        boolean bl;
        ArrayList<ORMetadata> arrayList = new ArrayList<ORMetadata>();
        for (ORMetadata oRMetadata : list) {
            bl = false;
            for (ORMetadata oRMetadata2 : list2) {
                if (!oRMetadata2.getIdentifier().equals(oRMetadata.getIdentifier())) continue;
                if (oRMetadata2.shouldOverride(oRMetadata)) {
                    arrayList.add(oRMetadata2);
                } else {
                    arrayList.add(oRMetadata);
                }
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(oRMetadata);
        }
        for (ORMetadata oRMetadata : list2) {
            bl = false;
            for (ORMetadata oRMetadata2 : list) {
                if (!oRMetadata.getIdentifier().equals(oRMetadata2.getIdentifier())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(oRMetadata);
        }
        return arrayList;
    }

    protected ORMetadata mergeORObjects(ORMetadata oRMetadata, ORMetadata oRMetadata2) {
        if (oRMetadata2 != null) {
            if (oRMetadata != null) {
                if (oRMetadata2.shouldOverride(oRMetadata)) {
                    return oRMetadata2;
                }
            } else {
                return oRMetadata2;
            }
        }
        return oRMetadata;
    }

    protected boolean mergePrimitiveBoolean(boolean bl, boolean bl2, MetadataAccessibleObject metadataAccessibleObject, String string) {
        Boolean bl3;
        Boolean bl4 = bl ? new Boolean(true) : null;
        Boolean bl5 = bl3 = bl2 ? new Boolean(true) : null;
        if (bl4 == null && bl3 == null) {
            return false;
        }
        return (Boolean)this.mergeSimpleObjects(bl4, bl3, metadataAccessibleObject, string);
    }

    protected Object mergeSimpleObjects(Object object, Object object2, MetadataAccessibleObject metadataAccessibleObject, String string) {
        if (object == null && object2 == null) {
            return null;
        }
        SimpleORMetadata simpleORMetadata = object == null ? null : new SimpleORMetadata(object, this.getAccessibleObject(), string);
        SimpleORMetadata simpleORMetadata2 = object2 == null ? null : new SimpleORMetadata(object2, metadataAccessibleObject, string);
        return ((SimpleORMetadata)this.mergeORObjects(simpleORMetadata, simpleORMetadata2)).getValue();
    }

    protected EntityAccessor reloadEntity(EntityAccessor entityAccessor, MetadataDescriptor metadataDescriptor) {
        if (this.m_accessibleObject.getEntityMappings() == null) {
            EntityAccessor entityAccessor2 = new EntityAccessor(entityAccessor.getAnnotation(), entityAccessor.getJavaClass(), entityAccessor.getProject());
            metadataDescriptor.setDefaultAccess(entityAccessor.getDescriptor().getDefaultAccess());
            entityAccessor2.setDescriptor(metadataDescriptor);
            return entityAccessor2;
        }
        return this.m_accessibleObject.getEntityMappings().reloadEntity(entityAccessor, metadataDescriptor);
    }

    protected MappedSuperclassAccessor reloadMappedSuperclass(MappedSuperclassAccessor mappedSuperclassAccessor, MetadataDescriptor metadataDescriptor) {
        if (this.m_accessibleObject.getEntityMappings() == null) {
            MappedSuperclassAccessor mappedSuperclassAccessor2 = new MappedSuperclassAccessor(mappedSuperclassAccessor.getAnnotation(), mappedSuperclassAccessor.getJavaClass(), metadataDescriptor);
            return mappedSuperclassAccessor2;
        }
        return this.m_accessibleObject.getEntityMappings().reloadMappedSuperclass(mappedSuperclassAccessor, metadataDescriptor);
    }

    public void setAccessibleObject(MetadataAccessibleObject metadataAccessibleObject) {
        this.m_accessibleObject = metadataAccessibleObject;
    }

    public boolean shouldOverride(ORMetadata oRMetadata) {
        MetadataLogger metadataLogger = this.getAccessibleObject().getLogger();
        if (oRMetadata == null) {
            return true;
        }
        if (!oRMetadata.equals(this)) {
            if (this.loadedFromXML() && oRMetadata.loadedFromAnnotation()) {
                if (this.hasIdentifier()) {
                    metadataLogger.logWarningMessage("metadata_warning_override_named_annotation_with_xml", oRMetadata.getAnnotation(), this.getIdentifier(), oRMetadata.getLocation(), this.getLocation());
                } else {
                    metadataLogger.logWarningMessage("metadata_warning_override_annotation_with_xml", oRMetadata.getAnnotation(), oRMetadata.getLocation(), this.getLocation());
                }
                return true;
            }
            if (this.loadedFromAnnotation() && oRMetadata.loadedFromXML()) {
                if (this.hasIdentifier()) {
                    metadataLogger.logWarningMessage("metadata_warning_override_named_annotation_with_xml", this.m_annotation, this.getIdentifier(), this.getLocation(), oRMetadata.getLocation());
                } else {
                    metadataLogger.logWarningMessage("metadata_warning_override_annotation_with_xml", this.m_annotation, this.getLocation(), oRMetadata.getLocation());
                }
            } else {
                if (this.loadedFromEclipseLinkXML() && !oRMetadata.loadedFromEclipseLinkXML()) {
                    if (this.hasIdentifier()) {
                        metadataLogger.logWarningMessage("metadata_warning_override_named_xml_with_eclipselink_xml", oRMetadata.getXMLElement(), this.getIdentifier(), oRMetadata.getLocation(), this.getLocation());
                    } else {
                        metadataLogger.logWarningMessage("metadata_warning_override_xml_with_eclipselink_xml", oRMetadata.getXMLElement(), oRMetadata.getLocation(), this.getLocation());
                    }
                    return true;
                }
                if (!this.loadedFromEclipseLinkXML() && oRMetadata.loadedFromEclipseLinkXML()) {
                    if (this.hasIdentifier()) {
                        metadataLogger.logWarningMessage("metadata_warning_override_named_xml_with_eclipselink_xml", oRMetadata.getXMLElement(), this.getIdentifier(), this.getLocation(), oRMetadata.getLocation());
                    } else {
                        metadataLogger.logWarningMessage("metadata_warning_override_xml_with_eclipselink_xml", oRMetadata.getXMLElement(), this.getLocation(), oRMetadata.getLocation());
                    }
                } else {
                    if (this.loadedFromAnnotation()) {
                        if (this.hasIdentifier()) {
                            throw ValidationException.conflictingNamedAnnotations(this.getIdentifier(), this.m_annotation, this.getLocation(), oRMetadata.getAnnotation(), oRMetadata.getLocation());
                        }
                        throw ValidationException.conflictingAnnotations(this.m_annotation, this.getLocation(), oRMetadata.getAnnotation(), oRMetadata.getLocation());
                    }
                    if (this.hasIdentifier()) {
                        throw ValidationException.conflictingNamedXMLElements(this.getIdentifier(), this.m_xmlElement, this.getLocation(), oRMetadata.getLocation());
                    }
                    throw ValidationException.conflictingXMLElements(this.m_xmlElement, this.getAccessibleObject().getElement(), this.getLocation(), oRMetadata.getLocation());
                }
            }
        }
        return false;
    }

    protected boolean valuesMatch(List<Object> list, List<Object> list2) {
        if (list.size() == list2.size()) {
            for (Object object : list) {
                if (list2.contains(object)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean valuesMatch(Object object, Object object2) {
        if (object == null && object2 != null || object2 == null && object != null) {
            return false;
        }
        if (object == null && object2 == null) {
            return true;
        }
        return object.equals(object2);
    }

    private class SimpleORMetadata
    extends ORMetadata {
        private Object m_value;

        public SimpleORMetadata(Object object, MetadataAccessibleObject metadataAccessibleObject, String string) {
            super(string);
            this.setAccessibleObject(metadataAccessibleObject);
            this.m_value = object;
        }

        public boolean equals(Object object) {
            if (object instanceof SimpleORMetadata) {
                return this.valuesMatch(this.getValue(), ((SimpleORMetadata)object).getValue());
            }
            return false;
        }

        public Object getValue() {
            return this.m_value;
        }
    }
}

