/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;

public class PropertyMetadata
extends ORMetadata {
    private String m_name;
    private String m_value;
    private Class m_valueType;
    private String m_valueTypeName;

    public PropertyMetadata() {
        super("<property>");
    }

    public PropertyMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        this.m_name = (String)MetadataHelper.invokeMethod("name", annotation);
        this.m_value = (String)MetadataHelper.invokeMethod("value", annotation);
        this.m_valueType = (Class)MetadataHelper.invokeMethod("valueType", annotation);
    }

    public String getIdentifier() {
        return this.getName();
    }

    public String getName() {
        return this.m_name;
    }

    public String getValue() {
        return this.m_value;
    }

    public Class getValueType() {
        return this.m_valueType;
    }

    public String getValueTypeName() {
        return this.m_valueTypeName;
    }

    public Object getConvertedValue() {
        if (this.m_valueType.equals(Void.TYPE) || this.m_valueType.equals(String.class)) {
            return this.m_value;
        }
        return ConversionManager.getDefaultManager().convertObject(this.m_value, this.m_valueType);
    }

    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.m_valueType = this.initXMLClassName(this.m_valueTypeName);
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void setValue(String string) {
        this.m_value = string;
    }

    public void setValueType(Class clazz) {
        this.m_valueType = clazz;
    }

    public void setValueTypeName(String string) {
        this.m_valueTypeName = string;
    }
}

